DROP TABLE IF EXISTS wp_commentmeta;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS wp_comments;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS wp_hms_testimonials;

CREATE TABLE `wp_hms_testimonials` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `blog_id` int(11) NOT NULL DEFAULT '0',
  `name` text NOT NULL,
  `image` int(11) NOT NULL DEFAULT '0',
  `testimonial` text NOT NULL,
  `url` varchar(255) NOT NULL DEFAULT '',
  `rating` int(1) NOT NULL DEFAULT '0',
  `readmore` varchar(255) NOT NULL DEFAULT '',
  `testimonial_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `display_order` int(11) NOT NULL DEFAULT '0',
  `display` int(1) NOT NULL DEFAULT '1',
  `autoapprove_token` varchar(255) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS wp_hms_testimonials_cf;

CREATE TABLE `wp_hms_testimonials_cf` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `blog_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `type` varchar(255) NOT NULL DEFAULT '',
  `isrequired` int(1) NOT NULL DEFAULT '0',
  `showonform` int(1) NOT NULL DEFAULT '0',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS wp_hms_testimonials_cf_meta;

CREATE TABLE `wp_hms_testimonials_cf_meta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `testimonial_id` int(11) NOT NULL,
  `key_id` int(11) NOT NULL,
  `value` text NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `testimonial_id` (`testimonial_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS wp_hms_testimonials_group_meta;

CREATE TABLE `wp_hms_testimonials_group_meta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `testimonial_id` int(11) NOT NULL,
  `group_id` int(11) NOT NULL,
  `display_order` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `id` (`id`),
  KEY `testimonial_id` (`testimonial_id`),
  KEY `group_id` (`group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS wp_hms_testimonials_groups;

CREATE TABLE `wp_hms_testimonials_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `blog_id` int(11) NOT NULL DEFAULT '0',
  `name` text NOT NULL,
  `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;




DROP TABLE IF EXISTS wp_hms_testimonials_templates;

CREATE TABLE `wp_hms_testimonials_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `blog_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `data` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=latin1;

INSERT INTO wp_hms_testimonials_templates VALUES("1","1","Testimonial, Author, URL, Date","a:4:{i:0;s:18:\"system_testimonial\";i:1;s:13:\"system_source\";i:2;s:10:\"system_url\";i:3;s:11:\"system_date\";}");
INSERT INTO wp_hms_testimonials_templates VALUES("2","1","Testimonial, URL, Author, Date","a:4:{i:0;s:18:\"system_testimonial\";i:1;s:10:\"system_url\";i:2;s:13:\"system_source\";i:3;s:11:\"system_date\";}");
INSERT INTO wp_hms_testimonials_templates VALUES("3","1","Author, Testimonial, URL, Date","a:4:{i:0;s:13:\"system_source\";i:1;s:18:\"system_testimonial\";i:2;s:10:\"system_url\";i:3;s:11:\"system_date\";}");
INSERT INTO wp_hms_testimonials_templates VALUES("4","1","Author, URL, Testimonial, Date","a:4:{i:0;s:13:\"system_source\";i:1;s:10:\"system_url\";i:2;s:18:\"system_testimonial\";i:3;s:11:\"system_date\";}");
INSERT INTO wp_hms_testimonials_templates VALUES("5","1","URL, Author, Testimonial, Date","a:4:{i:0;s:10:\"system_url\";i:1;s:13:\"system_source\";i:2;s:18:\"system_testimonial\";i:3;s:11:\"system_date\";}");
INSERT INTO wp_hms_testimonials_templates VALUES("6","1","URL, Testimonial, Author, Date","a:4:{i:0;s:10:\"system_url\";i:1;s:18:\"system_testimonial\";i:2;s:13:\"system_source\";i:3;s:11:\"system_date\";}");
INSERT INTO wp_hms_testimonials_templates VALUES("7","1","Testimonial, Author, Date, URL","a:4:{i:0;s:18:\"system_testimonial\";i:1;s:13:\"system_source\";i:2;s:11:\"system_date\";i:3;s:10:\"system_url\";}");
INSERT INTO wp_hms_testimonials_templates VALUES("8","1","Testimonial, URL, Date, Author","a:4:{i:0;s:18:\"system_testimonial\";i:1;s:10:\"system_url\";i:2;s:11:\"system_date\";i:3;s:13:\"system_source\";}");
INSERT INTO wp_hms_testimonials_templates VALUES("9","1","Testimonial, Date, Author, URL","a:4:{i:0;s:18:\"system_testimonial\";i:1;s:11:\"system_date\";i:2;s:13:\"system_source\";i:3;s:10:\"system_url\";}");
INSERT INTO wp_hms_testimonials_templates VALUES("10","1","Testimonial, Date, URL, Author","a:4:{i:0;s:18:\"system_testimonial\";i:1;s:11:\"system_date\";i:2;s:10:\"system_url\";i:3;s:13:\"system_source\";}");
INSERT INTO wp_hms_testimonials_templates VALUES("11","1","Author, Testimonial, Date, URL","a:4:{i:0;s:13:\"system_source\";i:1;s:18:\"system_testimonial\";i:2;s:11:\"system_date\";i:3;s:10:\"system_url\";}");
INSERT INTO wp_hms_testimonials_templates VALUES("12","1","Author, URL, Date, Testimonial","a:4:{i:0;s:13:\"system_source\";i:1;s:10:\"system_url\";i:2;s:11:\"system_date\";i:3;s:18:\"system_testimonial\";}");
INSERT INTO wp_hms_testimonials_templates VALUES("13","1","Author, Date, Testimonial, URL","a:4:{i:0;s:13:\"system_source\";i:1;s:11:\"system_date\";i:2;s:18:\"system_testimonial\";i:3;s:10:\"system_url\";}");
INSERT INTO wp_hms_testimonials_templates VALUES("14","1","Author, Date, URL, Testimonial","a:4:{i:0;s:13:\"system_source\";i:1;s:11:\"system_date\";i:2;s:10:\"system_url\";i:3;s:18:\"system_testimonial\";}");
INSERT INTO wp_hms_testimonials_templates VALUES("15","1","URL, Author, Date, Testimonial","a:4:{i:0;s:10:\"system_url\";i:1;s:13:\"system_source\";i:2;s:11:\"system_date\";i:3;s:18:\"system_testimonial\";}");
INSERT INTO wp_hms_testimonials_templates VALUES("16","1","URL, Testimonial, Date, Author","a:4:{i:0;s:10:\"system_url\";i:1;s:18:\"system_testimonial\";i:2;s:11:\"system_date\";i:3;s:13:\"system_source\";}");
INSERT INTO wp_hms_testimonials_templates VALUES("17","1","URL, Date, Author, Testimonial","a:4:{i:0;s:10:\"system_url\";i:1;s:11:\"system_date\";i:2;s:13:\"system_source\";i:3;s:18:\"system_testimonial\";}");
INSERT INTO wp_hms_testimonials_templates VALUES("18","1","URL, Date, Testimonial, Author","a:4:{i:0;s:10:\"system_url\";i:1;s:11:\"system_date\";i:2;s:18:\"system_testimonial\";i:3;s:13:\"system_source\";}");
INSERT INTO wp_hms_testimonials_templates VALUES("19","1","Date, Testimonial, Author, URL","a:4:{i:0;s:11:\"system_date\";i:1;s:18:\"system_testimonial\";i:2;s:13:\"system_source\";i:3;s:10:\"system_url\";}");
INSERT INTO wp_hms_testimonials_templates VALUES("20","1","Date, Testimonial, URL, Author","a:4:{i:0;s:11:\"system_date\";i:1;s:18:\"system_testimonial\";i:2;s:10:\"system_url\";i:3;s:13:\"system_source\";}");
INSERT INTO wp_hms_testimonials_templates VALUES("21","1","Date, Author, Testimonial, URL","a:4:{i:0;s:11:\"system_date\";i:1;s:13:\"system_source\";i:2;s:18:\"system_testimonial\";i:3;s:10:\"system_url\";}");
INSERT INTO wp_hms_testimonials_templates VALUES("22","1","Date, Author, URL, Testimonial","a:4:{i:0;s:11:\"system_date\";i:1;s:13:\"system_source\";i:2;s:10:\"system_url\";i:3;s:18:\"system_testimonial\";}");
INSERT INTO wp_hms_testimonials_templates VALUES("23","1","Date, URL, Author, Testimonial","a:4:{i:0;s:11:\"system_date\";i:1;s:10:\"system_url\";i:2;s:13:\"system_source\";i:3;s:18:\"system_testimonial\";}");
INSERT INTO wp_hms_testimonials_templates VALUES("24","1","Date, URL, Testimonial, Author","a:4:{i:0;s:11:\"system_date\";i:1;s:10:\"system_url\";i:2;s:18:\"system_testimonial\";i:3;s:13:\"system_source\";}");



DROP TABLE IF EXISTS wp_links;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS wp_masterslider_options;

CREATE TABLE `wp_masterslider_options` (
  `ID` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(120) NOT NULL,
  `option_value` text NOT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO wp_masterslider_options VALUES("1","preset_effect","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");
INSERT INTO wp_masterslider_options VALUES("2","buttons_style","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");
INSERT INTO wp_masterslider_options VALUES("3","masterslider_custom_css_ver","4.2");
INSERT INTO wp_masterslider_options VALUES("4","preset_style","eyJtZXRhIjp7fX0=");
INSERT INTO wp_masterslider_options VALUES("5","buttons_css",".msp-preset-btn-84{ background-color: #b97ebb;color: #fff; } .msp-preset-btn-84:hover{ background-color:#ca89cc;color: #fff; } .msp-preset-btn-84:active{ top:1px } .msp-preset-btn-85{ background-color: #b97ebb;color: #fff; } .msp-preset-btn-85:hover{ background-color:#ca89cc;color: #fff; } .msp-preset-btn-85:active{ top:1px } .msp-preset-btn-86{ color: #b97ebb;border:solid 1px #b97ebb; } .msp-preset-btn-86:hover{ border-color:#ca89cc;color:#ca89cc } .msp-preset-btn-86:active{ top:1px } .msp-preset-btn-87{ background-color: #b97ebb;color: #fff; } .msp-preset-btn-87:hover{ background-color:#ca89cc;color: #fff; } .msp-preset-btn-87:active{ top:1px } .msp-preset-btn-88{ background-color: #b97ebb;color: #fff;box-shadow:0 5px #9a699c; } .msp-preset-btn-88:hover{ background-color:#ca89cc;box-shadow:0 4px #9a699c;top:1px;color: #fff; } .msp-preset-btn-88:active{ box-shadow:0 2px #9a699c;top:3px; } .msp-preset-btn-89{ background-color: #5472D2;color: #fff; } .msp-preset-btn-89:hover{ background-color:#5d7fe9;color: #fff; } .msp-preset-btn-89:active{ top:1px } .msp-preset-btn-90{ background-color: #5472D2;color: #fff; } .msp-preset-btn-90:hover{ background-color:#5d7fe9;color: #fff; } .msp-preset-btn-90:active{ top:1px } .msp-preset-btn-91{ color: #5472D2;border:solid 1px #5472D2; } .msp-preset-btn-91:hover{ border-color:#5d7fe9;color:#5d7fe9 } .msp-preset-btn-91:active{ top:1px } .msp-preset-btn-92{ background-color: #5472D2;color: #fff; } .msp-preset-btn-92:hover{ background-color:#5d7fe9;color: #fff; } .msp-preset-btn-92:active{ top:1px } .msp-preset-btn-93{ background-color: #5472D2;color: #fff;box-shadow:0 5px #4c68be; } .msp-preset-btn-93:hover{ background-color:#5d7fe9;box-shadow:0 4px #4c68be;top:1px;color: #fff; } .msp-preset-btn-93:active{ box-shadow:0 2px #4c68be;top:3px; } .msp-preset-btn-94{ background-color: #00c1cf;color: #fff; } .msp-preset-btn-94:hover{ background-color:#01D4E4;color: #fff; } .msp-preset-btn-94:active{ top:1px } .msp-preset-btn-95{ background-color: #00c1cf;color: #fff; } .msp-preset-btn-95:hover{ background-color:#01D4E4;color: #fff; } .msp-preset-btn-95:active{ top:1px } .msp-preset-btn-96{ color: #00c1cf;border:solid 1px #00c1cf; } .msp-preset-btn-96:hover{ border-color:#01D4E4;color:#01D4E4 } .msp-preset-btn-96:active{ top:1px } .msp-preset-btn-97{ background-color: #00c1cf;color: #fff; } .msp-preset-btn-97:hover{ background-color:#01D4E4;color: #fff; } .msp-preset-btn-97:active{ top:1px } .msp-preset-btn-98{ background-color: #00c1cf;color: #fff;box-shadow:0 5px #00afbc; } .msp-preset-btn-98:hover{ background-color:#01D4E4;box-shadow:0 4px #00afbc;top:1px;color: #fff; } .msp-preset-btn-98:active{ box-shadow:0 2px #00afbc;top:3px; } .msp-preset-btn-99{ background-color: #4cadc9;color: #fff; } .msp-preset-btn-99:hover{ background-color:#63b2c9;color: #fff; } .msp-preset-btn-99:active{ top:1px } .msp-preset-btn-100{ background-color: #4cadc9;color: #fff; } .msp-preset-btn-100:hover{ background-color:#63b2c9;color: #fff; } .msp-preset-btn-100:active{ top:1px } .msp-preset-btn-101{ color: #4cadc9;border:solid 1px #4cadc9; } .msp-preset-btn-101:hover{ border-color:#63b2c9;color:#63b2c9 } .msp-preset-btn-101:active{ top:1px } .msp-preset-btn-102{ background-color: #4cadc9;color: #fff; } .msp-preset-btn-102:hover{ background-color:#63b2c9;color: #fff; } .msp-preset-btn-102:active{ top:1px } .msp-preset-btn-103{ background-color: #4cadc9;color: #fff;box-shadow:0 5px #1aa2c9; } .msp-preset-btn-103:hover{ background-color:#63b2c9;box-shadow:0 4px #1aa2c9;top:1px;color: #fff; } .msp-preset-btn-103:active{ box-shadow:0 2px #1aa2c9;top:3px; } .msp-preset-btn-104{ background-color: #cec2ab;color: #fff; } .msp-preset-btn-104:hover{ background-color:#cebd9d;color: #fff; } .msp-preset-btn-104:active{ top:1px } .msp-preset-btn-105{ background-color: #cec2ab;color: #fff; } .msp-preset-btn-105:hover{ background-color:#cebd9d;color: #fff; } .msp-preset-btn-105:active{ top:1px } .msp-preset-btn-106{ color: #cec2ab;border:solid 1px #cec2ab; } .msp-preset-btn-106:hover{ border-color:#cebd9d;color:#cebd9d } .msp-preset-btn-106:active{ top:1px } .msp-preset-btn-107{ background-color: #cec2ab;color: #fff; } .msp-preset-btn-107:hover{ background-color:#cebd9d;color: #fff; } .msp-preset-btn-107:active{ top:1px } .msp-preset-btn-108{ background-color: #cec2ab;color: #fff;box-shadow:0 5px #C2B7A2; } .msp-preset-btn-108:hover{ background-color:#cebd9d;box-shadow:0 4px #C2B7A2;top:1px;color: #fff; } .msp-preset-btn-108:active{ box-shadow:0 2px #C2B7A2;top:3px; } .msp-preset-btn-109{ background-color: #50485b;color: #fff; } .msp-preset-btn-109:hover{ background-color:#6a6176;color: #fff; } .msp-preset-btn-109:active{ top:1px } .msp-preset-btn-110{ background-color: #50485b;color: #fff; } .msp-preset-btn-110:hover{ background-color:#6a6176;color: #fff; } .msp-preset-btn-110:active{ top:1px } .msp-preset-btn-111{ color: #50485b;border:solid 1px #50485b; } .msp-preset-btn-111:hover{ border-color:#6a6176;color:#6a6176 } .msp-preset-btn-111:active{ top:1px } .msp-preset-btn-112{ background-color: #50485b;color: #fff; } .msp-preset-btn-112:hover{ background-color:#6a6176;color: #fff; } .msp-preset-btn-112:active{ top:1px } .msp-preset-btn-113{ background-color: #50485b;color: #fff;box-shadow:0 5px #412d5b; } .msp-preset-btn-113:hover{ background-color:#6a6176;box-shadow:0 4px #412d5b;top:1px;color: #fff; } .msp-preset-btn-113:active{ box-shadow:0 2px #412d5b;top:3px; } .msp-preset-btn-114{ background-color: #8d6dc4;color: #fff; } .msp-preset-btn-114:hover{ background-color:#977cc4;color: #fff; } .msp-preset-btn-114:active{ top:1px } .msp-preset-btn-115{ background-color: #8d6dc4;color: #fff; } .msp-preset-btn-115:hover{ background-color:#977cc4;color: #fff; } .msp-preset-btn-115:active{ top:1px } .msp-preset-btn-116{ color: #8d6dc4;border:solid 1px #8d6dc4; } .msp-preset-btn-116:hover{ border-color:#977cc4;color:#977cc4 } .msp-preset-btn-116:active{ top:1px } .msp-preset-btn-117{ background-color: #8d6dc4;color: #fff; } .msp-preset-btn-117:hover{ background-color:#977cc4;color: #fff; } .msp-preset-btn-117:active{ top:1px } .msp-preset-btn-118{ background-color: #8d6dc4;color: #fff;box-shadow:0 5px #7c51c4; } .msp-preset-btn-118:hover{ background-color:#977cc4;box-shadow:0 4px #7c51c4;top:1px;color: #fff; } .msp-preset-btn-118:active{ box-shadow:0 2px #7c51c4;top:3px; } .msp-preset-btn-119{ background-color: #75d69c;color: #fff; } .msp-preset-btn-119:hover{ background-color:#7de5a7;color: #fff; } .msp-preset-btn-119:active{ top:1px } .msp-preset-btn-120{ background-color: #75d69c;color: #fff; } .msp-preset-btn-120:hover{ background-color:#7de5a7;color: #fff; } .msp-preset-btn-120:active{ top:1px } .msp-preset-btn-121{ color: #75d69c;border:solid 1px #75d69c; } .msp-preset-btn-121:hover{ border-color:#7de5a7;color:#7de5a7 } .msp-preset-btn-121:active{ top:1px } .msp-preset-btn-122{ background-color: #75d69c;color: #fff; } .msp-preset-btn-122:hover{ background-color:#7de5a7;color: #fff; } .msp-preset-btn-122:active{ top:1px } .msp-preset-btn-123{ background-color: #75d69c;color: #fff;box-shadow:0 5px #41d67d; } .msp-preset-btn-123:hover{ background-color:#7de5a7;box-shadow:0 4px #41d67d;top:1px;color: #fff; } .msp-preset-btn-123:active{ box-shadow:0 2px #41d67d;top:3px; } .msp-preset-btn-124{ background-color: #222;color: #fff; } .msp-preset-btn-124:hover{ background-color:#333;color: #fff; } .msp-preset-btn-124:active{ top:1px } .msp-preset-btn-125{ background-color: #222;color: #fff; } .msp-preset-btn-125:hover{ background-color:#333;color: #fff; } .msp-preset-btn-125:active{ top:1px } .msp-preset-btn-126{ color: #222;border:solid 1px #222; } .msp-preset-btn-126:hover{ border-color:#333;color:#333 } .msp-preset-btn-126:active{ top:1px } .msp-preset-btn-127{ background-color: #222;color: #fff; } .msp-preset-btn-127:hover{ background-color:#333;color: #fff; } .msp-preset-btn-127:active{ top:1px } .msp-preset-btn-128{ background-color: #222;color: #fff;box-shadow:0 5px #000; } .msp-preset-btn-128:hover{ background-color:#333;box-shadow:0 4px #000;top:1px;color: #fff; } .msp-preset-btn-128:active{ box-shadow:0 2px #000;top:3px; } .msp-preset-btn-129{ background-color: #dedede;color: #666; } .msp-preset-btn-129:hover{ background-color:#d1d1d1;color: #666; } .msp-preset-btn-129:active{ top:1px } .msp-preset-btn-130{ background-color: #dedede;color: #666; } .msp-preset-btn-130:hover{ background-color:#d1d1d1;color: #666; } .msp-preset-btn-130:active{ top:1px } .msp-preset-btn-131{ color: #dedede;border:solid 1px #dedede; } .msp-preset-btn-131:hover{ border-color:#d1d1d1;color:#d1d1d1 } .msp-preset-btn-131:active{ top:1px } .msp-preset-btn-132{ background-color: #dedede;color: #666; } .msp-preset-btn-132:hover{ background-color:#d1d1d1;color: #666; } .msp-preset-btn-132:active{ top:1px } .msp-preset-btn-133{ background-color: #dedede;color: #666;box-shadow:0 5px #CACACA; } .msp-preset-btn-133:hover{ background-color:#d1d1d1;color: #666;box-shadow:0 4px #CACACA;top:1px } .msp-preset-btn-133:active{ box-shadow:0 2px #CACACA;top:3px; } .msp-preset-btn-134{ background-color: #f7be68;color: #fff; } .msp-preset-btn-134:hover{ background-color:#e9b362;color: #fff; } .msp-preset-btn-134:active{ top:1px } .msp-preset-btn-135{ background-color: #f7be68;color: #fff; } .msp-preset-btn-135:hover{ background-color:#e9b362;color: #fff; } .msp-preset-btn-135:active{ top:1px } .msp-preset-btn-136{ color: #f7be68;border:solid 1px #f7be68; } .msp-preset-btn-136:hover{ border-color:#e9b362;color:#e9b362 } .msp-preset-btn-136:active{ top:1px } .msp-preset-btn-137{ background-color: #f7be68;color: #fff; } .msp-preset-btn-137:hover{ background-color:#e9b362;color: #fff; } .msp-preset-btn-137:active{ top:1px } .msp-preset-btn-138{ background-color: #f7be68;color: #fff;box-shadow:0 5px #E7AF59; } .msp-preset-btn-138:hover{ background-color:#e9b362;box-shadow:0 4px #E7AF59;top:1px;color: #fff; } .msp-preset-btn-138:active{ box-shadow:0 2px #E7AF59;top:3px; } .msp-preset-btn-139{ background-color: #5aa1e3;color: #fff; } .msp-preset-btn-139:hover{ background-color:#5faaef;color: #fff; } .msp-preset-btn-139:active{ top:1px } .msp-preset-btn-140{ background-color: #5aa1e3;color: #fff; } .msp-preset-btn-140:hover{ background-color:#5faaef;color: #fff; } .msp-preset-btn-140:active{ top:1px } .msp-preset-btn-141{ color: #5aa1e3;border:solid 1px #5aa1e3; } .msp-preset-btn-141:hover{ border-color:#5faaef;color:#5faaef } .msp-preset-btn-141:active{ top:1px } .msp-preset-btn-142{ background-color: #5aa1e3;color: #fff; } .msp-preset-btn-142:hover{ background-color:#5faaef;color: #fff; } .msp-preset-btn-142:active{ top:1px } .msp-preset-btn-143{ background-color: #5aa1e3;color: #fff;box-shadow:0 5px #4c87bf; } .msp-preset-btn-143:hover{ background-color:#5faaef;box-shadow:0 4px #4c87bf;top:1px;color: #fff; } .msp-preset-btn-143:active{ box-shadow:0 2px #4c87bf;top:3px; } .msp-preset-btn-144{ background-color: #6dab3c;color: #fff; } .msp-preset-btn-144:hover{ background-color:#76b941;color: #fff; } .msp-preset-btn-144:active{ top:1px } .msp-preset-btn-145{ background-color: #6dab3c;color: #fff; } .msp-preset-btn-145:hover{ background-color:#76b941;color: #fff; } .msp-preset-btn-145:active{ top:1px } .msp-preset-btn-146{ color: #6dab3c;border:solid 1px #6dab3c; } .msp-preset-btn-146:hover{ border-color:#76b941;color:#76b941 } .msp-preset-btn-146:active{ top:1px } .msp-preset-btn-147{ background-color: #6dab3c;color: #fff; } .msp-preset-btn-147:hover{ background-color:#76b941;color: #fff; } .msp-preset-btn-147:active{ top:1px } .msp-preset-btn-148{ background-color: #6dab3c;color: #fff;box-shadow:0 5px #5e9334; } .msp-preset-btn-148:hover{ background-color:#76b941;box-shadow:0 4px #5e9334;top:1px;color: #fff; } .msp-preset-btn-148:active{ box-shadow:0 2px #5e9334;top:3px; } .msp-preset-btn-149{ background-color: #f4524d;color: #fff; } .msp-preset-btn-149:hover{ background-color:#e04b47;color: #fff; } .msp-preset-btn-149:active{ top:1px } .msp-preset-btn-150{ background-color: #f4524d;color: #fff; } .msp-preset-btn-150:hover{ background-color:#e04b47;color: #fff; } .msp-preset-btn-150:active{ top:1px } .msp-preset-btn-151{ color: #f4524d;border:solid 1px #f4524d; } .msp-preset-btn-151:hover{ border-color:#e04b47;color:#e04b47 } .msp-preset-btn-151:active{ top:1px } .msp-preset-btn-152{ background-color: #f4524d;color: #fff; } .msp-preset-btn-152:hover{ background-color:#e04b47;color: #fff; } .msp-preset-btn-152:active{ top:1px } .msp-preset-btn-153{ background-color: #f4524d;color: #fff;box-shadow:0 5px #cb4440; } .msp-preset-btn-153:hover{ background-color:#e04b47;box-shadow:0 4px #cb4440;top:1px;color: #fff; } .msp-preset-btn-153:active{ box-shadow:0 2px #cb4440;top:3px; } .msp-preset-btn-154{ background-color: #f79468;color: #fff; } .msp-preset-btn-154:hover{ background-color:#e78a61;color: #fff; } .msp-preset-btn-154:active{ top:1px } .msp-preset-btn-155{ background-color: #f79468;color: #fff; } .msp-preset-btn-155:hover{ background-color:#e78a61;color: #fff; } .msp-preset-btn-155:active{ top:1px } .msp-preset-btn-156{ color: #f79468;border:solid 1px #f79468; } .msp-preset-btn-156:hover{ border-color:#e78a61;color:#e78a61 } .msp-preset-btn-156:active{ top:1px } .msp-preset-btn-157{ background-color: #f79468;color: #fff; } .msp-preset-btn-157:hover{ background-color:#e78a61;color: #fff; } .msp-preset-btn-157:active{ top:1px } .msp-preset-btn-158{ background-color: #f79468;color: #fff;box-shadow:0 5px #da835c; } .msp-preset-btn-158:hover{ background-color:#e78a61;box-shadow:0 4px #da835c;top:1px;color: #fff; } .msp-preset-btn-158:active{ box-shadow:0 2px #da835c;top:3px; }");



DROP TABLE IF EXISTS wp_masterslider_sliders;

CREATE TABLE `wp_masterslider_sliders` (
  `ID` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `type` varchar(64) NOT NULL,
  `slides_num` smallint(5) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `params` mediumtext NOT NULL,
  `custom_styles` text NOT NULL,
  `custom_fonts` text NOT NULL,
  `status` varchar(10) NOT NULL DEFAULT 'draft',
  PRIMARY KEY (`ID`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO wp_masterslider_sliders VALUES("1","Untitled Slider","custom","0","2015-02-19 14:42:54","2015-02-19 14:42:54","a:0:{}","","","draft");
INSERT INTO wp_masterslider_sliders VALUES("2","Untitled Slider","custom","5","2015-02-19 19:51:24","2015-06-11 18:00:53","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","","","published");



DROP TABLE IF EXISTS wp_options;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `option_value` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=40073 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO wp_options VALUES("1","siteurl","https://capitaldistrictdigital.com","yes");
INSERT INTO wp_options VALUES("2","blogname","Capital District Digital Albany, NY","yes");
INSERT INTO wp_options VALUES("3","blogdescription","","yes");
INSERT INTO wp_options VALUES("4","users_can_register","0","yes");
INSERT INTO wp_options VALUES("5","admin_email","anthonytroia77@gmail.com","yes");
INSERT INTO wp_options VALUES("6","start_of_week","1","yes");
INSERT INTO wp_options VALUES("7","use_balanceTags","0","yes");
INSERT INTO wp_options VALUES("8","use_smilies","1","yes");
INSERT INTO wp_options VALUES("9","require_name_email","1","yes");
INSERT INTO wp_options VALUES("10","comments_notify","1","yes");
INSERT INTO wp_options VALUES("11","posts_per_rss","10","yes");
INSERT INTO wp_options VALUES("12","rss_use_excerpt","0","yes");
INSERT INTO wp_options VALUES("13","mailserver_url","mail.example.com","yes");
INSERT INTO wp_options VALUES("14","mailserver_login","login@example.com","yes");
INSERT INTO wp_options VALUES("15","mailserver_pass","password","yes");
INSERT INTO wp_options VALUES("16","mailserver_port","110","yes");
INSERT INTO wp_options VALUES("17","default_category","1","yes");
INSERT INTO wp_options VALUES("18","default_comment_status","open","yes");
INSERT INTO wp_options VALUES("19","default_ping_status","open","yes");
INSERT INTO wp_options VALUES("20","default_pingback_flag","1","yes");
INSERT INTO wp_options VALUES("21","posts_per_page","10","yes");
INSERT INTO wp_options VALUES("22","date_format","F j, Y","yes");
INSERT INTO wp_options VALUES("23","time_format","g:i a","yes");
INSERT INTO wp_options VALUES("24","links_updated_date_format","F j, Y g:i a","yes");
INSERT INTO wp_options VALUES("28","comment_moderation","0","yes");
INSERT INTO wp_options VALUES("29","moderation_notify","1","yes");
INSERT INTO wp_options VALUES("30","permalink_structure","/%postname%/","yes");
INSERT INTO wp_options VALUES("32","hack_file","0","yes");
INSERT INTO wp_options VALUES("33","blog_charset","UTF-8","yes");
INSERT INTO wp_options VALUES("34","moderation_keys","","no");
INSERT INTO wp_options VALUES("35","active_plugins","a:24:{i:0;s:39:\"automatic-updater/automatic-updater.php\";i:1;s:37:\"ds-live-composer/ds-live-composer.php\";i:2;s:55:\"easy-social-share-buttons/easy-social-share-buttons.php\";i:3;s:41:\"envato-wordpress-toolkit-master/index.php\";i:4;s:29:\"fresh-favicon/freshplugin.php\";i:5;s:31:\"fresh-framework/freshplugin.php\";i:6;s:37:\"hms-testimonials/hms-testimonials.php\";i:8;s:39:\"lockdown-wp-admin/lockdown-wp-admin.php\";i:9;s:29:\"masterslider/masterslider.php\";i:10;s:33:\"mega_main_menu/mega_main_menu.php\";i:11;s:21:\"meta-box/meta-box.php\";i:12;s:41:\"newsletter-sign-up/newsletter-sign-up.php\";i:13;s:42:\"nex-forms-express-wp-form-builder/main.php\";i:14;s:74:\"official-statcounter-plugin-for-wordpress/StatCounter-Wordpress-Plugin.php\";i:15;s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";i:16;s:31:\"sb-google-map/sb-google-map.php\";i:17;s:43:\"visual-form-builder/visual-form-builder.php\";i:18;s:23:\"wordfence/wordfence.php\";i:19;s:24:\"wordpress-seo/wp-seo.php\";i:20;s:34:\"wp-clone-by-wp-academy/wpclone.php\";i:21;s:23:\"wp-rankie/wp-ranker.php\";i:22;s:31:\"wp-seo-html-sitemap/sitemap.php\";i:23;s:27:\"wp-super-cache/wp-cache.php\";i:24;s:47:\"wpfw_menus_management/wpfw_menus_management.php\";}","yes");
INSERT INTO wp_options VALUES("36","home","https://capitaldistrictdigital.com","yes");
INSERT INTO wp_options VALUES("37","category_base","","yes");
INSERT INTO wp_options VALUES("38","ping_sites","http://rpc.pingomatic.com/","yes");
INSERT INTO wp_options VALUES("40","comment_max_links","2","yes");
INSERT INTO wp_options VALUES("41","gmt_offset","0","yes");
INSERT INTO wp_options VALUES("42","default_email_category","1","yes");
INSERT INTO wp_options VALUES("43","recently_edited","a:4:{i:0;s:60:\"/home/digital/public_html/wp-content/themes/seowp/header.php\";i:1;s:59:\"/home/digital/public_html/wp-content/themes/seowp/index.php\";i:2;s:59:\"/home/digital/public_html/wp-content/themes/seowp/style.css\";i:3;s:0:\"\";}","no");
INSERT INTO wp_options VALUES("44","template","seowp","yes");
INSERT INTO wp_options VALUES("45","stylesheet","seowp","yes");
INSERT INTO wp_options VALUES("46","comment_whitelist","1","yes");
INSERT INTO wp_options VALUES("47","blacklist_keys","","no");
INSERT INTO wp_options VALUES("48","comment_registration","0","yes");
INSERT INTO wp_options VALUES("49","html_type","text/html","yes");
INSERT INTO wp_options VALUES("50","use_trackback","0","yes");
INSERT INTO wp_options VALUES("51","default_role","subscriber","yes");
INSERT INTO wp_options VALUES("52","db_version","35700","yes");
INSERT INTO wp_options VALUES("53","uploads_use_yearmonth_folders","1","yes");
INSERT INTO wp_options VALUES("54","upload_path","","yes");
INSERT INTO wp_options VALUES("55","blog_public","1","yes");
INSERT INTO wp_options VALUES("56","default_link_category","2","yes");
INSERT INTO wp_options VALUES("57","show_on_front","page","yes");
INSERT INTO wp_options VALUES("58","tag_base","","yes");
INSERT INTO wp_options VALUES("59","show_avatars","1","yes");
INSERT INTO wp_options VALUES("60","avatar_rating","G","yes");
INSERT INTO wp_options VALUES("61","upload_url_path","","yes");
INSERT INTO wp_options VALUES("62","thumbnail_size_w","150","yes");
INSERT INTO wp_options VALUES("63","thumbnail_size_h","150","yes");
INSERT INTO wp_options VALUES("64","thumbnail_crop","1","yes");
INSERT INTO wp_options VALUES("65","medium_size_w","300","yes");
INSERT INTO wp_options VALUES("66","medium_size_h","300","yes");
INSERT INTO wp_options VALUES("67","avatar_default","mystery","yes");
INSERT INTO wp_options VALUES("68","large_size_w","1024","yes");
INSERT INTO wp_options VALUES("69","large_size_h","1024","yes");
INSERT INTO wp_options VALUES("70","image_default_link_type","file","yes");
INSERT INTO wp_options VALUES("71","image_default_size","","yes");
INSERT INTO wp_options VALUES("72","image_default_align","","yes");
INSERT INTO wp_options VALUES("73","close_comments_for_old_posts","0","yes");
INSERT INTO wp_options VALUES("74","close_comments_days_old","14","yes");
INSERT INTO wp_options VALUES("75","thread_comments","1","yes");
INSERT INTO wp_options VALUES("76","thread_comments_depth","5","yes");
INSERT INTO wp_options VALUES("77","page_comments","0","yes");
INSERT INTO wp_options VALUES("78","comments_per_page","50","yes");
INSERT INTO wp_options VALUES("79","default_comments_page","newest","yes");
INSERT INTO wp_options VALUES("80","comment_order","asc","yes");
INSERT INTO wp_options VALUES("81","sticky_posts","a:0:{}","yes");
INSERT INTO wp_options VALUES("82","widget_categories","a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("83","widget_text","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("84","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("85","uninstall_plugins","a:1:{s:27:\"wp-super-cache/wp-cache.php\";s:22:\"wpsupercache_uninstall\";}","no");
INSERT INTO wp_options VALUES("86","timezone_string","","yes");
INSERT INTO wp_options VALUES("87","page_for_posts","0","yes");
INSERT INTO wp_options VALUES("88","page_on_front","1041","yes");
INSERT INTO wp_options VALUES("89","default_post_format","0","yes");
INSERT INTO wp_options VALUES("90","link_manager_enabled","0","yes");
INSERT INTO wp_options VALUES("91","initial_db_version","26691","yes");
INSERT INTO wp_options VALUES("92","wp_user_roles","a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:68:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:19:\"access_masterslider\";b:1;s:20:\"publish_masterslider\";b:1;s:19:\"delete_masterslider\";b:1;s:19:\"create_masterslider\";b:1;s:19:\"export_masterslider\";b:1;s:22:\"duplicate_masterslider\";b:1;s:15:\"wpseo_bulk_edit\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:41:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:19:\"access_masterslider\";b:1;s:20:\"publish_masterslider\";b:1;s:19:\"delete_masterslider\";b:1;s:19:\"create_masterslider\";b:1;s:19:\"export_masterslider\";b:1;s:22:\"duplicate_masterslider\";b:1;s:15:\"wpseo_bulk_edit\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}","yes");
INSERT INTO wp_options VALUES("93","widget_search","a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("94","widget_recent-posts","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("95","widget_recent-comments","a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("96","widget_archives","a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("97","widget_meta","a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("98","sidebars_widgets","a:7:{s:19:\"wp_inactive_widgets\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:12:\"dslc_sidebar\";a:1:{i:0;s:12:\"vfb_widget-2\";}s:21:\"dslc_404_page_widgets\";a:0:{}s:22:\"dslc_comment_form_area\";a:0:{}s:16:\"mobile-offcanvas\";a:1:{i:0;s:10:\"nav_menu-3\";}s:23:\"mmm_menu_widgets_area_1\";a:0:{}s:13:\"array_version\";i:3;}","yes");
INSERT INTO wp_options VALUES("99","cron","a:21:{i:1459703669;a:1:{s:19:\"wp_rankie_rank_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:14:\"twice_a_minute\";s:4:\"args\";a:0:{}s:8:\"interval\";i:120;}}}i:1459703679;a:1:{s:21:\"wordfence_hourly_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1459703789;a:1:{s:21:\"wp_rankie_daily_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1459704159;a:1:{s:11:\"wp_cache_gc\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1459707087;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1459709372;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1459712945;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1459721679;a:2:{s:26:\"wordfence_daily_autoUpdate\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:20:\"wordfence_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1459736180;a:1:{s:46:\"check_plugin_updates-easy-social-share-buttons\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1459739488;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1459743751;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1459756168;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1459783023;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1459829325;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1459916044;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1460001849;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1460088303;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1460176027;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1460261725;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1460390400;a:1:{s:31:\"wordfence_email_activity_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}s:7:\"version\";i:2;}","yes");
INSERT INTO wp_options VALUES("135","_transient_twentyfourteen_category_count","1","yes");
INSERT INTO wp_options VALUES("136","auto_core_update_notified","a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:24:\"anthonytroia77@gmail.com\";s:7:\"version\";s:5:\"4.4.2\";s:9:\"timestamp\";i:1454440581;}","yes");
INSERT INTO wp_options VALUES("146","db_upgraded","","yes");
INSERT INTO wp_options VALUES("173","current_theme","SEOWP","yes");
INSERT INTO wp_options VALUES("174","theme_mods_Avada","a:2:{i:0;b:0;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1424354785;s:4:\"data\";a:10:{s:19:\"wp_inactive_widgets\";a:0:{}s:18:\"avada-blog-sidebar\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:21:\"avada-footer-widget-1\";a:0:{}s:21:\"avada-footer-widget-2\";a:0:{}s:21:\"avada-footer-widget-3\";N;s:21:\"avada-footer-widget-4\";N;s:25:\"avada-slidingbar-widget-1\";N;s:25:\"avada-slidingbar-widget-2\";N;s:25:\"avada-slidingbar-widget-3\";N;s:25:\"avada-slidingbar-widget-4\";N;}}}","yes");
INSERT INTO wp_options VALUES("175","theme_switched","","yes");
INSERT INTO wp_options VALUES("176","Avada_options","a:536:{s:0:\"\";s:0:\"\";s:9:\"demo_data\";s:100:\"http://capitaldistrictdigital.com/wp-admin/themes.php?page=optionsframework&import_data_content=true\";s:10:\"responsive\";i:1;s:12:\"ipad_potrait\";i:1;s:4:\"code\";s:81:\"<h3 style=\'margin: 0;\'>Tracking / Space Before Head / Space Before Body Code</h3>\";s:16:\"google_analytics\";s:0:\"\";s:10:\"space_head\";s:0:\"\";s:10:\"space_body\";s:0:\"\";s:11:\"header_info\";s:46:\"<h3 style=\'margin: 0;\'>Breadcrumb Options</h3>\";s:13:\"header_layout\";s:2:\"v1\";s:18:\"header_transparent\";i:0;s:15:\"slider_position\";s:5:\"Below\";s:19:\"header_left_content\";s:12:\"Contact Info\";s:20:\"header_right_content\";s:10:\"Navigation\";s:17:\"header_v4_content\";s:16:\"Tagline + Search\";s:18:\"header_banner_code\";s:0:\"\";s:13:\"header_number\";s:28:\"Call Us Today! 1.555.555.555\";s:12:\"header_email\";s:19:\"info@yourdomain.com\";s:14:\"header_tagline\";s:41:\"Insert Any Headline Or Link You Want Here\";s:15:\"header_bg_image\";s:0:\"\";s:14:\"header_bg_full\";i:0;s:18:\"header_bg_parallax\";i:1;s:16:\"header_bg_repeat\";s:0:\"\";s:17:\"margin_header_top\";s:3:\"0px\";s:20:\"margin_header_bottom\";s:3:\"0px\";s:30:\"header_social_links_icon_color\";s:7:\"#bebdbd\";s:25:\"header_social_links_boxed\";s:2:\"No\";s:29:\"header_social_links_box_color\";s:7:\"#e8e8e8\";s:32:\"header_social_links_boxed_radius\";s:3:\"4px\";s:37:\"header_social_links_tooltip_placement\";s:6:\"Bottom\";s:18:\"sticky_header_info\";s:49:\"<h3 style=\'margin: 0;\'>Sticky Header Options</h3>\";s:13:\"header_sticky\";i:1;s:20:\"header_sticky_tablet\";i:0;s:20:\"header_sticky_mobile\";i:0;s:21:\"header_sticky_opacity\";s:4:\"0.97\";s:25:\"header_sticky_nav_padding\";s:0:\"\";s:27:\"header_sticky_nav_font_size\";s:0:\"\";s:28:\"header_sticky_logo_max_width\";s:0:\"\";s:4:\"logo\";s:73:\"http://capitaldistrictdigital.com/wp-content/themes/Avada/images/logo.png\";s:11:\"logo_retina\";s:0:\"\";s:17:\"retina_logo_width\";s:0:\"\";s:18:\"retina_logo_height\";s:0:\"\";s:14:\"logo_alignment\";s:4:\"Left\";s:16:\"margin_logo_left\";s:3:\"0px\";s:17:\"margin_logo_right\";s:3:\"0px\";s:15:\"margin_logo_top\";s:4:\"31px\";s:18:\"margin_logo_bottom\";s:4:\"31px\";s:8:\"favicons\";s:43:\"<h3 style=\'margin: 0;\'>Favicon Options</h3>\";s:7:\"favicon\";s:0:\"\";s:11:\"iphone_icon\";s:0:\"\";s:18:\"iphone_icon_retina\";s:0:\"\";s:9:\"ipad_icon\";s:0:\"\";s:16:\"ipad_icon_retina\";s:0:\"\";s:10:\"nav_height\";s:2:\"83\";s:11:\"nav_padding\";s:2:\"35\";s:19:\"dropdown_menu_width\";s:5:\"170px\";s:23:\"topmenu_dropwdown_width\";s:5:\"100px\";s:19:\"megamenu_title_size\";s:4:\"18px\";s:20:\"main_nav_search_icon\";i:1;s:20:\"main_nav_icon_circle\";i:0;s:27:\"mobile_nav_submenu_slideout\";i:0;s:14:\"page_title_bar\";i:1;s:17:\"page_title_height\";s:4:\"87px\";s:13:\"page_title_bg\";s:82:\"http://capitaldistrictdigital.com/wp-content/themes/Avada/images/page_title_bg.png\";s:20:\"page_title_bg_retina\";s:0:\"\";s:18:\"page_title_bg_full\";i:0;s:22:\"page_title_bg_parallax\";i:0;s:10:\"breadcrumb\";i:1;s:17:\"page_title_bar_bs\";s:11:\"Breadcrumbs\";s:17:\"breadcrumb_mobile\";i:0;s:16:\"breacrumb_prefix\";s:0:\"\";s:11:\"sliding_bar\";s:47:\"<h3 style=\'margin: 0;\'>Sliding Bar Options</h3>\";s:18:\"slidingbar_widgets\";i:0;s:25:\"mobile_slidingbar_widgets\";i:0;s:21:\"slidingbar_top_border\";i:0;s:32:\"slidingbar_bg_color_transparency\";i:0;s:23:\"slidingbar_open_on_load\";i:0;s:26:\"slidingbar_widgets_columns\";s:1:\"4\";s:25:\"footer_widgets_area_title\";s:55:\"<h3 style=\'margin: 0;\'>Footer Widgets Area Options</h3>\";s:14:\"footer_widgets\";i:1;s:22:\"footer_widgets_columns\";s:1:\"4\";s:16:\"footerw_bg_image\";s:0:\"\";s:15:\"footerw_bg_full\";i:0;s:23:\"footer_area_bg_parallax\";i:1;s:17:\"footerw_bg_repeat\";s:0:\"\";s:14:\"footerw_bg_pos\";s:13:\"center center\";s:23:\"footer_area_top_padding\";s:4:\"43px\";s:26:\"footer_area_bottom_padding\";s:4:\"40px\";s:20:\"copyright_area_title\";s:45:\"<h3 style=\'margin: 0;\'>Copyright Options</h3>\";s:16:\"footer_copyright\";i:1;s:11:\"footer_text\";s:155:\"Copyright 2012 Avada | All Rights Reserved | Powered by <a href=\"http://wordpress.org\">WordPress</a>  |  <a href=\"http://theme-fusion.com\">Theme Fusion</a>\";s:21:\"copyright_top_padding\";s:4:\"18px\";s:24:\"copyright_bottom_padding\";s:4:\"16px\";s:24:\"footer_social_icon_title\";s:47:\"<h3 style=\'margin: 0;\'>Social Icon Options</h3>\";s:12:\"icons_footer\";i:1;s:30:\"footer_social_links_icon_color\";s:7:\"#46494a\";s:25:\"footer_social_links_boxed\";s:2:\"No\";s:29:\"footer_social_links_box_color\";s:7:\"#222222\";s:32:\"footer_social_links_boxed_radius\";s:3:\"4px\";s:37:\"footer_social_links_tooltip_placement\";s:3:\"Top\";s:6:\"layout\";s:4:\"Wide\";s:15:\"boxed_mode_only\";s:76:\"<h3 style=\'margin: 0;\'>Background options below only work in boxed mode</h3>\";s:8:\"bg_image\";s:0:\"\";s:7:\"bg_full\";i:0;s:9:\"bg_repeat\";s:0:\"\";s:8:\"bg_color\";s:7:\"#d7d6d6\";s:17:\"bg_pattern_option\";i:0;s:10:\"bg_pattern\";s:8:\"pattern1\";s:15:\"both_modes_only\";s:79:\"<h3 style=\'margin: 0;\'>Background Options Below Work For Boxed & Wide Mode</h3>\";s:16:\"content_bg_image\";s:0:\"\";s:15:\"content_bg_full\";i:0;s:17:\"content_bg_repeat\";s:0:\"\";s:19:\"custom_heading_font\";s:175:\"<h3 style=\'margin: 0;\'>Custom Font For Menus And Headings.</h3><p style=\'margin-bottom:0;\'>This will override the google / standard font options. All 4 files are required.</p>\";s:16:\"custom_font_woff\";s:0:\"\";s:15:\"custom_font_ttf\";s:0:\"\";s:15:\"custom_font_svg\";s:0:\"\";s:15:\"custom_font_eot\";s:0:\"\";s:18:\"google_fonts_intro\";s:113:\"<h3 style=\'margin: 0;\'>Google Fonts</h3><p style=\'margin-bottom:0;\'>This will override standard font options.</p>\";s:11:\"google_body\";s:7:\"PT Sans\";s:10:\"google_nav\";s:10:\"Antic Slab\";s:15:\"google_headings\";s:10:\"Antic Slab\";s:22:\"google_footer_headings\";s:10:\"Antic Slab\";s:20:\"standard_fonts_intro\";s:37:\"<h3 style=\'margin: 0;\'>Standards</h3>\";s:13:\"standard_body\";s:0:\"\";s:12:\"standard_nav\";s:0:\"\";s:17:\"standard_headings\";s:0:\"\";s:24:\"standard_footer_headings\";s:0:\"\";s:15:\"font_size_intro\";s:38:\"<h3 style=\'margin: 0;\'>Font Sizes</h3>\";s:14:\"body_font_size\";s:2:\"13\";s:13:\"nav_font_size\";s:2:\"14\";s:22:\"nav_dropdown_font_size\";s:2:\"13\";s:14:\"snav_font_size\";s:2:\"12\";s:18:\"side_nav_font_size\";s:2:\"14\";s:21:\"breadcrumbs_font_size\";s:2:\"10\";s:15:\"sidew_font_size\";s:2:\"13\";s:20:\"slidingbar_font_size\";s:2:\"13\";s:15:\"footw_font_size\";s:2:\"13\";s:19:\"copyright_font_size\";s:2:\"12\";s:12:\"h1_font_size\";s:2:\"32\";s:12:\"h2_font_size\";s:2:\"18\";s:12:\"h3_font_size\";s:2:\"16\";s:12:\"h4_font_size\";s:2:\"13\";s:12:\"h5_font_size\";s:2:\"12\";s:12:\"h6_font_size\";s:2:\"11\";s:17:\"tagline_font_size\";s:2:\"16\";s:14:\"meta_font_size\";s:2:\"12\";s:20:\"page_title_font_size\";s:2:\"18\";s:30:\"page_title_subheader_font_size\";s:2:\"14\";s:20:\"pagination_font_size\";s:2:\"12\";s:18:\"woo_icon_font_size\";s:2:\"12\";s:25:\"font_line_heights_wrapper\";s:46:\"<h3 style=\'margin: 0;\'\'>Font Line Heights</h3>\";s:12:\"body_font_lh\";s:2:\"20\";s:10:\"h1_font_lh\";s:2:\"48\";s:10:\"h2_font_lh\";s:2:\"27\";s:10:\"h3_font_lh\";s:2:\"24\";s:10:\"h4_font_lh\";s:2:\"20\";s:10:\"h5_font_lh\";s:2:\"18\";s:10:\"h6_font_lh\";s:2:\"17\";s:11:\"scheme_type\";s:5:\"Light\";s:12:\"color_scheme\";s:5:\"Green\";s:17:\"bg_colors_wrapper\";s:45:\"<h3 style=\'margin: 0;\'>Background Colors</h3>\";s:13:\"primary_color\";s:7:\"#a0ce4e\";s:19:\"slidingbar_bg_color\";s:7:\"#363839\";s:22:\"header_sticky_bg_color\";s:7:\"#ffffff\";s:15:\"header_bg_color\";s:7:\"#ffffff\";s:19:\"header_border_color\";s:7:\"#e5e5e5\";s:19:\"header_top_bg_color\";s:7:\"#a0ce4e\";s:19:\"page_title_bg_color\";s:7:\"#F6F6F6\";s:23:\"page_title_border_color\";s:7:\"#d2d3d4\";s:16:\"content_bg_color\";s:7:\"#ffffff\";s:15:\"footer_bg_color\";s:7:\"#363839\";s:19:\"footer_border_color\";s:7:\"#e9eaee\";s:18:\"copyright_bg_color\";s:7:\"#282a2b\";s:22:\"copyright_border_color\";s:7:\"#4b4c4d\";s:22:\"element_colors_wrapper\";s:42:\"<h3 style=\'margin: 0;\'>Element Colors</h3>\";s:24:\"image_gradient_top_color\";s:7:\"#D1E990\";s:27:\"image_gradient_bottom_color\";s:7:\"#AAD75B\";s:25:\"image_rollover_text_color\";s:7:\"#333333\";s:24:\"slidingbar_divider_color\";s:7:\"#282A2B\";s:20:\"footer_divider_color\";s:7:\"#505152\";s:13:\"form_bg_color\";s:7:\"#ffffff\";s:15:\"form_text_color\";s:7:\"#aaa9a9\";s:17:\"form_border_color\";s:7:\"#d2d2d2\";s:17:\"timeline_bg_color\";s:11:\"transparent\";s:14:\"timeline_color\";s:7:\"#ebeaea\";s:12:\"qty_bg_color\";s:7:\"#fbfaf9\";s:18:\"qty_bg_hover_color\";s:7:\"#ffffff\";s:19:\"bbp_forum_header_bg\";s:7:\"#ebeaea\";s:22:\"bbp_forum_border_color\";s:7:\"#ebeaea\";s:23:\"element_options_wrapper\";s:42:\"<h3 style=\'margin: 0;\'>Layout Options</h3>\";s:16:\"main_top_padding\";s:4:\"55px\";s:19:\"main_bottom_padding\";s:4:\"40px\";s:16:\"hundredp_padding\";s:4:\"20px\";s:22:\"slidingbar_text_shadow\";i:0;s:18:\"footer_text_shadow\";i:0;s:19:\"font_colors_wrapper\";s:39:\"<h3 style=\'margin: 0;\'>Font Colors</h3>\";s:18:\"tagline_font_color\";s:7:\"#747474\";s:16:\"page_title_color\";s:7:\"#333333\";s:8:\"h1_color\";s:7:\"#333333\";s:8:\"h2_color\";s:7:\"#333333\";s:8:\"h3_color\";s:7:\"#333333\";s:8:\"h4_color\";s:7:\"#333333\";s:8:\"h5_color\";s:7:\"#333333\";s:8:\"h6_color\";s:7:\"#333333\";s:15:\"body_text_color\";s:7:\"#747474\";s:10:\"link_color\";s:7:\"#333333\";s:22:\"breadcrumbs_text_color\";s:7:\"#333333\";s:25:\"slidingbar_headings_color\";s:7:\"#DDDDDD\";s:21:\"slidingbar_text_color\";s:7:\"#8C8989\";s:21:\"slidingbar_link_color\";s:7:\"#BFBFBF\";s:21:\"sidebar_heading_color\";s:7:\"#333333\";s:21:\"footer_headings_color\";s:7:\"#DDDDDD\";s:17:\"footer_text_color\";s:7:\"#8C8989\";s:17:\"footer_link_color\";s:7:\"#BFBFBF\";s:24:\"main_menu_colors_wrapper\";s:44:\"<h3 style=\'margin: 0;\'>Main Menu Colors</h3>\";s:17:\"menu_h45_bg_color\";s:7:\"#FFFFFF\";s:16:\"menu_first_color\";s:7:\"#333333\";s:22:\"menu_hover_first_color\";s:7:\"#a0ce4e\";s:17:\"menu_sub_bg_color\";s:7:\"#f2efef\";s:19:\"menu_bg_hover_color\";s:7:\"#f8f8f8\";s:14:\"menu_sub_color\";s:7:\"#333333\";s:18:\"menu_sub_sep_color\";s:7:\"#dcdadb\";s:17:\"woo_cart_bg_color\";s:7:\"#fafafa\";s:17:\"menu_colors_intro\";s:49:\"<h3 style=\'margin: 0;\'>Secondary Menu Colors</h3>\";s:10:\"snav_color\";s:7:\"#747474\";s:29:\"header_top_first_border_color\";s:7:\"#e5e5e5\";s:23:\"header_top_sub_bg_color\";s:7:\"#ffffff\";s:25:\"header_top_menu_sub_color\";s:7:\"#747474\";s:30:\"header_top_menu_bg_hover_color\";s:7:\"#fafafa\";s:31:\"header_top_menu_sub_hover_color\";s:7:\"#333333\";s:29:\"header_top_menu_sub_sep_color\";s:7:\"#e5e5e5\";s:26:\"mobile_menu_colors_wrapper\";s:46:\"<h3 style=\'margin: 0;\'>Mobile Menu Colors</h3>\";s:28:\"mobile_menu_background_color\";s:7:\"#f9f9f9\";s:24:\"mobile_menu_border_color\";s:7:\"#dadada\";s:23:\"mobile_menu_hover_color\";s:7:\"#f6f6f6\";s:19:\"accordion_shortcode\";s:47:\"<h3 style=\'margin: 0;\'>Accordion Shortcode</h3>\";s:24:\"accordian_inactive_color\";s:7:\"#333333\";s:14:\"blog_shortcode\";s:42:\"<h3 style=\'margin: 0;\'>Blog Shortcode</h3>\";s:15:\"dates_box_color\";s:7:\"#eef0f2\";s:16:\"button_shortcode\";s:44:\"<h3 style=\'margin: 0;\'>Button Shortcode</h3>\";s:11:\"button_size\";s:5:\"Large\";s:12:\"button_shape\";s:5:\"Round\";s:11:\"button_type\";s:4:\"Flat\";s:25:\"button_gradient_top_color\";s:7:\"#D1E990\";s:28:\"button_gradient_bottom_color\";s:7:\"#AAD75B\";s:31:\"button_gradient_top_color_hover\";s:7:\"#AAD75B\";s:34:\"button_gradient_bottom_color_hover\";s:7:\"#D1E990\";s:19:\"button_accent_color\";s:7:\"#6e9a1f\";s:25:\"button_accent_hover_color\";s:7:\"#638e1a\";s:18:\"button_bevel_color\";s:7:\"#54770F\";s:19:\"button_border_width\";s:3:\"1px\";s:18:\"button_text_shadow\";i:0;s:18:\"carousel_shortcode\";s:46:\"<h3 style=\'margin: 0;\'>Carousel Shortcode</h3>\";s:18:\"carousel_nav_color\";s:7:\"#999999\";s:20:\"carousel_hover_color\";s:7:\"#808080\";s:12:\"cb_shortcode\";s:49:\"<h3 style=\'margin: 0;\'>Content Box Shortcode</h3>\";s:20:\"content_box_bg_color\";s:11:\"transparent\";s:19:\"checklist_shortcode\";s:47:\"<h3 style=\'margin: 0;\'>Checklist Shortcode</h3>\";s:16:\"checklist_circle\";i:1;s:22:\"checklist_circle_color\";s:7:\"#a0ce4e\";s:21:\"checklist_icons_color\";s:7:\"#ffffff\";s:12:\"cc_shortcode\";s:52:\"<h3 style=\'margin: 0;\'>Counter Circle Shortcode</h3>\";s:20:\"counter_filled_color\";s:7:\"#a0ce4e\";s:22:\"counter_unfilled_color\";s:7:\"#f6f6f6\";s:18:\"counterb_shortcode\";s:51:\"<h3 style=\'margin: 0;\'>Counter Boxes Shortcode</h3>\";s:17:\"counter_box_color\";s:7:\"#a0ce4e\";s:17:\"dropcap_shortcode\";s:45:\"<h3 style=\'margin: 0;\'>Dropcap Shortcode</h3>\";s:13:\"dropcap_color\";s:7:\"#a0ce4e\";s:15:\"flipb_shortcode\";s:48:\"<h3 style=\'margin: 0;\'>Flip Boxes Shortcode</h3>\";s:19:\"flip_boxes_front_bg\";s:7:\"#f6f6f6\";s:24:\"flip_boxes_front_heading\";s:7:\"#333333\";s:21:\"flip_boxes_front_text\";s:7:\"#747474\";s:18:\"flip_boxes_back_bg\";s:7:\"#a0ce4e\";s:23:\"flip_boxes_back_heading\";s:7:\"#eeeded\";s:20:\"flip_boxes_back_text\";s:7:\"#ffffff\";s:22:\"flip_boxes_border_size\";s:3:\"1px\";s:23:\"flip_boxes_border_color\";s:11:\"transparent\";s:24:\"flip_boxes_border_radius\";s:3:\"4px\";s:19:\"fullwidth_shortcode\";s:48:\"<h3 style=\'margin: 0;\'>Full Width Shortcode</h3>\";s:19:\"full_width_bg_color\";s:0:\"\";s:22:\"full_width_border_size\";s:3:\"0px\";s:23:\"full_width_border_color\";s:7:\"#eae9e9\";s:14:\"icon_shortcode\";s:42:\"<h3 style=\'margin: 0;\'>Icon Shortcode</h3>\";s:17:\"icon_circle_color\";s:7:\"#333333\";s:17:\"icon_border_color\";s:7:\"#333333\";s:10:\"icon_color\";s:7:\"#ffffff\";s:14:\"imgf_shortcode\";s:49:\"<h3 style=\'margin: 0;\'>Image Frame Shortcode</h3>\";s:21:\"imgframe_border_color\";s:7:\"#f6f6f6\";s:22:\"imageframe_border_size\";s:1:\"0\";s:20:\"imgframe_style_color\";s:7:\"#000000\";s:15:\"modal_shortcode\";s:43:\"<h3 style=\'margin: 0;\'>Modal Shortcode</h3>\";s:14:\"modal_bg_color\";s:7:\"#f6f6f6\";s:18:\"modal_border_color\";s:7:\"#ebebeb\";s:16:\"person_shortcode\";s:44:\"<h3 style=\'margin: 0;\'>Person Shortcode</h3>\";s:18:\"person_border_size\";s:1:\"0\";s:19:\"person_border_color\";s:7:\"#f6f6f6\";s:18:\"person_style_color\";s:7:\"#000000\";s:17:\"popover_shortcode\";s:45:\"<h3 style=\'margin: 0;\'>Popover Shortcode</h3>\";s:24:\"popover_heading_bg_color\";s:7:\"#f6f6f6\";s:24:\"popover_content_bg_color\";s:7:\"#ffffff\";s:20:\"popover_border_color\";s:7:\"#ebebeb\";s:18:\"popover_text_color\";s:7:\"#747474\";s:17:\"popover_placement\";s:3:\"Top\";s:22:\"pricingtable_shortcode\";s:51:\"<h3 style=\'margin: 0;\'>Pricing Table Shortcode</h3>\";s:36:\"full_boxed_pricing_box_heading_color\";s:7:\"#333333\";s:29:\"sep_pricing_box_heading_color\";s:7:\"#333333\";s:17:\"pricing_box_color\";s:7:\"#a0ce4e\";s:16:\"pricing_bg_color\";s:7:\"#ffffff\";s:20:\"pricing_border_color\";s:7:\"#f8f8f8\";s:21:\"pricing_divider_color\";s:7:\"#ededed\";s:21:\"progressbar_shortcode\";s:50:\"<h3 style=\'margin: 0;\'>Progress Bar Shortcode</h3>\";s:24:\"progressbar_filled_color\";s:7:\"#a0ce4e\";s:26:\"progressbar_unfilled_color\";s:7:\"#f6f6f6\";s:22:\"progressbar_text_color\";s:7:\"#ffffff\";s:19:\"separator_shortcode\";s:47:\"<h3 style=\'margin: 0;\'>Separator Shortcode</h3>\";s:9:\"sep_color\";s:7:\"#e0dede\";s:26:\"sectionseparator_shortcode\";s:55:\"<h3 style=\'margin: 0;\'>Section Separator Shortcode</h3>\";s:23:\"section_sep_border_size\";s:3:\"1px\";s:14:\"section_sep_bg\";s:7:\"#f6f6f6\";s:24:\"section_sep_border_color\";s:7:\"#f6f6f6\";s:20:\"sharingbox_shortcode\";s:49:\"<h3 style=\'margin: 0;\'>Sharing Box Shortcode</h3>\";s:20:\"sharing_box_bg_color\";s:7:\"#f6f6f6\";s:30:\"sharing_box_tagline_text_color\";s:7:\"#333333\";s:21:\"sociallinks_shortcode\";s:50:\"<h3 style=\'margin: 0;\'>Social Links Shortcode</h3>\";s:23:\"social_links_icon_color\";s:7:\"#bebdbd\";s:18:\"social_links_boxed\";s:2:\"No\";s:22:\"social_links_box_color\";s:7:\"#e8e8e8\";s:25:\"social_links_boxed_radius\";s:3:\"4px\";s:30:\"social_links_tooltip_placement\";s:3:\"Top\";s:14:\"tabs_shortcode\";s:42:\"<h3 style=\'margin: 0;\'>Tabs Shortcode</h3>\";s:13:\"tabs_bg_color\";s:7:\"#ffffff\";s:19:\"tabs_inactive_color\";s:7:\"#ebeaea\";s:17:\"tagline_shortcode\";s:45:\"<h3 style=\'margin: 0;\'>Tagline Shortcode</h3>\";s:10:\"tagline_bg\";s:7:\"#f6f6f6\";s:20:\"tagline_border_color\";s:7:\"#f6f6f6\";s:22:\"testimonials_shortcode\";s:50:\"<h3 style=\'margin: 0;\'>Testimonials Shortcode</h3>\";s:20:\"testimonial_bg_color\";s:7:\"#f6f6f6\";s:22:\"testimonial_text_color\";s:7:\"#747474\";s:18:\"testimonials_speed\";s:4:\"4000\";s:15:\"title_shortcode\";s:43:\"<h3 style=\'margin: 0;\'>Title Shortcode</h3>\";s:18:\"title_border_color\";s:7:\"#e0dede\";s:16:\"blog_single_post\";s:62:\"<h3 style=\'margin: 0;\'>Portfolio Single Post Page Options</h3>\";s:10:\"blog_title\";s:4:\"Blog\";s:13:\"blog_subtitle\";s:0:\"\";s:11:\"blog_layout\";s:5:\"Large\";s:21:\"blog_sidebar_position\";s:5:\"Right\";s:19:\"blog_archive_layout\";s:5:\"Large\";s:20:\"blog_archive_sidebar\";s:4:\"None\";s:20:\"blog_pagination_type\";s:10:\"pagination\";s:17:\"blog_grid_columns\";s:1:\"3\";s:14:\"content_length\";s:7:\"Excerpt\";s:19:\"excerpt_length_blog\";s:2:\"55\";s:18:\"strip_html_excerpt\";i:1;s:15:\"blog_full_width\";i:0;s:22:\"single_post_full_width\";i:0;s:15:\"featured_images\";i:1;s:32:\"alternate_date_format_month_year\";s:4:\"m, Y\";s:25:\"alternate_date_format_day\";s:1:\"j\";s:20:\"timeline_date_format\";s:3:\"F Y\";s:22:\"featured_images_single\";i:1;s:11:\"blog_pn_nav\";i:0;s:15:\"blog_post_title\";i:1;s:11:\"author_info\";i:1;s:18:\"social_sharing_box\";i:1;s:13:\"related_posts\";i:1;s:13:\"blog_comments\";i:1;s:9:\"blog_meta\";s:45:\"<h3 style=\'margin: 0;\'>Blog Meta Options</h3>\";s:9:\"post_meta\";i:1;s:16:\"post_meta_author\";i:0;s:14:\"post_meta_date\";i:0;s:14:\"post_meta_cats\";i:0;s:18:\"post_meta_comments\";i:0;s:14:\"post_meta_read\";i:0;s:14:\"post_meta_tags\";i:1;s:11:\"date_format\";s:7:\"F jS, Y\";s:15:\"portfolio_items\";s:2:\"10\";s:24:\"portfolio_archive_layout\";s:20:\"Portfolio One Column\";s:25:\"portfolio_archive_sidebar\";s:4:\"None\";s:24:\"portfolio_content_length\";s:7:\"Excerpt\";s:24:\"excerpt_length_portfolio\";s:2:\"55\";s:20:\"grid_pagination_type\";s:10:\"pagination\";s:14:\"portfolio_slug\";s:15:\"portfolio-items\";s:25:\"portfolio_featured_images\";i:1;s:16:\"portfolio_pn_nav\";i:0;s:18:\"portfolio_comments\";i:0;s:16:\"portfolio_author\";i:0;s:28:\"portfolio_social_sharing_box\";i:1;s:23:\"portfolio_related_posts\";i:1;s:35:\"social_share_box_icon_options_title\";s:57:\"<h3 style=\'margin: 0;\'>Social Share Box Icon Options</h3>\";s:15:\"social_bg_color\";s:7:\"#f6f6f6\";s:31:\"sharing_social_links_icon_color\";s:7:\"#bebdbd\";s:26:\"sharing_social_links_boxed\";s:2:\"No\";s:30:\"sharing_social_links_box_color\";s:7:\"#e8e8e8\";s:33:\"sharing_social_links_boxed_radius\";s:3:\"4px\";s:38:\"sharing_social_links_tooltip_placement\";s:3:\"Top\";s:28:\"social_share_box_links_title\";s:50:\"<h3 style=\'margin: 0;\'>Social Share Box Links</h3>\";s:16:\"sharing_facebook\";i:1;s:15:\"sharing_twitter\";i:1;s:14:\"sharing_reddit\";i:1;s:16:\"sharing_linkedin\";i:1;s:14:\"sharing_google\";i:1;s:14:\"sharing_tumblr\";i:1;s:17:\"sharing_pinterest\";i:1;s:13:\"sharing_email\";i:1;s:13:\"social_sorter\";s:0:\"\";s:27:\"custom_color_scheme_element\";s:46:\"<h3 style=\'margin: 0;\'>Custom Social Icon</h3>\";s:16:\"custom_icon_name\";s:0:\"\";s:17:\"custom_icon_image\";s:0:\"\";s:24:\"custom_icon_image_retina\";s:0:\"\";s:17:\"retina_icon_width\";s:0:\"\";s:18:\"retina_icon_height\";s:0:\"\";s:16:\"custom_icon_link\";s:0:\"\";s:22:\"posts_slideshow_number\";s:1:\"5\";s:18:\"slideshow_autoplay\";i:1;s:23:\"slideshow_smooth_height\";i:0;s:15:\"slideshow_speed\";s:4:\"7000\";s:22:\"pagination_video_slide\";i:0;s:22:\"legacy_posts_slideshow\";i:0;s:15:\"posts_slideshow\";i:1;s:17:\"tfes_slider_width\";s:4:\"100%\";s:18:\"tfes_slider_height\";s:5:\"400px\";s:14:\"tfes_animation\";s:5:\"sides\";s:13:\"tfes_autoplay\";i:1;s:13:\"tfes_interval\";s:4:\"3000\";s:10:\"tfes_speed\";s:3:\"800\";s:10:\"tfes_width\";s:3:\"150\";s:18:\"es_title_font_size\";s:2:\"42\";s:20:\"es_caption_font_size\";s:2:\"20\";s:14:\"es_title_color\";s:7:\"#333333\";s:16:\"es_caption_color\";s:7:\"#747474\";s:24:\"lightbox_animation_speed\";s:4:\"fast\";s:16:\"lightbox_gallery\";i:1;s:17:\"lightbox_autoplay\";i:0;s:24:\"lightbox_slideshow_speed\";s:4:\"5000\";s:16:\"lightbox_opacity\";s:3:\"0.8\";s:14:\"lightbox_title\";i:1;s:13:\"lightbox_desc\";i:1;s:15:\"lightbox_social\";i:1;s:20:\"lightbox_post_images\";i:0;s:10:\"google_map\";s:53:\"<h3 style=\'margin: 0;\'>Google Map Design Styling</h3>\";s:9:\"gmap_type\";s:7:\"roadmap\";s:10:\"gmap_width\";s:4:\"100%\";s:11:\"gmap_height\";s:5:\"415px\";s:14:\"gmap_topmargin\";s:4:\"55px\";s:12:\"gmap_address\";s:49:\"775 New York Ave, Brooklyn, Kings, New York 11203\";s:13:\"email_address\";s:0:\"\";s:14:\"map_zoom_level\";s:1:\"8\";s:7:\"map_pin\";i:0;s:9:\"map_popup\";i:0;s:15:\"map_scrollwheel\";i:0;s:9:\"map_scale\";i:0;s:15:\"map_zoomcontrol\";i:0;s:11:\"map_styling\";s:7:\"default\";s:17:\"map_overlay_color\";s:0:\"\";s:19:\"map_infobox_styling\";s:7:\"default\";s:19:\"map_infobox_content\";s:0:\"\";s:20:\"map_infobox_bg_color\";s:0:\"\";s:22:\"map_infobox_text_color\";s:0:\"\";s:22:\"map_custom_marker_icon\";s:0:\"\";s:9:\"recaptcha\";s:50:\"<h3 style=\'margin: 0;\'>ReCaptcha Spam Options</h3>\";s:16:\"recaptcha_public\";s:0:\"\";s:17:\"recaptcha_private\";s:0:\"\";s:22:\"recaptcha_color_scheme\";s:5:\"Clean\";s:16:\"sidebar_bg_color\";s:11:\"transparent\";s:13:\"content_width\";s:10:\"71.1702128\";s:13:\"sidebar_width\";s:10:\"23.4042553\";s:15:\"sidebar_padding\";s:1:\"0\";s:12:\"sidebar_info\";s:1140:\"<h3 style=\'margin-top:0;\'>Important Instructions For These Options:</h3><b>1.  100% </b>- Your values added up cannot go over 100% or your sidebar will not show.<br /></br />\n<b>2. PADDING </b>-  Is always multiplied by 2 because it adds left and right padding. So a padding value of 5, actually equals 10.  And you should only use padding if you are using a background color that is different than your main background color.<br /></br />\n\n<b>3.  UNSEEN SPACE</b> - You need to factor in the space between the Content Width &amp; Sidebar Width. This space does not have a field.<br /></br />\n\n<b>EXAMPLE 1:</b> Content Width = 65 + Sidebar Width = 30  + Padding = 0\n* this example adds up to 95% which leaves you 5% in between the content and sidebar sections. This is good to use if your sidebar background is the same color as your main background<br /></br />\n\n<b>EXAMPLE 2:</b> Content Width = 60 + Sidebar Width = 30  + Padding = 2.5\n* this example adds up to 95% which leaves you 5% in between the content and sidebar sections. This is good to use if your sidebar background is a different color than your main background\";s:6:\"search\";s:42:\"<h3 style=\'margin: 0;\'>Search Options</h3>\";s:13:\"search_layout\";s:5:\"Large\";s:14:\"search_sidebar\";s:4:\"None\";s:23:\"search_sidebar_position\";s:5:\"Right\";s:14:\"search_content\";s:15:\"Posts and Pages\";s:14:\"search_excerpt\";i:0;s:23:\"search_results_per_page\";s:2:\"10\";s:22:\"search_featured_images\";i:0;s:12:\"misc_options\";s:49:\"<h3 style=\'margin: 0;\'>Miscellaneous Options</h3>\";s:19:\"default_sidebar_pos\";s:5:\"right\";s:16:\"sidenav_behavior\";s:5:\"hover\";s:20:\"number_related_posts\";s:1:\"5\";s:12:\"excerpt_base\";s:5:\"words\";s:16:\"disable_excerpts\";i:0;s:14:\"link_read_more\";i:0;s:14:\"comments_pages\";i:0;s:21:\"featured_images_pages\";i:0;s:18:\"faq_featured_image\";i:0;s:21:\"nofollow_social_links\";i:0;s:16:\"social_icons_new\";i:1;s:22:\"google_console_api_key\";s:0:\"\";s:9:\"rollovers\";s:50:\"<h3 style=\'margin: 0;\'>Image Rollover Options</h3>\";s:14:\"image_rollover\";i:1;s:19:\"link_image_rollover\";i:0;s:19:\"zoom_image_rollover\";i:0;s:20:\"title_image_rollover\";i:0;s:19:\"cats_image_rollover\";i:0;s:22:\"image_rollover_opacity\";s:1:\"1\";s:12:\"bbpress_only\";s:43:\"<h3 style=\'margin: 0;\'>BBPress Options</h3>\";s:22:\"bbpress_global_sidebar\";i:0;s:15:\"ppbress_sidebar\";s:4:\"None\";s:22:\"enable_disable_heading\";s:76:\"<h3 style=\'margin: 0;\'>Enable / Disable Theme Features & Plugin Support</h3>\";s:16:\"disable_megamenu\";i:0;s:16:\"avada_rev_styles\";i:0;s:8:\"ubermenu\";i:0;s:15:\"use_animate_css\";i:0;s:26:\"disable_mobile_animate_css\";i:1;s:15:\"status_lightbox\";i:0;s:22:\"status_lightbox_single\";i:0;s:9:\"status_yt\";i:0;s:12:\"status_vimeo\";i:0;s:11:\"status_gmap\";i:0;s:12:\"status_totop\";i:0;s:19:\"status_totop_mobile\";i:0;s:20:\"status_fusion_slider\";i:0;s:14:\"status_eslider\";i:0;s:18:\"status_fontawesome\";i:0;s:16:\"status_opengraph\";i:0;s:9:\"woo_items\";s:2:\"12\";s:27:\"woocommerce_archive_sidebar\";s:4:\"None\";s:26:\"woocommerce_avada_ordering\";i:0;s:29:\"woocommerce_one_page_checkout\";i:0;s:30:\"woocommerce_enable_order_notes\";i:1;s:28:\"woocommerce_acc_link_top_nav\";i:1;s:29:\"woocommerce_cart_link_top_nav\";i:1;s:29:\"woocommerce_acc_link_main_nav\";i:0;s:30:\"woocommerce_cart_link_main_nav\";i:1;s:24:\"woocommerce_social_links\";i:1;s:13:\"woo_acc_msg_1\";s:55:\"Need Assistance? Call customer service at 888-555-5555.\";s:13:\"woo_acc_msg_2\";s:32:\"E-mail them at info@yourshop.com\";s:18:\"advanced_css_intro\";s:55:\"<h3 style=\'margin: 0;\'>Advanced CSS Customizations</h3>\";s:10:\"custom_css\";s:0:\"\";s:9:\"of_backup\";s:0:\"\";s:11:\"of_transfer\";s:0:\"\";s:13:\"theme_updater\";s:62:\"<h3 style=\'margin: 0;\'>Enter all 3 required fields below!</h3>\";s:11:\"tf_username\";s:0:\"\";s:6:\"tf_api\";s:0:\"\";s:16:\"tf_purchase_code\";s:0:\"\";}","yes");
INSERT INTO wp_options VALUES("177","shop_catalog_image_size","a:3:{s:5:\"width\";i:500;s:6:\"height\";s:0:\"\";i:0;i:0;}","yes");
INSERT INTO wp_options VALUES("178","shop_single_image_size","a:3:{s:5:\"width\";i:500;s:6:\"height\";s:0:\"\";i:0;i:0;}","yes");
INSERT INTO wp_options VALUES("179","shop_thumbnail_image_size","a:3:{s:5:\"width\";i:120;s:6:\"height\";s:0:\"\";i:0;i:0;}","yes");
INSERT INTO wp_options VALUES("226","theme_mods_seowp","a:60:{i:0;b:0;s:18:\"lbmn_header_preset\";s:249:\"a:3:{s:15:\"header_design_1\";a:1:{s:30:\"lbmn_headertop_backgroundcolor\";s:7:\"#2192dd\";}s:15:\"header_design_2\";a:1:{s:30:\"lbmn_headertop_backgroundcolor\";s:7:\"#222222\";}s:15:\"header_design_3\";a:1:{s:30:\"lbmn_headertop_backgroundcolor\";s:7:\"#333333\";}}\";s:18:\"nav_menu_locations\";a:1:{s:11:\"header-menu\";i:26;}s:38:\"lbmn_notificationpanel_backgroundcolor\";s:17:\"rgb(24, 101, 160)\";s:32:\"lbmn_notificationpanel_textcolor\";s:18:\"rgb(189, 227, 252)\";s:44:\"lbmn_notificationpanel_backgroundcolor_hover\";s:17:\"rgb(15, 119, 200)\";s:38:\"lbmn_notificationpanel_textcolor_hover\";s:18:\"rgb(255, 255, 255)\";s:26:\"lbmn_topbar_linkhovercolor\";s:18:\"rgb(255, 255, 255)\";s:36:\"lbmn_topbar_linkhoverbackgroundcolor\";s:17:\"rgb(86, 174, 227)\";s:30:\"lbmn_headertop_backgroundcolor\";s:19:\"rgba(0, 0, 0, 0.88)\";s:21:\"lbmn_headertop_height\";s:3:\"104\";s:26:\"lbmn_headertop_menu_height\";s:2:\"44\";s:36:\"lbmn_headertop_stick_backgroundcolor\";s:19:\"rgba(0, 0, 0, 0.78)\";s:19:\"lbmn_logo_placement\";s:11:\"bottom-left\";s:23:\"lbmn_megamenu_linkcolor\";s:17:\"rgb(42, 160, 239)\";s:38:\"lbmn_megamenu_linkhoverbackgroundcolor\";s:22:\"rgba(255, 255, 255, 0)\";s:28:\"lbmn_megamenu_textlinescolor\";s:18:\"rgb(129, 129, 129)\";s:37:\"lbmn_megamenu_dropdown_linkhovercolor\";s:18:\"rgb(255, 255, 255)\";s:47:\"lbmn_megamenu_dropdown_linkhoverbackgroundcolor\";s:17:\"rgb(86, 174, 227)\";s:33:\"lbmn_megamenu_dropdown_background\";s:18:\"rgb(255, 255, 255)\";s:37:\"lbmn_searchblock_inputbackgroundcolor\";s:18:\"rgb(255, 255, 255)\";s:33:\"lbmn_searchblock_textandiconcolor\";s:19:\"rgba(0, 0, 0, 0.78)\";s:29:\"lbmn_content_background_color\";s:18:\"rgb(255, 255, 255)\";s:26:\"lbmn_page_background_color\";s:18:\"rgb(102, 130, 144)\";s:23:\"lbmn_typography_p_color\";s:15:\"rgb(65, 72, 77)\";s:24:\"lbmn_typography_h1_color\";s:15:\"rgb(70, 72, 75)\";s:24:\"lbmn_typography_h2_color\";s:15:\"rgb(39, 40, 43)\";s:24:\"lbmn_typography_h3_color\";s:15:\"rgb(16, 16, 17)\";s:24:\"lbmn_typography_h4_color\";s:15:\"rgb(53, 54, 57)\";s:24:\"lbmn_typography_h5_color\";s:15:\"rgb(16, 16, 17)\";s:24:\"lbmn_typography_h6_color\";s:15:\"rgb(70, 72, 75)\";s:27:\"lbmn_calltoaction_textcolor\";s:18:\"rgb(255, 255, 255)\";s:33:\"lbmn_calltoaction_textcolor_hover\";s:18:\"rgb(255, 255, 255)\";s:29:\"lbmn_notificationpanel_switch\";s:0:\"\";s:30:\"lbmn_notificationpanel_message\";s:64:\"Find out about our responsive web design and seo packages today!\";s:18:\"lbmn_topbar_switch\";s:0:\"\";s:36:\"lbmn_topbar_firstlevelitems_iconsize\";s:2:\"15\";s:20:\"lbmn_headertop_stick\";i:1;s:18:\"lbmn_topbar_height\";s:2:\"50\";s:16:\"lbmn_logo_height\";s:3:\"100\";s:28:\"lbmn_megamenu_linkhovercolor\";s:17:\"rgb(161, 198, 39)\";s:38:\"lbmn_megamenu_firstlevelitems_fontsize\";s:2:\"17\";s:42:\"lbmn_megamenu_firstlevelitems_iconposition\";s:4:\"left\";s:23:\"lbmn_searchblock_switch\";s:0:\"\";s:35:\"lbmn_megamenu_firstlevelitems_align\";s:5:\"right\";s:42:\"lbmn_megamenu_firstlevelitems_innerspacing\";s:2:\"13\";s:38:\"lbmn_megamenu_firstlevelitems_iconsize\";s:2:\"15\";s:29:\"lbmn_notificationpanel_height\";s:2:\"40\";s:40:\"lbmn_topbar_firstlevelitems_iconposition\";s:4:\"left\";s:35:\"lbmn_megamenu_linkhoverborderradius\";s:1:\"1\";s:40:\"lbmn_megamenu_firstlevelitems_fontweight\";s:3:\"400\";s:32:\"lbmn_searchblock_inputfieldwidth\";s:3:\"100\";s:23:\"lbmn_searchblock_shadow\";s:4:\"none\";s:33:\"lbmn_searchblock_inputfieldradius\";s:1:\"0\";s:20:\"lbmn_logo_margin_top\";s:2:\"-2\";s:21:\"lbmn_logo_margin_left\";s:2:\"34\";s:22:\"lbmn_logo_margin_right\";s:2:\"-6\";s:25:\"lbmn_calltoaction_message\";s:62:\"Contact Us Today To Hear About Our Web Design and SEO Packages\";s:33:\"lbmn_calltoaction_backgroundcolor\";s:12:\"rgb(0, 0, 0)\";s:21:\"lbmn_calltoaction_url\";s:11:\"/contact-us\";}","yes");
INSERT INTO wp_options VALUES("227","lbmn_theme_updates_log","a:1:{i:0;s:5:\"1.7.5\";}","yes");
INSERT INTO wp_options VALUES("228","seowp_required_plugins_installed","1","yes");
INSERT INTO wp_options VALUES("233","dslc_plugin_options_widgets_m","a:1:{s:8:\"sidebars\";s:43:\"Sidebar,404 Page Widgets,Comment Form Area,\";}","yes");
INSERT INTO wp_options VALUES("234","seowp_basic_config_done","1","yes");
INSERT INTO wp_options VALUES("264","category_children","a:0:{}","yes");
INSERT INTO wp_options VALUES("265","seowp_democontent_imported","1","yes");
INSERT INTO wp_options VALUES("268","essb-fans-options","a:2:{s:6:\"social\";a:20:{s:8:\"facebook\";a:2:{s:2:\"id\";s:0:\"\";s:4:\"text\";s:4:\"Fans\";}s:7:\"twitter\";a:2:{s:2:\"id\";s:0:\"\";s:4:\"text\";s:9:\"Followers\";}s:6:\"google\";a:2:{s:2:\"id\";s:0:\"\";s:4:\"text\";s:9:\"Followers\";}s:7:\"youtube\";a:3:{s:2:\"id\";s:0:\"\";s:4:\"text\";s:11:\"Subscribers\";s:4:\"type\";s:4:\"User\";}s:5:\"vimeo\";a:1:{s:4:\"text\";s:11:\"Subscribers\";}s:8:\"dribbble\";a:2:{s:2:\"id\";s:0:\"\";s:4:\"text\";s:9:\"Followers\";}s:6:\"envato\";a:3:{s:2:\"id\";s:0:\"\";s:4:\"text\";s:9:\"Followers\";s:4:\"site\";s:11:\"themeforest\";}s:6:\"github\";a:1:{s:4:\"text\";s:9:\"Followers\";}s:10:\"soundcloud\";a:1:{s:4:\"text\";s:9:\"Followers\";}s:7:\"behance\";a:1:{s:4:\"text\";s:9:\"Followers\";}s:9:\"instagram\";a:1:{s:4:\"text\";s:9:\"Followers\";}s:9:\"delicious\";a:1:{s:4:\"text\";s:9:\"Followers\";}s:9:\"pinterest\";a:1:{s:4:\"text\";s:9:\"Followers\";}s:4:\"love\";a:1:{s:4:\"text\";s:5:\"Loves\";}s:2:\"vk\";a:1:{s:4:\"text\";s:7:\"Members\";}s:3:\"rss\";a:1:{s:4:\"text\";s:11:\"Subscribers\";}s:9:\"mailchimp\";a:1:{s:4:\"text\";s:11:\"Subscribers\";}s:5:\"users\";a:1:{s:4:\"text\";s:5:\"Users\";}s:5:\"posts\";a:1:{s:4:\"text\";s:5:\"Posts\";}s:8:\"comments\";a:1:{s:4:\"text\";s:8:\"Comments\";}}s:5:\"cache\";i:2;}","yes");
INSERT INTO wp_options VALUES("269","easy-social-share-buttons","a:11:{s:5:\"style\";i:1;s:8:\"networks\";a:24:{s:8:\"facebook\";a:2:{i:0;i:1;i:1;s:8:\"Facebook\";}s:7:\"twitter\";a:2:{i:0;i:1;i:1;s:7:\"Twitter\";}s:6:\"google\";a:2:{i:0;i:0;i:1;s:7:\"Google+\";}s:9:\"pinterest\";a:2:{i:0;i:0;i:1;s:9:\"Pinterest\";}s:8:\"linkedin\";a:2:{i:0;i:0;i:1;s:8:\"LinkedIn\";}s:4:\"digg\";a:2:{i:0;i:0;i:1;s:4:\"Digg\";}s:11:\"stumbleupon\";a:2:{i:0;i:0;i:1;s:11:\"StumbleUpon\";}s:2:\"vk\";a:2:{i:0;i:0;i:1;s:9:\"VKontakte\";}s:6:\"tumblr\";a:2:{i:0;i:0;i:1;s:6:\"Tumblr\";}s:5:\"print\";a:2:{i:0;i:0;i:1;s:5:\"Print\";}s:4:\"mail\";a:2:{i:0;i:1;i:1;s:6:\"E-mail\";}s:3:\"del\";a:2:{i:0;i:0;i:1;s:3:\"Del\";}s:6:\"flattr\";a:2:{i:0;i:0;i:1;s:6:\"Flattr\";}s:6:\"reddit\";a:2:{i:0;i:0;i:1;s:6:\"Reddit\";}s:6:\"buffer\";a:2:{i:0;i:0;i:1;s:6:\"Buffer\";}s:4:\"love\";a:2:{i:0;i:0;i:1;s:9:\"Love This\";}s:5:\"weibo\";a:2:{i:0;i:0;i:1;s:5:\"Weibo\";}s:6:\"pocket\";a:2:{i:0;i:0;i:1;s:6:\"Pocket\";}s:4:\"xing\";a:2:{i:0;i:0;i:1;s:4:\"Xing\";}s:2:\"ok\";a:2:{i:0;i:0;i:1;s:13:\"Odnoklassniki\";}s:3:\"mwp\";a:2:{i:0;i:0;i:1;s:12:\"ManageWP.org\";}s:4:\"more\";a:2:{i:0;i:0;i:1;s:11:\"More Button\";}s:8:\"whatsapp\";a:2:{i:0;i:0;i:1;s:8:\"WhatsApp\";}s:7:\"meneame\";a:2:{i:0;i:0;i:1;s:7:\"Meneame\";}}s:12:\"show_counter\";i:0;s:16:\"hide_social_name\";i:0;s:11:\"target_link\";i:1;s:12:\"twitter_user\";s:0:\"\";s:16:\"display_in_types\";a:1:{i:0;s:4:\"post\";}s:13:\"display_where\";s:6:\"bottom\";s:12:\"mail_subject\";s:27:\"Visit this site %%siteurl%%\";s:9:\"mail_body\";s:76:\"Hi, this may be intersting you: \"%%title%%\"! This is the link: %%permalink%%\";s:6:\"colors\";a:3:{s:8:\"bg_color\";s:0:\"\";s:9:\"txt_color\";s:0:\"\";s:20:\"facebook_like_button\";s:5:\"false\";}}","yes");
INSERT INTO wp_options VALUES("271","masterslider_db_version","1.03","yes");
INSERT INTO wp_options VALUES("272","masterslider_capabilities_added","1","yes");
INSERT INTO wp_options VALUES("273","nex-forms-version","3.4","yes");
INSERT INTO wp_options VALUES("274","basix-client-id","87746042","yes");
INSERT INTO wp_options VALUES("275","iz-default-fields","a:1:{s:9:\"nex_forms\";N;}","yes");
INSERT INTO wp_options VALUES("276","iz-modules-base","a:2:{i:0;s:9:\"nex_forms\";i:1;s:13:\"not installed\";}","yes");
INSERT INTO wp_options VALUES("277","iz-firstrun","a:2:{i:0;s:9:\"nex_forms\";i:1;b:1;}","yes");
INSERT INTO wp_options VALUES("278","iz-filters","a:1:{s:9:\"nex_forms\";a:1:{i:0;s:0:\"\";}}","yes");
INSERT INTO wp_options VALUES("279","iz-active-modules","a:1:{s:9:\"nex_forms\";a:1:{i:0;s:0:\"\";}}","yes");
INSERT INTO wp_options VALUES("280","iz-linked-modules","a:1:{s:9:\"nex_forms\";a:1:{i:0;s:0:\"\";}}","yes");
INSERT INTO wp_options VALUES("281","iz-module-widgets","a:1:{s:9:\"nex_forms\";a:1:{i:0;s:0:\"\";}}","yes");
INSERT INTO wp_options VALUES("282","iz-pluggables","a:2:{i:0;s:0:\"\";i:1;s:9:\"nex_forms\";}","yes");
INSERT INTO wp_options VALUES("283","iz-menus","a:2:{i:0;s:0:\"\";s:9:\"NEX-Forms\";a:2:{s:9:\"menu_page\";a:7:{s:10:\"page_title\";s:9:\"NEX-Forms\";s:10:\"menu_title\";s:9:\"NEX-Forms\";s:10:\"capability\";s:13:\"administrator\";s:9:\"menu_slug\";s:14:\"nex-forms-main\";s:8:\"function\";s:18:\"NEXForms_main_page\";s:8:\"icon_url\";s:107:\"http://capitaldistrictdigital.com/wp-content/plugins/nex-forms-express-wp-form-builder/images/menu_icon.png\";s:9:\"position \";s:0:\"\";}s:13:\"sub_menu_page\";a:4:{s:12:\"Form Builder\";a:6:{s:11:\"parent_slug\";s:14:\"nex-forms-main\";s:10:\"page_title\";s:12:\"Form Builder\";s:10:\"menu_title\";s:12:\"Form Builder\";s:10:\"capability\";s:13:\"administrator\";s:9:\"menu_slug\";s:14:\"nex-forms-main\";s:8:\"function\";s:18:\"NEXForms_main_page\";}s:12:\"Form Entries\";a:6:{s:11:\"parent_slug\";s:14:\"nex-forms-main\";s:10:\"page_title\";s:12:\"Form Entries\";s:10:\"menu_title\";s:12:\"Form Entries\";s:10:\"capability\";s:13:\"administrator\";s:9:\"menu_slug\";s:22:\"nex-forms-form-entries\";s:8:\"function\";s:26:\"NEXForms_form_entries_page\";}s:15:\"Global Settings\";a:6:{s:11:\"parent_slug\";s:14:\"nex-forms-main\";s:10:\"page_title\";s:15:\"Global Settings\";s:10:\"menu_title\";s:15:\"Global Settings\";s:10:\"capability\";s:13:\"administrator\";s:9:\"menu_slug\";s:25:\"nex-forms-global-settings\";s:8:\"function\";s:27:\"NEXForms_form_settings_page\";}s:6:\"export\";a:6:{s:11:\"parent_slug\";s:14:\"nex-forms-main\";s:10:\"page_title\";s:6:\"export\";s:10:\"menu_title\";s:6:\"export\";s:10:\"capability\";s:13:\"administrator\";s:9:\"menu_slug\";s:16:\"nex-forms-export\";s:8:\"function\";s:25:\"NEXForms_form_export_page\";}}}}","yes");
INSERT INTO wp_options VALUES("284","iz-ui-positions","a:2:{i:0;s:0:\"\";s:9:\"nex_forms\";a:1:{i:0;s:0:\"\";}}","yes");
INSERT INTO wp_options VALUES("285","nsu_form","a:14:{s:13:\"load_form_css\";i:0;s:9:\"use_html5\";i:1;s:13:\"submit_button\";s:7:\"Sign up\";s:10:\"name_label\";s:5:\"Name:\";s:11:\"email_label\";s:6:\"Email:\";s:19:\"email_default_value\";s:19:\"Your emailaddress..\";s:13:\"name_required\";i:0;s:18:\"name_default_value\";s:11:\"Your name..\";s:7:\"wpautop\";i:0;s:17:\"text_after_signup\";s:95:\"Thanks for signing up to our newsletter. Please check your inbox to confirm your email address.\";s:11:\"redirect_to\";s:0:\"\";s:15:\"text_empty_name\";s:30:\"Please fill in the name field.\";s:16:\"text_empty_email\";s:31:\"Please fill in the email field.\";s:18:\"text_invalid_email\";s:35:\"Please enter a valid email address.\";}","yes");
INSERT INTO wp_options VALUES("286","nsu_mailinglist","a:6:{s:8:\"provider\";s:0:\"\";s:7:\"use_api\";i:0;s:19:\"subscribe_with_name\";i:0;s:8:\"email_id\";s:0:\"\";s:7:\"name_id\";s:0:\"\";s:11:\"form_action\";s:0:\"\";}","yes");
INSERT INTO wp_options VALUES("287","nsu_checkbox","a:10:{s:4:\"text\";s:29:\"Sign me up for the newsletter\";s:11:\"redirect_to\";s:0:\"\";s:8:\"precheck\";i:0;s:11:\"cookie_hide\";i:0;s:9:\"css_reset\";i:0;s:24:\"add_to_registration_form\";i:0;s:19:\"add_to_comment_form\";i:1;s:22:\"add_to_buddypress_form\";i:0;s:21:\"add_to_multisite_form\";i:0;s:20:\"add_to_bbpress_forms\";i:0;}","yes");
INSERT INTO wp_options VALUES("288","sb_map_db_version","1.0","yes");
INSERT INTO wp_options VALUES("289","wp_rankie_table_version","3","yes");
INSERT INTO wp_options VALUES("290","seowp_hide_quicksetup","1","yes");
INSERT INTO wp_options VALUES("292","dslc_plugin_options","a:1:{s:15:\"lc_css_position\";s:4:\"body\";}","yes");
INSERT INTO wp_options VALUES("293","wp_rankie_last_run","1459703559","yes");
INSERT INTO wp_options VALUES("294","masterslider_default_options_added","1","yes");
INSERT INTO wp_options VALUES("295","masterslider_default_buttons_added","1","yes");
INSERT INTO wp_options VALUES("296","external_updates-easy-social-share-buttons","O:8:\"stdClass\":3:{s:9:\"lastCheck\";i:1459682968;s:14:\"checkedVersion\";s:5:\"2.0.7\";s:6:\"update\";O:8:\"stdClass\":6:{s:2:\"id\";i:0;s:4:\"slug\";s:25:\"easy-social-share-buttons\";s:7:\"version\";s:5:\"2.0.7\";s:8:\"homepage\";s:87:\"http://codecanyon.net/item/easy-social-share-buttons-for-wordpress/6394476?ref=appscreo\";s:12:\"download_url\";s:112:\"http://update.creoworx.com/essb/download.php?key=126d0802ec0faa8e575e38a41ea299f8&slug=easy-social-share-buttons\";s:14:\"upgrade_notice\";s:107:\"Service update with instructions on how to update to version 3 - that version does not contain new features\";}}","yes");
INSERT INTO wp_options VALUES("297","msp_general_setting","","yes");
INSERT INTO wp_options VALUES("298","msp_woocommerce","","yes");
INSERT INTO wp_options VALUES("299","msp_advanced","","yes");
INSERT INTO wp_options VALUES("300","wp_rankie_license_active","active","yes");
INSERT INTO wp_options VALUES("301","wp_rankie_license_active_date","1424355404","yes");
INSERT INTO wp_options VALUES("302","masterslider_plugin_version","2.9.7","yes");
INSERT INTO wp_options VALUES("303","mega_main_menu_options","a:66:{s:31:\"topbar_menu_first_level_link_bg\";s:0:\"\";s:23:\"topbar_menu_bg_gradient\";a:2:{s:6:\"color2\";s:0:\"\";s:6:\"color1\";s:0:\"\";}s:28:\"topbar_menu_dropdown_link_bg\";a:2:{s:6:\"color2\";s:0:\"\";s:6:\"color1\";s:0:\"\";}s:30:\"topbar_first_level_item_height\";s:2:\"50\";s:34:\"topbar_menu_first_level_link_color\";s:25:\"rgba(150, 193, 216, 0.81)\";s:40:\"topbar_menu_first_level_link_color_hover\";s:18:\"rgb(255, 255, 255)\";s:37:\"topbar_menu_first_level_link_bg_hover\";a:2:{s:6:\"color2\";s:17:\"rgb(86, 174, 227)\";s:6:\"color1\";s:17:\"rgb(86, 174, 227)\";}s:33:\"topbar_menu_first_level_link_font\";a:3:{s:11:\"font_family\";s:0:\"\";s:11:\"font_weight\";i:400;s:9:\"font_size\";s:2:\"15\";}s:29:\"topbar_first_level_item_align\";s:5:\"right\";s:33:\"topbar_first_level_icons_position\";s:4:\"left\";s:33:\"topbar_menu_first_level_icon_font\";a:1:{s:9:\"font_size\";s:2:\"15\";}s:28:\"topbar_first_level_separator\";s:6:\"smooth\";s:39:\"header-menu_menu_first_level_link_color\";s:17:\"rgb(42, 160, 239)\";s:45:\"header-menu_menu_first_level_link_color_hover\";s:17:\"rgb(161, 198, 39)\";s:42:\"header-menu_menu_first_level_link_bg_hover\";a:2:{s:6:\"color2\";s:22:\"rgba(255, 255, 255, 0)\";s:6:\"color1\";s:22:\"rgba(255, 255, 255, 0)\";}s:38:\"header-menu_menu_first_level_link_font\";a:3:{s:11:\"font_family\";s:0:\"\";s:11:\"font_weight\";s:3:\"400\";s:9:\"font_size\";s:2:\"17\";}s:34:\"header-menu_first_level_item_align\";s:5:\"right\";s:38:\"header-menu_first_level_icons_position\";s:4:\"left\";s:38:\"header-menu_menu_first_level_icon_font\";a:1:{s:9:\"font_size\";s:2:\"15\";}s:33:\"header-menu_first_level_separator\";s:6:\"smooth\";s:42:\"header-menu_menu_dropdown_plain_text_color\";s:21:\"rgba(2, 11, 18, 0.63)\";s:37:\"topbar_menu_dropdown_plain_text_color\";s:21:\"rgba(2, 11, 18, 0.63)\";s:36:\"header-menu_menu_dropdown_link_color\";s:21:\"rgba(2, 11, 18, 0.63)\";s:31:\"topbar_menu_dropdown_link_color\";s:21:\"rgba(2, 11, 18, 0.63)\";s:42:\"header-menu_menu_dropdown_link_color_hover\";s:18:\"rgb(255, 255, 255)\";s:37:\"topbar_menu_dropdown_link_color_hover\";s:18:\"rgb(255, 255, 255)\";s:39:\"header-menu_menu_dropdown_link_bg_hover\";a:2:{s:6:\"color2\";s:17:\"rgb(86, 174, 227)\";s:6:\"color1\";s:17:\"rgb(86, 174, 227)\";}s:34:\"topbar_menu_dropdown_link_bg_hover\";a:2:{s:6:\"color2\";s:17:\"rgb(86, 174, 227)\";s:6:\"color1\";s:17:\"rgb(86, 174, 227)\";}s:42:\"header-menu_menu_dropdown_wrapper_gradient\";a:2:{s:6:\"color2\";s:18:\"rgb(255, 255, 255)\";s:6:\"color1\";s:18:\"rgb(255, 255, 255)\";}s:37:\"topbar_menu_dropdown_wrapper_gradient\";a:2:{s:6:\"color2\";s:18:\"rgb(255, 255, 255)\";s:6:\"color1\";s:18:\"rgb(255, 255, 255)\";}s:35:\"header-menu_menu_dropdown_icon_font\";a:1:{s:9:\"font_size\";i:19;}s:30:\"topbar_menu_dropdown_icon_font\";a:1:{s:9:\"font_size\";i:19;}s:43:\"header-menu_menu_dropdown_link_border_color\";s:25:\"rgba(141, 141, 141, 0.07)\";s:38:\"topbar_menu_dropdown_link_border_color\";s:25:\"rgba(141, 141, 141, 0.07)\";s:35:\"header-menu_menu_dropdown_link_font\";a:3:{s:11:\"font_family\";s:0:\"\";s:9:\"font_size\";s:2:\"15\";s:11:\"font_weight\";i:300;}s:30:\"topbar_menu_dropdown_link_font\";a:3:{s:11:\"font_family\";s:0:\"\";s:9:\"font_size\";s:2:\"15\";s:11:\"font_weight\";i:300;}s:26:\"topbar_dropdowns_animation\";s:6:\"anim_4\";s:31:\"header-menu_dropdowns_animation\";s:6:\"anim_4\";s:23:\"topbar_corners_rounding\";i:3;s:28:\"header-menu_corners_rounding\";i:3;s:31:\"header-menu_included_components\";a:1:{i:0;s:12:\"company_logo\";}s:8:\"logo_src\";s:89:\"http://capitaldistrictdigital.com/wp-content/uploads/2015/06/cdd_logo_greenblue_small.png\";s:11:\"logo_height\";s:3:\"100\";s:35:\"header-menu_first_level_item_height\";s:2:\"44\";s:17:\"responsive_styles\";a:1:{i:1;s:4:\"true\";}s:23:\"topbar_mobile_minimized\";a:0:{}s:28:\"header-menu_mobile_minimized\";a:1:{i:1;s:4:\"true\";}s:42:\"header-menu_first_level_item_height_sticky\";s:2:\"34\";s:25:\"header-menu_sticky_offset\";s:3:\"134\";s:26:\"header-menu_menu_search_bg\";s:18:\"rgb(255, 255, 255)\";s:21:\"topbar_menu_search_bg\";s:18:\"rgb(255, 255, 255)\";s:29:\"header-menu_menu_search_color\";s:19:\"rgba(0, 0, 0, 0.78)\";s:24:\"topbar_menu_search_color\";s:19:\"rgba(0, 0, 0, 0.78)\";s:37:\"topbar_first_level_item_height_sticky\";s:0:\"\";s:32:\"topbar_first_level_button_height\";s:0:\"\";s:20:\"topbar_menu_bg_image\";s:0:\"\";s:36:\"header-menu_menu_first_level_link_bg\";s:0:\"\";s:37:\"header-menu_first_level_button_height\";s:0:\"\";s:25:\"header-menu_menu_bg_image\";s:0:\"\";s:28:\"header-menu_menu_bg_gradient\";a:2:{s:6:\"color2\";s:0:\"\";s:6:\"color1\";s:0:\"\";}s:33:\"header-menu_menu_dropdown_link_bg\";a:2:{s:6:\"color2\";s:0:\"\";s:6:\"color1\";s:0:\"\";}s:19:\"set_of_google_fonts\";a:0:{}s:21:\"responsive_resolution\";s:4:\"1025\";s:13:\"last_modified\";i:1437073151;s:19:\"mega_menu_locations\";a:2:{i:0;s:6:\"topbar\";i:1;s:11:\"header-menu\";}s:25:\"header-menu_sticky_status\";a:1:{i:1;s:4:\"true\";}}","yes");
INSERT INTO wp_options VALUES("306","ffpf_ffWPUpgrader_response_from_our_server","a:0:{}","yes");
INSERT INTO wp_options VALUES("307","recently_activated","a:0:{}","yes");
INSERT INTO wp_options VALUES("311","msp_envato_license","","yes");
INSERT INTO wp_options VALUES("315","theme_mods_twentyfourteen","a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1424356212;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}","yes");
INSERT INTO wp_options VALUES("328","WPLANG","","yes");
INSERT INTO wp_options VALUES("329","_transient_random_seed","275d7dfa376ee6bb1f9a2afd2465a3d4","yes");
INSERT INTO wp_options VALUES("344","lbmn_theme_options","a:1:{s:15:\"lbmn_logo_image\";s:89:\"http://capitaldistrictdigital.com/wp-content/uploads/2015/06/cdd_logo_greenblue_small.png\";}","yes");
INSERT INTO wp_options VALUES("373","seowp_menuid_topbar","","yes");
INSERT INTO wp_options VALUES("374","seowp_menuid_header","26","yes");
INSERT INTO wp_options VALUES("376","nav_menu_options","a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}","yes");
INSERT INTO wp_options VALUES("421","dslc_module_id_count","857","yes");
INSERT INTO wp_options VALUES("521","dslc_projects_cats_children","a:0:{}","yes");
INSERT INTO wp_options VALUES("1013","widget_nav_menu","a:2:{i:3;a:2:{s:5:\"title\";s:9:\"Main Menu\";s:8:\"nav_menu\";i:26;}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("1380","_site_transient_update_themes","O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1459703393;s:7:\"checked\";a:1:{s:5:\"seowp\";s:5:\"1.7.5\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}}","yes");
INSERT INTO wp_options VALUES("2457","dslc_templates","s:8209:\"a:4:{s:11:\"project-tem\";a:4:{s:5:\"title\";s:11:\"Project Tem\";s:2:\"id\";s:11:\"project-tem\";s:4:\"code\";s:2856:\"[dslc_modules_section type=\"wrapped\" columns_spacing=\"spacing\" bg_color=\"\" bg_image_thumb=\"disabled\" bg_image=\"\" bg_image_repeat=\"repeat\" bg_image_position=\"left top\" bg_image_attachment=\"scroll\" bg_image_size=\"auto\" bg_video=\"\" bg_video_overlay_color=\"#000000\" bg_video_overlay_opacity=\"0\" border_color=\"\" border_width=\"0\" border_style=\"solid\" border=\"top right bottom left\" margin_h=\"0\" margin_b=\"0\" padding=\"80\" padding_h=\"0\" custom_class=\"\" custom_id=\"\" ] [dslc_modules_area last=\"no\" first=\"yes\" size=\"6\"] [dslc_module]YTo0OntzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6NzQ7czo3OiJwb3N0X2lkIjtzOjQ6IjE0OTYiO3M6MTE6ImRzbGNfbV9zaXplIjtzOjI6IjEyIjtzOjk6Im1vZHVsZV9pZCI7czoxNzoiRFNMQ19UUF9UaHVtYm5haWwiO30=[/dslc_module] [/dslc_modules_area] [dslc_modules_area last=\"yes\" first=\"no\" size=\"6\"] [dslc_module]YTo0OntzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6NzU7czo3OiJwb3N0X2lkIjtzOjQ6IjE0OTYiO3M6MTE6ImRzbGNfbV9zaXplIjtzOjI6IjEyIjtzOjk6Im1vZHVsZV9pZCI7czoxMzoiRFNMQ19UUF9UaXRsZSI7fQ==[/dslc_module] [dslc_module]YTo2OntzOjE2OiJjc3NfYm9yZGVyX2NvbG9yIjtzOjIyOiJyZ2JhKDIzNywgMjM3LCAyMzcsIDApIjtzOjY6ImhlaWdodCI7czoyOiIxMCI7czoxODoibW9kdWxlX2luc3RhbmNlX2lkIjtzOjI6Ijc2IjtzOjc6InBvc3RfaWQiO3M6NDoiMTQ5NiI7czoxMToiZHNsY19tX3NpemUiO3M6MjoiMTIiO3M6OToibW9kdWxlX2lkIjtzOjE0OiJEU0xDX1NlcGFyYXRvciI7fQ==[/dslc_module] [dslc_module]YTo0OntzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6Nzg7czo3OiJwb3N0X2lkIjtzOjQ6IjE0OTYiO3M6MTE6ImRzbGNfbV9zaXplIjtzOjI6IjEyIjtzOjk6Im1vZHVsZV9pZCI7czoxNToiRFNMQ19UUF9FeGNlcnB0Ijt9[/dslc_module] [dslc_module]YTo2OntzOjE2OiJjc3NfYm9yZGVyX2NvbG9yIjtzOjIyOiJyZ2JhKDIzNywgMjM3LCAyMzcsIDApIjtzOjY6ImhlaWdodCI7czoyOiIxMCI7czoxODoibW9kdWxlX2luc3RhbmNlX2lkIjtzOjI6Ijc3IjtzOjc6InBvc3RfaWQiO3M6NDoiMTQ5NiI7czoxMToiZHNsY19tX3NpemUiO3M6MjoiMTIiO3M6OToibW9kdWxlX2lkIjtzOjE0OiJEU0xDX1NlcGFyYXRvciI7fQ==[/dslc_module] [dslc_module]YToxMjp7czoxMToiYnV0dG9uX3RleHQiO3M6MTM6IlZJU0lUIFdFQlNJVEUiO3M6MTI6ImNzc19iZ19jb2xvciI7czoxNjoicmdiKDE2NCwgMTk3LCAxKSI7czoyMDoiY3NzX3BhZGRpbmdfdmVydGljYWwiO3M6MToiOSI7czoyMjoiY3NzX3BhZGRpbmdfaG9yaXpvbnRhbCI7czoyOiIyOCI7czoxNjoiY3NzX2J1dHRvbl9jb2xvciI7czoxODoicmdiKDI1NSwgMjU1LCAyNTUpIjtzOjIyOiJjc3NfYnV0dG9uX2ZvbnRfd2VpZ2h0IjtzOjM6IjQwMCI7czoxNDoiYnV0dG9uX2ljb25faWQiO3M6MTU6ImV4dC1wYXBlcnBsYW5lMiI7czoxNToiY3NzX2ljb25fbWFyZ2luIjtzOjI6IjE2IjtzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO3M6MjoiNzkiO3M6NzoicG9zdF9pZCI7czo0OiIxNDk2IjtzOjExOiJkc2xjX21fc2l6ZSI7czoyOiIxMiI7czo5OiJtb2R1bGVfaWQiO3M6MTE6IkRTTENfQnV0dG9uIjt9[/dslc_module] [dslc_module]YTo3OntzOjE0OiJjc3NfdGV4dF9hbGlnbiI7czo1OiJyaWdodCI7czoxMjoiY3NzX2JnX2NvbG9yIjtzOjE0OiJyZ2IoMCwgNTAsIDY2KSI7czoxODoiY3NzX2JnX2NvbG9yX2hvdmVyIjtzOjE3OiJyZ2IoNzUsIDEyMywgMTk0KSI7czoxODoibW9kdWxlX2luc3RhbmNlX2lkIjtzOjI6IjgwIjtzOjc6InBvc3RfaWQiO3M6NDoiMTQ5NiI7czoxMToiZHNsY19tX3NpemUiO3M6MjoiMTIiO3M6OToibW9kdWxlX2lkIjtzOjExOiJEU0xDX1NvY2lhbCI7fQ==[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] \";s:7:\"section\";s:4:\"user\";}s:5:\"staff\";a:4:{s:5:\"title\";s:5:\"Staff\";s:2:\"id\";s:5:\"staff\";s:4:\"code\";s:1444:\"[dslc_modules_section type=\"wrapped\" columns_spacing=\"spacing\" bg_color=\"\" bg_image_thumb=\"disabled\" bg_image=\"\" bg_image_repeat=\"repeat\" bg_image_position=\"left top\" bg_image_attachment=\"scroll\" bg_image_size=\"auto\" bg_video=\"\" bg_video_overlay_color=\"#000000\" bg_video_overlay_opacity=\"0\" border_color=\"\" border_width=\"0\" border_style=\"solid\" border=\"top right bottom left\" margin_h=\"0\" margin_b=\"0\" padding=\"80\" padding_h=\"0\" custom_class=\"\" custom_id=\"\" ] [dslc_modules_area last=\"no\" first=\"yes\" size=\"8\"] [dslc_module]YTo0OntzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6Mzg2O3M6NzoicG9zdF9pZCI7czo0OiIxNTM0IjtzOjExOiJkc2xjX21fc2l6ZSI7czoyOiIxMiI7czo5OiJtb2R1bGVfaWQiO3M6MTM6IkRTTENfVFBfVGl0bGUiO30=[/dslc_module] [dslc_module]YTo0OntzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6MzgxO3M6NzoicG9zdF9pZCI7czo0OiIxNTM0IjtzOjExOiJkc2xjX21fc2l6ZSI7czoyOiIxMiI7czo5OiJtb2R1bGVfaWQiO3M6MTU6IkRTTENfVFBfQ29udGVudCI7fQ==[/dslc_module] [dslc_module]YTo0OntzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6MzgyO3M6NzoicG9zdF9pZCI7czo0OiIxNTM0IjtzOjExOiJkc2xjX21fc2l6ZSI7czoyOiIxMiI7czo5OiJtb2R1bGVfaWQiO3M6MjA6IkRTTENfVFBfU3RhZmZfU29jaWFsIjt9[/dslc_module] [/dslc_modules_area] [dslc_modules_area last=\"yes\" first=\"no\" size=\"4\"] [dslc_module]YTo0OntzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6Mzg1O3M6NzoicG9zdF9pZCI7czo0OiIxNTM0IjtzOjExOiJkc2xjX21fc2l6ZSI7czoyOiIxMiI7czo5OiJtb2R1bGVfaWQiO3M6MTc6IkRTTENfVFBfVGh1bWJuYWlsIjt9[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] \";s:7:\"section\";s:4:\"user\";}s:6:\"staff2\";a:4:{s:5:\"title\";s:6:\"staff2\";s:2:\"id\";s:6:\"staff2\";s:4:\"code\";s:1720:\"[dslc_modules_section type=\"wrapped\" columns_spacing=\"spacing\" bg_color=\"\" bg_image_thumb=\"disabled\" bg_image=\"\" bg_image_repeat=\"repeat\" bg_image_position=\"left top\" bg_image_attachment=\"scroll\" bg_image_size=\"auto\" bg_video=\"\" bg_video_overlay_color=\"#000000\" bg_video_overlay_opacity=\"0\" border_color=\"\" border_width=\"0\" border_style=\"solid\" border=\"top right bottom left\" margin_h=\"0\" margin_b=\"0\" padding=\"80\" padding_h=\"0\" custom_class=\"\" custom_id=\"\" ] [dslc_modules_area last=\"no\" first=\"yes\" size=\"8\"] [dslc_module]YTo0OntzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6Mzg2O3M6NzoicG9zdF9pZCI7czo0OiIxNTM0IjtzOjExOiJkc2xjX21fc2l6ZSI7czoyOiIxMiI7czo5OiJtb2R1bGVfaWQiO3M6MTM6IkRTTENfVFBfVGl0bGUiO30=[/dslc_module] [dslc_module]YTo1OntzOjc6ImNvbnRlbnQiO3M6Mjc6IjxoMz5EaWdpdGFsIENvbnN1bHRhbnQ8L2gzPiI7czoxODoibW9kdWxlX2luc3RhbmNlX2lkIjtzOjM6IjM5MiI7czo3OiJwb3N0X2lkIjtzOjQ6IjE1MzQiO3M6MTE6ImRzbGNfbV9zaXplIjtzOjI6IjEyIjtzOjk6Im1vZHVsZV9pZCI7czoxNjoiRFNMQ19UZXh0X1NpbXBsZSI7fQ==[/dslc_module] [dslc_module]YTo0OntzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6MzgxO3M6NzoicG9zdF9pZCI7czo0OiIxNTM0IjtzOjExOiJkc2xjX21fc2l6ZSI7czoyOiIxMiI7czo5OiJtb2R1bGVfaWQiO3M6MTU6IkRTTENfVFBfQ29udGVudCI7fQ==[/dslc_module] [dslc_module]YTo0OntzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6MzgyO3M6NzoicG9zdF9pZCI7czo0OiIxNTM0IjtzOjExOiJkc2xjX21fc2l6ZSI7czoyOiIxMiI7czo5OiJtb2R1bGVfaWQiO3M6MjA6IkRTTENfVFBfU3RhZmZfU29jaWFsIjt9[/dslc_module] [/dslc_modules_area] [dslc_modules_area last=\"yes\" first=\"no\" size=\"4\"] [dslc_module]YTo0OntzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6Mzg1O3M6NzoicG9zdF9pZCI7czo0OiIxNTM0IjtzOjExOiJkc2xjX21fc2l6ZSI7czoyOiIxMiI7czo5OiJtb2R1bGVfaWQiO3M6MTc6IkRTTENfVFBfVGh1bWJuYWlsIjt9[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] \";s:7:\"section\";s:4:\"user\";}s:6:\"staff3\";a:4:{s:5:\"title\";s:6:\"staff3\";s:2:\"id\";s:6:\"staff3\";s:4:\"code\";s:1720:\"[dslc_modules_section type=\"wrapped\" columns_spacing=\"spacing\" bg_color=\"\" bg_image_thumb=\"disabled\" bg_image=\"\" bg_image_repeat=\"repeat\" bg_image_position=\"left top\" bg_image_attachment=\"scroll\" bg_image_size=\"auto\" bg_video=\"\" bg_video_overlay_color=\"#000000\" bg_video_overlay_opacity=\"0\" border_color=\"\" border_width=\"0\" border_style=\"solid\" border=\"top right bottom left\" margin_h=\"0\" margin_b=\"0\" padding=\"80\" padding_h=\"0\" custom_class=\"\" custom_id=\"\" ] [dslc_modules_area last=\"no\" first=\"yes\" size=\"8\"] [dslc_module]YTo0OntzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6Mzg2O3M6NzoicG9zdF9pZCI7czo0OiIxNTM0IjtzOjExOiJkc2xjX21fc2l6ZSI7czoyOiIxMiI7czo5OiJtb2R1bGVfaWQiO3M6MTM6IkRTTENfVFBfVGl0bGUiO30=[/dslc_module] [dslc_module]YTo1OntzOjc6ImNvbnRlbnQiO3M6Mjc6IjxoMz5EaWdpdGFsIENvbnN1bHRhbnQ8L2gzPiI7czoxODoibW9kdWxlX2luc3RhbmNlX2lkIjtzOjM6IjM5MiI7czo3OiJwb3N0X2lkIjtzOjQ6IjE1MzQiO3M6MTE6ImRzbGNfbV9zaXplIjtzOjI6IjEyIjtzOjk6Im1vZHVsZV9pZCI7czoxNjoiRFNMQ19UZXh0X1NpbXBsZSI7fQ==[/dslc_module] [dslc_module]YTo0OntzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6MzgxO3M6NzoicG9zdF9pZCI7czo0OiIxNTM0IjtzOjExOiJkc2xjX21fc2l6ZSI7czoyOiIxMiI7czo5OiJtb2R1bGVfaWQiO3M6MTU6IkRTTENfVFBfQ29udGVudCI7fQ==[/dslc_module] [dslc_module]YTo0OntzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6MzgyO3M6NzoicG9zdF9pZCI7czo0OiIxNTM0IjtzOjExOiJkc2xjX21fc2l6ZSI7czoyOiIxMiI7czo5OiJtb2R1bGVfaWQiO3M6MjA6IkRTTENfVFBfU3RhZmZfU29jaWFsIjt9[/dslc_module] [/dslc_modules_area] [dslc_modules_area last=\"yes\" first=\"no\" size=\"4\"] [dslc_module]YTo0OntzOjE4OiJtb2R1bGVfaW5zdGFuY2VfaWQiO2k6Mzg1O3M6NzoicG9zdF9pZCI7czo0OiIxNTM0IjtzOjExOiJkc2xjX21fc2l6ZSI7czoyOiIxMiI7czo5OiJtb2R1bGVfaWQiO3M6MTc6IkRTTENfVFBfVGh1bWJuYWlsIjt9[/dslc_module] [/dslc_modules_area] [/dslc_modules_section] \";s:7:\"section\";s:4:\"user\";}}\";","yes");
INSERT INTO wp_options VALUES("2622","nex-forms-email-config","a:2:{s:12:\"email_method\";s:10:\"php_mailer\";s:9:\"smtp_auth\";s:1:\"0\";}","yes");
INSERT INTO wp_options VALUES("2623","nex-forms-script-config","a:7:{s:10:\"inc-jquery\";s:1:\"1\";s:18:\"inc-jquery-ui-core\";s:1:\"1\";s:26:\"inc-jquery-ui-autocomplete\";s:1:\"1\";s:20:\"inc-jquery-ui-slider\";s:1:\"1\";s:15:\"inc-jquery-form\";s:1:\"1\";s:13:\"inc-bootstrap\";s:1:\"1\";s:10:\"inc-onload\";s:1:\"1\";}","yes");
INSERT INTO wp_options VALUES("2624","nex-forms-style-config","a:4:{s:15:\"incstyle-jquery\";s:1:\"1\";s:21:\"incstyle-font-awesome\";s:1:\"1\";s:18:\"incstyle-bootstrap\";s:1:\"1\";s:15:\"incstyle-custom\";s:1:\"1\";}","yes");
INSERT INTO wp_options VALUES("2625","nex-forms-other-config","a:4:{s:20:\"enable-print-scripts\";s:1:\"1\";s:19:\"enable-print-styles\";s:1:\"1\";s:14:\"enable-tinymce\";s:1:\"1\";s:13:\"enable-widget\";s:1:\"1\";}","yes");
INSERT INTO wp_options VALUES("2626","nex-forms-convert-old-form-entries","1","yes");
INSERT INTO wp_options VALUES("2756","widget_calendar","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("2757","widget_easy-social-share-fans-counter","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("2758","widget_easy-social-share-buttons-widget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("2759","widget_essb_top_social_posts","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("2760","widget_master-slider-main-widget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("2761","widget_mega_main_sidebar_menu","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("2762","widget_newslettersignupwidget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("2763","widget_pages","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("2765","widget_sbmap_widget","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("2766","widget_tag_cloud","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("2781","wpseo","a:21:{s:14:\"blocking_files\";a:0:{}s:26:\"ignore_blog_public_warning\";b:0;s:31:\"ignore_meta_description_warning\";b:0;s:20:\"ignore_page_comments\";b:0;s:16:\"ignore_permalink\";b:0;s:15:\"ms_defaults_set\";b:0;s:23:\"theme_description_found\";s:0:\"\";s:21:\"theme_has_description\";b:0;s:7:\"version\";s:5:\"3.1.2\";s:11:\"alexaverify\";s:0:\"\";s:12:\"company_logo\";s:83:\"http://capitaldistrictdigital.com/wp-content/uploads/2015/06/cdd_logo_greenblue.png\";s:12:\"company_name\";s:24:\"Capital District Digital\";s:17:\"company_or_person\";s:7:\"company\";s:20:\"disableadvanced_meta\";b:1;s:19:\"onpage_indexability\";b:1;s:12:\"googleverify\";s:43:\"3qNGqyjdpb7KaWL9BBHp-FQYw3anXExSjspBzTfH8BU\";s:8:\"msverify\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:12:\"website_name\";s:24:\"Capital District Digital\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";}","yes");
INSERT INTO wp_options VALUES("2782","wpseo_permalinks","a:13:{s:15:\"cleanpermalinks\";b:0;s:24:\"cleanpermalink-extravars\";s:0:\"\";s:29:\"cleanpermalink-googlecampaign\";b:0;s:31:\"cleanpermalink-googlesitesearch\";b:0;s:15:\"cleanreplytocom\";b:0;s:10:\"cleanslugs\";b:1;s:14:\"hide-feedlinks\";b:0;s:12:\"hide-rsdlink\";b:0;s:14:\"hide-shortlink\";b:0;s:16:\"hide-wlwmanifest\";b:0;s:18:\"redirectattachment\";b:0;s:17:\"stripcategorybase\";b:0;s:13:\"trailingslash\";b:0;}","yes");
INSERT INTO wp_options VALUES("2783","wpseo_titles","a:153:{s:10:\"title_test\";i:0;s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:5:\"noodp\";b:0;s:6:\"noydir\";b:0;s:15:\"usemetakeywords\";b:0;s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:41:\"%%name%%, Author at %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:63:\"You searched for %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:35:\"Page not found %%sep%% %%sitename%%\";s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:18:\"metakey-home-wpseo\";s:0:\"\";s:20:\"metakey-author-wpseo\";s:0:\"\";s:22:\"noindex-subpages-wpseo\";b:0;s:20:\"noindex-author-wpseo\";b:0;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"metakey-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:13:\"showdate-post\";b:0;s:16:\"hideeditbox-post\";b:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"metakey-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:13:\"showdate-page\";b:0;s:16:\"hideeditbox-page\";b:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"metakey-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:19:\"showdate-attachment\";b:0;s:22:\"hideeditbox-attachment\";b:0;s:18:\"title-lbmn_archive\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-lbmn_archive\";s:0:\"\";s:20:\"metakey-lbmn_archive\";s:0:\"\";s:20:\"noindex-lbmn_archive\";b:0;s:21:\"showdate-lbmn_archive\";b:0;s:24:\"hideeditbox-lbmn_archive\";b:0;s:17:\"title-lbmn_footer\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:20:\"metadesc-lbmn_footer\";s:0:\"\";s:19:\"metakey-lbmn_footer\";s:0:\"\";s:19:\"noindex-lbmn_footer\";b:0;s:20:\"showdate-lbmn_footer\";b:0;s:23:\"hideeditbox-lbmn_footer\";b:0;s:20:\"title-dslc_templates\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:23:\"metadesc-dslc_templates\";s:0:\"\";s:22:\"metakey-dslc_templates\";s:0:\"\";s:22:\"noindex-dslc_templates\";b:0;s:23:\"showdate-dslc_templates\";b:0;s:26:\"hideeditbox-dslc_templates\";b:0;s:19:\"title-dslc_projects\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:22:\"metadesc-dslc_projects\";s:0:\"\";s:21:\"metakey-dslc_projects\";s:0:\"\";s:21:\"noindex-dslc_projects\";b:0;s:22:\"showdate-dslc_projects\";b:0;s:25:\"hideeditbox-dslc_projects\";b:0;s:20:\"title-dslc_galleries\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:23:\"metadesc-dslc_galleries\";s:0:\"\";s:22:\"metakey-dslc_galleries\";s:0:\"\";s:22:\"noindex-dslc_galleries\";b:0;s:23:\"showdate-dslc_galleries\";b:0;s:26:\"hideeditbox-dslc_galleries\";b:0;s:16:\"title-dslc_staff\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-dslc_staff\";s:0:\"\";s:18:\"metakey-dslc_staff\";s:0:\"\";s:18:\"noindex-dslc_staff\";b:0;s:19:\"showdate-dslc_staff\";b:0;s:22:\"hideeditbox-dslc_staff\";b:0;s:20:\"title-dslc_downloads\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:23:\"metadesc-dslc_downloads\";s:0:\"\";s:22:\"metakey-dslc_downloads\";s:0:\"\";s:22:\"noindex-dslc_downloads\";b:0;s:23:\"showdate-dslc_downloads\";b:0;s:26:\"hideeditbox-dslc_downloads\";b:0;s:23:\"title-dslc_testimonials\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:26:\"metadesc-dslc_testimonials\";s:0:\"\";s:25:\"metakey-dslc_testimonials\";s:0:\"\";s:25:\"noindex-dslc_testimonials\";b:0;s:26:\"showdate-dslc_testimonials\";b:0;s:29:\"hideeditbox-dslc_testimonials\";b:0;s:19:\"title-dslc_partners\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:22:\"metadesc-dslc_partners\";s:0:\"\";s:21:\"metakey-dslc_partners\";s:0:\"\";s:21:\"noindex-dslc_partners\";b:0;s:22:\"showdate-dslc_partners\";b:0;s:25:\"hideeditbox-dslc_partners\";b:0;s:28:\"title-ptarchive-lbmn_archive\";s:51:\"%%pt_plural%% Archive %%page%% %%sep%% %%sitename%%\";s:31:\"metadesc-ptarchive-lbmn_archive\";s:0:\"\";s:30:\"metakey-ptarchive-lbmn_archive\";s:0:\"\";s:30:\"bctitle-ptarchive-lbmn_archive\";s:0:\"\";s:30:\"noindex-ptarchive-lbmn_archive\";b:0;s:27:\"title-ptarchive-lbmn_footer\";s:51:\"%%pt_plural%% Archive %%page%% %%sep%% %%sitename%%\";s:30:\"metadesc-ptarchive-lbmn_footer\";s:0:\"\";s:29:\"metakey-ptarchive-lbmn_footer\";s:0:\"\";s:29:\"bctitle-ptarchive-lbmn_footer\";s:0:\"\";s:29:\"noindex-ptarchive-lbmn_footer\";b:0;s:18:\"title-tax-category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:20:\"metakey-tax-category\";s:0:\"\";s:24:\"hideeditbox-tax-category\";b:0;s:20:\"noindex-tax-category\";b:0;s:18:\"title-tax-post_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:20:\"metakey-tax-post_tag\";s:0:\"\";s:24:\"hideeditbox-tax-post_tag\";b:0;s:20:\"noindex-tax-post_tag\";b:0;s:21:\"title-tax-post_format\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:23:\"metakey-tax-post_format\";s:0:\"\";s:27:\"hideeditbox-tax-post_format\";b:0;s:23:\"noindex-tax-post_format\";b:1;s:28:\"title-tax-dslc_projects_cats\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:31:\"metadesc-tax-dslc_projects_cats\";s:0:\"\";s:30:\"metakey-tax-dslc_projects_cats\";s:0:\"\";s:34:\"hideeditbox-tax-dslc_projects_cats\";b:0;s:30:\"noindex-tax-dslc_projects_cats\";b:0;s:29:\"title-tax-dslc_galleries_cats\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:32:\"metadesc-tax-dslc_galleries_cats\";s:0:\"\";s:31:\"metakey-tax-dslc_galleries_cats\";s:0:\"\";s:35:\"hideeditbox-tax-dslc_galleries_cats\";b:0;s:31:\"noindex-tax-dslc_galleries_cats\";b:0;s:25:\"title-tax-dslc_staff_cats\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:28:\"metadesc-tax-dslc_staff_cats\";s:0:\"\";s:27:\"metakey-tax-dslc_staff_cats\";s:0:\"\";s:31:\"hideeditbox-tax-dslc_staff_cats\";b:0;s:27:\"noindex-tax-dslc_staff_cats\";b:0;s:29:\"title-tax-dslc_downloads_cats\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:32:\"metadesc-tax-dslc_downloads_cats\";s:0:\"\";s:31:\"metakey-tax-dslc_downloads_cats\";s:0:\"\";s:35:\"hideeditbox-tax-dslc_downloads_cats\";b:0;s:31:\"noindex-tax-dslc_downloads_cats\";b:0;s:29:\"title-tax-dslc_downloads_tags\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:32:\"metadesc-tax-dslc_downloads_tags\";s:0:\"\";s:31:\"metakey-tax-dslc_downloads_tags\";s:0:\"\";s:35:\"hideeditbox-tax-dslc_downloads_tags\";b:0;s:31:\"noindex-tax-dslc_downloads_tags\";b:0;s:32:\"title-tax-dslc_testimonials_cats\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:35:\"metadesc-tax-dslc_testimonials_cats\";s:0:\"\";s:34:\"metakey-tax-dslc_testimonials_cats\";s:0:\"\";s:38:\"hideeditbox-tax-dslc_testimonials_cats\";b:0;s:34:\"noindex-tax-dslc_testimonials_cats\";b:0;s:28:\"title-tax-dslc_partners_cats\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:31:\"metadesc-tax-dslc_partners_cats\";s:0:\"\";s:30:\"metakey-tax-dslc_partners_cats\";s:0:\"\";s:34:\"hideeditbox-tax-dslc_partners_cats\";b:0;s:30:\"noindex-tax-dslc_partners_cats\";b:0;}","yes");
INSERT INTO wp_options VALUES("2784","wpseo_social","a:21:{s:9:\"fb_admins\";a:0:{}s:12:\"fbconnectkey\";s:32:\"227e58fff4a17533a9e22d44682cff1c\";s:13:\"facebook_site\";s:71:\"https://www.facebook.com/pages/Capital-District-Digital/415010842034708\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:9:\"opengraph\";b:1;s:10:\"googleplus\";b:0;s:13:\"pinterest_url\";s:40:\"https://www.pinterest.com/capdisdigital/\";s:15:\"pinterestverify\";s:32:\"d2f7319410bd7db0707d0441b66560da\";s:14:\"plus-publisher\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:13:\"CapDisDigital\";s:17:\"twitter_card_type\";s:7:\"summary\";s:11:\"youtube_url\";s:0:\"\";s:15:\"google_plus_url\";s:79:\"https://plus.google.com/u/0/b/113967157393345972529/113967157393345972529/about\";s:10:\"fbadminapp\";s:0:\"\";}","yes");
INSERT INTO wp_options VALUES("2785","wpseo_rss","a:2:{s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:53:\"The post %%POSTLINK%% appeared first on %%BLOGLINK%%.\";}","yes");
INSERT INTO wp_options VALUES("2786","wpseo_internallinks","a:23:{s:20:\"breadcrumbs-404crumb\";s:25:\"Error 404: Page not found\";s:23:\"breadcrumbs-blog-remove\";b:0;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:12:\"Archives for\";s:18:\"breadcrumbs-enable\";b:0;s:16:\"breadcrumbs-home\";s:4:\"Home\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:16:\"You searched for\";s:15:\"breadcrumbs-sep\";s:7:\"&raquo;\";s:23:\"post_types-post-maintax\";i:0;s:32:\"post_types-dslc_projects-maintax\";i:0;s:33:\"post_types-dslc_galleries-maintax\";i:0;s:29:\"post_types-dslc_staff-maintax\";i:0;s:33:\"post_types-dslc_downloads-maintax\";i:0;s:36:\"post_types-dslc_testimonials-maintax\";i:0;s:32:\"post_types-dslc_partners-maintax\";i:0;s:36:\"taxonomy-dslc_projects_cats-ptparent\";i:0;s:37:\"taxonomy-dslc_galleries_cats-ptparent\";i:0;s:33:\"taxonomy-dslc_staff_cats-ptparent\";i:0;s:37:\"taxonomy-dslc_downloads_cats-ptparent\";i:0;s:37:\"taxonomy-dslc_downloads_tags-ptparent\";i:0;s:40:\"taxonomy-dslc_testimonials_cats-ptparent\";i:0;s:36:\"taxonomy-dslc_partners_cats-ptparent\";i:0;}","yes");
INSERT INTO wp_options VALUES("2787","wpseo_xml","a:31:{s:22:\"disable_author_sitemap\";b:1;s:22:\"disable_author_noposts\";b:1;s:16:\"enablexmlsitemap\";b:1;s:16:\"entries-per-page\";i:1000;s:38:\"user_role-administrator-not_in_sitemap\";b:0;s:31:\"user_role-editor-not_in_sitemap\";b:0;s:31:\"user_role-author-not_in_sitemap\";b:0;s:36:\"user_role-contributor-not_in_sitemap\";b:0;s:35:\"user_role-subscriber-not_in_sitemap\";b:0;s:30:\"post_types-post-not_in_sitemap\";b:0;s:30:\"post_types-page-not_in_sitemap\";b:0;s:36:\"post_types-attachment-not_in_sitemap\";b:1;s:38:\"post_types-lbmn_archive-not_in_sitemap\";b:0;s:37:\"post_types-lbmn_footer-not_in_sitemap\";b:0;s:40:\"post_types-dslc_templates-not_in_sitemap\";b:0;s:39:\"post_types-dslc_projects-not_in_sitemap\";b:0;s:40:\"post_types-dslc_galleries-not_in_sitemap\";b:0;s:36:\"post_types-dslc_staff-not_in_sitemap\";b:0;s:40:\"post_types-dslc_downloads-not_in_sitemap\";b:0;s:43:\"post_types-dslc_testimonials-not_in_sitemap\";b:0;s:39:\"post_types-dslc_partners-not_in_sitemap\";b:0;s:34:\"taxonomies-category-not_in_sitemap\";b:0;s:34:\"taxonomies-post_tag-not_in_sitemap\";b:0;s:37:\"taxonomies-post_format-not_in_sitemap\";b:0;s:44:\"taxonomies-dslc_projects_cats-not_in_sitemap\";b:0;s:45:\"taxonomies-dslc_galleries_cats-not_in_sitemap\";b:0;s:41:\"taxonomies-dslc_staff_cats-not_in_sitemap\";b:0;s:45:\"taxonomies-dslc_downloads_cats-not_in_sitemap\";b:0;s:45:\"taxonomies-dslc_downloads_tags-not_in_sitemap\";b:0;s:48:\"taxonomies-dslc_testimonials_cats-not_in_sitemap\";b:0;s:44:\"taxonomies-dslc_partners_cats-not_in_sitemap\";b:0;}","yes");
INSERT INTO wp_options VALUES("2994","hms_testimonials_db_version","15","yes");
INSERT INTO wp_options VALUES("2995","hms_testimonials","a:20:{s:4:\"role\";s:13:\"administrator\";s:11:\"autoapprove\";s:13:\"administrator\";s:9:\"moderator\";s:13:\"administrator\";s:13:\"resetapproval\";i:1;s:20:\"num_users_can_create\";i:1;s:17:\"show_active_links\";i:0;s:21:\"active_links_nofollow\";i:1;s:30:\"moderators_can_access_settings\";i:1;s:9:\"collation\";s:17:\"latin1_swedish_ci\";s:13:\"use_recaptcha\";i:0;s:20:\"recaptcha_privatekey\";s:0:\"\";s:19:\"recaptcha_publickey\";s:0:\"\";s:11:\"image_width\";i:100;s:12:\"image_height\";i:100;s:7:\"js_load\";i:0;s:20:\"testimonial_contaner\";s:10:\"blockquote\";s:11:\"flood_limit\";i:5;s:13:\"form_show_url\";i:1;s:16:\"form_show_upload\";i:0;s:15:\"nl2br_on_output\";i:1;}","yes");
INSERT INTO wp_options VALUES("3163","widget_hms_testimonial_view","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("3164","widget_hms_testimonial_rotator","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("3671","vfb_db_version","2.8","yes");
INSERT INTO wp_options VALUES("3672","vfb_dashboard_widget_options","a:1:{s:28:\"vfb_dashboard_recent_entries\";a:1:{s:5:\"items\";i:5;}}","yes");
INSERT INTO wp_options VALUES("3674","widget_vfb_widget","a:2:{i:2;a:2:{s:2:\"id\";i:1;s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("5942","finished_splitting_shared_terms","1","yes");
INSERT INTO wp_options VALUES("6365","sc_project","10593828","yes");
INSERT INTO wp_options VALUES("6366","key_sc_security","2c90e7be","yes");
INSERT INTO wp_options VALUES("6367","sc_invisible","1","yes");
INSERT INTO wp_options VALUES("6372","sc_position","footer","yes");
INSERT INTO wp_options VALUES("6659","dslc_staff_cats_children","a:0:{}","yes");
INSERT INTO wp_options VALUES("7870","wordfence_version","6.0.25","yes");
INSERT INTO wp_options VALUES("7871","wordfenceActivated","1","yes");
INSERT INTO wp_options VALUES("7872","wf_plugin_act_error","","yes");
INSERT INTO wp_options VALUES("7876","essb-dismiss3","yes","yes");
INSERT INTO wp_options VALUES("11993","ld_http_auth","none","yes");
INSERT INTO wp_options VALUES("11994","ld_hide_wp_admin","1","yes");
INSERT INTO wp_options VALUES("11995","ld_login_base","newadminpage","yes");
INSERT INTO wp_options VALUES("14387","jetpack_options","a:9:{s:7:\"version\";s:16:\"3.9.5:1459458522\";s:11:\"old_version\";s:16:\"3.9.4:1457598262\";s:28:\"fallback_no_verify_ssl_certs\";i:0;s:9:\"time_diff\";i:0;s:2:\"id\";i:104024585;s:6:\"public\";i:1;s:9:\"jumpstart\";s:19:\"jumpstart_dismissed\";s:11:\"master_user\";i:1;s:14:\"last_heartbeat\";i:1459396965;}","yes");
INSERT INTO wp_options VALUES("14388","jetpack_activated","1","yes");
INSERT INTO wp_options VALUES("14389","jetpack_file_data","a:1:{s:5:\"3.9.5\";a:49:{s:32:\"31e5b9ae08b62c2b0cd8a7792242298b\";a:14:{s:4:\"name\";s:20:\"Spelling and Grammar\";s:11:\"description\";s:89:\"Check your spelling, style, and grammar with the After the Deadline proofreading service.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"6\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:115:\"after the deadline, afterthedeadline, spell, spellchecker, spelling, grammar, proofreading, style, language, cliche\";}s:32:\"3f41b2d629265b5de8108b463abbe8e2\";a:14:{s:4:\"name\";s:8:\"Carousel\";s:11:\"description\";s:63:\"Transform standard image galleries into full-screen slideshows.\";s:14:\"jumpstart_desc\";s:79:\"Brings your photos and images to life as full-size, easily navigable galleries.\";s:4:\"sort\";s:2:\"22\";s:20:\"recommendation_order\";s:2:\"12\";s:10:\"introduced\";s:3:\"1.5\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:9:\"Jumpstart\";s:25:\"additional_search_queries\";s:80:\"gallery, carousel, diaporama, slideshow, images, lightbox, exif, metadata, image\";}s:32:\"c6ebb418dde302de09600a6025370583\";a:14:{s:4:\"name\";s:8:\"Comments\";s:11:\"description\";s:79:\"Let readers comment with WordPress.com, Twitter, Facebook, or Google+ accounts.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"20\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:53:\"comments, comment, facebook, twitter, google+, social\";}s:32:\"836f9485669e1bbb02920cb474730df0\";a:14:{s:4:\"name\";s:12:\"Contact Form\";s:11:\"description\";s:44:\"Insert a contact form anywhere on your site.\";s:14:\"jumpstart_desc\";s:111:\"Adds a button to your post and page editors, allowing you to build simple forms to help visitors stay in touch.\";s:4:\"sort\";s:2:\"15\";s:20:\"recommendation_order\";s:2:\"14\";s:10:\"introduced\";s:3:\"1.3\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:5:\"Other\";s:7:\"feature\";s:9:\"Jumpstart\";s:25:\"additional_search_queries\";s:44:\"contact, form, grunion, feedback, submission\";}s:32:\"ea3970eebf8aac55fc3eca5dca0e0157\";a:14:{s:4:\"name\";s:20:\"Custom Content Types\";s:11:\"description\";s:92:\"Organize and display different types of content on your site, separate from posts and pages.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"34\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:72:\"cpt, custom post types, portfolio, portfolios, testimonial, testimonials\";}s:32:\"d2bb05ccad3d8789df40ca3abb97336c\";a:14:{s:4:\"name\";s:10:\"Custom CSS\";s:11:\"description\";s:57:\"Customize your site’s CSS without modifying your theme.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"2\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.7\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:108:\"css, customize, custom, style, editor, less, sass, preprocessor, font, mobile, appearance, theme, stylesheet\";}s:32:\"a2064eec5b9c7e0d816af71dee7a715f\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"53a4ec755022ef3953699734c343da02\";a:14:{s:4:\"name\";s:21:\"Enhanced Distribution\";s:11:\"description\";s:27:\"Increase reach and traffic.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"5\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:7:\"Traffic\";s:25:\"additional_search_queries\";s:54:\"google, seo, firehose, search, broadcast, broadcasting\";}s:32:\"72fecb67ee6704ba0a33e0225316ad06\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"d56e2886185a9eace719cc57d46770df\";a:14:{s:4:\"name\";s:19:\"Gravatar Hovercards\";s:11:\"description\";s:58:\"Enable pop-up business cards over commenters’ Gravatars.\";s:14:\"jumpstart_desc\";s:131:\"Let commenters link their profiles to their Gravatar accounts, making it easy for your visitors to learn more about your community.\";s:4:\"sort\";s:2:\"11\";s:20:\"recommendation_order\";s:2:\"13\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:18:\"Social, Appearance\";s:7:\"feature\";s:9:\"Jumpstart\";s:25:\"additional_search_queries\";s:20:\"gravatar, hovercards\";}s:32:\"e391e760617bd0e0736550e34a73d7fe\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:8:\"2.0.3 ??\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"2e345370766346c616b3c5046e817720\";a:14:{s:4:\"name\";s:15:\"Infinite Scroll\";s:11:\"description\";s:46:\"Add support for infinite scroll to your theme.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"26\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:33:\"scroll, infinite, infinite scroll\";}s:32:\"bd69edbf134de5fae8fdcf2e70a45b56\";a:14:{s:4:\"name\";s:8:\"JSON API\";s:11:\"description\";s:69:\"Allow applications to securely access your content through the cloud.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"19\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:19:\"Writing, Developers\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:50:\"api, rest, develop, developers, json, klout, oauth\";}s:32:\"8110b7a4423aaa619dfa46b8843e10d1\";a:14:{s:4:\"name\";s:14:\"Beautiful Math\";s:11:\"description\";s:85:\"Use LaTeX markup language in posts and pages for complex equations and other geekery.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"12\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:47:\"latex, math, equation, equations, formula, code\";}s:32:\"fd7e85d3b4887fa6b6f997d6592c1f33\";a:14:{s:4:\"name\";s:5:\"Likes\";s:11:\"description\";s:70:\"Give visitors an easy way to show their appreciation for your content.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"23\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:26:\"like, likes, wordpress.com\";}s:32:\"c5dfef41fad5bcdcaae8e315e5cfc420\";a:14:{s:4:\"name\";s:6:\"Manage\";s:11:\"description\";s:76:\"Manage all your sites from a centralized place, https://wordpress.com/sites.\";s:14:\"jumpstart_desc\";s:151:\"Helps you remotely manage plugins, turn on automated updates, and more from <a href=\"https://wordpress.com/plugins/\" target=\"_blank\">wordpress.com</a>.\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"3\";s:10:\"introduced\";s:3:\"3.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:35:\"Centralized Management, Recommended\";s:7:\"feature\";s:22:\"Recommended, Jumpstart\";s:25:\"additional_search_queries\";s:26:\"manage, management, remote\";}s:32:\"fd6dc399b92bce76013427e3107c314f\";a:14:{s:4:\"name\";s:8:\"Markdown\";s:11:\"description\";s:51:\"Write posts or pages in plain-text Markdown syntax.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"31\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.8\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:12:\"md, markdown\";}s:32:\"c49a35b6482b0426cb07ad28ecf5d7df\";a:14:{s:4:\"name\";s:12:\"Mobile Theme\";s:11:\"description\";s:64:\"Optimize your site with a mobile-friendly theme for smartphones.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"21\";s:20:\"recommendation_order\";s:2:\"11\";s:10:\"introduced\";s:3:\"1.8\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:31:\"Appearance, Mobile, Recommended\";s:7:\"feature\";s:11:\"Recommended\";s:25:\"additional_search_queries\";s:24:\"mobile, theme, minileven\";}s:32:\"b42e38f6fafd2e4104ebe5bf39b4be47\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"771cfeeba0d3d23ec344d5e781fb0ae2\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"54f0661d27c814fc8bde39580181d939\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"46c4c413b5c72bbd3c3dbd14ff8f8adc\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"9ea52fa25783e5ceeb6bfaed3268e64e\";a:14:{s:4:\"name\";s:7:\"Monitor\";s:11:\"description\";s:25:\"Reports on site downtime.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"28\";s:20:\"recommendation_order\";s:2:\"10\";s:10:\"introduced\";s:3:\"2.6\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:33:\"Recommended, Performance-Security\";s:25:\"additional_search_queries\";s:37:\"monitor, uptime, downtime, monitoring\";}s:32:\"cfcaafd0fcad087899d715e0b877474d\";a:14:{s:4:\"name\";s:13:\"Notifications\";s:11:\"description\";s:84:\"Receive notification of site activity via the admin toolbar and your Mobile devices.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"13\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:5:\"Other\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:62:\"notification, notifications, toolbar, adminbar, push, comments\";}s:32:\"0d18bfa69bec61550c1d813ce64149b0\";a:14:{s:4:\"name\";s:10:\"Omnisearch\";s:11:\"description\";s:66:\"Search your entire database from a single field in your Dashboard.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"16\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.3\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:10:\"Developers\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:6:\"search\";}s:32:\"3f0a11e23118f0788d424b646a6d465f\";a:14:{s:4:\"name\";s:6:\"Photon\";s:11:\"description\";s:27:\"Speed up images and photos.\";s:14:\"jumpstart_desc\";s:141:\"Mirrors and serves your images from our free and fast image CDN, improving your site’s performance with no additional load on your servers.\";s:4:\"sort\";s:2:\"25\";s:20:\"recommendation_order\";s:1:\"1\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:42:\"Photos and Videos, Appearance, Recommended\";s:7:\"feature\";s:44:\"Recommended, Jumpstart, Performance-Security\";s:25:\"additional_search_queries\";s:38:\"photon, image, cdn, performance, speed\";}s:32:\"e37cfbcb72323fb1fe8255a2edb4d738\";a:14:{s:4:\"name\";s:13:\"Post by Email\";s:11:\"description\";s:58:\"Publish posts by email, using any device and email client.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"14\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:7:\"Writing\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:20:\"post by email, email\";}s:32:\"728290d131a480bfe7b9e405d7cd925f\";a:14:{s:4:\"name\";s:7:\"Protect\";s:11:\"description\";s:28:\"Prevent brute force attacks.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"4\";s:10:\"introduced\";s:3:\"3.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:33:\"Recommended, Performance-Security\";s:25:\"additional_search_queries\";s:65:\"security, secure, protection, botnet, brute force, protect, login\";}s:32:\"f9ce784babbbf4dcca99b8cd2ceb420c\";a:14:{s:4:\"name\";s:9:\"Publicize\";s:11:\"description\";s:30:\"Automatically promote content.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"10\";s:20:\"recommendation_order\";s:1:\"7\";s:10:\"introduced\";s:3:\"2.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:19:\"Social, Recommended\";s:7:\"feature\";s:20:\"Recommended, Traffic\";s:25:\"additional_search_queries\";s:107:\"facebook, twitter, google+, googleplus, google, path, tumblr, linkedin, social, tweet, connections, sharing\";}s:32:\"052c03877dd3d296a71531cb07ad939a\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"52edecb2a75222e75b2dce4356a4efce\";a:14:{s:4:\"name\";s:13:\"Related Posts\";s:11:\"description\";s:24:\"Display similar content.\";s:14:\"jumpstart_desc\";s:113:\"Keep visitors engaged on your blog by highlighting relevant and new content at the bottom of each published post.\";s:4:\"sort\";s:2:\"29\";s:20:\"recommendation_order\";s:1:\"9\";s:10:\"introduced\";s:3:\"2.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:11:\"Recommended\";s:7:\"feature\";s:31:\"Recommended, Jumpstart, Traffic\";s:25:\"additional_search_queries\";s:22:\"related, related posts\";}s:32:\"8b059cb50a66b717f1ec842e736b858c\";a:14:{s:4:\"name\";s:7:\"Sharing\";s:11:\"description\";s:32:\"Visitors can share your content.\";s:14:\"jumpstart_desc\";s:116:\"Twitter, Facebook and Google+ buttons at the bottom of each post, making it easy for visitors to share your content.\";s:4:\"sort\";s:1:\"7\";s:20:\"recommendation_order\";s:1:\"6\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:3:\"1.2\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:19:\"Social, Recommended\";s:7:\"feature\";s:31:\"Recommended, Jumpstart, Traffic\";s:25:\"additional_search_queries\";s:141:\"share, sharing, sharedaddy, buttons, icons, email, facebook, twitter, google+, linkedin, pinterest, pocket, press this, print, reddit, tumblr\";}s:32:\"a6d2394329871857401255533a9873f7\";a:14:{s:4:\"name\";s:16:\"Shortcode Embeds\";s:11:\"description\";s:77:\"Embed content from YouTube, Vimeo, SlideShare, and more, no coding necessary.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"3\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:3:\"1.2\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:46:\"Photos and Videos, Social, Writing, Appearance\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:251:\"shortcodes, shortcode, embeds, media, bandcamp, blip.tv, dailymotion, digg, facebook, flickr, google calendars, google maps, google+, polldaddy, recipe, recipes, scribd, slideshare, slideshow, slideshows, soundcloud, ted, twitter, vimeo, vine, youtube\";}s:32:\"21496e2897ea5f81605e2f2ac3beb921\";a:14:{s:4:\"name\";s:16:\"WP.me Shortlinks\";s:11:\"description\";s:56:\"Enable WP.me-powered shortlinks for all posts and pages.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"8\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:17:\"shortlinks, wp.me\";}s:32:\"e2a54a5d7879a4162709e6ffb540dd08\";a:14:{s:4:\"name\";s:9:\"Site Icon\";s:11:\"description\";s:29:\"Add a site icon to your site.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"22\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:5:\"Other\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:24:\"favicon, icon, site icon\";}s:32:\"f5c537bc304f55b29c1a87e30be0cd24\";a:14:{s:4:\"name\";s:8:\"Sitemaps\";s:11:\"description\";s:75:\"Creates sitemaps to allow your site to be easily indexed by search engines.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"13\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.9\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:6:\"Public\";s:11:\"module_tags\";s:20:\"Recommended, Traffic\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:39:\"sitemap, traffic, search, site map, seo\";}s:32:\"59a23643437358a9b557f1d1e20ab040\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"6a90f97c3194cfca5671728eaaeaf15e\";a:14:{s:4:\"name\";s:14:\"Single Sign On\";s:11:\"description\";s:27:\"Secure user authentication.\";s:14:\"jumpstart_desc\";s:98:\"Lets you log in to all your Jetpack-enabled sites with one click using your WordPress.com account.\";s:4:\"sort\";s:2:\"30\";s:20:\"recommendation_order\";s:1:\"5\";s:10:\"introduced\";s:3:\"2.6\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:10:\"Developers\";s:7:\"feature\";s:31:\"Jumpstart, Performance-Security\";s:25:\"additional_search_queries\";s:34:\"sso, single sign on, login, log in\";}s:32:\"b65604e920392e2f7134b646760b75e8\";a:14:{s:4:\"name\";s:10:\"Site Stats\";s:11:\"description\";s:35:\"Collect traffic stats and insights.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"1\";s:20:\"recommendation_order\";s:1:\"2\";s:10:\"introduced\";s:3:\"1.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:23:\"Site Stats, Recommended\";s:7:\"feature\";s:20:\"Recommended, Traffic\";s:25:\"additional_search_queries\";s:54:\"statistics, tracking, analytics, views, traffic, stats\";}s:32:\"23a586dd7ead00e69ec53eb32ef740e4\";a:14:{s:4:\"name\";s:13:\"Subscriptions\";s:11:\"description\";s:88:\"Allow users to subscribe to your posts and comments and receive notifications via email.\";s:14:\"jumpstart_desc\";s:126:\"Give visitors two easy subscription options — while commenting, or via a separate email subscription widget you can display.\";s:4:\"sort\";s:1:\"9\";s:20:\"recommendation_order\";s:1:\"8\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:6:\"Social\";s:7:\"feature\";s:9:\"Jumpstart\";s:25:\"additional_search_queries\";s:74:\"subscriptions, subscription, email, follow, followers, subscribers, signup\";}s:32:\"1d978b8d84d2f378fe1a702a67633b6d\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"b3b983461d7f3d27322a3551ed8a9405\";a:14:{s:4:\"name\";s:15:\"Tiled Galleries\";s:11:\"description\";s:73:\"Display your image galleries in a variety of sleek, graphic arrangements.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"24\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.1\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:2:\"No\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:43:\"gallery, tiles, tiled, grid, mosaic, images\";}s:32:\"d924e5b05722b0e104448543598f54c0\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}s:32:\"36741583b10c521997e563ad8e1e8b77\";a:14:{s:4:\"name\";s:12:\"Data Backups\";s:11:\"description\";s:27:\"Daily or real-time backups.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"32\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:5:\"0:1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:5:\"false\";s:4:\"free\";s:5:\"false\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:20:\"Performance-Security\";s:25:\"additional_search_queries\";s:28:\"vaultpress, backup, security\";}s:32:\"2b9b44f09b5459617d68dd82ee17002a\";a:14:{s:4:\"name\";s:17:\"Site Verification\";s:11:\"description\";s:77:\"Verify your site or domain with Google Search Console, Pinterest, and others.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"33\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"3.0\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:56:\"webmaster, seo, google, bing, pinterest, search, console\";}s:32:\"5ab4c0db7c42e10e646342da0274c491\";a:14:{s:4:\"name\";s:10:\"VideoPress\";s:11:\"description\";s:68:\"Upload and embed videos right on your site. (Subscription required.)\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"27\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.5\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:5:\"false\";s:19:\"requires_connection\";s:3:\"Yes\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:17:\"Photos and Videos\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:25:\"video, videos, videopress\";}s:32:\"60a1d3aa38bc0fe1039e59dd60888543\";a:14:{s:4:\"name\";s:17:\"Widget Visibility\";s:11:\"description\";s:57:\"Specify which widgets appear on which pages of your site.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:2:\"17\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"2.4\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:10:\"Appearance\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:54:\"widget visibility, logic, conditional, widgets, widget\";}s:32:\"174ed3416476c2cb9ff5b0f671280b15\";a:14:{s:4:\"name\";s:21:\"Extra Sidebar Widgets\";s:11:\"description\";s:79:\"Add images, Twitter streams, your site’s RSS links, and more to your sidebar.\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:1:\"4\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:3:\"1.2\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:2:\"No\";s:13:\"auto_activate\";s:3:\"Yes\";s:11:\"module_tags\";s:18:\"Social, Appearance\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:65:\"widget, widgets, facebook, gallery, twitter, gravatar, image, rss\";}s:32:\"28b931a1db19bd24869bd54b14e733d5\";a:14:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";s:14:\"jumpstart_desc\";s:0:\"\";s:4:\"sort\";s:0:\"\";s:20:\"recommendation_order\";s:0:\"\";s:10:\"introduced\";s:0:\"\";s:7:\"changed\";s:0:\"\";s:10:\"deactivate\";s:0:\"\";s:4:\"free\";s:0:\"\";s:19:\"requires_connection\";s:0:\"\";s:13:\"auto_activate\";s:0:\"\";s:11:\"module_tags\";s:0:\"\";s:7:\"feature\";s:0:\"\";s:25:\"additional_search_queries\";s:0:\"\";}}}","yes");
INSERT INTO wp_options VALUES("14390","jetpack_available_modules","a:1:{s:5:\"3.9.5\";a:37:{s:18:\"after-the-deadline\";s:3:\"1.1\";s:8:\"carousel\";s:3:\"1.5\";s:8:\"comments\";s:3:\"1.4\";s:12:\"contact-form\";s:3:\"1.3\";s:20:\"custom-content-types\";s:3:\"3.1\";s:10:\"custom-css\";s:3:\"1.7\";s:21:\"enhanced-distribution\";s:3:\"1.2\";s:19:\"gravatar-hovercards\";s:3:\"1.1\";s:15:\"infinite-scroll\";s:3:\"2.0\";s:8:\"json-api\";s:3:\"1.9\";s:5:\"latex\";s:3:\"1.1\";s:5:\"likes\";s:3:\"2.2\";s:6:\"manage\";s:3:\"3.4\";s:8:\"markdown\";s:3:\"2.8\";s:9:\"minileven\";s:3:\"1.8\";s:7:\"monitor\";s:3:\"2.6\";s:5:\"notes\";s:3:\"1.9\";s:10:\"omnisearch\";s:3:\"2.3\";s:6:\"photon\";s:3:\"2.0\";s:13:\"post-by-email\";s:3:\"2.0\";s:7:\"protect\";s:3:\"3.4\";s:9:\"publicize\";s:3:\"2.0\";s:13:\"related-posts\";s:3:\"2.9\";s:10:\"sharedaddy\";s:3:\"1.1\";s:10:\"shortcodes\";s:3:\"1.1\";s:10:\"shortlinks\";s:3:\"1.1\";s:9:\"site-icon\";s:3:\"3.2\";s:8:\"sitemaps\";s:3:\"3.9\";s:3:\"sso\";s:3:\"2.6\";s:5:\"stats\";s:3:\"1.1\";s:13:\"subscriptions\";s:3:\"1.2\";s:13:\"tiled-gallery\";s:3:\"2.1\";s:10:\"vaultpress\";s:5:\"0:1.2\";s:18:\"verification-tools\";s:3:\"3.0\";s:10:\"videopress\";s:3:\"2.5\";s:17:\"widget-visibility\";s:3:\"2.4\";s:7:\"widgets\";s:3:\"1.2\";}}","yes");
INSERT INTO wp_options VALUES("14394","jetpack_security_report","a:0:{}","yes");
INSERT INTO wp_options VALUES("14397","jetpack_log","a:22:{i:0;a:4:{s:4:\"time\";i:1450062679;s:7:\"user_id\";i:1;s:7:\"blog_id\";b:0;s:4:\"code\";s:8:\"register\";}i:1;a:4:{s:4:\"time\";i:1450062687;s:7:\"user_id\";i:1;s:7:\"blog_id\";i:104024585;s:4:\"code\";s:9:\"authorize\";}i:2;a:5:{s:4:\"time\";i:1450084741;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:104024585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:6:\"plugin\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"26827\";s:4:\"slug\";s:8:\"meta-box\";s:6:\"plugin\";s:21:\"meta-box/meta-box.php\";s:11:\"new_version\";s:5:\"4.7.3\";s:3:\"url\";s:39:\"https://wordpress.org/plugins/meta-box/\";s:7:\"package\";s:57:\"https://downloads.wordpress.org/plugin/meta-box.4.7.3.zip\";}s:6:\"result\";b:1;s:4:\"name\";s:8:\"Meta Box\";s:8:\"messages\";a:6:{i:0;s:25:\"Updating plugin: Meta Box\";i:1;s:88:\"Downloading update from https://downloads.wordpress.org/plugin/meta-box.4.7.3.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:2:{s:6:\"plugin\";a:1:{i:0;s:21:\"meta-box/meta-box.php\";}s:5:\"theme\";a:0:{}}}}i:3;a:5:{s:4:\"time\";i:1450381372;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:104024585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:6:\"plugin\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"20101\";s:4:\"slug\";s:7:\"jetpack\";s:6:\"plugin\";s:19:\"jetpack/jetpack.php\";s:11:\"new_version\";s:5:\"3.8.2\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/jetpack/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.3.8.2.zip\";}s:6:\"result\";b:1;s:4:\"name\";s:24:\"Jetpack by WordPress.com\";s:8:\"messages\";a:6:{i:0;s:41:\"Updating plugin: Jetpack by WordPress.com\";i:1;s:87:\"Downloading update from https://downloads.wordpress.org/plugin/jetpack.3.8.2.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:2:{s:6:\"plugin\";a:1:{i:0;s:19:\"jetpack/jetpack.php\";}s:5:\"theme\";a:0:{}}}}i:4;a:5:{s:4:\"time\";i:1450900613;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:104024585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:6:\"plugin\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"5899\";s:4:\"slug\";s:13:\"wordpress-seo\";s:6:\"plugin\";s:24:\"wordpress-seo/wp-seo.php\";s:11:\"new_version\";s:5:\"3.0.7\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/wordpress-seo/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.3.0.7.zip\";}s:6:\"result\";b:1;s:4:\"name\";s:9:\"Yoast SEO\";s:8:\"messages\";a:6:{i:0;s:26:\"Updating plugin: Yoast SEO\";i:1;s:93:\"Downloading update from https://downloads.wordpress.org/plugin/wordpress-seo.3.0.7.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:2:{s:6:\"plugin\";a:1:{i:0;s:24:\"wordpress-seo/wp-seo.php\";}s:5:\"theme\";a:0:{}}}}i:5;a:5:{s:4:\"time\";i:1453364556;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:104024585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:6:\"plugin\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"20101\";s:4:\"slug\";s:7:\"jetpack\";s:6:\"plugin\";s:19:\"jetpack/jetpack.php\";s:11:\"new_version\";s:5:\"3.9.0\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/jetpack/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.3.9.0.zip\";}s:6:\"result\";b:1;s:4:\"name\";s:24:\"Jetpack by WordPress.com\";s:8:\"messages\";a:6:{i:0;s:41:\"Updating plugin: Jetpack by WordPress.com\";i:1;s:87:\"Downloading update from https://downloads.wordpress.org/plugin/jetpack.3.9.0.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}i:1;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"25305\";s:4:\"slug\";s:9:\"wordfence\";s:6:\"plugin\";s:23:\"wordfence/wordfence.php\";s:11:\"new_version\";s:6:\"6.0.23\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/wordfence/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/wordfence.6.0.23.zip\";}s:6:\"result\";b:1;s:4:\"name\";s:18:\"Wordfence Security\";s:8:\"messages\";a:6:{i:0;s:35:\"Updating plugin: Wordfence Security\";i:1;s:90:\"Downloading update from https://downloads.wordpress.org/plugin/wordfence.6.0.23.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:2:{s:6:\"plugin\";a:2:{i:0;s:19:\"jetpack/jetpack.php\";i:1;s:23:\"wordfence/wordfence.php\";}s:5:\"theme\";a:0:{}}}}i:6;a:5:{s:4:\"time\";i:1453451422;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:104024585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:6:\"plugin\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"20101\";s:4:\"slug\";s:7:\"jetpack\";s:6:\"plugin\";s:19:\"jetpack/jetpack.php\";s:11:\"new_version\";s:5:\"3.9.1\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/jetpack/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.3.9.1.zip\";}s:6:\"result\";b:1;s:4:\"name\";s:24:\"Jetpack by WordPress.com\";s:8:\"messages\";a:6:{i:0;s:41:\"Updating plugin: Jetpack by WordPress.com\";i:1;s:87:\"Downloading update from https://downloads.wordpress.org/plugin/jetpack.3.9.1.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:2:{s:6:\"plugin\";a:1:{i:0;s:19:\"jetpack/jetpack.php\";}s:5:\"theme\";a:0:{}}}}i:7;a:5:{s:4:\"time\";i:1454578033;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:104024585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:6:\"plugin\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"25305\";s:4:\"slug\";s:9:\"wordfence\";s:6:\"plugin\";s:23:\"wordfence/wordfence.php\";s:11:\"new_version\";s:6:\"6.0.24\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/wordfence/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/wordfence.6.0.24.zip\";}s:6:\"result\";b:1;s:4:\"name\";s:18:\"Wordfence Security\";s:8:\"messages\";a:6:{i:0;s:35:\"Updating plugin: Wordfence Security\";i:1;s:90:\"Downloading update from https://downloads.wordpress.org/plugin/wordfence.6.0.24.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:2:{s:6:\"plugin\";a:1:{i:0;s:23:\"wordfence/wordfence.php\";}s:5:\"theme\";a:0:{}}}}i:8;a:5:{s:4:\"time\";i:1455741515;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:104024585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:6:\"plugin\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"26827\";s:4:\"slug\";s:8:\"meta-box\";s:6:\"plugin\";s:21:\"meta-box/meta-box.php\";s:11:\"new_version\";s:5:\"4.8.0\";s:3:\"url\";s:39:\"https://wordpress.org/plugins/meta-box/\";s:7:\"package\";s:57:\"https://downloads.wordpress.org/plugin/meta-box.4.8.0.zip\";}s:6:\"result\";b:1;s:4:\"name\";s:8:\"Meta Box\";s:8:\"messages\";a:6:{i:0;s:25:\"Updating plugin: Meta Box\";i:1;s:88:\"Downloading update from https://downloads.wordpress.org/plugin/meta-box.4.8.0.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:2:{s:6:\"plugin\";a:1:{i:0;s:21:\"meta-box/meta-box.php\";}s:5:\"theme\";a:0:{}}}}i:9;a:5:{s:4:\"time\";i:1455825772;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:104024585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:6:\"plugin\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"26827\";s:4:\"slug\";s:8:\"meta-box\";s:6:\"plugin\";s:21:\"meta-box/meta-box.php\";s:11:\"new_version\";s:5:\"4.8.1\";s:3:\"url\";s:39:\"https://wordpress.org/plugins/meta-box/\";s:7:\"package\";s:57:\"https://downloads.wordpress.org/plugin/meta-box.4.8.1.zip\";}s:6:\"result\";b:1;s:4:\"name\";s:8:\"Meta Box\";s:8:\"messages\";a:6:{i:0;s:25:\"Updating plugin: Meta Box\";i:1;s:88:\"Downloading update from https://downloads.wordpress.org/plugin/meta-box.4.8.1.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:2:{s:6:\"plugin\";a:1:{i:0;s:21:\"meta-box/meta-box.php\";}s:5:\"theme\";a:0:{}}}}i:10;a:5:{s:4:\"time\";i:1456437186;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:104024585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:6:\"plugin\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"20101\";s:4:\"slug\";s:7:\"jetpack\";s:6:\"plugin\";s:19:\"jetpack/jetpack.php\";s:11:\"new_version\";s:5:\"3.9.2\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/jetpack/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.3.9.2.zip\";}s:6:\"result\";b:1;s:4:\"name\";s:24:\"Jetpack by WordPress.com\";s:8:\"messages\";a:6:{i:0;s:41:\"Updating plugin: Jetpack by WordPress.com\";i:1;s:87:\"Downloading update from https://downloads.wordpress.org/plugin/jetpack.3.9.2.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:2:{s:6:\"plugin\";a:1:{i:0;s:19:\"jetpack/jetpack.php\";}s:5:\"theme\";a:0:{}}}}i:11;a:5:{s:4:\"time\";i:1456473469;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:104024585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:6:\"plugin\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"26827\";s:4:\"slug\";s:8:\"meta-box\";s:6:\"plugin\";s:21:\"meta-box/meta-box.php\";s:11:\"new_version\";s:5:\"4.8.2\";s:3:\"url\";s:39:\"https://wordpress.org/plugins/meta-box/\";s:7:\"package\";s:57:\"https://downloads.wordpress.org/plugin/meta-box.4.8.2.zip\";}s:6:\"result\";b:1;s:4:\"name\";s:8:\"Meta Box\";s:8:\"messages\";a:6:{i:0;s:25:\"Updating plugin: Meta Box\";i:1;s:88:\"Downloading update from https://downloads.wordpress.org/plugin/meta-box.4.8.2.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:2:{s:6:\"plugin\";a:1:{i:0;s:21:\"meta-box/meta-box.php\";}s:5:\"theme\";a:0:{}}}}i:12;a:5:{s:4:\"time\";i:1456866844;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:104024585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:6:\"plugin\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"5899\";s:4:\"slug\";s:13:\"wordpress-seo\";s:6:\"plugin\";s:24:\"wordpress-seo/wp-seo.php\";s:11:\"new_version\";s:3:\"3.1\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/wordpress-seo/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/wordpress-seo.3.1.zip\";}s:6:\"result\";b:1;s:4:\"name\";s:9:\"Yoast SEO\";s:8:\"messages\";a:6:{i:0;s:26:\"Updating plugin: Yoast SEO\";i:1;s:91:\"Downloading update from https://downloads.wordpress.org/plugin/wordpress-seo.3.1.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:2:{s:6:\"plugin\";a:1:{i:0;s:24:\"wordpress-seo/wp-seo.php\";}s:5:\"theme\";a:0:{}}}}i:13;a:5:{s:4:\"time\";i:1457089220;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:104024585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:6:\"plugin\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"26827\";s:4:\"slug\";s:8:\"meta-box\";s:6:\"plugin\";s:21:\"meta-box/meta-box.php\";s:11:\"new_version\";s:5:\"4.8.3\";s:3:\"url\";s:39:\"https://wordpress.org/plugins/meta-box/\";s:7:\"package\";s:57:\"https://downloads.wordpress.org/plugin/meta-box.4.8.3.zip\";}s:6:\"result\";b:1;s:4:\"name\";s:8:\"Meta Box\";s:8:\"messages\";a:6:{i:0;s:25:\"Updating plugin: Meta Box\";i:1;s:88:\"Downloading update from https://downloads.wordpress.org/plugin/meta-box.4.8.3.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:2:{s:6:\"plugin\";a:1:{i:0;s:21:\"meta-box/meta-box.php\";}s:5:\"theme\";a:0:{}}}}i:14;a:5:{s:4:\"time\";i:1457493122;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:104024585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:6:\"plugin\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":8:{s:2:\"id\";s:4:\"5899\";s:4:\"slug\";s:13:\"wordpress-seo\";s:6:\"plugin\";s:24:\"wordpress-seo/wp-seo.php\";s:11:\"new_version\";s:5:\"3.1.1\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/wordpress-seo/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.3.1.1.zip\";s:6:\"tested\";s:5:\"4.4.2\";s:13:\"compatibility\";b:0;}s:6:\"result\";b:1;s:4:\"name\";s:9:\"Yoast SEO\";s:8:\"messages\";a:6:{i:0;s:26:\"Updating plugin: Yoast SEO\";i:1;s:93:\"Downloading update from https://downloads.wordpress.org/plugin/wordpress-seo.3.1.1.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:2:{s:6:\"plugin\";a:1:{i:0;s:24:\"wordpress-seo/wp-seo.php\";}s:5:\"theme\";a:0:{}}}}i:15;a:5:{s:4:\"time\";i:1457557558;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:104024585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:6:\"plugin\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":8:{s:2:\"id\";s:5:\"20101\";s:4:\"slug\";s:7:\"jetpack\";s:6:\"plugin\";s:19:\"jetpack/jetpack.php\";s:11:\"new_version\";s:5:\"3.9.3\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/jetpack/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.3.9.3.zip\";s:6:\"tested\";s:5:\"4.4.2\";s:13:\"compatibility\";b:0;}s:6:\"result\";b:1;s:4:\"name\";s:24:\"Jetpack by WordPress.com\";s:8:\"messages\";a:6:{i:0;s:41:\"Updating plugin: Jetpack by WordPress.com\";i:1;s:87:\"Downloading update from https://downloads.wordpress.org/plugin/jetpack.3.9.3.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:2:{s:6:\"plugin\";a:1:{i:0;s:19:\"jetpack/jetpack.php\";}s:5:\"theme\";a:0:{}}}}i:16;a:5:{s:4:\"time\";i:1457598185;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:104024585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:6:\"plugin\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":8:{s:2:\"id\";s:5:\"20101\";s:4:\"slug\";s:7:\"jetpack\";s:6:\"plugin\";s:19:\"jetpack/jetpack.php\";s:11:\"new_version\";s:5:\"3.9.4\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/jetpack/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.3.9.4.zip\";s:6:\"tested\";s:5:\"4.4.2\";s:13:\"compatibility\";b:0;}s:6:\"result\";b:1;s:4:\"name\";s:24:\"Jetpack by WordPress.com\";s:8:\"messages\";a:6:{i:0;s:41:\"Updating plugin: Jetpack by WordPress.com\";i:1;s:87:\"Downloading update from https://downloads.wordpress.org/plugin/jetpack.3.9.4.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:2:{s:6:\"plugin\";a:1:{i:0;s:19:\"jetpack/jetpack.php\";}s:5:\"theme\";a:0:{}}}}i:17;a:5:{s:4:\"time\";i:1458765304;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:104024585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:6:\"plugin\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":8:{s:2:\"id\";s:4:\"5899\";s:4:\"slug\";s:13:\"wordpress-seo\";s:6:\"plugin\";s:24:\"wordpress-seo/wp-seo.php\";s:11:\"new_version\";s:5:\"3.1.2\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/wordpress-seo/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/wordpress-seo.3.1.2.zip\";s:6:\"tested\";s:3:\"4.5\";s:13:\"compatibility\";b:0;}s:6:\"result\";b:1;s:4:\"name\";s:9:\"Yoast SEO\";s:8:\"messages\";a:6:{i:0;s:26:\"Updating plugin: Yoast SEO\";i:1;s:93:\"Downloading update from https://downloads.wordpress.org/plugin/wordpress-seo.3.1.2.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:2:{s:6:\"plugin\";a:1:{i:0;s:24:\"wordpress-seo/wp-seo.php\";}s:5:\"theme\";a:0:{}}}}i:18;a:5:{s:4:\"time\";i:1459023591;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:104024585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:6:\"plugin\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":8:{s:2:\"id\";s:5:\"26827\";s:4:\"slug\";s:8:\"meta-box\";s:6:\"plugin\";s:21:\"meta-box/meta-box.php\";s:11:\"new_version\";s:5:\"4.8.4\";s:3:\"url\";s:39:\"https://wordpress.org/plugins/meta-box/\";s:7:\"package\";s:57:\"https://downloads.wordpress.org/plugin/meta-box.4.8.4.zip\";s:6:\"tested\";s:5:\"4.4.2\";s:13:\"compatibility\";b:0;}s:6:\"result\";b:1;s:4:\"name\";s:8:\"Meta Box\";s:8:\"messages\";a:6:{i:0;s:25:\"Updating plugin: Meta Box\";i:1;s:88:\"Downloading update from https://downloads.wordpress.org/plugin/meta-box.4.8.4.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:2:{s:6:\"plugin\";a:1:{i:0;s:21:\"meta-box/meta-box.php\";}s:5:\"theme\";a:0:{}}}}i:19;a:5:{s:4:\"time\";i:1459202773;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:104024585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:6:\"plugin\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":8:{s:2:\"id\";s:2:\"15\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:5:\"3.1.9\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/akismet.3.1.9.zip\";s:6:\"tested\";s:5:\"4.4.2\";s:13:\"compatibility\";b:0;}s:6:\"result\";b:1;s:4:\"name\";s:7:\"Akismet\";s:8:\"messages\";a:6:{i:0;s:24:\"Updating plugin: Akismet\";i:1;s:87:\"Downloading update from https://downloads.wordpress.org/plugin/akismet.3.1.9.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}i:1;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":8:{s:2:\"id\";s:5:\"25305\";s:4:\"slug\";s:9:\"wordfence\";s:6:\"plugin\";s:23:\"wordfence/wordfence.php\";s:11:\"new_version\";s:6:\"6.0.25\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/wordfence/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/wordfence.6.0.25.zip\";s:6:\"tested\";s:5:\"4.4.2\";s:13:\"compatibility\";b:0;}s:6:\"result\";b:1;s:4:\"name\";s:18:\"Wordfence Security\";s:8:\"messages\";a:6:{i:0;s:35:\"Updating plugin: Wordfence Security\";i:1;s:90:\"Downloading update from https://downloads.wordpress.org/plugin/wordfence.6.0.25.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:2:{s:6:\"plugin\";a:1:{i:0;s:23:\"wordfence/wordfence.php\";}s:5:\"theme\";a:0:{}}}}i:20;a:5:{s:4:\"time\";i:1459356468;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:104024585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:6:\"plugin\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":9:{s:2:\"id\";s:5:\"23488\";s:4:\"slug\";s:19:\"visual-form-builder\";s:6:\"plugin\";s:43:\"visual-form-builder/visual-form-builder.php\";s:11:\"new_version\";s:5:\"2.8.7\";s:3:\"url\";s:50:\"https://wordpress.org/plugins/visual-form-builder/\";s:7:\"package\";s:68:\"https://downloads.wordpress.org/plugin/visual-form-builder.2.8.7.zip\";s:14:\"upgrade_notice\";s:98:\"This version requires at least WordPress 4.3 or higher due to previous use of deprecated functions\";s:6:\"tested\";s:5:\"4.3.3\";s:13:\"compatibility\";b:0;}s:6:\"result\";b:1;s:4:\"name\";s:19:\"Visual Form Builder\";s:8:\"messages\";a:6:{i:0;s:36:\"Updating plugin: Visual Form Builder\";i:1;s:99:\"Downloading update from https://downloads.wordpress.org/plugin/visual-form-builder.2.8.7.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:2:{s:6:\"plugin\";a:1:{i:0;s:43:\"visual-form-builder/visual-form-builder.php\";}s:5:\"theme\";a:0:{}}}}i:21;a:5:{s:4:\"time\";i:1459458520;s:7:\"user_id\";i:0;s:7:\"blog_id\";i:104024585;s:4:\"code\";s:11:\"autoupdates\";s:4:\"data\";a:3:{s:7:\"results\";a:1:{s:6:\"plugin\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"item\";O:8:\"stdClass\":8:{s:2:\"id\";s:5:\"20101\";s:4:\"slug\";s:7:\"jetpack\";s:6:\"plugin\";s:19:\"jetpack/jetpack.php\";s:11:\"new_version\";s:5:\"3.9.5\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/jetpack/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/jetpack.3.9.5.zip\";s:6:\"tested\";s:3:\"4.5\";s:13:\"compatibility\";b:0;}s:6:\"result\";b:1;s:4:\"name\";s:24:\"Jetpack by WordPress.com\";s:8:\"messages\";a:6:{i:0;s:41:\"Updating plugin: Jetpack by WordPress.com\";i:1;s:87:\"Downloading update from https://downloads.wordpress.org/plugin/jetpack.3.9.5.zip&#8230;\";i:2;s:27:\"Unpacking the update&#8230;\";i:3;s:36:\"Installing the latest version&#8230;\";i:4;s:45:\"Removing the old version of the plugin&#8230;\";i:5;s:28:\"Plugin updated successfully.\";}}}}s:6:\"failed\";a:2:{s:6:\"plugin\";a:0:{}s:5:\"theme\";a:0:{}}s:7:\"success\";a:2:{s:6:\"plugin\";a:1:{i:0;s:19:\"jetpack/jetpack.php\";}s:5:\"theme\";a:0:{}}}}}","no");
INSERT INTO wp_options VALUES("14398","jetpack_private_options","a:3:{s:8:\"register\";s:76:\"PkCT9Jyw62mbWuOmsDvaxTLfAMAXKKRA:xkK7RtadpkyoJAGIiLFzLftVKYAyMebt:1450063279\";s:10:\"blog_token\";s:65:\"g^^rCtatMNS58QvAn&p#!WzgaN9hhDbA.GKbsE@b51NCY3^jFbomAC0eHAqxg)YRv\";s:11:\"user_tokens\";a:1:{i:1;s:67:\"t&)FuHgCSK#eDI#2Waislb@Nq#ElcAXv.DD%97#qNljXwdjg4cUk&HGwS@T1u6%&z.1\";}}","yes");
INSERT INTO wp_options VALUES("14403","jetpack_unique_connection","a:3:{s:9:\"connected\";i:1;s:12:\"disconnected\";i:0;s:7:\"version\";s:5:\"3.6.1\";}","yes");
INSERT INTO wp_options VALUES("14404","jetpack_active_modules","a:20:{i:0;s:18:\"after-the-deadline\";i:1;s:12:\"contact-form\";i:2;s:20:\"custom-content-types\";i:3;s:10:\"custom-css\";i:4;s:21:\"enhanced-distribution\";i:5;s:19:\"gravatar-hovercards\";i:6;s:8:\"json-api\";i:7;s:5:\"latex\";i:8;s:5:\"notes\";i:9;s:10:\"omnisearch\";i:10;s:13:\"post-by-email\";i:11;s:9:\"publicize\";i:12;s:10:\"sharedaddy\";i:13;s:10:\"shortcodes\";i:14;s:10:\"shortlinks\";i:15;s:5:\"stats\";i:16;s:13:\"subscriptions\";i:18;s:17:\"widget-visibility\";i:19;s:7:\"widgets\";i:20;s:6:\"manage\";}","yes");
INSERT INTO wp_options VALUES("14408","stats_options","a:7:{s:9:\"admin_bar\";b:1;s:5:\"roles\";a:1:{i:0;s:13:\"administrator\";}s:11:\"count_roles\";a:0:{}s:7:\"blog_id\";i:104024585;s:12:\"do_not_track\";b:1;s:10:\"hide_smile\";b:1;s:7:\"version\";s:1:\"9\";}","yes");
INSERT INTO wp_options VALUES("14415","jetpack_autoupdate_plugins","a:19:{i:0;s:55:\"easy-social-share-buttons/easy-social-share-buttons.php\";i:1;s:29:\"fresh-favicon/freshplugin.php\";i:2;s:31:\"fresh-framework/freshplugin.php\";i:3;s:37:\"hms-testimonials/hms-testimonials.php\";i:4;s:19:\"jetpack/jetpack.php\";i:5;s:37:\"ds-live-composer/ds-live-composer.php\";i:6;s:39:\"lockdown-wp-admin/lockdown-wp-admin.php\";i:7;s:29:\"masterslider/masterslider.php\";i:8;s:33:\"mega_main_menu/mega_main_menu.php\";i:9;s:21:\"meta-box/meta-box.php\";i:10;s:41:\"newsletter-sign-up/newsletter-sign-up.php\";i:11;s:42:\"nex-forms-express-wp-form-builder/main.php\";i:12;s:74:\"official-statcounter-plugin-for-wordpress/StatCounter-Wordpress-Plugin.php\";i:13;s:31:\"sb-google-map/sb-google-map.php\";i:14;s:43:\"visual-form-builder/visual-form-builder.php\";i:15;s:23:\"wordfence/wordfence.php\";i:16;s:24:\"wordpress-seo/wp-seo.php\";i:17;s:23:\"wp-rankie/wp-ranker.php\";i:18;s:47:\"wpfw_menus_management/wpfw_menus_management.php\";}","yes");
INSERT INTO wp_options VALUES("14466","sharing-options","a:1:{s:6:\"global\";a:5:{s:12:\"button_style\";s:9:\"icon-text\";s:13:\"sharing_label\";s:11:\"Share this:\";s:10:\"open_links\";s:4:\"same\";s:4:\"show\";a:0:{}s:6:\"custom\";a:0:{}}}","yes");
INSERT INTO wp_options VALUES("17077","_site_transient_timeout_browser_15297098b1b9a9d1d3687dc973a31662","1451846165","yes");
INSERT INTO wp_options VALUES("17078","_site_transient_browser_15297098b1b9a9d1d3687dc973a31662","a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"47.0.2526.106\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO wp_options VALUES("17099","stats_cache","a:2:{s:32:\"ed2ac44a34a9f049d74e4efd9ffb9fad\";a:1:{i:1459463161;a:4:{i:0;a:4:{s:7:\"post_id\";s:3:\"452\";s:10:\"post_title\";s:12:\"Case Studies\";s:14:\"post_permalink\";s:47:\"http://capitaldistrictdigital.com/case-studies/\";s:5:\"views\";s:1:\"3\";}i:1;a:4:{s:7:\"post_id\";s:4:\"1041\";s:10:\"post_title\";s:9:\"Home page\";s:14:\"post_permalink\";s:34:\"http://capitaldistrictdigital.com/\";s:5:\"views\";s:1:\"2\";}i:2;a:4:{s:7:\"post_id\";s:4:\"1299\";s:10:\"post_title\";s:31:\"WordPress Virus Removal Service\";s:14:\"post_permalink\";s:67:\"https://capitaldistrictdigital.com/wordpress-virus-removal-service/\";s:5:\"views\";s:1:\"1\";}i:3;a:4:{s:7:\"post_id\";s:3:\"626\";s:10:\"post_title\";s:10:\"Contact us\";s:14:\"post_permalink\";s:45:\"http://capitaldistrictdigital.com/contact-us/\";s:5:\"views\";s:1:\"1\";}}}s:32:\"eca6337f6b05e37da00d190ab947096c\";a:1:{i:1459463161;a:1:{i:0;a:2:{s:10:\"searchterm\";s:32:\"capital district digital reviews\";s:5:\"views\";s:1:\"2\";}}}}","yes");
INSERT INTO wp_options VALUES("17105","widget_nexforms_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("17106","widget_blog_subscription","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("17107","widget_facebook-likebox","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("17108","widget_wpcom-goodreads","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("17109","widget_googleplus-badge","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("17110","widget_grofile","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("17111","widget_image","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("17112","widget_rss_links","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("17113","widget_wpcom_social_media_icons_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("17114","widget_twitter_timeline","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("17115","widget_jetpack_display_posts_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("17119","site_icon","0","yes");
INSERT INTO wp_options VALUES("17120","medium_large_size_w","768","yes");
INSERT INTO wp_options VALUES("17121","medium_large_size_h","0","yes");
INSERT INTO wp_options VALUES("17124","can_compress_scripts","1","yes");
INSERT INTO wp_options VALUES("17358","_site_transient_timeout_browser_c6e0d466c988c4043691b020b1fec366","1451914252","yes");
INSERT INTO wp_options VALUES("17359","_site_transient_browser_c6e0d466c988c4043691b020b1fec366","a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"47.0.2526.106\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO wp_options VALUES("18954","_transient_timeout_wflginfl_00000000000000000000ffff5bc80c05","1452059599","no");
INSERT INTO wp_options VALUES("18955","_transient_wflginfl_00000000000000000000ffff5bc80c05","1","no");
INSERT INTO wp_options VALUES("24068","_site_transient_update_core","O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.4.2.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-4.4.2.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-4.4.2-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-4.4.2-new-bundled.zip\";s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.4.2\";s:7:\"version\";s:5:\"4.4.2\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.4\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1459703568;s:15:\"version_checked\";s:5:\"4.4.2\";s:12:\"translations\";a:0:{}}","yes");
INSERT INTO wp_options VALUES("25252","_site_transient_timeout_browser_b241fa4a919c1a7c7b01b9c57dfa9bb9","1455575994","yes");
INSERT INTO wp_options VALUES("25253","_site_transient_browser_b241fa4a919c1a7c7b01b9c57dfa9bb9","a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"48.0.2564.97\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO wp_options VALUES("25458","envato-wordpress-toolkit","a:2:{s:9:\"user_name\";s:14:\"anthonytroia77\";s:7:\"api_key\";s:32:\"xwp4ylxquf5v815b4u0576xt094ihnfg\";}","yes");
INSERT INTO wp_options VALUES("25550","_transient_timeout_wflginfl_00000000000000000000ffffbc7929ba","1454974725","no");
INSERT INTO wp_options VALUES("25551","_transient_wflginfl_00000000000000000000ffffbc7929ba","1","no");
INSERT INTO wp_options VALUES("25578","_transient_timeout_wflginfl_00000000000000000000ffffb8a8988e","1454981745","no");
INSERT INTO wp_options VALUES("25579","_transient_wflginfl_00000000000000000000ffffb8a8988e","1","no");
INSERT INTO wp_options VALUES("25636","_transient_timeout_wflginfl_00000000000000000000ffff67f096ab","1455003327","no");
INSERT INTO wp_options VALUES("25637","_transient_wflginfl_00000000000000000000ffff67f096ab","1","no");
INSERT INTO wp_options VALUES("25649","_transient_timeout_wflginfl_00000000000000000000ffffbc5d9033","1455005049","no");
INSERT INTO wp_options VALUES("25650","_transient_wflginfl_00000000000000000000ffffbc5d9033","1","no");
INSERT INTO wp_options VALUES("25775","_transient_timeout_wflginfl_00000000000000000000ffffd1ec4768","1455040427","no");
INSERT INTO wp_options VALUES("25776","_transient_wflginfl_00000000000000000000ffffd1ec4768","1","no");
INSERT INTO wp_options VALUES("25866","_transient_timeout_wflginfl_00000000000000000000ffffbc5d902c","1455068021","no");
INSERT INTO wp_options VALUES("25867","_transient_wflginfl_00000000000000000000ffffbc5d902c","1","no");
INSERT INTO wp_options VALUES("25873","_transient_timeout_wflginfl_00000000000000000000ffff3e958f5f","1455068603","no");
INSERT INTO wp_options VALUES("25874","_transient_wflginfl_00000000000000000000ffff3e958f5f","1","no");
INSERT INTO wp_options VALUES("25915","_transient_timeout_wflginfl_00000000000000000000ffffbc740944","1455075690","no");
INSERT INTO wp_options VALUES("25916","_transient_wflginfl_00000000000000000000ffffbc740944","1","no");
INSERT INTO wp_options VALUES("25948","_transient_timeout_wflginfl_00000000000000000000ffffa2dbfb7d","1455082318","no");
INSERT INTO wp_options VALUES("25949","_transient_wflginfl_00000000000000000000ffffa2dbfb7d","1","no");
INSERT INTO wp_options VALUES("26039","_transient_timeout_wflginfl_00000000000000000000ffffb8a89814","1455125591","no");
INSERT INTO wp_options VALUES("26040","_transient_wflginfl_00000000000000000000ffffb8a89814","1","no");
INSERT INTO wp_options VALUES("26049","_transient_timeout_wflginfl_00000000000000000000ffff44b2fe79","1455126798","no");
INSERT INTO wp_options VALUES("26050","_transient_wflginfl_00000000000000000000ffff44b2fe79","1","no");
INSERT INTO wp_options VALUES("26218","_transient_timeout_wflginfl_00000000000000000000ffffb3bc115c","1455184761","no");
INSERT INTO wp_options VALUES("26219","_transient_wflginfl_00000000000000000000ffffb3bc115c","1","no");
INSERT INTO wp_options VALUES("26239","_transient_timeout_wflginfl_00000000000000000000ffffb8a8c1c8","1455186980","no");
INSERT INTO wp_options VALUES("26240","_transient_wflginfl_00000000000000000000ffffb8a8c1c8","1","no");
INSERT INTO wp_options VALUES("26266","_transient_timeout_wflginfl_00000000000000000000ffff323ea159","1455192523","no");
INSERT INTO wp_options VALUES("26267","_transient_wflginfl_00000000000000000000ffff323ea159","1","no");
INSERT INTO wp_options VALUES("26269","_transient_timeout_wflginfl_00000000000000000000ffff52922f63","1455193098","no");
INSERT INTO wp_options VALUES("26270","_transient_wflginfl_00000000000000000000ffff52922f63","1","no");
INSERT INTO wp_options VALUES("26344","_site_transient_timeout_browser_b2b3dba9c11a5bff2b6abe2b38145363","1455811987","yes");
INSERT INTO wp_options VALUES("26345","_site_transient_browser_b2b3dba9c11a5bff2b6abe2b38145363","a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"48.0.2564.103\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO wp_options VALUES("26379","_transient_timeout_wflginfl_00000000000000000000ffffbc5d90b1","1455207708","no");
INSERT INTO wp_options VALUES("26380","_transient_wflginfl_00000000000000000000ffffbc5d90b1","1","no");
INSERT INTO wp_options VALUES("26437","_transient_timeout_wflginfl_00000000000000000000ffffc091ed3e","1455219595","no");
INSERT INTO wp_options VALUES("26438","_transient_wflginfl_00000000000000000000ffffc091ed3e","1","no");
INSERT INTO wp_options VALUES("26490","_transient_timeout_wflginfl_00000000000000000000ffff323eb1dd","1455233903","no");
INSERT INTO wp_options VALUES("26491","_transient_wflginfl_00000000000000000000ffff323eb1dd","1","no");
INSERT INTO wp_options VALUES("26516","_transient_timeout_wflginfl_00000000000000000000ffffd111724e","1455237920","no");
INSERT INTO wp_options VALUES("26517","_transient_wflginfl_00000000000000000000ffffd111724e","1","no");
INSERT INTO wp_options VALUES("26561","_transient_timeout_wflginfl_00000000000000000000ffffd1ec480e","1455251002","no");
INSERT INTO wp_options VALUES("26562","_transient_wflginfl_00000000000000000000ffffd1ec480e","1","no");
INSERT INTO wp_options VALUES("26571","_transient_timeout_wflginfl_00000000000000000000ffff175b466b","1455252161","no");
INSERT INTO wp_options VALUES("26572","_transient_wflginfl_00000000000000000000ffff175b466b","1","no");
INSERT INTO wp_options VALUES("26703","_transient_timeout_wflginfl_00000000000000000000ffffb8a89815","1455296429","no");
INSERT INTO wp_options VALUES("26704","_transient_wflginfl_00000000000000000000ffffb8a89815","1","no");
INSERT INTO wp_options VALUES("26942","_transient_timeout_wflginfl_00000000000000000000ffff44b2fe6b","1455366215","no");
INSERT INTO wp_options VALUES("26943","_transient_wflginfl_00000000000000000000ffff44b2fe6b","1","no");
INSERT INTO wp_options VALUES("27105","_transient_timeout_wflginfl_00000000000000000000ffffd06db5d2","1455423888","no");
INSERT INTO wp_options VALUES("27106","_transient_wflginfl_00000000000000000000ffffd06db5d2","1","no");
INSERT INTO wp_options VALUES("27143","_transient_timeout_wflginfl_00000000000000000000ffff323ea137","1455429664","no");
INSERT INTO wp_options VALUES("27144","_transient_wflginfl_00000000000000000000ffff323ea137","1","no");
INSERT INTO wp_options VALUES("27225","_transient_timeout_wflginfl_00000000000000000000ffff48a78308","1455450687","no");
INSERT INTO wp_options VALUES("27226","_transient_wflginfl_00000000000000000000ffff48a78308","1","no");
INSERT INTO wp_options VALUES("27237","_transient_timeout_wflginfl_00000000000000000000ffffb8a8c141","1455451947","no");
INSERT INTO wp_options VALUES("27238","_transient_wflginfl_00000000000000000000ffffb8a8c141","1","no");
INSERT INTO wp_options VALUES("27319","_transient_timeout_wflginfl_00000000000000000000ffff3e958f60","1455478656","no");
INSERT INTO wp_options VALUES("27320","_transient_wflginfl_00000000000000000000ffff3e958f60","1","no");
INSERT INTO wp_options VALUES("27326","_transient_timeout_wflginfl_00000000000000000000ffffb63282a3","1455479236","no");
INSERT INTO wp_options VALUES("27327","_transient_wflginfl_00000000000000000000ffffb63282a3","1","no");
INSERT INTO wp_options VALUES("27333","_transient_timeout_wflginfl_00000000000000000000ffff4f60b24d","1455479823","no");
INSERT INTO wp_options VALUES("27334","_transient_wflginfl_00000000000000000000ffff4f60b24d","1","no");
INSERT INTO wp_options VALUES("27348","_transient_timeout_wflginfl_00000000000000000000ffff4a32150d","1455481546","no");
INSERT INTO wp_options VALUES("27349","_transient_wflginfl_00000000000000000000ffff4a32150d","1","no");
INSERT INTO wp_options VALUES("27354","_transient_timeout_wflginfl_00000000000000000000ffff726c969f","1455482279","no");
INSERT INTO wp_options VALUES("27355","_transient_wflginfl_00000000000000000000ffff726c969f","1","no");
INSERT INTO wp_options VALUES("27361","_transient_timeout_wflginfl_00000000000000000000ffff48a7b70e","1455483254","no");
INSERT INTO wp_options VALUES("27362","_transient_wflginfl_00000000000000000000ffff48a7b70e","1","no");
INSERT INTO wp_options VALUES("27364","_transient_timeout_wflginfl_00000000000000000000ffffd071e41b","1455483813","no");
INSERT INTO wp_options VALUES("27365","_transient_wflginfl_00000000000000000000ffffd071e41b","1","no");
INSERT INTO wp_options VALUES("27409","_transient_timeout_wflginfl_00000000000000000000ffffb8a8c1c9","1455507532","no");
INSERT INTO wp_options VALUES("27410","_transient_wflginfl_00000000000000000000ffffb8a8c1c9","1","no");
INSERT INTO wp_options VALUES("27428","_transient_timeout_wflginfl_00000000000000000000ffff40142442","1455514071","no");
INSERT INTO wp_options VALUES("27429","_transient_wflginfl_00000000000000000000ffff40142442","1","no");
INSERT INTO wp_options VALUES("27443","_transient_timeout_wflginfl_00000000000000000000ffffb8a8c8c2","1455521393","no");
INSERT INTO wp_options VALUES("27444","_transient_wflginfl_00000000000000000000ffffb8a8c8c2","1","no");
INSERT INTO wp_options VALUES("27446","_transient_timeout_wflginfl_00000000000000000000ffffadc9c465","1455521966","no");
INSERT INTO wp_options VALUES("27447","_transient_wflginfl_00000000000000000000ffffadc9c465","1","no");
INSERT INTO wp_options VALUES("27599","_transient_timeout_wflginfl_00000000000000000000ffff323ea1eb","1455565215","no");
INSERT INTO wp_options VALUES("27600","_transient_wflginfl_00000000000000000000ffff323ea1eb","1","no");
INSERT INTO wp_options VALUES("27621","_transient_timeout_wflginfl_00000000000000000000ffff253b1a4a","1455567789","no");
INSERT INTO wp_options VALUES("27622","_transient_wflginfl_00000000000000000000ffff253b1a4a","1","no");
INSERT INTO wp_options VALUES("27629","_transient_timeout_wflginfl_00000000000000000000ffffb8a8988f","1455571909","no");
INSERT INTO wp_options VALUES("27630","_transient_wflginfl_00000000000000000000ffffb8a8988f","1","no");
INSERT INTO wp_options VALUES("27634","_transient_timeout_wflginfl_00000000000000000000ffff9e45769d","1455572492","no");
INSERT INTO wp_options VALUES("27635","_transient_wflginfl_00000000000000000000ffff9e45769d","1","no");
INSERT INTO wp_options VALUES("27656","_transient_timeout_wflginfl_00000000000000000000ffffd06db5af","1455574769","no");
INSERT INTO wp_options VALUES("27657","_transient_wflginfl_00000000000000000000ffffd06db5af","1","no");
INSERT INTO wp_options VALUES("27675","_transient_timeout_wflginfl_00000000000000000000ffff3e958fb6","1455577016","no");
INSERT INTO wp_options VALUES("27676","_transient_wflginfl_00000000000000000000ffff3e958fb6","1","no");
INSERT INTO wp_options VALUES("27719","_transient_timeout_wflginfl_00000000000000000000ffff323eb03c","1455593975","no");
INSERT INTO wp_options VALUES("27720","_transient_wflginfl_00000000000000000000ffff323eb03c","1","no");
INSERT INTO wp_options VALUES("27733","_transient_timeout_wflginfl_00000000000000000000ffff559f40e2","1455595123","no");
INSERT INTO wp_options VALUES("27734","_transient_wflginfl_00000000000000000000ffff559f40e2","1","no");
INSERT INTO wp_options VALUES("27737","_transient_timeout_wflginfl_00000000000000000000ffff2efccdbb","1455595678","no");
INSERT INTO wp_options VALUES("27738","_transient_wflginfl_00000000000000000000ffff2efccdbb","1","no");
INSERT INTO wp_options VALUES("27756","_transient_timeout_wflginfl_00000000000000000000ffff323eb023","1455600675","no");
INSERT INTO wp_options VALUES("27757","_transient_wflginfl_00000000000000000000ffff323eb023","1","no");
INSERT INTO wp_options VALUES("27778","_transient_timeout_wflginfl_00000000000000000000ffff5d7d6323","1455603560","no");
INSERT INTO wp_options VALUES("27779","_transient_wflginfl_00000000000000000000ffff5d7d6323","1","no");
INSERT INTO wp_options VALUES("27815","_transient_timeout_wflginfl_00000000000000000000ffff5b926b1f","1455609246","no");
INSERT INTO wp_options VALUES("27816","_transient_wflginfl_00000000000000000000ffff5b926b1f","1","no");
INSERT INTO wp_options VALUES("27822","_transient_timeout_wflginfl_00000000000000000000ffff4adcd747","1455609908","no");
INSERT INTO wp_options VALUES("27823","_transient_wflginfl_00000000000000000000ffff4adcd747","1","no");
INSERT INTO wp_options VALUES("27832","_transient_timeout_wflginfl_00000000000000000000ffff323ea14b","1455611189","no");
INSERT INTO wp_options VALUES("27833","_transient_wflginfl_00000000000000000000ffff323ea14b","1","no");
INSERT INTO wp_options VALUES("27835","_transient_timeout_wflginfl_00000000000000000000ffff48a7b732","1455611790","no");
INSERT INTO wp_options VALUES("27836","_transient_wflginfl_00000000000000000000ffff48a7b732","1","no");
INSERT INTO wp_options VALUES("27845","_transient_timeout_wflginfl_00000000000000000000ffff323ea12e","1455612998","no");
INSERT INTO wp_options VALUES("27846","_transient_wflginfl_00000000000000000000ffff323ea12e","1","no");
INSERT INTO wp_options VALUES("27894","_transient_timeout_wflginfl_00000000000000000000ffff323eb083","1455636642","no");
INSERT INTO wp_options VALUES("27895","_transient_wflginfl_00000000000000000000ffff323eb083","1","no");
INSERT INTO wp_options VALUES("27905","_transient_timeout_wflginfl_00000000000000000000ffff4b62af7b","1455637858","no");
INSERT INTO wp_options VALUES("27906","_transient_wflginfl_00000000000000000000ffff4b62af7b","1","no");
INSERT INTO wp_options VALUES("27908","_transient_timeout_wflginfl_00000000000000000000ffff48a7e829","1455638450","no");
INSERT INTO wp_options VALUES("27909","_transient_wflginfl_00000000000000000000ffff48a7e829","1","no");
INSERT INTO wp_options VALUES("27915","_transient_timeout_wflginfl_00000000000000000000ffff0585b4c7","1455639039","no");
INSERT INTO wp_options VALUES("27916","_transient_wflginfl_00000000000000000000ffff0585b4c7","1","no");
INSERT INTO wp_options VALUES("27929","_transient_timeout_wflginfl_00000000000000000000ffff3e958f5e","1455643840","no");
INSERT INTO wp_options VALUES("27930","_transient_wflginfl_00000000000000000000ffff3e958f5e","1","no");
INSERT INTO wp_options VALUES("27933","_transient_timeout_wflginfl_00000000000000000000ffff48a78309","1455644430","no");
INSERT INTO wp_options VALUES("27934","_transient_wflginfl_00000000000000000000ffff48a78309","1","no");
INSERT INTO wp_options VALUES("27940","_transient_timeout_wflginfl_00000000000000000000ffff323eb052","1455645021","no");
INSERT INTO wp_options VALUES("27941","_transient_wflginfl_00000000000000000000ffff323eb052","1","no");
INSERT INTO wp_options VALUES("27944","_transient_timeout_wflginfl_00000000000000000000ffffbc5d9056","1455645607","no");
INSERT INTO wp_options VALUES("27945","_transient_wflginfl_00000000000000000000ffffbc5d9056","1","no");
INSERT INTO wp_options VALUES("27957","_transient_timeout_wflginfl_00000000000000000000ffff45c37c7b","1455646770","no");
INSERT INTO wp_options VALUES("27958","_transient_wflginfl_00000000000000000000ffff45c37c7b","1","no");
INSERT INTO wp_options VALUES("27964","_transient_timeout_wflginfl_00000000000000000000ffff3e958f4b","1455647353","no");
INSERT INTO wp_options VALUES("27965","_transient_wflginfl_00000000000000000000ffff3e958f4b","1","no");
INSERT INTO wp_options VALUES("28019","_transient_timeout_wflginfl_00000000000000000000ffff48a7e812","1455672936","no");
INSERT INTO wp_options VALUES("28020","_transient_wflginfl_00000000000000000000ffff48a7e812","1","no");
INSERT INTO wp_options VALUES("28022","_transient_timeout_wflginfl_00000000000000000000ffffb8a89812","1455673559","no");
INSERT INTO wp_options VALUES("28023","_transient_wflginfl_00000000000000000000ffffb8a89812","1","no");
INSERT INTO wp_options VALUES("28030","_transient_timeout_wflginfl_00000000000000000000ffff323ea1a2","1455674184","no");
INSERT INTO wp_options VALUES("28031","_transient_wflginfl_00000000000000000000ffff323ea1a2","1","no");
INSERT INTO wp_options VALUES("28033","_transient_timeout_wflginfl_00000000000000000000ffff5bef4254","1455674800","no");
INSERT INTO wp_options VALUES("28034","_transient_wflginfl_00000000000000000000ffff5bef4254","1","no");
INSERT INTO wp_options VALUES("28040","_transient_timeout_wflginfl_00000000000000000000ffffbc5d9054","1455675421","no");
INSERT INTO wp_options VALUES("28041","_transient_wflginfl_00000000000000000000ffffbc5d9054","1","no");
INSERT INTO wp_options VALUES("28050","_transient_timeout_wflginfl_00000000000000000000ffff323ea14c","1455676651","no");
INSERT INTO wp_options VALUES("28051","_transient_wflginfl_00000000000000000000ffff323ea14c","1","no");
INSERT INTO wp_options VALUES("30354","_transient_timeout_wflginfl_00000000000000000000ffffdf492c42","1456476286","no");
INSERT INTO wp_options VALUES("30355","_transient_wflginfl_00000000000000000000ffffdf492c42","2","no");
INSERT INTO wp_options VALUES("30591","_transient_timeout_wflginfl_00000000000000000000ffff5850c402","1456579554","no");
INSERT INTO wp_options VALUES("30592","_transient_wflginfl_00000000000000000000ffff5850c402","1","no");
INSERT INTO wp_options VALUES("30738","_site_transient_timeout_browser_ca08ca969049f0b66eb017ee29553ab8","1457282375","yes");
INSERT INTO wp_options VALUES("30739","_site_transient_browser_ca08ca969049f0b66eb017ee29553ab8","a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"48.0.2564.116\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO wp_options VALUES("30766","_site_transient_timeout_available_translations","1456688386","yes");
INSERT INTO wp_options VALUES("30767","_site_transient_available_translations","a:77:{s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-12 10:15:45\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4.2/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-07 13:09:53\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-07 20:53:51\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-11 22:42:10\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4.2/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-08 08:50:29\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:22:\"Продължение\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-08 13:17:04\";s:12:\"english_name\";s:7:\"Bengali\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:23:\"এগিয়ে চল.\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-04 09:40:25\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-01-16 13:48:03\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-16 15:34:57\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-01-26 16:01:40\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-08 22:48:20\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Forts&#230;t\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-08 14:19:21\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Fortfahren\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-26 16:11:41\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Fortfahren\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-26 16:11:56\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/4.4.2/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Fortfahren\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-25 16:27:59\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-06 23:10:59\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-01-14 21:14:29\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-08 13:34:17\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-15 11:52:35\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-07 04:39:48\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-01-25 13:07:29\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-01-28 19:55:54\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/es_CL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-09 18:08:52\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/es_GT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-01-24 15:17:36\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/es_PE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-01-13 06:14:13\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/es_VE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:6:\"4.3-RC\";s:7:\"updated\";s:19:\"2015-08-04 06:10:33\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.3-RC/es_CO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-07 17:35:10\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/es_MX.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-23 00:46:01\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/es_AR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-13 12:28:49\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/es_ES.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"es\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-18 06:44:22\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-07 21:19:15\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-01-31 19:24:20\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-23 06:49:15\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-08 13:47:35\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-11 10:20:56\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-09 02:16:19\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.3.3\";s:7:\"updated\";s:19:\"2015-09-24 15:25:30\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.3.3/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-01-13 16:48:03\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4.2/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-20 23:17:57\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"להמשיך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-06 14:16:56\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"जारी\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-24 11:33:48\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-03 14:37:42\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Tovább\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-04 07:13:54\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-21 16:17:50\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-08 00:20:24\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-01-30 18:58:39\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-25 13:08:14\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"続ける\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-08 07:31:53\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-24 00:12:01\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-08 20:07:24\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-01-28 05:41:39\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.1.10\";s:7:\"updated\";s:19:\"2015-03-26 15:57:42\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.1.10/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ေဆာင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-07 10:01:09\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-01-20 13:35:50\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/4.4.2/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-23 18:59:13\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-14 12:19:44\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-08 16:21:37\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.4.2/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-26 19:07:19\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.1.10\";s:7:\"updated\";s:19:\"2015-03-29 22:19:48\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1.10/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"دوام\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-10 18:05:56\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-25 13:02:32\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-24 11:09:36\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-01-02 00:04:31\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-26 11:29:13\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-11-26 00:00:18\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Nadaljujte\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-02-23 10:30:30\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-09 09:09:51\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-08 23:28:56\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-08 03:22:55\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-11-27 15:51:36\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-17 23:12:27\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:6:\"4.1.10\";s:7:\"updated\";s:19:\"2015-03-26 16:45:38\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:9:\"Uyƣurqə\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.1.10/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2016-01-03 22:04:41\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-09 01:01:25\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.4.2/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-11 18:51:41\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"4.4.2\";s:7:\"updated\";s:19:\"2015-12-12 22:55:08\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.4.2/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}}","yes");
INSERT INTO wp_options VALUES("30811","ossdl_off_cdn_url","https://capitaldistrictdigital.com","yes");
INSERT INTO wp_options VALUES("30812","ossdl_off_include_dirs","wp-content,wp-includes","yes");
INSERT INTO wp_options VALUES("30813","ossdl_off_exclude",".php","yes");
INSERT INTO wp_options VALUES("30814","ossdl_cname","","yes");
INSERT INTO wp_options VALUES("30817","wpsupercache_start","1456678515","yes");
INSERT INTO wp_options VALUES("30818","wpsupercache_count","0","yes");
INSERT INTO wp_options VALUES("30819","wpsupercache_gc_time","1459703559","yes");
INSERT INTO wp_options VALUES("30866","rlrsssl_options","a:13:{s:27:\"force_ssl_without_detection\";b:0;s:12:\"site_has_ssl\";b:1;s:4:\"hsts\";b:0;s:22:\"htaccess_warning_shown\";b:0;s:28:\"wpmu_subfolder_warning_shown\";b:0;s:16:\"yoasterror_shown\";b:0;s:25:\"ssl_success_message_shown\";b:0;s:26:\"autoreplace_insecure_links\";b:1;s:17:\"plugin_db_version\";s:5:\"2.3.2\";s:5:\"debug\";b:0;s:20:\"do_not_edit_htaccess\";b:0;s:11:\"ssl_enabled\";b:1;s:19:\"javascript_redirect\";b:1;}","yes");
INSERT INTO wp_options VALUES("30872","really_simple_ssl_do_scan","activate_scan","yes");
INSERT INTO wp_options VALUES("31090","_transient_timeout_wpseo_sitemap_cache_dslc_templates_1","1456854527","no");
INSERT INTO wp_options VALUES("31091","_transient_wpseo_sitemap_cache_dslc_templates_1","<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:image=\"http://www.google.com/schemas/sitemap-image/1.1\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>https://capitaldistrictdigital.com/dslc_templates/project/</loc>\n		<lastmod>2015-05-20T18:22:17+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/dslc_templates/staff-2/</loc>\n		<lastmod>2015-09-08T00:42:24+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n</urlset>","no");
INSERT INTO wp_options VALUES("31252","_transient_timeout_wpseo_sitemap_cache_dslc_projects_cats_1","1456919319","no");
INSERT INTO wp_options VALUES("31253","_transient_wpseo_sitemap_cache_dslc_projects_cats_1","<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>https://capitaldistrictdigital.com/dslc_projects_cats/responsive-web-design/</loc>\n		<lastmod>2016-02-25T17:23:05+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n</urlset>","no");
INSERT INTO wp_options VALUES("31256","_transient_timeout_wpseo_sitemap_cache_dslc_projects_1","1456919366","no");
INSERT INTO wp_options VALUES("31257","_transient_wpseo_sitemap_cache_dslc_projects_1","<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:image=\"http://www.google.com/schemas/sitemap-image/1.1\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/muddaddy-flats-quesadillary/</loc>\n		<lastmod>2016-02-25T16:35:06+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-Muddaddy-Flats.png</image:loc>\n			<image:caption><![CDATA[Muddaddy Flats Quesadillary]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/ambrose-electric/</loc>\n		<lastmod>2016-02-25T16:34:01+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-Ambrose-Electric.png</image:loc>\n			<image:caption><![CDATA[Ambrose Electric]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/1495/</loc>\n		<lastmod>2016-02-25T16:33:27+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-JM-Jewelers.png</image:loc>\n			<image:caption><![CDATA[JM Jewelers]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/empire-state-plumbing/</loc>\n		<lastmod>2016-02-25T16:32:25+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-Empire-State-Plumbing.png</image:loc>\n			<image:caption><![CDATA[Empire State Plumbing]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/classic-crust-mobile-catering/</loc>\n		<lastmod>2016-02-25T16:31:22+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-Classic-Crust.png</image:loc>\n			<image:caption><![CDATA[Classic Crust Mobile Catering]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/ania-hair-studio-spa/</loc>\n		<lastmod>2016-02-25T16:30:40+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-Ania-Hair-Studio.png</image:loc>\n			<image:caption><![CDATA[Ania Hair Studio &amp; Spa]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/dream-street-modulars/</loc>\n		<lastmod>2016-02-25T16:30:05+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-Dream-St-Modulars.png</image:loc>\n			<image:caption><![CDATA[Dream Street Modulars]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/prestige-dmv/</loc>\n		<lastmod>2016-02-25T16:29:31+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-Prestige-DMV.png</image:loc>\n			<image:caption><![CDATA[Prestige DMV]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/kickassvacuumdealer-com/</loc>\n		<lastmod>2016-02-25T16:28:54+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-Kickass-Vacuum-Dealer.png</image:loc>\n			<image:caption><![CDATA[KickAssVacuumDealer.com]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/mde-scouting/</loc>\n		<lastmod>2016-02-25T16:26:39+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-MDE-Scouting.png</image:loc>\n			<image:caption><![CDATA[MDE Scouting]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/northwood-homes/</loc>\n		<lastmod>2016-02-25T16:28:14+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-Northwood-Homes.png</image:loc>\n			<image:caption><![CDATA[NorthWood Homes]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/capital-district-contractors/</loc>\n		<lastmod>2016-02-25T16:27:21+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-Capital-District-Contractors.png</image:loc>\n			<image:caption><![CDATA[Capital District Contractors]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/a-magic-kingdom/</loc>\n		<lastmod>2016-02-25T16:37:13+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-A-Magic-Kingdom.png</image:loc>\n			<image:caption><![CDATA[A Magic Kingdom]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/machnick-builders/</loc>\n		<lastmod>2016-02-25T16:42:59+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-Machnick-Builders.png</image:loc>\n			<image:caption><![CDATA[Machnick Builders, LTD.]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/teds-flooring-interior-design/</loc>\n		<lastmod>2016-02-25T16:47:28+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-Teds-Flooring.png</image:loc>\n			<image:caption><![CDATA[Ted]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/brits-r-us/</loc>\n		<lastmod>2016-02-25T16:53:50+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-Brits-R-Us.png</image:loc>\n			<image:caption><![CDATA[Brits R Us]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/albany-beverage-center/</loc>\n		<lastmod>2016-02-25T16:58:13+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-Albany-Beverage-Center.png</image:loc>\n			<image:caption><![CDATA[Albany Beverage Center]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/the-della-ratta-law-office/</loc>\n		<lastmod>2016-02-25T17:06:08+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-Della-Ratta-Law-Office.png</image:loc>\n			<image:caption><![CDATA[The Della Ratta Law Office]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/ac-towing-recovery/</loc>\n		<lastmod>2016-02-25T17:11:21+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-ACs-Towing-and-Recovery.png</image:loc>\n			<image:caption><![CDATA[Ac Towing &amp; Recovery]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/crescent-gardens/</loc>\n		<lastmod>2016-02-25T17:18:46+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2016/02/Capital-District-Digital_-Web-Design_-Crescent-Gardens.png</image:loc>\n			<image:caption><![CDATA[Crescent Gardens]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/the-ideal-u/</loc>\n		<lastmod>2016-02-25T17:23:05+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-The-Ideal-U.png</image:loc>\n			<image:caption><![CDATA[The Ideal U]]></image:caption>\n		</image:image>\n	</url>\n</urlset>","no");
INSERT INTO wp_options VALUES("31335","wpseo_sitemap_cache_validator_global","9MdGrI","yes");
INSERT INTO wp_options VALUES("31348","wpseo_sitemap_dslc_templates_cache_validator","aFADdn","yes");
INSERT INTO wp_options VALUES("31351","wpseo_sitemap_page_cache_validator","28FiiR","yes");
INSERT INTO wp_options VALUES("31354","wpseo_sitemap_dslc_staff_cache_validator","94j49n","yes");
INSERT INTO wp_options VALUES("31357","wpseo_sitemap_dslc_projects_cache_validator","aFFNeU","yes");
INSERT INTO wp_options VALUES("31433","wpseo_sitemap_1_cache_validator","28FidT","yes");
INSERT INTO wp_options VALUES("31469","wpseo_sitemap_dslc_projects_cats_cache_validator","7oZuIK","yes");
INSERT INTO wp_options VALUES("31514","wpseosms","a:6:{s:6:\"pageID\";s:4:\"1575\";s:8:\"location\";s:5:\"after\";s:7:\"columns\";s:1:\"3\";s:11:\"css-disable\";s:2:\"no\";s:8:\"xml-link\";s:2:\"no\";s:12:\"credits-link\";s:2:\"no\";}","yes");
INSERT INTO wp_options VALUES("31517","wpseo_sitemap_revision_cache_validator","uvAlY","yes");
INSERT INTO wp_options VALUES("31526","wpseo_sitemap_nav_menu_item_cache_validator","RyIIM","yes");
INSERT INTO wp_options VALUES("31527","wpseo_sitemap_nav_menu_cache_validator","RyJ4w","yes");
INSERT INTO wp_options VALUES("31789","wpseo_sitemap_post_cache_validator","azcU6E","yes");
INSERT INTO wp_options VALUES("32328","_transient_timeout_yst_sm_dslc_projects_cats_1:a4ISs3_7oZuIK","1457486277","no");
INSERT INTO wp_options VALUES("32340","_transient_timeout_yst_sm_dslc_templates_1:a4ISs3_aFADdn","1457489545","no");
INSERT INTO wp_options VALUES("32417","_transient_timeout_yst_sm_dslc_projects_1:a4ISs3_aFFNeU","1457522039","no");
INSERT INTO wp_options VALUES("32567","_transient_timeout_wflginfl_00000000000000000000ffff5158e07c","1457557488","no");
INSERT INTO wp_options VALUES("32568","_transient_wflginfl_00000000000000000000ffff5158e07c","5","no");
INSERT INTO wp_options VALUES("32833","_transient_timeout_wflginfl_00000000000000000000ffff5bcf0622","1457647196","no");
INSERT INTO wp_options VALUES("32834","_transient_wflginfl_00000000000000000000ffff5bcf0622","1","no");
INSERT INTO wp_options VALUES("32910","_site_transient_timeout_browser_06d3d9617a2883877c8f5e774e52c741","1458314548","yes");
INSERT INTO wp_options VALUES("32911","_site_transient_browser_06d3d9617a2883877c8f5e774e52c741","a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"48.0.2564.116\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO wp_options VALUES("32938","wpseo_sitemap_attachment_cache_validator","rByEY","yes");
INSERT INTO wp_options VALUES("33808","_transient_timeout_yst_sm_dslc_projects_1:2t93ZY_aFFNeU","1458167374","no");
INSERT INTO wp_options VALUES("34641","_transient_timeout_yst_sm_dslc_projects_cats_1:2t93ZY_7oZuIK","1458478764","no");
INSERT INTO wp_options VALUES("34774","_site_transient_timeout_browser_1b39d7d1d62ac4d2b3dc7459ef7d1588","1459040446","yes");
INSERT INTO wp_options VALUES("34775","_site_transient_browser_1b39d7d1d62ac4d2b3dc7459ef7d1588","a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"49.0.2623.87\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO wp_options VALUES("35147","_transient_timeout_wflginfl_00000000000000000000ffffb98194cb","1458518779","no");
INSERT INTO wp_options VALUES("35148","_transient_wflginfl_00000000000000000000ffffb98194cb","1","no");
INSERT INTO wp_options VALUES("35166","_site_transient_timeout_browser_5ae30cdd14332a186c84b08c03075a6c","1459129128","yes");
INSERT INTO wp_options VALUES("35167","_site_transient_browser_5ae30cdd14332a186c84b08c03075a6c","a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"49.0.2623.87\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO wp_options VALUES("35201","automatic-updater","a:8:{s:6:\"update\";a:3:{s:4:\"core\";a:2:{s:5:\"major\";b:0;s:5:\"minor\";b:1;}s:7:\"plugins\";b:1;s:6:\"themes\";b:0;}s:3:\"svn\";a:3:{s:4:\"core\";b:0;s:7:\"plugins\";a:0:{}s:6:\"themes\";a:0:{}}s:17:\"svn-success-email\";b:1;s:5:\"debug\";s:5:\"debug\";s:23:\"next-development-update\";i:1458524358;s:14:\"override-email\";s:0:\"\";s:13:\"disable-email\";b:0;s:17:\"upgrade-after-3.7\";b:1;}","yes");
INSERT INTO wp_options VALUES("35791","_transient_timeout_yst_sm_dslc_templates_1:2t93ZY_aFADdn","1458807432","no");
INSERT INTO wp_options VALUES("35863","_transient_timeout_yst_sm_dslc_staff_1:2t93ZY_94j49n","1458821966","no");
INSERT INTO wp_options VALUES("35933","rewrite_rules","a:289:{s:15:\"lbmn_archive/?$\";s:32:\"index.php?post_type=lbmn_archive\";s:45:\"lbmn_archive/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=lbmn_archive&feed=$matches[1]\";s:40:\"lbmn_archive/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=lbmn_archive&feed=$matches[1]\";s:32:\"lbmn_archive/page/([0-9]{1,})/?$\";s:50:\"index.php?post_type=lbmn_archive&paged=$matches[1]\";s:14:\"lbmn_footer/?$\";s:31:\"index.php?post_type=lbmn_footer\";s:44:\"lbmn_footer/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?post_type=lbmn_footer&feed=$matches[1]\";s:39:\"lbmn_footer/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?post_type=lbmn_footer&feed=$matches[1]\";s:31:\"lbmn_footer/page/([0-9]{1,})/?$\";s:49:\"index.php?post_type=lbmn_footer&paged=$matches[1]\";s:19:\"sitemap_index\\.xml$\";s:19:\"index.php?sitemap=1\";s:31:\"([^/]+?)-sitemap([0-9]+)?\\.xml$\";s:51:\"index.php?sitemap=$matches[1]&sitemap_n=$matches[2]\";s:24:\"([a-z]+)?-?sitemap\\.xsl$\";s:25:\"index.php?xsl=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:40:\"lbmn_archive/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"lbmn_archive/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"lbmn_archive/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"lbmn_archive/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"lbmn_archive/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"lbmn_archive/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"lbmn_archive/([^/]+)/embed/?$\";s:45:\"index.php?lbmn_archive=$matches[1]&embed=true\";s:33:\"lbmn_archive/([^/]+)/trackback/?$\";s:39:\"index.php?lbmn_archive=$matches[1]&tb=1\";s:53:\"lbmn_archive/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?lbmn_archive=$matches[1]&feed=$matches[2]\";s:48:\"lbmn_archive/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?lbmn_archive=$matches[1]&feed=$matches[2]\";s:41:\"lbmn_archive/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?lbmn_archive=$matches[1]&paged=$matches[2]\";s:48:\"lbmn_archive/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?lbmn_archive=$matches[1]&cpage=$matches[2]\";s:37:\"lbmn_archive/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?lbmn_archive=$matches[1]&page=$matches[2]\";s:29:\"lbmn_archive/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"lbmn_archive/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"lbmn_archive/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"lbmn_archive/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"lbmn_archive/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"lbmn_archive/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"lbmn_footer/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"lbmn_footer/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"lbmn_footer/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"lbmn_footer/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"lbmn_footer/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"lbmn_footer/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"lbmn_footer/([^/]+)/embed/?$\";s:44:\"index.php?lbmn_footer=$matches[1]&embed=true\";s:32:\"lbmn_footer/([^/]+)/trackback/?$\";s:38:\"index.php?lbmn_footer=$matches[1]&tb=1\";s:52:\"lbmn_footer/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?lbmn_footer=$matches[1]&feed=$matches[2]\";s:47:\"lbmn_footer/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?lbmn_footer=$matches[1]&feed=$matches[2]\";s:40:\"lbmn_footer/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?lbmn_footer=$matches[1]&paged=$matches[2]\";s:47:\"lbmn_footer/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?lbmn_footer=$matches[1]&cpage=$matches[2]\";s:36:\"lbmn_footer/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?lbmn_footer=$matches[1]&page=$matches[2]\";s:28:\"lbmn_footer/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:38:\"lbmn_footer/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:58:\"lbmn_footer/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"lbmn_footer/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:53:\"lbmn_footer/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:34:\"lbmn_footer/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:42:\"dslc_templates/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"dslc_templates/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"dslc_templates/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"dslc_templates/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"dslc_templates/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"dslc_templates/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"dslc_templates/([^/]+)/embed/?$\";s:47:\"index.php?dslc_templates=$matches[1]&embed=true\";s:35:\"dslc_templates/([^/]+)/trackback/?$\";s:41:\"index.php?dslc_templates=$matches[1]&tb=1\";s:43:\"dslc_templates/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?dslc_templates=$matches[1]&paged=$matches[2]\";s:50:\"dslc_templates/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?dslc_templates=$matches[1]&cpage=$matches[2]\";s:39:\"dslc_templates/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?dslc_templates=$matches[1]&page=$matches[2]\";s:31:\"dslc_templates/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"dslc_templates/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"dslc_templates/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"dslc_templates/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"dslc_templates/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"dslc_templates/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:40:\"project-view/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"project-view/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"project-view/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"project-view/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"project-view/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"project-view/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"project-view/([^/]+)/embed/?$\";s:46:\"index.php?dslc_projects=$matches[1]&embed=true\";s:33:\"project-view/([^/]+)/trackback/?$\";s:40:\"index.php?dslc_projects=$matches[1]&tb=1\";s:41:\"project-view/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?dslc_projects=$matches[1]&paged=$matches[2]\";s:48:\"project-view/([^/]+)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?dslc_projects=$matches[1]&cpage=$matches[2]\";s:37:\"project-view/([^/]+)(?:/([0-9]+))?/?$\";s:52:\"index.php?dslc_projects=$matches[1]&page=$matches[2]\";s:29:\"project-view/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"project-view/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"project-view/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"project-view/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"project-view/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"project-view/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"dslc_projects_cats/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?dslc_projects_cats=$matches[1]&feed=$matches[2]\";s:54:\"dslc_projects_cats/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?dslc_projects_cats=$matches[1]&feed=$matches[2]\";s:47:\"dslc_projects_cats/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?dslc_projects_cats=$matches[1]&paged=$matches[2]\";s:29:\"dslc_projects_cats/([^/]+)/?$\";s:40:\"index.php?dslc_projects_cats=$matches[1]\";s:40:\"gallery-view/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"gallery-view/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"gallery-view/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"gallery-view/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"gallery-view/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"gallery-view/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"gallery-view/([^/]+)/embed/?$\";s:47:\"index.php?dslc_galleries=$matches[1]&embed=true\";s:33:\"gallery-view/([^/]+)/trackback/?$\";s:41:\"index.php?dslc_galleries=$matches[1]&tb=1\";s:41:\"gallery-view/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?dslc_galleries=$matches[1]&paged=$matches[2]\";s:48:\"gallery-view/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?dslc_galleries=$matches[1]&cpage=$matches[2]\";s:37:\"gallery-view/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?dslc_galleries=$matches[1]&page=$matches[2]\";s:29:\"gallery-view/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"gallery-view/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"gallery-view/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"gallery-view/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"gallery-view/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"gallery-view/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:60:\"dslc_galleries_cats/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?dslc_galleries_cats=$matches[1]&feed=$matches[2]\";s:55:\"dslc_galleries_cats/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?dslc_galleries_cats=$matches[1]&feed=$matches[2]\";s:48:\"dslc_galleries_cats/([^/]+)/page/?([0-9]{1,})/?$\";s:59:\"index.php?dslc_galleries_cats=$matches[1]&paged=$matches[2]\";s:30:\"dslc_galleries_cats/([^/]+)/?$\";s:41:\"index.php?dslc_galleries_cats=$matches[1]\";s:38:\"staff-view/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"staff-view/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"staff-view/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"staff-view/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"staff-view/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"staff-view/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"staff-view/([^/]+)/embed/?$\";s:43:\"index.php?dslc_staff=$matches[1]&embed=true\";s:31:\"staff-view/([^/]+)/trackback/?$\";s:37:\"index.php?dslc_staff=$matches[1]&tb=1\";s:39:\"staff-view/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?dslc_staff=$matches[1]&paged=$matches[2]\";s:46:\"staff-view/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?dslc_staff=$matches[1]&cpage=$matches[2]\";s:35:\"staff-view/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?dslc_staff=$matches[1]&page=$matches[2]\";s:27:\"staff-view/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"staff-view/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"staff-view/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"staff-view/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"staff-view/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"staff-view/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:56:\"dslc_staff_cats/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?dslc_staff_cats=$matches[1]&feed=$matches[2]\";s:51:\"dslc_staff_cats/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?dslc_staff_cats=$matches[1]&feed=$matches[2]\";s:44:\"dslc_staff_cats/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?dslc_staff_cats=$matches[1]&paged=$matches[2]\";s:26:\"dslc_staff_cats/([^/]+)/?$\";s:37:\"index.php?dslc_staff_cats=$matches[1]\";s:41:\"download-view/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"download-view/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"download-view/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"download-view/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"download-view/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"download-view/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:30:\"download-view/([^/]+)/embed/?$\";s:47:\"index.php?dslc_downloads=$matches[1]&embed=true\";s:34:\"download-view/([^/]+)/trackback/?$\";s:41:\"index.php?dslc_downloads=$matches[1]&tb=1\";s:42:\"download-view/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?dslc_downloads=$matches[1]&paged=$matches[2]\";s:49:\"download-view/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?dslc_downloads=$matches[1]&cpage=$matches[2]\";s:38:\"download-view/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?dslc_downloads=$matches[1]&page=$matches[2]\";s:30:\"download-view/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"download-view/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"download-view/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"download-view/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"download-view/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"download-view/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"dslc_downloads_cat/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?dslc_downloads_cats=$matches[1]&feed=$matches[2]\";s:54:\"dslc_downloads_cat/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?dslc_downloads_cats=$matches[1]&feed=$matches[2]\";s:47:\"dslc_downloads_cat/([^/]+)/page/?([0-9]{1,})/?$\";s:59:\"index.php?dslc_downloads_cats=$matches[1]&paged=$matches[2]\";s:29:\"dslc_downloads_cat/([^/]+)/?$\";s:41:\"index.php?dslc_downloads_cats=$matches[1]\";s:59:\"dslc_downloads_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?dslc_downloads_tags=$matches[1]&feed=$matches[2]\";s:54:\"dslc_downloads_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?dslc_downloads_tags=$matches[1]&feed=$matches[2]\";s:47:\"dslc_downloads_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:59:\"index.php?dslc_downloads_tags=$matches[1]&paged=$matches[2]\";s:29:\"dslc_downloads_tag/([^/]+)/?$\";s:41:\"index.php?dslc_downloads_tags=$matches[1]\";s:44:\"testimonial-view/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"testimonial-view/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"testimonial-view/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"testimonial-view/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"testimonial-view/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"testimonial-view/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"testimonial-view/([^/]+)/embed/?$\";s:50:\"index.php?dslc_testimonials=$matches[1]&embed=true\";s:37:\"testimonial-view/([^/]+)/trackback/?$\";s:44:\"index.php?dslc_testimonials=$matches[1]&tb=1\";s:45:\"testimonial-view/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?dslc_testimonials=$matches[1]&paged=$matches[2]\";s:52:\"testimonial-view/([^/]+)/comment-page-([0-9]{1,})/?$\";s:57:\"index.php?dslc_testimonials=$matches[1]&cpage=$matches[2]\";s:41:\"testimonial-view/([^/]+)(?:/([0-9]+))?/?$\";s:56:\"index.php?dslc_testimonials=$matches[1]&page=$matches[2]\";s:33:\"testimonial-view/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"testimonial-view/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"testimonial-view/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"testimonial-view/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"testimonial-view/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"testimonial-view/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:63:\"dslc_testimonials_cats/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:61:\"index.php?dslc_testimonials_cats=$matches[1]&feed=$matches[2]\";s:58:\"dslc_testimonials_cats/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:61:\"index.php?dslc_testimonials_cats=$matches[1]&feed=$matches[2]\";s:51:\"dslc_testimonials_cats/([^/]+)/page/?([0-9]{1,})/?$\";s:62:\"index.php?dslc_testimonials_cats=$matches[1]&paged=$matches[2]\";s:33:\"dslc_testimonials_cats/([^/]+)/?$\";s:44:\"index.php?dslc_testimonials_cats=$matches[1]\";s:40:\"partner-view/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"partner-view/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"partner-view/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"partner-view/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"partner-view/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"partner-view/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"partner-view/([^/]+)/embed/?$\";s:46:\"index.php?dslc_partners=$matches[1]&embed=true\";s:33:\"partner-view/([^/]+)/trackback/?$\";s:40:\"index.php?dslc_partners=$matches[1]&tb=1\";s:41:\"partner-view/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?dslc_partners=$matches[1]&paged=$matches[2]\";s:48:\"partner-view/([^/]+)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?dslc_partners=$matches[1]&cpage=$matches[2]\";s:37:\"partner-view/([^/]+)(?:/([0-9]+))?/?$\";s:52:\"index.php?dslc_partners=$matches[1]&page=$matches[2]\";s:29:\"partner-view/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"partner-view/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"partner-view/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"partner-view/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"partner-view/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"partner-view/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:59:\"dslc_partners_cats/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?dslc_partners_cats=$matches[1]&feed=$matches[2]\";s:54:\"dslc_partners_cats/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?dslc_partners_cats=$matches[1]&feed=$matches[2]\";s:47:\"dslc_partners_cats/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?dslc_partners_cats=$matches[1]&paged=$matches[2]\";s:29:\"dslc_partners_cats/([^/]+)/?$\";s:40:\"index.php?dslc_partners_cats=$matches[1]\";s:38:\"ff-options/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"ff-options/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"ff-options/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"ff-options/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"ff-options/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"ff-options/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"ff-options/([^/]+)/embed/?$\";s:43:\"index.php?ff-options=$matches[1]&embed=true\";s:31:\"ff-options/([^/]+)/trackback/?$\";s:37:\"index.php?ff-options=$matches[1]&tb=1\";s:39:\"ff-options/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?ff-options=$matches[1]&paged=$matches[2]\";s:46:\"ff-options/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?ff-options=$matches[1]&cpage=$matches[2]\";s:35:\"ff-options/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?ff-options=$matches[1]&page=$matches[2]\";s:27:\"ff-options/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"ff-options/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"ff-options/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"ff-options/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"ff-options/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"ff-options/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:41:\"index.php?&page_id=1041&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}","yes");
INSERT INTO wp_options VALUES("36861","7103891","a:2:{i:0;s:10:\"1053817331\";i:1;i:1461369600;}","yes");
INSERT INTO wp_options VALUES("36862","_transient_timeout_styles_google_font_data","1460080174","no");
INSERT INTO wp_options VALUES("36863","_transient_styles_google_font_data","O:8:\"stdClass\":2:{s:4:\"kind\";s:20:\"webfonts#webfontList\";s:5:\"items\";a:652:{i:0;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Open Sans\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"800\";i:9;s:9:\"800italic\";}s:7:\"subsets\";a:7:{i:0;s:12:\"cyrillic-ext\";i:1;s:9:\"latin-ext\";i:2;s:9:\"greek-ext\";i:3;s:8:\"cyrillic\";i:4;s:5:\"greek\";i:5;s:10:\"vietnamese\";i:6;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":10:{s:3:\"300\";s:108:\"http://themes.googleusercontent.com/static/fonts/opensans/v6/DXI1ORHCpsQm3Vp6mXoaTS3USBnSvpkopQaUR-2r7iU.ttf\";s:9:\"300italic\";s:108:\"http://themes.googleusercontent.com/static/fonts/opensans/v6/PRmiXeptR36kaC0GEAetxi9-WlPSxbfiI49GsXo3q0g.ttf\";s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/opensans/v6/IgZJs4-7SA1XX_edsoXWog.ttf\";s:6:\"italic\";s:108:\"http://themes.googleusercontent.com/static/fonts/opensans/v6/O4NhV7_qs9r9seTo7fnsVKCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"600\";s:108:\"http://themes.googleusercontent.com/static/fonts/opensans/v6/MTP_ySUJH_bn48VBG8sNSi3USBnSvpkopQaUR-2r7iU.ttf\";s:9:\"600italic\";s:108:\"http://themes.googleusercontent.com/static/fonts/opensans/v6/PRmiXeptR36kaC0GEAetxpZ7xm-Bj30Bj2KNdXDzSZg.ttf\";s:3:\"700\";s:108:\"http://themes.googleusercontent.com/static/fonts/opensans/v6/k3k702ZOKiLJc3WVjuplzC3USBnSvpkopQaUR-2r7iU.ttf\";s:9:\"700italic\";s:108:\"http://themes.googleusercontent.com/static/fonts/opensans/v6/PRmiXeptR36kaC0GEAetxne1Pd76Vl7zRpE7NLJQ7XU.ttf\";s:3:\"800\";s:108:\"http://themes.googleusercontent.com/static/fonts/opensans/v6/EInbV5DfGHOiMmvb1Xr-hi3USBnSvpkopQaUR-2r7iU.ttf\";s:9:\"800italic\";s:108:\"http://themes.googleusercontent.com/static/fonts/opensans/v6/PRmiXeptR36kaC0GEAetxg89PwPrYLaRFJ-HNCU9NbA.ttf\";}}i:1;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Roboto\";s:8:\"variants\";a:12:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:7:\"regular\";i:5;s:6:\"italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"900\";i:11;s:9:\"900italic\";}s:7:\"subsets\";a:7:{i:0;s:12:\"cyrillic-ext\";i:1;s:9:\"latin-ext\";i:2;s:9:\"greek-ext\";i:3;s:8:\"cyrillic\";i:4;s:5:\"greek\";i:5;s:10:\"vietnamese\";i:6;s:5:\"latin\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2013-07-31\";s:5:\"files\";O:8:\"stdClass\":12:{s:3:\"100\";s:85:\"http://themes.googleusercontent.com/static/fonts/roboto/v9/7MygqTe2zs9YkP0adA9QQQ.ttf\";s:9:\"100italic\";s:106:\"http://themes.googleusercontent.com/static/fonts/roboto/v9/T1xnudodhcgwXCmZQ490TPesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"300\";s:85:\"http://themes.googleusercontent.com/static/fonts/roboto/v9/dtpHsbgPEm2lVWciJZ0P-A.ttf\";s:9:\"300italic\";s:106:\"http://themes.googleusercontent.com/static/fonts/roboto/v9/iE8HhaRzdhPxC93dOdA056CWcynf_cDxXwCLxiixG1c.ttf\";s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/roboto/v9/W5F8_SL0XFawnjxHGsZjJA.ttf\";s:6:\"italic\";s:85:\"http://themes.googleusercontent.com/static/fonts/roboto/v9/hcKoSgxdnKlbH5dlTwKbow.ttf\";s:3:\"500\";s:85:\"http://themes.googleusercontent.com/static/fonts/roboto/v9/Uxzkqj-MIMWle-XP2pDNAA.ttf\";s:9:\"500italic\";s:106:\"http://themes.googleusercontent.com/static/fonts/roboto/v9/daIfzbEw-lbjMyv4rMUUTqCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"700\";s:85:\"http://themes.googleusercontent.com/static/fonts/roboto/v9/bdHGHleUa-ndQCOrdpfxfw.ttf\";s:9:\"700italic\";s:106:\"http://themes.googleusercontent.com/static/fonts/roboto/v9/owYYXKukxFDFjr0ZO8NXh6CWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"900\";s:85:\"http://themes.googleusercontent.com/static/fonts/roboto/v9/H1vB34nOKWXqzKotq25pcg.ttf\";s:9:\"900italic\";s:106:\"http://themes.googleusercontent.com/static/fonts/roboto/v9/b9PWBSMHrT2zM5FgUdtu0aCWcynf_cDxXwCLxiixG1c.ttf\";}}i:2;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Oswald\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2012-10-03\";s:5:\"files\";O:8:\"stdClass\":3:{s:3:\"300\";s:85:\"http://themes.googleusercontent.com/static/fonts/oswald/v7/y3tZpCdiRD4oNRRYFcAR5Q.ttf\";s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/oswald/v7/uLEd2g2vJglLPfsBF91DCg.ttf\";s:3:\"700\";s:85:\"http://themes.googleusercontent.com/static/fonts/oswald/v7/7wj8ldV_5Ti37rHa0m1DDw.ttf\";}}i:3;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Droid Sans\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/droidsans/v3/rS9BT6-asrfjpkcV3DXf__esZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:109:\"http://themes.googleusercontent.com/static/fonts/droidsans/v3/EFpQQyG9GqCrobXxL-KRMQJKKGfqHaYFsRG-T3ceEVo.ttf\";}}i:4;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Lato\";s:8:\"variants\";a:10:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:7:\"regular\";i:5;s:6:\"italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"900\";i:9;s:9:\"900italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":10:{s:3:\"100\";s:83:\"http://themes.googleusercontent.com/static/fonts/lato/v6/Upp-ka9rLQmHYCsFgwL-eg.ttf\";s:9:\"100italic\";s:83:\"http://themes.googleusercontent.com/static/fonts/lato/v6/zLegi10uS_9-fnUDISl0KA.ttf\";s:3:\"300\";s:83:\"http://themes.googleusercontent.com/static/fonts/lato/v6/Ja02qOppOVq9jeRjWekbHg.ttf\";s:9:\"300italic\";s:83:\"http://themes.googleusercontent.com/static/fonts/lato/v6/dVebFcn7EV7wAKwgYestUg.ttf\";s:7:\"regular\";s:83:\"http://themes.googleusercontent.com/static/fonts/lato/v6/h7rISIcQapZBpei-sXwIwg.ttf\";s:6:\"italic\";s:83:\"http://themes.googleusercontent.com/static/fonts/lato/v6/P_dJOFJylV3A870UIOtr0w.ttf\";s:3:\"700\";s:83:\"http://themes.googleusercontent.com/static/fonts/lato/v6/iX_QxBBZLhNj5JHlTzHQzg.ttf\";s:9:\"700italic\";s:83:\"http://themes.googleusercontent.com/static/fonts/lato/v6/WFcZakHrrCKeUJxHA4T_gw.ttf\";s:3:\"900\";s:83:\"http://themes.googleusercontent.com/static/fonts/lato/v6/8TPEV6NbYWZlNsXjbYVv7w.ttf\";s:9:\"900italic\";s:83:\"http://themes.googleusercontent.com/static/fonts/lato/v6/draWperrI7n2xi35Cl08fA.ttf\";}}i:5;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:19:\"Open Sans Condensed\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";}s:7:\"subsets\";a:7:{i:0;s:12:\"cyrillic-ext\";i:1;s:9:\"latin-ext\";i:2;s:9:\"greek-ext\";i:3;s:8:\"cyrillic\";i:4;s:5:\"greek\";i:5;s:10:\"vietnamese\";i:6;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":3:{s:3:\"300\";s:117:\"http://themes.googleusercontent.com/static/fonts/opensanscondensed/v6/gk5FxslNkTTHtojXrkp-xEMwSSh38KQVJx4ABtsZTnA.ttf\";s:9:\"300italic\";s:117:\"http://themes.googleusercontent.com/static/fonts/opensanscondensed/v6/jIXlqT1WKafUSwj6s9AzV4_LkTZ_uhAwfmGJ084hlvM.ttf\";s:3:\"700\";s:117:\"http://themes.googleusercontent.com/static/fonts/opensanscondensed/v6/gk5FxslNkTTHtojXrkp-xBEM87DM3yorPOrvA-vB930.ttf\";}}i:6;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"PT Sans\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:4:{i:0;s:12:\"cyrillic-ext\";i:1;s:9:\"latin-ext\";i:2;s:8:\"cyrillic\";i:3;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2013-05-29\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/ptsans/v5/UFoEz2uiuMypUGZL1NKoeg.ttf\";s:6:\"italic\";s:85:\"http://themes.googleusercontent.com/static/fonts/ptsans/v5/yls9EYWOd496wiu7qzfgNg.ttf\";s:3:\"700\";s:106:\"http://themes.googleusercontent.com/static/fonts/ptsans/v5/F51BEgHuR0tYHxF0bD4vwvesZW2xOQ-xsNqO47m55DA.ttf\";s:9:\"700italic\";s:106:\"http://themes.googleusercontent.com/static/fonts/ptsans/v5/lILlYDvubYemzYzN7GbLkC3USBnSvpkopQaUR-2r7iU.ttf\";}}i:7;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Droid Serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/droidserif/v3/DgAtPy6rIVa2Zx3Xh9KaNaCWcynf_cDxXwCLxiixG1c.ttf\";s:6:\"italic\";s:110:\"http://themes.googleusercontent.com/static/fonts/droidserif/v3/cj2hUnSRBhwmSPr9kS5890eOrDcLawS7-ssYqLr2Xp4.ttf\";s:3:\"700\";s:110:\"http://themes.googleusercontent.com/static/fonts/droidserif/v3/QQt14e8dY39u-eYBZmppwXe1Pd76Vl7zRpE7NLJQ7XU.ttf\";s:9:\"700italic\";s:110:\"http://themes.googleusercontent.com/static/fonts/droidserif/v3/c92rD_x0V1LslSFt3-QEps_zJjSACmk0BRPxQqhnNLU.ttf\";}}i:8;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Roboto Condensed\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";}s:7:\"subsets\";a:7:{i:0;s:12:\"cyrillic-ext\";i:1;s:9:\"latin-ext\";i:2;s:9:\"greek-ext\";i:3;s:8:\"cyrillic\";i:4;s:5:\"greek\";i:5;s:10:\"vietnamese\";i:6;s:5:\"latin\";}s:7:\"version\";s:2:\"v8\";s:12:\"lastModified\";s:10:\"2013-07-31\";s:5:\"files\";O:8:\"stdClass\":6:{s:3:\"300\";s:115:\"http://themes.googleusercontent.com/static/fonts/robotocondensed/v8/b9QBgL0iMZfDSpmcXcE8nJRhFVcex_hajThhFkHyhYk.ttf\";s:9:\"300italic\";s:115:\"http://themes.googleusercontent.com/static/fonts/robotocondensed/v8/mg0cGfGRUERshzBlvqxeAPYa9bgCHecWXGgisnodcS0.ttf\";s:7:\"regular\";s:115:\"http://themes.googleusercontent.com/static/fonts/robotocondensed/v8/Zd2E9abXLFGSr9G3YK2MsKDbm6fPDOZJsR8PmdG62gY.ttf\";s:6:\"italic\";s:115:\"http://themes.googleusercontent.com/static/fonts/robotocondensed/v8/BP5K8ZAJv9qEbmuFp8RpJY_eiqgTfYGaH0bJiUDZ5GA.ttf\";s:3:\"700\";s:115:\"http://themes.googleusercontent.com/static/fonts/robotocondensed/v8/b9QBgL0iMZfDSpmcXcE8nPOYkGiSOYDq_T7HbIOV1hA.ttf\";s:9:\"700italic\";s:115:\"http://themes.googleusercontent.com/static/fonts/robotocondensed/v8/mg0cGfGRUERshzBlvqxeAE2zk2RGRC3SlyyLLQfjS_8.ttf\";}}i:9;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Source Sans Pro\";s:8:\"variants\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:7:\"regular\";i:5;s:6:\"italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"900\";i:11;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:9:\"latin-ext\";i:1;s:10:\"vietnamese\";i:2;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2013-09-26\";s:5:\"files\";O:8:\"stdClass\":12:{s:3:\"200\";s:113:\"http://themes.googleusercontent.com/static/fonts/sourcesanspro/v6/toadOcfmlt9b38dHJxOBGKXvKVW_haheDNrHjziJZVk.ttf\";s:9:\"200italic\";s:113:\"http://themes.googleusercontent.com/static/fonts/sourcesanspro/v6/fpTVHK8qsXbIeTHTrnQH6OptKU7UIBg2hLM7eMTU8bI.ttf\";s:3:\"300\";s:113:\"http://themes.googleusercontent.com/static/fonts/sourcesanspro/v6/toadOcfmlt9b38dHJxOBGFP7R5lD_au4SZC6Ks_vyWs.ttf\";s:9:\"300italic\";s:113:\"http://themes.googleusercontent.com/static/fonts/sourcesanspro/v6/fpTVHK8qsXbIeTHTrnQH6DUpNKoQAsDux-Todp8f29w.ttf\";s:7:\"regular\";s:113:\"http://themes.googleusercontent.com/static/fonts/sourcesanspro/v6/ODelI1aHBYDBqgeIAH2zlNRl0pGnog23EMYRrBmUzJQ.ttf\";s:6:\"italic\";s:113:\"http://themes.googleusercontent.com/static/fonts/sourcesanspro/v6/M2Jd71oPJhLKp0zdtTvoMwRX4TIfMQQEXLu74GftruE.ttf\";s:3:\"600\";s:113:\"http://themes.googleusercontent.com/static/fonts/sourcesanspro/v6/toadOcfmlt9b38dHJxOBGOiMeWyi5E_-XkTgB5psiDg.ttf\";s:9:\"600italic\";s:113:\"http://themes.googleusercontent.com/static/fonts/sourcesanspro/v6/fpTVHK8qsXbIeTHTrnQH6Pp6lGoTTgjlW0sC4r900Co.ttf\";s:3:\"700\";s:113:\"http://themes.googleusercontent.com/static/fonts/sourcesanspro/v6/toadOcfmlt9b38dHJxOBGPgXsetDviZcdR5OzC1KPcw.ttf\";s:9:\"700italic\";s:113:\"http://themes.googleusercontent.com/static/fonts/sourcesanspro/v6/fpTVHK8qsXbIeTHTrnQH6LVT4locI09aamSzFGQlDMY.ttf\";s:3:\"900\";s:113:\"http://themes.googleusercontent.com/static/fonts/sourcesanspro/v6/toadOcfmlt9b38dHJxOBGBA_awHl7mXRjE_LQVochcU.ttf\";s:9:\"900italic\";s:113:\"http://themes.googleusercontent.com/static/fonts/sourcesanspro/v6/fpTVHK8qsXbIeTHTrnQH6A0NcF6HPGWR298uWIdxWv0.ttf\";}}i:10;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Ubuntu\";s:8:\"variants\";a:8:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";}s:7:\"subsets\";a:6:{i:0;s:12:\"cyrillic-ext\";i:1;s:9:\"latin-ext\";i:2;s:9:\"greek-ext\";i:3;s:8:\"cyrillic\";i:4;s:5:\"greek\";i:5;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":8:{s:3:\"300\";s:85:\"http://themes.googleusercontent.com/static/fonts/ubuntu/v4/7-wH0j2QCTHKgp7vLh9-sQ.ttf\";s:9:\"300italic\";s:106:\"http://themes.googleusercontent.com/static/fonts/ubuntu/v4/j-TYDdXcC_eQzhhp386SjaCWcynf_cDxXwCLxiixG1c.ttf\";s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/ubuntu/v4/lhhB5ZCwEkBRbHMSnYuKyA.ttf\";s:6:\"italic\";s:85:\"http://themes.googleusercontent.com/static/fonts/ubuntu/v4/b9hP8wd30SygxZjGGk4DCQ.ttf\";s:3:\"500\";s:85:\"http://themes.googleusercontent.com/static/fonts/ubuntu/v4/bMbHEMwSUmkzcK2x_74QbA.ttf\";s:9:\"500italic\";s:106:\"http://themes.googleusercontent.com/static/fonts/ubuntu/v4/NWdMogIO7U6AtEM4dDdf_aCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"700\";s:85:\"http://themes.googleusercontent.com/static/fonts/ubuntu/v4/B7BtHjNYwAp3HgLNagENOQ.ttf\";s:9:\"700italic\";s:106:\"http://themes.googleusercontent.com/static/fonts/ubuntu/v4/pqisLQoeO9YTDCNnlQ9bf6CWcynf_cDxXwCLxiixG1c.ttf\";}}i:11;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"PT Sans Narrow\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:4:{i:0;s:12:\"cyrillic-ext\";i:1;s:9:\"latin-ext\";i:2;s:8:\"cyrillic\";i:3;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2013-05-29\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:112:\"http://themes.googleusercontent.com/static/fonts/ptsansnarrow/v4/UyYrYy3ltEffJV9QueSi4ZTvAuddT2xDMbdz0mdLyZY.ttf\";s:3:\"700\";s:112:\"http://themes.googleusercontent.com/static/fonts/ptsansnarrow/v4/Q_pTky3Sc3ubRibGToTAYsLtdzs3iyjn_YuT226ZsLU.ttf\";}}i:12;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Oxygen\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-10-31\";s:5:\"files\";O:8:\"stdClass\":3:{s:3:\"300\";s:85:\"http://themes.googleusercontent.com/static/fonts/oxygen/v2/lZ31r0bR1Bzt_DfGZu1S8A.ttf\";s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/oxygen/v2/uhoyAE7XlQL22abzQieHjw.ttf\";s:3:\"700\";s:85:\"http://themes.googleusercontent.com/static/fonts/oxygen/v2/yLqkmDwuNtt5pSqsJmhyrg.ttf\";}}i:13;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Raleway\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";i:7;s:3:\"800\";i:8;s:3:\"900\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2012-09-14\";s:5:\"files\";O:8:\"stdClass\":9:{s:3:\"100\";s:86:\"http://themes.googleusercontent.com/static/fonts/raleway/v6/UDfD6oxBaBnmFJwQ7XAFNw.ttf\";s:3:\"200\";s:107:\"http://themes.googleusercontent.com/static/fonts/raleway/v6/LAQwev4hdCtYkOYX4Oc7nPesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"300\";s:107:\"http://themes.googleusercontent.com/static/fonts/raleway/v6/2VvSZU2kb4DZwFfRM4fLQPesZW2xOQ-xsNqO47m55DA.ttf\";s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/raleway/v6/_dCzxpXzIS3sL-gdJWAP8A.ttf\";s:3:\"500\";s:107:\"http://themes.googleusercontent.com/static/fonts/raleway/v6/348gn6PEmbLDWlHbbV15d_esZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"600\";s:107:\"http://themes.googleusercontent.com/static/fonts/raleway/v6/M7no6oPkwKYJkedjB1wqEvesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:107:\"http://themes.googleusercontent.com/static/fonts/raleway/v6/VGEV9-DrblisWOWLbK-1XPesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"800\";s:107:\"http://themes.googleusercontent.com/static/fonts/raleway/v6/mMh0JrsYMXcLO69jgJwpUvesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"900\";s:107:\"http://themes.googleusercontent.com/static/fonts/raleway/v6/ajQQGcDBLcyLpaUfD76UuPesZW2xOQ-xsNqO47m55DA.ttf\";}}i:14;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:17:\"Yanone Kaffeesatz\";s:8:\"variants\";a:4:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":4:{s:3:\"200\";s:116:\"http://themes.googleusercontent.com/static/fonts/yanonekaffeesatz/v4/We_iSDqttE3etzfdfhuPRbq92v6XxU4pSv06GI0NsGc.ttf\";s:3:\"300\";s:116:\"http://themes.googleusercontent.com/static/fonts/yanonekaffeesatz/v4/We_iSDqttE3etzfdfhuPRZlIwXPiNoNT_wxzJ2t3mTE.ttf\";s:7:\"regular\";s:116:\"http://themes.googleusercontent.com/static/fonts/yanonekaffeesatz/v4/YDAoLskQQ5MOAgvHUQCcLdXn3cHbFGWU4T2HrSN6JF4.ttf\";s:3:\"700\";s:116:\"http://themes.googleusercontent.com/static/fonts/yanonekaffeesatz/v4/We_iSDqttE3etzfdfhuPRf2R4S6PlKaGXWPfWpHpcl0.ttf\";}}i:15;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Lora\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:83:\"http://themes.googleusercontent.com/static/fonts/lora/v5/aXJ7KVIGcejEy1abawZazg.ttf\";s:6:\"italic\";s:83:\"http://themes.googleusercontent.com/static/fonts/lora/v5/AN2EZaj2tFRpyveuNn9BOg.ttf\";s:3:\"700\";s:83:\"http://themes.googleusercontent.com/static/fonts/lora/v5/enKND5SfzQKkggBA_VnT1A.ttf\";s:9:\"700italic\";s:83:\"http://themes.googleusercontent.com/static/fonts/lora/v5/ivs9j3kYU65pR9QD9YFdzQ.ttf\";}}i:16;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Lobster\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:12:\"cyrillic-ext\";i:1;s:9:\"latin-ext\";i:2;s:8:\"cyrillic\";i:3;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/lobster/v5/9LpJGtNuM1D8FAZ2BkJH2Q.ttf\";}}i:17;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Arvo\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:83:\"http://themes.googleusercontent.com/static/fonts/arvo/v5/vvWPwz-PlZEwjOOIKqoZzA.ttf\";s:6:\"italic\";s:83:\"http://themes.googleusercontent.com/static/fonts/arvo/v5/id5a4BCjbenl5Gkqonw_Rw.ttf\";s:3:\"700\";s:83:\"http://themes.googleusercontent.com/static/fonts/arvo/v5/OB3FDST7U38u3OjPK_vvRQ.ttf\";s:9:\"700italic\";s:83:\"http://themes.googleusercontent.com/static/fonts/arvo/v5/Hvl2MuWoXLaCy2v6MD4Yvw.ttf\";}}i:18;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Montserrat\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-10-03\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/montserrat/v3/Kqy6-utIpx_30Xzecmeo8_esZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:110:\"http://themes.googleusercontent.com/static/fonts/montserrat/v3/IQHow_FEYlDC4Gzy_m8fcgJKKGfqHaYFsRG-T3ceEVo.ttf\";}}i:19;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Bitter\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":3:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/bitter/v4/w_BNdJvVZDRmqy5aSfB2kQ.ttf\";s:6:\"italic\";s:85:\"http://themes.googleusercontent.com/static/fonts/bitter/v4/TC0FZEVzXQIGgzmRfKPZbA.ttf\";s:3:\"700\";s:85:\"http://themes.googleusercontent.com/static/fonts/bitter/v4/4dUtr_4BvHuoRU35suyOAg.ttf\";}}i:20;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Francois One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/francoisone/v6/bYbkq2nU2TSx4SwFbz5sCC3USBnSvpkopQaUR-2r7iU.ttf\";}}i:21;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Arimo\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:7:{i:0;s:12:\"cyrillic-ext\";i:1;s:9:\"latin-ext\";i:2;s:9:\"greek-ext\";i:3;s:8:\"cyrillic\";i:4;s:5:\"greek\";i:5;s:10:\"vietnamese\";i:6;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2013-07-31\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/arimo/v5/Gpeo80g-5ji2CcyXWnzh7g.ttf\";s:6:\"italic\";s:84:\"http://themes.googleusercontent.com/static/fonts/arimo/v5/_OdGbnX2-qQ96C4OjhyuPw.ttf\";s:3:\"700\";s:84:\"http://themes.googleusercontent.com/static/fonts/arimo/v5/ZItXugREyvV9LnbY_gxAmw.ttf\";s:9:\"700italic\";s:105:\"http://themes.googleusercontent.com/static/fonts/arimo/v5/__nOLWqmeXdhfr0g7GaFePesZW2xOQ-xsNqO47m55DA.ttf\";}}i:22;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Noto Sans\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:7:{i:0;s:12:\"cyrillic-ext\";i:1;s:9:\"latin-ext\";i:2;s:9:\"greek-ext\";i:3;s:8:\"cyrillic\";i:4;s:5:\"greek\";i:5;s:10:\"vietnamese\";i:6;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2013-11-21\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/notosans/v1/0Ue9FiUJwVhi4NGfHJS5uA.ttf\";s:6:\"italic\";s:108:\"http://themes.googleusercontent.com/static/fonts/notosans/v1/dLcNKMgJ1H5RVoZFraDz0qCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"700\";s:108:\"http://themes.googleusercontent.com/static/fonts/notosans/v1/PIbvSEyHEdL91QLOQRnZ1y3USBnSvpkopQaUR-2r7iU.ttf\";s:9:\"700italic\";s:108:\"http://themes.googleusercontent.com/static/fonts/notosans/v1/9Z3uUWMRR7crzm1TjRicDne1Pd76Vl7zRpE7NLJQ7XU.ttf\";}}i:23;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Merriweather\";s:8:\"variants\";a:8:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:3:\"900\";i:7;s:9:\"900italic\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2013-05-22\";s:5:\"files\";O:8:\"stdClass\":8:{s:3:\"300\";s:112:\"http://themes.googleusercontent.com/static/fonts/merriweather/v5/ZvcMqxEwPfh2qDWBPxn6nqcQoVhARpoaILP7amxE_8g.ttf\";s:9:\"300italic\";s:112:\"http://themes.googleusercontent.com/static/fonts/merriweather/v5/EYh7Vl4ywhowqULgRdYwICna0FLWfcB-J_SAYmcAXaI.ttf\";s:7:\"regular\";s:112:\"http://themes.googleusercontent.com/static/fonts/merriweather/v5/RFda8w1V0eDZheqfcyQ4EC3USBnSvpkopQaUR-2r7iU.ttf\";s:6:\"italic\";s:112:\"http://themes.googleusercontent.com/static/fonts/merriweather/v5/So5lHxHT37p2SS4-t60SlPMZXuCXbOrAvx5R0IT5Oyo.ttf\";s:3:\"700\";s:112:\"http://themes.googleusercontent.com/static/fonts/merriweather/v5/ZvcMqxEwPfh2qDWBPxn6nkD2ttfZwueP-QU272T9-k4.ttf\";s:9:\"700italic\";s:112:\"http://themes.googleusercontent.com/static/fonts/merriweather/v5/EYh7Vl4ywhowqULgRdYwIPAs9-1nE9qOqhChW0m4nDE.ttf\";s:3:\"900\";s:112:\"http://themes.googleusercontent.com/static/fonts/merriweather/v5/ZvcMqxEwPfh2qDWBPxn6nqObDOjC3UL77puoeHsE3fw.ttf\";s:9:\"900italic\";s:112:\"http://themes.googleusercontent.com/static/fonts/merriweather/v5/EYh7Vl4ywhowqULgRdYwIBd0_s6jQr9r5s5OZYvtzBY.ttf\";}}i:24;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"PT Serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:4:{i:0;s:12:\"cyrillic-ext\";i:1;s:9:\"latin-ext\";i:2;s:8:\"cyrillic\";i:3;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2013-05-29\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/ptserif/v5/sAo427rn3-QL9sWCbMZXhA.ttf\";s:6:\"italic\";s:107:\"http://themes.googleusercontent.com/static/fonts/ptserif/v5/9khWhKzhpkH0OkNnBKS3n_esZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:107:\"http://themes.googleusercontent.com/static/fonts/ptserif/v5/kyZw18tqQ5if-_wpmxxOeKCWcynf_cDxXwCLxiixG1c.ttf\";s:9:\"700italic\";s:107:\"http://themes.googleusercontent.com/static/fonts/ptserif/v5/Foydq9xJp--nfYIx2TBz9QJKKGfqHaYFsRG-T3ceEVo.ttf\";}}i:25;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Rokkitt\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/rokkitt/v5/GMA7Z_ToF8uSvpZAgnp_VQ.ttf\";s:3:\"700\";s:107:\"http://themes.googleusercontent.com/static/fonts/rokkitt/v5/gxlo-sr3rPmvgSixYog_ofesZW2xOQ-xsNqO47m55DA.ttf\";}}i:26;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Cabin\";s:8:\"variants\";a:8:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":8:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/cabin/v4/XeuAFYo2xAPHxZGBbQtHhA.ttf\";s:6:\"italic\";s:84:\"http://themes.googleusercontent.com/static/fonts/cabin/v4/0tJ9k3DI5xC4GBgs1E_Jxw.ttf\";s:3:\"500\";s:84:\"http://themes.googleusercontent.com/static/fonts/cabin/v4/HgsCQ-k3_Z_uQ86aFolNBg.ttf\";s:9:\"500italic\";s:105:\"http://themes.googleusercontent.com/static/fonts/cabin/v4/50sjhrGE0njyO-7mGDhGP_esZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"600\";s:84:\"http://themes.googleusercontent.com/static/fonts/cabin/v4/eUDAvKhBtmTCkeVBsFk34A.ttf\";s:9:\"600italic\";s:105:\"http://themes.googleusercontent.com/static/fonts/cabin/v4/sFQpQDBd3G2om0Nl5dD2CvesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:84:\"http://themes.googleusercontent.com/static/fonts/cabin/v4/4EKhProuY1hq_WCAomq9Dg.ttf\";s:9:\"700italic\";s:105:\"http://themes.googleusercontent.com/static/fonts/cabin/v4/K83QKi8MOKLEqj6bgZ7LrfesZW2xOQ-xsNqO47m55DA.ttf\";}}i:27;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Dosis\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":7:{s:3:\"200\";s:84:\"http://themes.googleusercontent.com/static/fonts/dosis/v1/ztftab0r6hcd7AeurUGrSQ.ttf\";s:3:\"300\";s:84:\"http://themes.googleusercontent.com/static/fonts/dosis/v1/awIB6L0h5mb0plIKorXmuA.ttf\";s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/dosis/v1/rJRlixu-w0JZ1MyhJpao_Q.ttf\";s:3:\"500\";s:84:\"http://themes.googleusercontent.com/static/fonts/dosis/v1/ruEXDOFMxDPGnjCBKRqdAQ.ttf\";s:3:\"600\";s:84:\"http://themes.googleusercontent.com/static/fonts/dosis/v1/KNAswRNwm3tfONddYyidxg.ttf\";s:3:\"700\";s:84:\"http://themes.googleusercontent.com/static/fonts/dosis/v1/AEEAj0ONidK8NQQMBBlSig.ttf\";s:3:\"800\";s:84:\"http://themes.googleusercontent.com/static/fonts/dosis/v1/nlrKd8E69vvUU39XGsvR7Q.ttf\";}}i:28;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Nunito\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":3:{s:3:\"300\";s:85:\"http://themes.googleusercontent.com/static/fonts/nunito/v4/zXQvrWBJqUooM7Xv98MrQw.ttf\";s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/nunito/v4/ySZTeT3IuzJj0GK6uGpbBg.ttf\";s:3:\"700\";s:85:\"http://themes.googleusercontent.com/static/fonts/nunito/v4/aEdlqgMuYbpe4U3TnqOQMA.ttf\";}}i:29;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Titillium Web\";s:8:\"variants\";a:11:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:7:\"regular\";i:5;s:6:\"italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"900\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-10-03\";s:5:\"files\";O:8:\"stdClass\":11:{s:3:\"200\";s:112:\"http://themes.googleusercontent.com/static/fonts/titilliumweb/v1/anMUvcNT0H1YN4FII8wprzOdCrLccoxq42eaxM802O0.ttf\";s:9:\"200italic\";s:112:\"http://themes.googleusercontent.com/static/fonts/titilliumweb/v1/RZunN20OBmkvrU7sA4GPPj4N98U-66ThNJvtgddRfBE.ttf\";s:3:\"300\";s:112:\"http://themes.googleusercontent.com/static/fonts/titilliumweb/v1/anMUvcNT0H1YN4FII8wpr9ZAkYT8DuUZELiKLwMGWAo.ttf\";s:9:\"300italic\";s:112:\"http://themes.googleusercontent.com/static/fonts/titilliumweb/v1/RZunN20OBmkvrU7sA4GPPrfzCkqg7ORZlRf2cc4mXu8.ttf\";s:7:\"regular\";s:112:\"http://themes.googleusercontent.com/static/fonts/titilliumweb/v1/7XUFZ5tgS-tD6QamInJTcTyagQBwYgYywpS70xNq8SQ.ttf\";s:6:\"italic\";s:112:\"http://themes.googleusercontent.com/static/fonts/titilliumweb/v1/r9OmwyQxrgzUAhaLET_KO-ixohbIP6lHkU-1Mgq95cY.ttf\";s:3:\"600\";s:112:\"http://themes.googleusercontent.com/static/fonts/titilliumweb/v1/anMUvcNT0H1YN4FII8wpr28K9dEd5Ue-HTQrlA7E2xQ.ttf\";s:9:\"600italic\";s:112:\"http://themes.googleusercontent.com/static/fonts/titilliumweb/v1/RZunN20OBmkvrU7sA4GPPgOhzTSndyK8UWja2yJjKLc.ttf\";s:3:\"700\";s:112:\"http://themes.googleusercontent.com/static/fonts/titilliumweb/v1/anMUvcNT0H1YN4FII8wpr2-6tpSbB9YhmWtmd1_gi_U.ttf\";s:9:\"700italic\";s:112:\"http://themes.googleusercontent.com/static/fonts/titilliumweb/v1/RZunN20OBmkvrU7sA4GPPio3LEw-4MM8Ao2j9wPOfpw.ttf\";s:3:\"900\";s:112:\"http://themes.googleusercontent.com/static/fonts/titilliumweb/v1/anMUvcNT0H1YN4FII8wpr7L0GmZLri-m-nfoo0Vul4Y.ttf\";}}i:30;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Play\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:6:{i:0;s:12:\"cyrillic-ext\";i:1;s:9:\"latin-ext\";i:2;s:9:\"greek-ext\";i:3;s:8:\"cyrillic\";i:4;s:5:\"greek\";i:5;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:83:\"http://themes.googleusercontent.com/static/fonts/play/v3/GWvfObW8LhtsOX333MCpBg.ttf\";s:3:\"700\";s:83:\"http://themes.googleusercontent.com/static/fonts/play/v3/crPhg6I0alLI-MpB3vW-zw.ttf\";}}i:31;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:17:\"Libre Baskerville\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-12-06\";s:5:\"files\";O:8:\"stdClass\":3:{s:7:\"regular\";s:116:\"http://themes.googleusercontent.com/static/fonts/librebaskerville/v1/pR0sBQVcY0JZc_ciXjFsKyyZRYCSvpCzQKuMWnP5NDY.ttf\";s:6:\"italic\";s:116:\"http://themes.googleusercontent.com/static/fonts/librebaskerville/v1/QHIOz1iKF3bIEzRdDFaf5QnhapNS5Oi8FPrBRDLbsW4.ttf\";s:3:\"700\";s:116:\"http://themes.googleusercontent.com/static/fonts/librebaskerville/v1/kH7K4InNTm7mmOXXjrA5v-xuswJKUVpBRfYFpz0W3Iw.ttf\";}}i:32;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Abel\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:83:\"http://themes.googleusercontent.com/static/fonts/abel/v3/RpUKfqNxoyNe_ka23bzQ2A.ttf\";}}i:33;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Cuprum\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:3:{i:0;s:9:\"latin-ext\";i:1;s:8:\"cyrillic\";i:2;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-08-02\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/cuprum/v4/JgXs0F_UiaEdAS74msmFNg.ttf\";s:6:\"italic\";s:85:\"http://themes.googleusercontent.com/static/fonts/cuprum/v4/cLEz0KV6OxInnktSzpk58g.ttf\";s:3:\"700\";s:85:\"http://themes.googleusercontent.com/static/fonts/cuprum/v4/6tl3_FkDeXSD72oEHuJh4w.ttf\";s:9:\"700italic\";s:106:\"http://themes.googleusercontent.com/static/fonts/cuprum/v4/bnkXaBfoYvaJ75axRPSwVKCWcynf_cDxXwCLxiixG1c.ttf\";}}i:34;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Roboto Slab\";s:8:\"variants\";a:4:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"700\";}s:7:\"subsets\";a:7:{i:0;s:12:\"cyrillic-ext\";i:1;s:9:\"latin-ext\";i:2;s:9:\"greek-ext\";i:3;s:8:\"cyrillic\";i:4;s:5:\"greek\";i:5;s:10:\"vietnamese\";i:6;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2013-07-31\";s:5:\"files\";O:8:\"stdClass\":4:{s:3:\"100\";s:110:\"http://themes.googleusercontent.com/static/fonts/robotoslab/v2/MEz38VLIFL-t46JUtkIEgIAWxXGWZ3yJw6KhWS7MxOk.ttf\";s:3:\"300\";s:110:\"http://themes.googleusercontent.com/static/fonts/robotoslab/v2/dazS1PrQQuCxC3iOAJFEJS9-WlPSxbfiI49GsXo3q0g.ttf\";s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/robotoslab/v2/3__ulTNA7unv0UtplybPiqCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"700\";s:110:\"http://themes.googleusercontent.com/static/fonts/robotoslab/v2/dazS1PrQQuCxC3iOAJFEJXe1Pd76Vl7zRpE7NLJQ7XU.ttf\";}}i:35;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Ubuntu Condensed\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:6:{i:0;s:12:\"cyrillic-ext\";i:1;s:9:\"latin-ext\";i:2;s:9:\"greek-ext\";i:3;s:8:\"cyrillic\";i:4;s:5:\"greek\";i:5;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:115:\"http://themes.googleusercontent.com/static/fonts/ubuntucondensed/v3/DBCt-NXN57MTAFjitYxdrKDbm6fPDOZJsR8PmdG62gY.ttf\";}}i:36;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Fjalla One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2013-11-21\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/fjallaone/v1/3b7vWCfOZsU53vMa8LWsf_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:37;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:18:\"Shadows Into Light\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:116:\"http://themes.googleusercontent.com/static/fonts/shadowsintolight/v3/clhLqOv7MXn459PTh0gXYAW_5bEze-iLRNvGrRpJsfM.ttf\";}}i:38;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Anton\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/anton/v3/XIbCenm-W0IRHWYIh7CGUQ.ttf\";}}i:39;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Maven Pro\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"700\";i:3;s:3:\"900\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/mavenpro/v4/sqPJIFG4gqsjl-0q_46Gbw.ttf\";s:3:\"500\";s:108:\"http://themes.googleusercontent.com/static/fonts/mavenpro/v4/SQVfzoJBbj9t3aVcmbspRi3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"700\";s:108:\"http://themes.googleusercontent.com/static/fonts/mavenpro/v4/uDssvmXgp7Nj3i336k_dSi3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"900\";s:108:\"http://themes.googleusercontent.com/static/fonts/mavenpro/v4/-91TwiFzqeL1F7Kh91APwS3USBnSvpkopQaUR-2r7iU.ttf\";}}i:40;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Electrolize\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/electrolize/v2/yFVu5iokC-nt4B1Cyfxb9aCWcynf_cDxXwCLxiixG1c.ttf\";}}i:41;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Signika\";s:8:\"variants\";a:4:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"600\";i:3;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":4:{s:3:\"300\";s:107:\"http://themes.googleusercontent.com/static/fonts/signika/v3/0wDPonOzsYeEo-1KO78w4fesZW2xOQ-xsNqO47m55DA.ttf\";s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/signika/v3/WvDswbww0oAtvBg2l1L-9w.ttf\";s:3:\"600\";s:107:\"http://themes.googleusercontent.com/static/fonts/signika/v3/lQMOF6NUN2ooR7WvB7tADvesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:107:\"http://themes.googleusercontent.com/static/fonts/signika/v3/lEcnfPBICWJPv5BbVNnFJPesZW2xOQ-xsNqO47m55DA.ttf\";}}i:42;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:17:\"Merriweather Sans\";s:8:\"variants\";a:8:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:3:\"800\";i:7;s:9:\"800italic\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2013-06-12\";s:5:\"files\";O:8:\"stdClass\":8:{s:3:\"300\";s:116:\"http://themes.googleusercontent.com/static/fonts/merriweathersans/v2/6LmGj5dOJopQKEkt88Gowan5N8K-_DP0e9e_v51obXQ.ttf\";s:9:\"300italic\";s:116:\"http://themes.googleusercontent.com/static/fonts/merriweathersans/v2/nAqt4hiqwq3tzCecpgPmVdytE4nGXk2hYD5nJ740tBw.ttf\";s:7:\"regular\";s:116:\"http://themes.googleusercontent.com/static/fonts/merriweathersans/v2/AKu1CjQ4qnV8MUltkAX3sOAj_ty82iuwwDTNEYXGiyQ.ttf\";s:6:\"italic\";s:116:\"http://themes.googleusercontent.com/static/fonts/merriweathersans/v2/3Mz4hOHzs2npRMG3B1ascZ32VBCoA_HLsn85tSWZmdo.ttf\";s:3:\"700\";s:116:\"http://themes.googleusercontent.com/static/fonts/merriweathersans/v2/6LmGj5dOJopQKEkt88GowbqxG25nQNOioCZSK4sU-CA.ttf\";s:9:\"700italic\";s:116:\"http://themes.googleusercontent.com/static/fonts/merriweathersans/v2/nAqt4hiqwq3tzCecpgPmVbuqAJxizi8Dk_SK5et7kMg.ttf\";s:3:\"800\";s:116:\"http://themes.googleusercontent.com/static/fonts/merriweathersans/v2/6LmGj5dOJopQKEkt88GowYufzO2zUYSj5LqoJ3UGkco.ttf\";s:9:\"800italic\";s:116:\"http://themes.googleusercontent.com/static/fonts/merriweathersans/v2/nAqt4hiqwq3tzCecpgPmVdDmPrYMy3aZO4LmnZsxTQw.ttf\";}}i:43;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Inconsolata\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2012-09-26\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/inconsolata/v6/7bMKuoy6Nh0ft0SHnIGMuaCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"700\";s:111:\"http://themes.googleusercontent.com/static/fonts/inconsolata/v6/AIed271kqQlcIRSOnQH0yXe1Pd76Vl7zRpE7NLJQ7XU.ttf\";}}i:44;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Vollkorn\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/vollkorn/v3/IiexqYAeh8uII223thYx3w.ttf\";s:6:\"italic\";s:108:\"http://themes.googleusercontent.com/static/fonts/vollkorn/v3/UuIzosgR1ovBhJFdwVp3fvesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:108:\"http://themes.googleusercontent.com/static/fonts/vollkorn/v3/gOwQjJVGXlDOONC12hVoBqCWcynf_cDxXwCLxiixG1c.ttf\";s:9:\"700italic\";s:108:\"http://themes.googleusercontent.com/static/fonts/vollkorn/v3/KNiAlx6phRqXCwnZZG51JAJKKGfqHaYFsRG-T3ceEVo.ttf\";}}i:45;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Josefin Sans\";s:8:\"variants\";a:10:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:7:\"regular\";i:5;s:6:\"italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":10:{s:3:\"100\";s:111:\"http://themes.googleusercontent.com/static/fonts/josefinsans/v3/q9w3H4aeBxj0hZ8Osfi3d8SVQ0giZ-l_NELu3lgGyYw.ttf\";s:9:\"100italic\";s:111:\"http://themes.googleusercontent.com/static/fonts/josefinsans/v3/s7-P1gqRNRNn-YWdOYnAOXXcj1rQwlNLIS625o-SrL0.ttf\";s:3:\"300\";s:111:\"http://themes.googleusercontent.com/static/fonts/josefinsans/v3/C6HYlRF50SGJq1XyXj04z6cQoVhARpoaILP7amxE_8g.ttf\";s:9:\"300italic\";s:111:\"http://themes.googleusercontent.com/static/fonts/josefinsans/v3/ppse0J9fKSaoxCIIJb33Gyna0FLWfcB-J_SAYmcAXaI.ttf\";s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/josefinsans/v3/xgzbb53t8j-Mo-vYa23n5i3USBnSvpkopQaUR-2r7iU.ttf\";s:6:\"italic\";s:111:\"http://themes.googleusercontent.com/static/fonts/josefinsans/v3/q9w3H4aeBxj0hZ8Osfi3d_MZXuCXbOrAvx5R0IT5Oyo.ttf\";s:3:\"600\";s:111:\"http://themes.googleusercontent.com/static/fonts/josefinsans/v3/C6HYlRF50SGJq1XyXj04z2v8CylhIUtwUiYO7Z2wXbE.ttf\";s:9:\"600italic\";s:111:\"http://themes.googleusercontent.com/static/fonts/josefinsans/v3/ppse0J9fKSaoxCIIJb33G4R-5-urNOGAobhAyctHvW8.ttf\";s:3:\"700\";s:111:\"http://themes.googleusercontent.com/static/fonts/josefinsans/v3/C6HYlRF50SGJq1XyXj04z0D2ttfZwueP-QU272T9-k4.ttf\";s:9:\"700italic\";s:111:\"http://themes.googleusercontent.com/static/fonts/josefinsans/v3/ppse0J9fKSaoxCIIJb33G_As9-1nE9qOqhChW0m4nDE.ttf\";}}i:46;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Archivo Narrow\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-12-17\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:113:\"http://themes.googleusercontent.com/static/fonts/archivonarrow/v2/DsLzC9scoPnrGiwYYMQXppTvAuddT2xDMbdz0mdLyZY.ttf\";s:6:\"italic\";s:113:\"http://themes.googleusercontent.com/static/fonts/archivonarrow/v2/vqsrtPCpTU3tJlKfuXP5zUpmlyBQEFfdE6dERLXdQGQ.ttf\";s:3:\"700\";s:113:\"http://themes.googleusercontent.com/static/fonts/archivonarrow/v2/M__Wu4PAmHf4YZvQM8tWsMLtdzs3iyjn_YuT226ZsLU.ttf\";s:9:\"700italic\";s:113:\"http://themes.googleusercontent.com/static/fonts/archivonarrow/v2/wG6O733y5zHl4EKCOh8rSTg5KB8MNJ4uPAETq9naQO8.ttf\";}}i:47;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Crafty Girls\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/craftygirls/v2/0Sv8UWFFdhQmesHL32H8oy3USBnSvpkopQaUR-2r7iU.ttf\";}}i:48;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Asap\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:83:\"http://themes.googleusercontent.com/static/fonts/asap/v1/2lf-1MDR8tsTpEtvJmr2hA.ttf\";s:6:\"italic\";s:83:\"http://themes.googleusercontent.com/static/fonts/asap/v1/mwxNHf8QS8gNWCAMwkJNIg.ttf\";s:3:\"700\";s:83:\"http://themes.googleusercontent.com/static/fonts/asap/v1/o5RUA7SsJ80M8oDFBnrDbg.ttf\";s:9:\"700italic\";s:83:\"http://themes.googleusercontent.com/static/fonts/asap/v1/_rZz9y2oXc09jT5T6BexLQ.ttf\";}}i:49;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Questrial\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/questrial/v3/MoHHaw_WwNs_hd9ob1zTVw.ttf\";}}i:50;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Armata\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-08-23\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/armata/v3/1H8FwGgIRrbYtxSfXhOHlQ.ttf\";}}i:51;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Alegreya\";s:8:\"variants\";a:6:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:3:\"900\";i:5;s:9:\"900italic\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-08-08\";s:5:\"files\";O:8:\"stdClass\":6:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/alegreya/v4/62J3atXd6bvMU4qO_ca-eA.ttf\";s:6:\"italic\";s:108:\"http://themes.googleusercontent.com/static/fonts/alegreya/v4/cbshnQGxwmlHBjUil7DaIfesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:108:\"http://themes.googleusercontent.com/static/fonts/alegreya/v4/5oZtdI5-wQwgAFrd9erCsaCWcynf_cDxXwCLxiixG1c.ttf\";s:9:\"700italic\";s:108:\"http://themes.googleusercontent.com/static/fonts/alegreya/v4/IWi8e5bpnqhMRsZKTcTUWgJKKGfqHaYFsRG-T3ceEVo.ttf\";s:3:\"900\";s:108:\"http://themes.googleusercontent.com/static/fonts/alegreya/v4/oQeMxX-vxGImzDgX6nxA7KCWcynf_cDxXwCLxiixG1c.ttf\";s:9:\"900italic\";s:108:\"http://themes.googleusercontent.com/static/fonts/alegreya/v4/-L71QLH_XqgYWaI1GbOVhp0EAVxt0G0biEntp43Qt6E.ttf\";}}i:52;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Playfair Display\";s:8:\"variants\";a:6:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:3:\"900\";i:5;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:9:\"latin-ext\";i:1;s:8:\"cyrillic\";i:2;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2012-11-28\";s:5:\"files\";O:8:\"stdClass\":6:{s:7:\"regular\";s:115:\"http://themes.googleusercontent.com/static/fonts/playfairdisplay/v7/2NBgzUtEeyB-Xtpr9bm1CV6uyC_qD11hrFQ6EGgTJWI.ttf\";s:6:\"italic\";s:115:\"http://themes.googleusercontent.com/static/fonts/playfairdisplay/v7/9MkijrV-dEJ0-_NWV7E6NzMsbnvDNEBX25F5HWk9AhI.ttf\";s:3:\"700\";s:115:\"http://themes.googleusercontent.com/static/fonts/playfairdisplay/v7/UC3ZEjagJi85gF9qFaBgICsv6SrURqJprbhH_C1Mw8w.ttf\";s:9:\"700italic\";s:115:\"http://themes.googleusercontent.com/static/fonts/playfairdisplay/v7/n7G4PqJvFP2Kubl0VBLDECsYW3XoOVcYyYdp9NzzS9E.ttf\";s:3:\"900\";s:115:\"http://themes.googleusercontent.com/static/fonts/playfairdisplay/v7/UC3ZEjagJi85gF9qFaBgIKqwMe2wjvZrAR44M0BJZ48.ttf\";s:9:\"900italic\";s:115:\"http://themes.googleusercontent.com/static/fonts/playfairdisplay/v7/n7G4PqJvFP2Kubl0VBLDEC0JfJ4xmm7j1kL6D7mPxrA.ttf\";}}i:53;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Istok Web\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:4:{i:0;s:12:\"cyrillic-ext\";i:1;s:9:\"latin-ext\";i:2;s:8:\"cyrillic\";i:3;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/istokweb/v5/RYLSjEXQ0nNtLLc4n7--dQ.ttf\";s:6:\"italic\";s:108:\"http://themes.googleusercontent.com/static/fonts/istokweb/v5/kvcT2SlTjmGbC3YlZxmrl6CWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"700\";s:108:\"http://themes.googleusercontent.com/static/fonts/istokweb/v5/2koEo4AKFSvK4B52O_Mwai3USBnSvpkopQaUR-2r7iU.ttf\";s:9:\"700italic\";s:108:\"http://themes.googleusercontent.com/static/fonts/istokweb/v5/ycQ3g52ELrh3o_HYCNNUw3e1Pd76Vl7zRpE7NLJQ7XU.ttf\";}}i:54;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Pacifico\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/pacifico/v4/GIrpeRY1r5CzbfL8r182lw.ttf\";}}i:55;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Dancing Script\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:113:\"http://themes.googleusercontent.com/static/fonts/dancingscript/v3/DK0eTGXiZjN6yA8zAEyM2RnpV0hQCek3EmWnCPrvGRM.ttf\";s:3:\"700\";s:113:\"http://themes.googleusercontent.com/static/fonts/dancingscript/v3/KGBfwabt0ZRLA5W1ywjowb_dAmXiKjTPGCuO6G2MbfA.ttf\";}}i:56;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Muli\";s:8:\"variants\";a:4:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":4:{s:3:\"300\";s:83:\"http://themes.googleusercontent.com/static/fonts/muli/v4/VJw4F3ZHRAZ7Hmg3nQu5YQ.ttf\";s:9:\"300italic\";s:83:\"http://themes.googleusercontent.com/static/fonts/muli/v4/s-NKMCru8HiyjEt0ZDoBoA.ttf\";s:7:\"regular\";s:83:\"http://themes.googleusercontent.com/static/fonts/muli/v4/KJiP6KznxbALQgfJcDdPAw.ttf\";s:6:\"italic\";s:83:\"http://themes.googleusercontent.com/static/fonts/muli/v4/Cg0K_IWANs9xkNoxV7H1_w.ttf\";}}i:57;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Coming Soon\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/comingsoon/v3/Yz2z3IAe2HSQAOWsSG8COKCWcynf_cDxXwCLxiixG1c.ttf\";}}i:58;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"PT Sans Caption\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:4:{i:0;s:12:\"cyrillic-ext\";i:1;s:9:\"latin-ext\";i:2;s:8:\"cyrillic\";i:3;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2013-05-29\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:113:\"http://themes.googleusercontent.com/static/fonts/ptsanscaption/v6/OXYTDOzBcXU8MTNBvBHeSW8by34Z3mUMtM-o4y-SHCY.ttf\";s:3:\"700\";s:113:\"http://themes.googleusercontent.com/static/fonts/ptsanscaption/v6/Q-gJrFokeE7JydPpxASt25tc0eyfI4QDEsobEEpk_hA.ttf\";}}i:59;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:3:\"Exo\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:7:\"regular\";i:7;s:6:\"italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";i:14;s:3:\"800\";i:15;s:9:\"800italic\";i:16;s:3:\"900\";i:17;s:9:\"900italic\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":18:{s:3:\"100\";s:82:\"http://themes.googleusercontent.com/static/fonts/exo/v1/RI7A9uwjRmPbVp0n8e-Jvg.ttf\";s:9:\"100italic\";s:82:\"http://themes.googleusercontent.com/static/fonts/exo/v1/qtGyZZlWb2EEvby3ZPosxw.ttf\";s:3:\"200\";s:82:\"http://themes.googleusercontent.com/static/fonts/exo/v1/F8OfC_swrRRxpFt-tlXZQg.ttf\";s:9:\"200italic\";s:82:\"http://themes.googleusercontent.com/static/fonts/exo/v1/fr4HBfXHYiIngW2_bhlgRw.ttf\";s:3:\"300\";s:82:\"http://themes.googleusercontent.com/static/fonts/exo/v1/SBrN7TKUqgGUvfxqHqsnNw.ttf\";s:9:\"300italic\";s:82:\"http://themes.googleusercontent.com/static/fonts/exo/v1/3gmiLjBegIfcDLISjTGA1g.ttf\";s:7:\"regular\";s:82:\"http://themes.googleusercontent.com/static/fonts/exo/v1/eUEzTFueNXRVhbt4PEB8kQ.ttf\";s:6:\"italic\";s:82:\"http://themes.googleusercontent.com/static/fonts/exo/v1/cfgolWisMSURhpQeVHl_NA.ttf\";s:3:\"500\";s:82:\"http://themes.googleusercontent.com/static/fonts/exo/v1/jCg6DmGGXt_OVyp5ofQHPw.ttf\";s:9:\"500italic\";s:82:\"http://themes.googleusercontent.com/static/fonts/exo/v1/lo5eTdCNJZQVN08p8RnzAQ.ttf\";s:3:\"600\";s:82:\"http://themes.googleusercontent.com/static/fonts/exo/v1/q_SG5kXUmOcIvFpgtdZnlw.ttf\";s:9:\"600italic\";s:82:\"http://themes.googleusercontent.com/static/fonts/exo/v1/0cExa8K_pxS2lTuMr68XUA.ttf\";s:3:\"700\";s:82:\"http://themes.googleusercontent.com/static/fonts/exo/v1/3_jwsL4v9uHjl5Q37G57mw.ttf\";s:9:\"700italic\";s:82:\"http://themes.googleusercontent.com/static/fonts/exo/v1/0me55yJIxd5vyQ9bF7SsiA.ttf\";s:3:\"800\";s:82:\"http://themes.googleusercontent.com/static/fonts/exo/v1/yLPuxBuV0lzqibRJyooOJg.ttf\";s:9:\"800italic\";s:82:\"http://themes.googleusercontent.com/static/fonts/exo/v1/n3LejeKVj_8gtZq5fIgNYw.ttf\";s:3:\"900\";s:82:\"http://themes.googleusercontent.com/static/fonts/exo/v1/97d0nd6Yv4-SA_X92xAuZA.ttf\";s:9:\"900italic\";s:82:\"http://themes.googleusercontent.com/static/fonts/exo/v1/JHTkQVhzyLtkY13Ye95TJQ.ttf\";}}i:60;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Indie Flower\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/indieflower/v4/10JVD_humAd5zP2yrFqw6i3USBnSvpkopQaUR-2r7iU.ttf\";}}i:61;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Quicksand\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":3:{s:3:\"300\";s:109:\"http://themes.googleusercontent.com/static/fonts/quicksand/v2/qhfoJiLu10kFjChCCTvGlC3USBnSvpkopQaUR-2r7iU.ttf\";s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/quicksand/v2/Ngv3fIJjKB7sD-bTUGIFCA.ttf\";s:3:\"700\";s:109:\"http://themes.googleusercontent.com/static/fonts/quicksand/v2/32nyIRHyCu6iqEka_hbKsi3USBnSvpkopQaUR-2r7iU.ttf\";}}i:62;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Changa One\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/changaone/v6/dr4qjce4W3kxFrZRkVD87fesZW2xOQ-xsNqO47m55DA.ttf\";s:6:\"italic\";s:109:\"http://themes.googleusercontent.com/static/fonts/changaone/v6/wJVQlUs1lAZel-WdTo2U9y3USBnSvpkopQaUR-2r7iU.ttf\";}}i:63;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Economica\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/economica/v1/G4rJRujzZbq9Nxngu9l3hg.ttf\";s:6:\"italic\";s:109:\"http://themes.googleusercontent.com/static/fonts/economica/v1/p5O9AVeUqx_n35xQRinNYaCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"700\";s:109:\"http://themes.googleusercontent.com/static/fonts/economica/v1/UK4l2VEpwjv3gdcwbwXE9C3USBnSvpkopQaUR-2r7iU.ttf\";s:9:\"700italic\";s:109:\"http://themes.googleusercontent.com/static/fonts/economica/v1/ac5dlUsedQ03RqGOeay-3Xe1Pd76Vl7zRpE7NLJQ7XU.ttf\";}}i:64;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Kreon\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":3:{s:3:\"300\";s:84:\"http://themes.googleusercontent.com/static/fonts/kreon/v6/HKtJRiq5C2zbq5N1IX32sA.ttf\";s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/kreon/v6/zA_IZt0u0S3cvHJu-n1oEg.ttf\";s:3:\"700\";s:84:\"http://themes.googleusercontent.com/static/fonts/kreon/v6/jh0dSmaPodjxISiblIUTkw.ttf\";}}i:65;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Special Elite\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:112:\"http://themes.googleusercontent.com/static/fonts/specialelite/v3/9-wW4zu3WNoD5Fjka35Jm4jjx0o0jr6fNXxPgYh_a8Q.ttf\";}}i:66;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Cabin Condensed\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:114:\"http://themes.googleusercontent.com/static/fonts/cabincondensed/v4/B0txb0blf2N29WdYPJjMSiQPsWWoiv__AzYJ9Zzn9II.ttf\";s:3:\"500\";s:114:\"http://themes.googleusercontent.com/static/fonts/cabincondensed/v4/Ez4zJbsGr2BgXcNUWBVgEARL_-ABKXdjsJSPT0lc2Bk.ttf\";s:3:\"600\";s:114:\"http://themes.googleusercontent.com/static/fonts/cabincondensed/v4/Ez4zJbsGr2BgXcNUWBVgELS5sSASxc8z4EQTQj7DCAI.ttf\";s:3:\"700\";s:114:\"http://themes.googleusercontent.com/static/fonts/cabincondensed/v4/Ez4zJbsGr2BgXcNUWBVgEMAWgzcA047xWLixhLCofl8.ttf\";}}i:67;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"News Cycle\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v9\";s:12:\"lastModified\";s:10:\"2012-08-16\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/newscycle/v9/xyMAr8VfiUzIOvS1abHJO_esZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:109:\"http://themes.googleusercontent.com/static/fonts/newscycle/v9/G28Ny31cr5orMqEQy6ljtwJKKGfqHaYFsRG-T3ceEVo.ttf\";}}i:68;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Nobile\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/nobile/v4/lC_lPi1ddtN38iXTCRh6ow.ttf\";s:6:\"italic\";s:85:\"http://themes.googleusercontent.com/static/fonts/nobile/v4/vGmrpKzWQQSrb-PR6FWBIA.ttf\";s:3:\"700\";s:85:\"http://themes.googleusercontent.com/static/fonts/nobile/v4/9p6M-Yrg_r_QPmSD1skrOg.ttf\";s:9:\"700italic\";s:106:\"http://themes.googleusercontent.com/static/fonts/nobile/v4/oQ1eYPaXV638N03KvsNvyKCWcynf_cDxXwCLxiixG1c.ttf\";}}i:69;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Squada One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/squadaone/v2/3tzGuaJdD65cZVgfQzN8uvesZW2xOQ-xsNqO47m55DA.ttf\";}}i:70;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Tangerine\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/tangerine/v3/DTPeM3IROhnkz7aYG2a9sA.ttf\";s:3:\"700\";s:109:\"http://themes.googleusercontent.com/static/fonts/tangerine/v3/UkFsr-RwJB_d2l9fIWsx3i3USBnSvpkopQaUR-2r7iU.ttf\";}}i:71;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Philosopher\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/philosopher/v4/oZLTrB9jmJsyV0u_T0TKEaCWcynf_cDxXwCLxiixG1c.ttf\";s:6:\"italic\";s:111:\"http://themes.googleusercontent.com/static/fonts/philosopher/v4/_9Hnc_gz9k7Qq6uKaeHKmUeOrDcLawS7-ssYqLr2Xp4.ttf\";s:3:\"700\";s:111:\"http://themes.googleusercontent.com/static/fonts/philosopher/v4/napvkewXG9Gqby5vwGHICHe1Pd76Vl7zRpE7NLJQ7XU.ttf\";s:9:\"700italic\";s:111:\"http://themes.googleusercontent.com/static/fonts/philosopher/v4/PuKlryTcvTj7-qZWfLCFIM_zJjSACmk0BRPxQqhnNLU.ttf\";}}i:72;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Cantarell\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/cantarell/v3/p5ydP_uWQ5lsFzcP_XVMEw.ttf\";s:6:\"italic\";s:109:\"http://themes.googleusercontent.com/static/fonts/cantarell/v3/DTCLtOSqP-7dgM-V_xKUjqCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"700\";s:109:\"http://themes.googleusercontent.com/static/fonts/cantarell/v3/Yir4ZDsCn4g1kWopdg-ehC3USBnSvpkopQaUR-2r7iU.ttf\";s:9:\"700italic\";s:109:\"http://themes.googleusercontent.com/static/fonts/cantarell/v3/weehrwMeZBXb0QyrWnRwFXe1Pd76Vl7zRpE7NLJQ7XU.ttf\";}}i:73;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Noto Serif\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:7:{i:0;s:12:\"cyrillic-ext\";i:1;s:9:\"latin-ext\";i:2;s:9:\"greek-ext\";i:3;s:8:\"cyrillic\";i:4;s:5:\"greek\";i:5;s:10:\"vietnamese\";i:6;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2013-11-21\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/notoserif/v1/zW6mc7bC1CWw8dH0yxY8JfesZW2xOQ-xsNqO47m55DA.ttf\";s:6:\"italic\";s:109:\"http://themes.googleusercontent.com/static/fonts/notoserif/v1/HQXBIwLHsOJCNEQeX9kNzy3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"700\";s:109:\"http://themes.googleusercontent.com/static/fonts/notoserif/v1/lJAvZoKA5NttpPc9yc6lPQJKKGfqHaYFsRG-T3ceEVo.ttf\";s:9:\"700italic\";s:109:\"http://themes.googleusercontent.com/static/fonts/notoserif/v1/Wreg0Be4tcFGM2t6VWytvED2ttfZwueP-QU272T9-k4.ttf\";}}i:74;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Comfortaa\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"700\";}s:7:\"subsets\";a:5:{i:0;s:12:\"cyrillic-ext\";i:1;s:9:\"latin-ext\";i:2;s:8:\"cyrillic\";i:3;s:5:\"greek\";i:4;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":3:{s:3:\"300\";s:109:\"http://themes.googleusercontent.com/static/fonts/comfortaa/v4/r_tUZNl0G8xCoOmp_JkSCi3USBnSvpkopQaUR-2r7iU.ttf\";s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/comfortaa/v4/lZx6C1VViPgSOhCBUP7hXA.ttf\";s:3:\"700\";s:109:\"http://themes.googleusercontent.com/static/fonts/comfortaa/v4/fND5XPYKrF2tQDwwfWZJIy3USBnSvpkopQaUR-2r7iU.ttf\";}}i:75;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Chewy\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/chewy/v4/hcDN5cvQdIu6Bx4mg_TSyw.ttf\";}}i:76;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Luckiest Guy\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/luckiestguy/v3/5718gH8nDy3hFVihOpkY5C3USBnSvpkopQaUR-2r7iU.ttf\";}}i:77;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Bree Serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/breeserif/v2/5h9crBVIrvZqgf34FHcnEfesZW2xOQ-xsNqO47m55DA.ttf\";}}i:78;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Playball\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/playball/v3/3hOFiQm_EUzycTpcN9uz4w.ttf\";}}i:79;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Gudea\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":3:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/gudea/v1/S-4QqBlkMPiiA3jNeCR5yw.ttf\";s:6:\"italic\";s:84:\"http://themes.googleusercontent.com/static/fonts/gudea/v1/7mNgsGw_vfS-uUgRVXNDSw.ttf\";s:3:\"700\";s:84:\"http://themes.googleusercontent.com/static/fonts/gudea/v1/lsip4aiWhJ9bx172Y9FN_w.ttf\";}}i:80;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Ropa Sans\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-10-03\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/ropasans/v2/Gba7ZzVBuhg6nX_AoSwlkQ.ttf\";s:6:\"italic\";s:108:\"http://themes.googleusercontent.com/static/fonts/ropasans/v2/V1zbhZQscNrh63dy5Jk2nqCWcynf_cDxXwCLxiixG1c.ttf\";}}i:81;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Signika Negative\";s:8:\"variants\";a:4:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"600\";i:3;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":4:{s:3:\"300\";s:115:\"http://themes.googleusercontent.com/static/fonts/signikanegative/v2/q5TOjIw4CenPw6C-TW06FjYFXpUPtCmIEFDvjUnLLaI.ttf\";s:7:\"regular\";s:115:\"http://themes.googleusercontent.com/static/fonts/signikanegative/v2/Z-Q1hzbY8uAo3TpTyPFMXVM1lnCWMnren5_v6047e5A.ttf\";s:3:\"600\";s:115:\"http://themes.googleusercontent.com/static/fonts/signikanegative/v2/q5TOjIw4CenPw6C-TW06FrKLaDJM01OezSVA2R_O3qI.ttf\";s:3:\"700\";s:115:\"http://themes.googleusercontent.com/static/fonts/signikanegative/v2/q5TOjIw4CenPw6C-TW06FpYzPxtVvobH1w3hEppR8WI.ttf\";}}i:82;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Patua One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-08-08\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/patuaone/v3/njZwotTYjswR4qdhsW-kJw.ttf\";}}i:83;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Pontano Sans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/pontanosans/v1/gTHiwyxi6S7iiHpqAoiE3C3USBnSvpkopQaUR-2r7iU.ttf\";}}i:84;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Fredoka One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/fredokaone/v1/QKfwXi-z-KtJAlnO2ethYqCWcynf_cDxXwCLxiixG1c.ttf\";}}i:85;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Marvel\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/marvel/v3/Fg1dO8tWVb-MlyqhsbXEkg.ttf\";s:6:\"italic\";s:85:\"http://themes.googleusercontent.com/static/fonts/marvel/v3/HzyjFB-oR5usrc7Lxz9g8w.ttf\";s:3:\"700\";s:85:\"http://themes.googleusercontent.com/static/fonts/marvel/v3/WrHDBL1RupWGo2UcdgxB3Q.ttf\";s:9:\"700italic\";s:106:\"http://themes.googleusercontent.com/static/fonts/marvel/v3/Gzf5NT09Y6xskdQRj2kz1qCWcynf_cDxXwCLxiixG1c.ttf\";}}i:86;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Varela Round\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/varelaround/v3/APH4jr0uSos5wiut5cpjri3USBnSvpkopQaUR-2r7iU.ttf\";}}i:87;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Monda\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-12-06\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/monda/v1/qFMHZ9zvR6B_gnoIgosPrw.ttf\";s:3:\"700\";s:84:\"http://themes.googleusercontent.com/static/fonts/monda/v1/EVOzZUyc_j1w2GuTgTAW1g.ttf\";}}i:88;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Noticia Text\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:3:{i:0;s:9:\"latin-ext\";i:1;s:10:\"vietnamese\";i:2;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/noticiatext/v3/wdyV6x3eKpdeUPQ7BJ5uUC3USBnSvpkopQaUR-2r7iU.ttf\";s:6:\"italic\";s:111:\"http://themes.googleusercontent.com/static/fonts/noticiatext/v3/dAuxVpkYE_Q_IwIm6elsKPMZXuCXbOrAvx5R0IT5Oyo.ttf\";s:3:\"700\";s:111:\"http://themes.googleusercontent.com/static/fonts/noticiatext/v3/pEko-RqEtp45bE2P80AAKUD2ttfZwueP-QU272T9-k4.ttf\";s:9:\"700italic\";s:111:\"http://themes.googleusercontent.com/static/fonts/noticiatext/v3/-rQ7V8ARjf28_b7kRa0JuvAs9-1nE9qOqhChW0m4nDE.ttf\";}}i:89;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Karla\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-10-03\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/karla/v2/78UgGRwJFkhqaoFimqoKpQ.ttf\";s:6:\"italic\";s:84:\"http://themes.googleusercontent.com/static/fonts/karla/v2/51UBKly9RQOnOkj95ZwEFw.ttf\";s:3:\"700\";s:84:\"http://themes.googleusercontent.com/static/fonts/karla/v2/JS501sZLxZ4zraLQdncOUA.ttf\";s:9:\"700italic\";s:105:\"http://themes.googleusercontent.com/static/fonts/karla/v2/3YDyi09gQjCRh-5-SVhTTvesZW2xOQ-xsNqO47m55DA.ttf\";}}i:90;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Black Ops One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-08-23\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/blackopsone/v4/2XW-DmDsGbDLE372KrMW1Yjjx0o0jr6fNXxPgYh_a8Q.ttf\";}}i:91;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Righteous\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/righteous/v2/0nRRWM_gCGCt2S-BCfN8WQ.ttf\";}}i:92;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Voltaire\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/voltaire/v3/WvqBzaGEBbRV-hrahwO2cA.ttf\";}}i:93;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Permanent Marker\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:115:\"http://themes.googleusercontent.com/static/fonts/permanentmarker/v2/9vYsg5VgPHKK8SXYbf3sMol14xj5tdg9OHF8w4E7StQ.ttf\";}}i:94;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Josefin Slab\";s:8:\"variants\";a:10:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:7:\"regular\";i:5;s:6:\"italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":10:{s:3:\"100\";s:111:\"http://themes.googleusercontent.com/static/fonts/josefinslab/v3/etsUjZYO8lTLU85lDhZwUsSVQ0giZ-l_NELu3lgGyYw.ttf\";s:9:\"100italic\";s:111:\"http://themes.googleusercontent.com/static/fonts/josefinslab/v3/8BjDChqLgBF3RJKfwHIYh3Xcj1rQwlNLIS625o-SrL0.ttf\";s:3:\"300\";s:111:\"http://themes.googleusercontent.com/static/fonts/josefinslab/v3/NbE6ykYuM2IyEwxQxOIi2KcQoVhARpoaILP7amxE_8g.ttf\";s:9:\"300italic\";s:111:\"http://themes.googleusercontent.com/static/fonts/josefinslab/v3/af9sBoKGPbGO0r21xJulyyna0FLWfcB-J_SAYmcAXaI.ttf\";s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/josefinslab/v3/46aYWdgz-1oFX11flmyEfS3USBnSvpkopQaUR-2r7iU.ttf\";s:6:\"italic\";s:111:\"http://themes.googleusercontent.com/static/fonts/josefinslab/v3/etsUjZYO8lTLU85lDhZwUvMZXuCXbOrAvx5R0IT5Oyo.ttf\";s:3:\"600\";s:111:\"http://themes.googleusercontent.com/static/fonts/josefinslab/v3/NbE6ykYuM2IyEwxQxOIi2Gv8CylhIUtwUiYO7Z2wXbE.ttf\";s:9:\"600italic\";s:111:\"http://themes.googleusercontent.com/static/fonts/josefinslab/v3/af9sBoKGPbGO0r21xJuly4R-5-urNOGAobhAyctHvW8.ttf\";s:3:\"700\";s:111:\"http://themes.googleusercontent.com/static/fonts/josefinslab/v3/NbE6ykYuM2IyEwxQxOIi2ED2ttfZwueP-QU272T9-k4.ttf\";s:9:\"700italic\";s:111:\"http://themes.googleusercontent.com/static/fonts/josefinslab/v3/af9sBoKGPbGO0r21xJuly_As9-1nE9qOqhChW0m4nDE.ttf\";}}i:95;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Crimson Text\";s:8:\"variants\";a:6:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":6:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/crimsontext/v3/3IFMwfRa07i-auYR-B-zNS3USBnSvpkopQaUR-2r7iU.ttf\";s:6:\"italic\";s:111:\"http://themes.googleusercontent.com/static/fonts/crimsontext/v3/a5QZnvmn5amyNI-t2BMkWPMZXuCXbOrAvx5R0IT5Oyo.ttf\";s:3:\"600\";s:111:\"http://themes.googleusercontent.com/static/fonts/crimsontext/v3/rEy5tGc5HdXy56Xvd4f3I2v8CylhIUtwUiYO7Z2wXbE.ttf\";s:9:\"600italic\";s:111:\"http://themes.googleusercontent.com/static/fonts/crimsontext/v3/4j4TR-EfnvCt43InYpUNDIR-5-urNOGAobhAyctHvW8.ttf\";s:3:\"700\";s:111:\"http://themes.googleusercontent.com/static/fonts/crimsontext/v3/rEy5tGc5HdXy56Xvd4f3I0D2ttfZwueP-QU272T9-k4.ttf\";s:9:\"700italic\";s:111:\"http://themes.googleusercontent.com/static/fonts/crimsontext/v3/4j4TR-EfnvCt43InYpUNDPAs9-1nE9qOqhChW0m4nDE.ttf\";}}i:96;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Lobster Two\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/lobstertwo/v4/xb9aY4w9ceh8JRzobID1naCWcynf_cDxXwCLxiixG1c.ttf\";s:6:\"italic\";s:110:\"http://themes.googleusercontent.com/static/fonts/lobstertwo/v4/Ul_16MSbfayQv1I4QhLEoEeOrDcLawS7-ssYqLr2Xp4.ttf\";s:3:\"700\";s:110:\"http://themes.googleusercontent.com/static/fonts/lobstertwo/v4/bmdxOflBqMqjEC0-kGsIiHe1Pd76Vl7zRpE7NLJQ7XU.ttf\";s:9:\"700italic\";s:110:\"http://themes.googleusercontent.com/static/fonts/lobstertwo/v4/LEkN2_no_6kFvRfiBZ8xpM_zJjSACmk0BRPxQqhnNLU.ttf\";}}i:97;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Amatic SC\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/amaticsc/v3/MldbRWLFytvqxU1y81xSVg.ttf\";s:3:\"700\";s:108:\"http://themes.googleusercontent.com/static/fonts/amaticsc/v3/IDnkRTPGcrSVo50UyYNK7y3USBnSvpkopQaUR-2r7iU.ttf\";}}i:98;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:17:\"Quattrocento Sans\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:116:\"http://themes.googleusercontent.com/static/fonts/quattrocentosans/v5/efd6FGWWGX5Z3ztwLBrG9eAj_ty82iuwwDTNEYXGiyQ.ttf\";s:6:\"italic\";s:116:\"http://themes.googleusercontent.com/static/fonts/quattrocentosans/v5/8PXYbvM__bjl0rBnKiByg532VBCoA_HLsn85tSWZmdo.ttf\";s:3:\"700\";s:116:\"http://themes.googleusercontent.com/static/fonts/quattrocentosans/v5/tXSgPxDl7Lk8Zr_5qX8FIbqxG25nQNOioCZSK4sU-CA.ttf\";s:9:\"700italic\";s:116:\"http://themes.googleusercontent.com/static/fonts/quattrocentosans/v5/8N1PdXpbG6RtFvTjl-5E7buqAJxizi8Dk_SK5et7kMg.ttf\";}}i:99;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Cantata One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-08-23\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/cantataone/v2/-a5FDvnBqaBMDaGgZYnEfqCWcynf_cDxXwCLxiixG1c.ttf\";}}i:100;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Satisfy\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/satisfy/v3/PRlyepkd-JCGHiN8e9WV2w.ttf\";}}i:101;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Poiret One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:9:\"latin-ext\";i:1;s:8:\"cyrillic\";i:2;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/poiretone/v1/dWcYed048E5gHGDIt8i1CPesZW2xOQ-xsNqO47m55DA.ttf\";}}i:102;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Calligraffitti\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:114:\"http://themes.googleusercontent.com/static/fonts/calligraffitti/v4/vLVN2Y-z65rVu1R7lWdvyDXz_orj3gX0_NzfmYulrko.ttf\";}}i:103;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Crete Round\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/creteround/v2/B8EwN421qqOCCT8vOH4wJ6CWcynf_cDxXwCLxiixG1c.ttf\";s:6:\"italic\";s:110:\"http://themes.googleusercontent.com/static/fonts/creteround/v2/5xAt7XK2vkUdjhGtt98unUeOrDcLawS7-ssYqLr2Xp4.ttf\";}}i:104;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Rock Salt\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/rocksalt/v3/Zy7JF9h9WbhD9V3SFMQ1UQ.ttf\";}}i:105;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Passion One\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:3:\"700\";i:2;s:3:\"900\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":3:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/passionone/v3/1UIK1tg3bKJ4J3o35M4heqCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"700\";s:110:\"http://themes.googleusercontent.com/static/fonts/passionone/v3/feOcYDy2R-f3Ysy72PYJ2ne1Pd76Vl7zRpE7NLJQ7XU.ttf\";s:3:\"900\";s:110:\"http://themes.googleusercontent.com/static/fonts/passionone/v3/feOcYDy2R-f3Ysy72PYJ2ienaqEuufTBk9XMKnKmgDA.ttf\";}}i:106;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Telex\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/telex/v1/24-3xP9ywYeHOcFU3iGk8A.ttf\";}}i:107;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Droid Sans Mono\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:113:\"http://themes.googleusercontent.com/static/fonts/droidsansmono/v4/ns-m2xQYezAtqh7ai59hJcwD6PD0c3_abh9zHKQtbGU.ttf\";}}i:108;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:22:\"Shadows Into Light Two\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:119:\"http://themes.googleusercontent.com/static/fonts/shadowsintolighttwo/v1/gDxHeefcXIo-lOuZFCn2xVQrZk-Pga5KeEE_oZjkQjQ.ttf\";}}i:109;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"EB Garamond\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:5:{i:0;s:12:\"cyrillic-ext\";i:1;s:9:\"latin-ext\";i:2;s:8:\"cyrillic\";i:3;s:10:\"vietnamese\";i:4;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/ebgaramond/v4/CDR0kuiFK7I1OZ2hSdR7G6CWcynf_cDxXwCLxiixG1c.ttf\";}}i:110;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:18:\"Pathway Gothic One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2013-06-12\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:116:\"http://themes.googleusercontent.com/static/fonts/pathwaygothicone/v1/Lqv9ztoTUV8Q0FmQZzPqaA6A6xIYD7vYcYDop1i-K-c.ttf\";}}i:111;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Tinos\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:7:{i:0;s:12:\"cyrillic-ext\";i:1;s:9:\"latin-ext\";i:2;s:9:\"greek-ext\";i:3;s:8:\"cyrillic\";i:4;s:5:\"greek\";i:5;s:10:\"vietnamese\";i:6;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2013-07-31\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/tinos/v5/EqpUbkVmutfwZ0PjpoGwCg.ttf\";s:6:\"italic\";s:84:\"http://themes.googleusercontent.com/static/fonts/tinos/v5/slfyzlasCr9vTsaP4lUh9A.ttf\";s:3:\"700\";s:84:\"http://themes.googleusercontent.com/static/fonts/tinos/v5/vHXfhX8jZuQruowfon93yQ.ttf\";s:9:\"700italic\";s:105:\"http://themes.googleusercontent.com/static/fonts/tinos/v5/M6kfzvDMM0CdxdraoFpG6vesZW2xOQ-xsNqO47m55DA.ttf\";}}i:112;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Old Standard TT\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":3:{s:7:\"regular\";s:113:\"http://themes.googleusercontent.com/static/fonts/oldstandardtt/v4/n6RTCDcIPWSE8UNBa4k-DLcB5jyhm1VsHs65c3QNDr0.ttf\";s:6:\"italic\";s:113:\"http://themes.googleusercontent.com/static/fonts/oldstandardtt/v4/QQT_AUSp4AV4dpJfIN7U5PWrQzeMtsHf8QsWQ2cZg3c.ttf\";s:3:\"700\";s:113:\"http://themes.googleusercontent.com/static/fonts/oldstandardtt/v4/5Ywdce7XEbTSbxs__4X1_HJqbZqK7TdZ58X80Q_Lw8Y.ttf\";}}i:113;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:23:\"Waiting for the Sunrise\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:120:\"http://themes.googleusercontent.com/static/fonts/waitingforthesunrise/v4/eNfH7kLpF1PZWpsetF-ha9TChrNgrDiT3Zy6yGf3FnM.ttf\";}}i:114;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Quattrocento\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:112:\"http://themes.googleusercontent.com/static/fonts/quattrocento/v4/WZDISdyil4HsmirlOdBRFC3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"700\";s:112:\"http://themes.googleusercontent.com/static/fonts/quattrocento/v4/Uvi-cRwyvqFpl9j3oT2mqkD2ttfZwueP-QU272T9-k4.ttf\";}}i:115;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"BenchNine\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-10-03\";s:5:\"files\";O:8:\"stdClass\":3:{s:3:\"300\";s:109:\"http://themes.googleusercontent.com/static/fonts/benchnine/v1/ah9xtUy9wLQ3qnWa2p-piS3USBnSvpkopQaUR-2r7iU.ttf\";s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/benchnine/v1/h3OAlYqU3aOeNkuXgH2Q2w.ttf\";s:3:\"700\";s:109:\"http://themes.googleusercontent.com/static/fonts/benchnine/v1/qZpi6ZVZg3L2RL_xoBLxWS3USBnSvpkopQaUR-2r7iU.ttf\";}}i:116;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Unkempt\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/unkempt/v4/NLLBeNSspr0RGs71R5LHWA.ttf\";s:3:\"700\";s:107:\"http://themes.googleusercontent.com/static/fonts/unkempt/v4/V7H-GCl9bgwGwqFqTTgDHvesZW2xOQ-xsNqO47m55DA.ttf\";}}i:117;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:18:\"Gentium Book Basic\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:116:\"http://themes.googleusercontent.com/static/fonts/gentiumbookbasic/v3/IRFxB2matTxrjZt6a3FUnrWDjKAyldGEr6eEi2MBNeY.ttf\";s:6:\"italic\";s:116:\"http://themes.googleusercontent.com/static/fonts/gentiumbookbasic/v3/qHqW2lwKO8-uTfIkh8FsUfXfjMwrYnmPVsQth2IcAPY.ttf\";s:3:\"700\";s:116:\"http://themes.googleusercontent.com/static/fonts/gentiumbookbasic/v3/T2vUYmWzlqUtgLYdlemGnaWESMHIjnSjm9UUxYtEOko.ttf\";s:9:\"700italic\";s:116:\"http://themes.googleusercontent.com/static/fonts/gentiumbookbasic/v3/632u7TMIoFDWQYUaHFUp5PA2A9KyRZEkn4TZVuhsWRM.ttf\";}}i:118;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Molengo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/molengo/v4/jcjgeGuzv83I55AzOTpXNQ.ttf\";}}i:119;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Handlee\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/handlee/v2/6OfkXkyC0E5NZN80ED8u3A.ttf\";}}i:120;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Marck Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:9:\"latin-ext\";i:1;s:8:\"cyrillic\";i:2;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/marckscript/v4/O_D1NAZVOFOobLbVtW3bci3USBnSvpkopQaUR-2r7iU.ttf\";}}i:121;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:17:\"Cherry Cream Soda\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:115:\"http://themes.googleusercontent.com/static/fonts/cherrycreamsoda/v3/OrD-AUnFcZeeKa6F_c0_WxOiHiuAPYA9ry3O1RG2XIU.ttf\";}}i:122;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Varela\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/varela/v4/ON7qs0cKUUixhhDFXlZUjw.ttf\";}}i:123;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Pinyon Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:112:\"http://themes.googleusercontent.com/static/fonts/pinyonscript/v3/TzghnhfCn7TuE73f-CBQ0CeUSrabuTpOsMEiRLtKwk0.ttf\";}}i:124;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:19:\"Architects Daughter\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:118:\"http://themes.googleusercontent.com/static/fonts/architectsdaughter/v3/RXTgOOQ9AAtaVOHxx0IUBMCy0EhZjHzu-y0e6uLf4Fg.ttf\";}}i:125;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Chivo\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"900\";i:3;s:9:\"900italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/chivo/v4/L88PEuzS9eRfHRZhAPhZyw.ttf\";s:6:\"italic\";s:84:\"http://themes.googleusercontent.com/static/fonts/chivo/v4/Oe3-Q-a2kBzPnhHck_baMg.ttf\";s:3:\"900\";s:84:\"http://themes.googleusercontent.com/static/fonts/chivo/v4/JAdkiWd46QCW4vOsj3dzTA.ttf\";s:9:\"900italic\";s:105:\"http://themes.googleusercontent.com/static/fonts/chivo/v4/LoszYnE86q2wJEOjCigBQ_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:126;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Allerta\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/allerta/v4/s9FOEuiJFTNbMe06ifzV8g.ttf\";}}i:127;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Patrick Hand\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:9:\"latin-ext\";i:1;s:10:\"vietnamese\";i:2;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2013-02-27\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/patrickhand/v7/9BG3JJgt_HlF3NpEUehL0C3USBnSvpkopQaUR-2r7iU.ttf\";}}i:128;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Orbitron\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:3:\"500\";i:2;s:3:\"700\";i:3;s:3:\"900\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/orbitron/v3/DY8swouAZjR3RaUPRf0HDQ.ttf\";s:3:\"500\";s:108:\"http://themes.googleusercontent.com/static/fonts/orbitron/v3/p-y_ffzMdo5JN_7ia0vYEqCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"700\";s:108:\"http://themes.googleusercontent.com/static/fonts/orbitron/v3/PS9_6SLkY1Y6OgPO3APr6qCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"900\";s:108:\"http://themes.googleusercontent.com/static/fonts/orbitron/v3/2I3-8i9hT294TE_pyjy9SaCWcynf_cDxXwCLxiixG1c.ttf\";}}i:129;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Bevan\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-08-08\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/bevan/v4/Rtg3zDsCeQiaJ_Qno22OJA.ttf\";}}i:130;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Amaranth\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/amaranth/v3/7VcBog22JBHsHXHdnnycTA.ttf\";s:6:\"italic\";s:108:\"http://themes.googleusercontent.com/static/fonts/amaranth/v3/UrJlRY9LcVERJSvggsdBqPesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:108:\"http://themes.googleusercontent.com/static/fonts/amaranth/v3/j5OFHqadfxyLnQRxFeox6qCWcynf_cDxXwCLxiixG1c.ttf\";s:9:\"700italic\";s:108:\"http://themes.googleusercontent.com/static/fonts/amaranth/v3/BHyuYFj9nqLFNvOvGh0xTwJKKGfqHaYFsRG-T3ceEVo.ttf\";}}i:131;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Reenie Beanie\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:112:\"http://themes.googleusercontent.com/static/fonts/reeniebeanie/v3/ljpKc6CdXusL1cnGUSamX4jjx0o0jr6fNXxPgYh_a8Q.ttf\";}}i:132;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Archivo Black\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-09-26\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:112:\"http://themes.googleusercontent.com/static/fonts/archivoblack/v1/WoAoVT7K3k7hHfxKbvB6B51XQG8isOYYJhPIYAyrESQ.ttf\";}}i:133;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Doppio One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/doppioone/v1/WHZ3HJQotpk_4aSMNBo_t_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:134;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Jockey One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/jockeyone/v3/cAucnOZLvFo07w2AbufBCfesZW2xOQ-xsNqO47m55DA.ttf\";}}i:135;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Coda\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"800\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:83:\"http://themes.googleusercontent.com/static/fonts/coda/v7/yHDvulhg-P-p2KRgRrnUYw.ttf\";s:3:\"800\";s:83:\"http://themes.googleusercontent.com/static/fonts/coda/v7/6ZIw0sbALY0KTMWllZB3hQ.ttf\";}}i:136;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Actor\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/actor/v3/ugMf40CrRK6Jf6Yz_xNSmQ.ttf\";}}i:137;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:17:\"Gloria Hallelujah\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:116:\"http://themes.googleusercontent.com/static/fonts/gloriahallelujah/v4/CA1k7SlXcY5kvI81M_R28Q3RdPdyebSUyJECJouPsvA.ttf\";}}i:138;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Carme\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/carme/v4/08E0NP1eRBEyFRUadmMfgA.ttf\";}}i:139;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Leckerli One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-08-08\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/leckerlione/v4/S2Y_iLrItTu8kIJTkS7DrC3USBnSvpkopQaUR-2r7iU.ttf\";}}i:140;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Sanchez\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-11-28\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/sanchez/v1/BEL8ao-E2LJ5eHPLB2UAiw.ttf\";s:6:\"italic\";s:86:\"http://themes.googleusercontent.com/static/fonts/sanchez/v1/iSrhkWLexUZzDeNxNEHtzA.ttf\";}}i:141;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Syncopate\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/syncopate/v3/RQVwO52fAH6MI764EcaYtw.ttf\";s:3:\"700\";s:109:\"http://themes.googleusercontent.com/static/fonts/syncopate/v3/S5z8ixiOoC4WJ1im6jAlYC3USBnSvpkopQaUR-2r7iU.ttf\";}}i:142;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Didact Gothic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:6:{i:0;s:12:\"cyrillic-ext\";i:1;s:9:\"latin-ext\";i:2;s:9:\"greek-ext\";i:3;s:8:\"cyrillic\";i:4;s:5:\"greek\";i:5;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:112:\"http://themes.googleusercontent.com/static/fonts/didactgothic/v4/v8_72sD3DYMKyM0dn3LtWotBLojGU5Qdl8-5NL4v70w.ttf\";}}i:143;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Neucha\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/neucha/v4/bijdhB-TzQdtpl0ykhGh4Q.ttf\";}}i:144;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Source Code Pro\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"900\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2013-01-23\";s:5:\"files\";O:8:\"stdClass\":7:{s:3:\"200\";s:113:\"http://themes.googleusercontent.com/static/fonts/sourcecodepro/v3/leqv3v-yTsJNC7nFznSMqaXvKVW_haheDNrHjziJZVk.ttf\";s:3:\"300\";s:113:\"http://themes.googleusercontent.com/static/fonts/sourcecodepro/v3/leqv3v-yTsJNC7nFznSMqVP7R5lD_au4SZC6Ks_vyWs.ttf\";s:7:\"regular\";s:113:\"http://themes.googleusercontent.com/static/fonts/sourcecodepro/v3/mrl8jkM18OlOQN8JLgasD9Rl0pGnog23EMYRrBmUzJQ.ttf\";s:3:\"500\";s:113:\"http://themes.googleusercontent.com/static/fonts/sourcecodepro/v3/leqv3v-yTsJNC7nFznSMqX63uKwMO11Of4rJWV582wg.ttf\";s:3:\"600\";s:113:\"http://themes.googleusercontent.com/static/fonts/sourcecodepro/v3/leqv3v-yTsJNC7nFznSMqeiMeWyi5E_-XkTgB5psiDg.ttf\";s:3:\"700\";s:113:\"http://themes.googleusercontent.com/static/fonts/sourcecodepro/v3/leqv3v-yTsJNC7nFznSMqfgXsetDviZcdR5OzC1KPcw.ttf\";s:3:\"900\";s:113:\"http://themes.googleusercontent.com/static/fonts/sourcecodepro/v3/leqv3v-yTsJNC7nFznSMqRA_awHl7mXRjE_LQVochcU.ttf\";}}i:145;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Kameron\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/kameron/v4/9r8HYhqDSwcq9WMjupL82A.ttf\";s:3:\"700\";s:107:\"http://themes.googleusercontent.com/static/fonts/kameron/v4/rabVVbzlflqvmXJUFlKnu_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:146;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Lusitana\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/lusitana/v1/l1h9VDomkwbdzbPdmLcUIw.ttf\";s:3:\"700\";s:108:\"http://themes.googleusercontent.com/static/fonts/lusitana/v1/GWtZyUsONxgkdl3Mc1P7FKCWcynf_cDxXwCLxiixG1c.ttf\";}}i:147;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Share\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-10-31\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/share/v1/1ytD7zSb_-g9I2GG67vmVw.ttf\";s:6:\"italic\";s:84:\"http://themes.googleusercontent.com/static/fonts/share/v1/a9YGdQWFRlNJ0zClJVaY3Q.ttf\";s:3:\"700\";s:84:\"http://themes.googleusercontent.com/static/fonts/share/v1/XrU8e7a1YKurguyY2azk1Q.ttf\";s:9:\"700italic\";s:105:\"http://themes.googleusercontent.com/static/fonts/share/v1/A992-bLVYwAflKu6iaznufesZW2xOQ-xsNqO47m55DA.ttf\";}}i:148;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Copse\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/copse/v3/wikLrtPGjZDvZ5w2i5HLWg.ttf\";}}i:149;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:21:\"Covered By Your Grace\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:118:\"http://themes.googleusercontent.com/static/fonts/coveredbyyourgrace/v3/6ozZp4BPlrbDRWPe3EBGA6CVUMdvnk-GcAiZQrX9Gek.ttf\";}}i:150;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Trocchi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/trocchi/v1/uldNPaKrUGVeGCVsmacLwA.ttf\";}}i:151;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Walter Turncoat\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:114:\"http://themes.googleusercontent.com/static/fonts/walterturncoat/v3/sG9su5g4GXy1KP73cU3hvQplL2YwNeota48DxFlGDUo.ttf\";}}i:152;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Cardo\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";}s:7:\"subsets\";a:4:{i:0;s:9:\"latin-ext\";i:1;s:9:\"greek-ext\";i:2;s:5:\"greek\";i:3;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":3:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/cardo/v5/jbkF2_R0FKUEZTq5dwSknQ.ttf\";s:6:\"italic\";s:84:\"http://themes.googleusercontent.com/static/fonts/cardo/v5/pcv4Np9tUkq0YREYUcEEJQ.ttf\";s:3:\"700\";s:84:\"http://themes.googleusercontent.com/static/fonts/cardo/v5/lQN30weILimrKvp8rZhF1w.ttf\";}}i:153;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:21:\"Goudy Bookletter 1911\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:119:\"http://themes.googleusercontent.com/static/fonts/goudybookletter1911/v3/l5lwlGTN3pEY5Bf-rQEuIIjNDsyURsIKu4GSfvSE4mA.ttf\";}}i:154;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Paytone One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/paytoneone/v5/3WCxC7JAJjQHQVoIE0ZwvqCWcynf_cDxXwCLxiixG1c.ttf\";}}i:155;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Antic Slab\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/anticslab/v1/PSbJCTKkAS7skPdkd7AKEvesZW2xOQ-xsNqO47m55DA.ttf\";}}i:156;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:20:\"Nothing You Could Do\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:117:\"http://themes.googleusercontent.com/static/fonts/nothingyoucoulddo/v3/jpk1K3jbJoyoK0XKaSyQAf-TpkXjXYGWiJZAEtBRjPU.ttf\";}}i:157;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Rancho\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/rancho/v3/ekp3-4QykC4--6KaslRgHA.ttf\";}}i:158;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:23:\"Just Me Again Down Here\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2013-05-22\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:119:\"http://themes.googleusercontent.com/static/fonts/justmeagaindownhere/v5/sN06iTc9ITubLTgXoG-kc3M9eVLpVTSK6TqZTIgBrWQ.ttf\";}}i:159;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Oleo Script\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-11-28\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/oleoscript/v2/21stZcmPyzbQVXtmGegyqKCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"700\";s:110:\"http://themes.googleusercontent.com/static/fonts/oleoscript/v2/hudNQFKFl98JdNnlo363fne1Pd76Vl7zRpE7NLJQ7XU.ttf\";}}i:160;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"PT Serif Caption\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:4:{i:0;s:12:\"cyrillic-ext\";i:1;s:9:\"latin-ext\";i:2;s:8:\"cyrillic\";i:3;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2013-05-29\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:114:\"http://themes.googleusercontent.com/static/fonts/ptserifcaption/v5/7xkFOeTxxO1GMC1suOUYWVsRioCqs5fohhaYel24W3k.ttf\";s:6:\"italic\";s:114:\"http://themes.googleusercontent.com/static/fonts/ptserifcaption/v5/0kfPsmrmTSgiec7u_Wa0DB1mqvzPHelJwRcF_s_EUM0.ttf\";}}i:161;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Kotta One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/kottaone/v1/AB2Q7hVw6niJYDgLvFXu5w.ttf\";}}i:162;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:17:\"Loved by the King\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:114:\"http://themes.googleusercontent.com/static/fonts/lovedbytheking/v3/wg03xD4cWigj4YDufLBSr8io2AFEwwMpu7y5KyiyAJc.ttf\";}}i:163;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Nixie One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-08-01\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/nixieone/v4/h6kQfmzm0Shdnp3eswRaqQ.ttf\";}}i:164;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Happy Monkey\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-09-14\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/happymonkey/v2/c2o0ps8nkBmaOYctqBq1rS3USBnSvpkopQaUR-2r7iU.ttf\";}}i:165;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Schoolbell\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/schoolbell/v3/95-3djEuubb3cJx-6E7j4vesZW2xOQ-xsNqO47m55DA.ttf\";}}i:166;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Overlock\";s:8:\"variants\";a:6:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:3:\"900\";i:5;s:9:\"900italic\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":6:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/overlock/v2/Z8oYsGi88-E1cUB8YBFMAg.ttf\";s:6:\"italic\";s:108:\"http://themes.googleusercontent.com/static/fonts/overlock/v2/rq6EacukHROOBrFrK_zF6_esZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:108:\"http://themes.googleusercontent.com/static/fonts/overlock/v2/Fexr8SqXM8Bm_gEVUA7AKaCWcynf_cDxXwCLxiixG1c.ttf\";s:9:\"700italic\";s:108:\"http://themes.googleusercontent.com/static/fonts/overlock/v2/wFWnYgeXKYBks6gEUwYnfAJKKGfqHaYFsRG-T3ceEVo.ttf\";s:3:\"900\";s:108:\"http://themes.googleusercontent.com/static/fonts/overlock/v2/YPJCVTT8ZbG3899l_-KIGqCWcynf_cDxXwCLxiixG1c.ttf\";s:9:\"900italic\";s:108:\"http://themes.googleusercontent.com/static/fonts/overlock/v2/iOZhxT2zlg7W5ij_lb-oDp0EAVxt0G0biEntp43Qt6E.ttf\";}}i:167;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:17:\"Just Another Hand\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:115:\"http://themes.googleusercontent.com/static/fonts/justanotherhand/v4/fKV8XYuRNNagXr38eqbRf99BnJIEGrvoojniP57E51c.ttf\";}}i:168;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Enriqueta\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/enriqueta/v2/_p90TrIwR1SC-vDKtmrv6A.ttf\";s:3:\"700\";s:109:\"http://themes.googleusercontent.com/static/fonts/enriqueta/v2/I27Pb-wEGH2ajLYP0QrtSC3USBnSvpkopQaUR-2r7iU.ttf\";}}i:169;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Sorts Mill Goudy\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:114:\"http://themes.googleusercontent.com/static/fonts/sortsmillgoudy/v3/JzRrPKdwEnE8F1TDmDLMUlIL2Qjg-Xlsg_fhGbe2P5U.ttf\";s:6:\"italic\";s:114:\"http://themes.googleusercontent.com/static/fonts/sortsmillgoudy/v3/UUu1lKiy4hRmBWk599VL1TYNkCNSzLyoucKmbTguvr0.ttf\";}}i:170;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Viga\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:83:\"http://themes.googleusercontent.com/static/fonts/viga/v2/uD87gDbhS7frHLX4uL6agg.ttf\";}}i:171;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Kaushan Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:113:\"http://themes.googleusercontent.com/static/fonts/kaushanscript/v1/qx1LSqts-NtiKcLw4N03IBnpV0hQCek3EmWnCPrvGRM.ttf\";}}i:172;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Scada\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:3:{i:0;s:9:\"latin-ext\";i:1;s:8:\"cyrillic\";i:2;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-09-26\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/scada/v1/iZNC3ZEYwe3je6H-28d5Ug.ttf\";s:6:\"italic\";s:84:\"http://themes.googleusercontent.com/static/fonts/scada/v1/PCGyLT1qNawkOUQ3uHFhBw.ttf\";s:3:\"700\";s:84:\"http://themes.googleusercontent.com/static/fonts/scada/v1/t6XNWdMdVWUz93EuRVmifQ.ttf\";s:9:\"700italic\";s:105:\"http://themes.googleusercontent.com/static/fonts/scada/v1/kLrBIf7V4mDMwcd_Yw7-D_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:173;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Berkshire Swash\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:114:\"http://themes.googleusercontent.com/static/fonts/berkshireswash/v1/4RZJjVRPjYnC2939hKCAimKfbtsIjCZP_edQljX9gR0.ttf\";}}i:174;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Bangers\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/bangers/v4/WAffdge5w99Xif-DLeqmcA.ttf\";}}i:175;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Marmelad\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:9:\"latin-ext\";i:1;s:8:\"cyrillic\";i:2;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/marmelad/v3/jI0_FBlSOIRLL0ePWOhOwQ.ttf\";}}i:176;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Vidaloka\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/vidaloka/v5/C6Nul0ogKUWkx356rrt9RA.ttf\";}}i:177;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Russo One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:9:\"latin-ext\";i:1;s:8:\"cyrillic\";i:2;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/russoone/v1/zfwxZ--UhUc7FVfgT21PRQ.ttf\";}}i:178;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Neuton\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"700\";i:5;s:3:\"800\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":6:{s:3:\"200\";s:85:\"http://themes.googleusercontent.com/static/fonts/neuton/v5/DA3Mkew3XqSkPpi1f4tJow.ttf\";s:3:\"300\";s:85:\"http://themes.googleusercontent.com/static/fonts/neuton/v5/xrc_aZ2hx-gdeV0mlY8Vww.ttf\";s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/neuton/v5/9R-MGIOQUdjAVeB6nE6PcQ.ttf\";s:6:\"italic\";s:85:\"http://themes.googleusercontent.com/static/fonts/neuton/v5/uVMT3JOB5BNFi3lgPp6kEg.ttf\";s:3:\"700\";s:85:\"http://themes.googleusercontent.com/static/fonts/neuton/v5/gnWpkWY7DirkKiovncYrfg.ttf\";s:3:\"800\";s:85:\"http://themes.googleusercontent.com/static/fonts/neuton/v5/XPzBQV4lY6enLxQG9cF1jw.ttf\";}}i:179;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Rambla\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-11-28\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/rambla/v1/YaTmpvm5gFg_ShJKTQmdzg.ttf\";s:6:\"italic\";s:85:\"http://themes.googleusercontent.com/static/fonts/rambla/v1/mhUgsKmp0qw3uATdDDAuwA.ttf\";s:3:\"700\";s:85:\"http://themes.googleusercontent.com/static/fonts/rambla/v1/C5VZH8BxQKmnBuoC00UPpw.ttf\";s:9:\"700italic\";s:106:\"http://themes.googleusercontent.com/static/fonts/rambla/v1/ziMzUZya6QahrKONSI1TzqCWcynf_cDxXwCLxiixG1c.ttf\";}}i:180;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Allan\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-09-14\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/allan/v4/T3lemhgZmLQkQI2Qc2bQHA.ttf\";s:3:\"700\";s:84:\"http://themes.googleusercontent.com/static/fonts/allan/v4/zSxQiwo7wgnr7KkMXhSiag.ttf\";}}i:181;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Rochester\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/rochester/v3/bnj8tmQBiOkdji_G_yvypg.ttf\";}}i:182;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Homemade Apple\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:113:\"http://themes.googleusercontent.com/static/fonts/homemadeapple/v3/yg3UMEsefgZ8IHz_ryz86BiPOmFWYV1WlrJkRafc4c0.ttf\";}}i:183;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Domine\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-12-06\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/domine/v1/wfVIgamVFjMNQAEWurCiHA.ttf\";s:3:\"700\";s:85:\"http://themes.googleusercontent.com/static/fonts/domine/v1/phBcG1ZbQFxUIt18hPVxnw.ttf\";}}i:184;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Julius Sans One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-10-26\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:113:\"http://themes.googleusercontent.com/static/fonts/juliussansone/v1/iU65JP9acQHPDLkdalCF7jjVlsJB_M_Q_LtZxsoxvlw.ttf\";}}i:185;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Rosario\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v7\";s:12:\"lastModified\";s:10:\"2013-05-22\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/rosario/v7/bL-cEh8dXtDupB2WccA2LA.ttf\";s:6:\"italic\";s:86:\"http://themes.googleusercontent.com/static/fonts/rosario/v7/pkflNy18HEuVVx4EOjeb_Q.ttf\";s:3:\"700\";s:107:\"http://themes.googleusercontent.com/static/fonts/rosario/v7/nrS6PJvDWN42RP4TFWccd_esZW2xOQ-xsNqO47m55DA.ttf\";s:9:\"700italic\";s:107:\"http://themes.googleusercontent.com/static/fonts/rosario/v7/EOgFX2Va5VGrkhn_eDpIRS3USBnSvpkopQaUR-2r7iU.ttf\";}}i:186;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Damion\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/damion/v3/13XtECwKxhD_VrOqXL4SiA.ttf\";}}i:187;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Hammersmith One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-08-23\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:114:\"http://themes.googleusercontent.com/static/fonts/hammersmithone/v4/FWNn6ITYqL6or7ZTmBxRhjjVlsJB_M_Q_LtZxsoxvlw.ttf\";}}i:188;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Jura\";s:8:\"variants\";a:4:{i:0;s:3:\"300\";i:1;s:7:\"regular\";i:2;s:3:\"500\";i:3;s:3:\"600\";}s:7:\"subsets\";a:6:{i:0;s:12:\"cyrillic-ext\";i:1;s:9:\"latin-ext\";i:2;s:9:\"greek-ext\";i:3;s:8:\"cyrillic\";i:4;s:5:\"greek\";i:5;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":4:{s:3:\"300\";s:83:\"http://themes.googleusercontent.com/static/fonts/jura/v4/Rqx_xy1UnN0C7wD3FUSyPQ.ttf\";s:7:\"regular\";s:83:\"http://themes.googleusercontent.com/static/fonts/jura/v4/YAWMwF3sN0KCbynMq-Yr_Q.ttf\";s:3:\"500\";s:83:\"http://themes.googleusercontent.com/static/fonts/jura/v4/16xhfjHCiaLj3tsqqgmtGg.ttf\";s:3:\"600\";s:83:\"http://themes.googleusercontent.com/static/fonts/jura/v4/iwseduOwJSdY8wQ1Y6CJdA.ttf\";}}i:189;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Convergence\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/convergence/v2/eykrGz1NN_YpQmkAZjW-qKCWcynf_cDxXwCLxiixG1c.ttf\";}}i:190;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Great Vibes\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/greatvibes/v1/4Mi5RG_9LjQYrTU55GN_L6CWcynf_cDxXwCLxiixG1c.ttf\";}}i:191;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Glegoo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/glegoo/v1/2tf-h3n2A_SNYXEO0C8bKw.ttf\";}}i:192;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Spirax\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-09-14\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/spirax/v2/IOKqhk-Ccl7y31yDsePPkw.ttf\";}}i:193;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Coustard\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"900\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/coustard/v3/iO2Rs5PmqAEAXoU3SkMVBg.ttf\";s:3:\"900\";s:108:\"http://themes.googleusercontent.com/static/fonts/coustard/v3/W02OCWO6OfMUHz6aVyegQ6CWcynf_cDxXwCLxiixG1c.ttf\";}}i:194;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Ubuntu Mono\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:6:{i:0;s:12:\"cyrillic-ext\";i:1;s:9:\"latin-ext\";i:2;s:9:\"greek-ext\";i:3;s:8:\"cyrillic\";i:4;s:5:\"greek\";i:5;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/ubuntumono/v3/EgeuS9OtEmA0y_JRo03MQaCWcynf_cDxXwCLxiixG1c.ttf\";s:6:\"italic\";s:110:\"http://themes.googleusercontent.com/static/fonts/ubuntumono/v3/KAKuHXAHZOeECOWAHsRKA0eOrDcLawS7-ssYqLr2Xp4.ttf\";s:3:\"700\";s:110:\"http://themes.googleusercontent.com/static/fonts/ubuntumono/v3/ceqTZGKHipo8pJj4molytne1Pd76Vl7zRpE7NLJQ7XU.ttf\";s:9:\"700italic\";s:110:\"http://themes.googleusercontent.com/static/fonts/ubuntumono/v3/n_d8tv_JOIiYyMXR4eaV9c_zJjSACmk0BRPxQqhnNLU.ttf\";}}i:195;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Alfa Slab One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/alfaslabone/v2/Qx6FPcitRwTC_k88tLPc-Yjjx0o0jr6fNXxPgYh_a8Q.ttf\";}}i:196;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Metrophobic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/metrophobic/v3/SaglWZWCrrv_D17u1i4v_aCWcynf_cDxXwCLxiixG1c.ttf\";}}i:197;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:18:\"The Girl Next Door\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:115:\"http://themes.googleusercontent.com/static/fonts/thegirlnextdoor/v4/cWRA4JVGeEcHGcPl5hmX7kzo0nFFoM60ux_D9BUymX4.ttf\";}}i:198;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Bad Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:8:\"cyrillic\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/badscript/v2/cRyUs0nJ2eMQFHwBsZNRXfesZW2xOQ-xsNqO47m55DA.ttf\";}}i:199;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Andika\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:12:\"cyrillic-ext\";i:1;s:9:\"latin-ext\";i:2;s:8:\"cyrillic\";i:3;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/andika/v3/oe-ag1G0lcqZ3IXfeEgaGg.ttf\";}}i:200;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Aldrich\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/aldrich/v3/kMMW1S56gFx7RP_mW1g-Eg.ttf\";}}i:201;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Sansita One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/sansitaone/v3/xWqf68oB50JXqGIRR0h2hqCWcynf_cDxXwCLxiixG1c.ttf\";}}i:202;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Allerta Stencil\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:114:\"http://themes.googleusercontent.com/static/fonts/allertastencil/v4/CdSZfRtHbQrBohqmzSdDYFf2eT4jUldwg_9fgfY_tHc.ttf\";}}i:203;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Radley\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/radley/v6/FgE9di09a-mXGzAIyI6Q9Q.ttf\";s:6:\"italic\";s:85:\"http://themes.googleusercontent.com/static/fonts/radley/v6/Z_JcACuPAOO2f9kzQcGRug.ttf\";}}i:204;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Cinzel\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:3:\"700\";i:2;s:3:\"900\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-10-26\";s:5:\"files\";O:8:\"stdClass\":3:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/cinzel/v1/GF7dy_Nc-a6EaHYSyGd-EA.ttf\";s:3:\"700\";s:85:\"http://themes.googleusercontent.com/static/fonts/cinzel/v1/nYcFQ6_3pf_6YDrOFjBR8Q.ttf\";s:3:\"900\";s:85:\"http://themes.googleusercontent.com/static/fonts/cinzel/v1/FTBj72ozM2cEOSxiVsRb3A.ttf\";}}i:205;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"ABeeZee\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-10-31\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/abeezee/v1/mE5BOuZKGln_Ex0uYKpIaw.ttf\";s:6:\"italic\";s:86:\"http://themes.googleusercontent.com/static/fonts/abeezee/v1/kpplLynmYgP0YtlJA3atRw.ttf\";}}i:206;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Judson\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":3:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/judson/v4/znM1AAs0eytUaJzf1CrYZQ.ttf\";s:6:\"italic\";s:85:\"http://themes.googleusercontent.com/static/fonts/judson/v4/GVqQW9P52ygW-ySq-CLwAA.ttf\";s:3:\"700\";s:85:\"http://themes.googleusercontent.com/static/fonts/judson/v4/he4a2LwiPJc7r8x0oKCKiA.ttf\";}}i:207;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Arbutus Slab\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-09-26\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/arbutusslab/v1/6k3Yp6iS9l4jRIpynA8qMy3USBnSvpkopQaUR-2r7iU.ttf\";}}i:208;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Gentium Basic\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:112:\"http://themes.googleusercontent.com/static/fonts/gentiumbasic/v4/KCktj43blvLkhOTolFn-MYtBLojGU5Qdl8-5NL4v70w.ttf\";s:6:\"italic\";s:112:\"http://themes.googleusercontent.com/static/fonts/gentiumbasic/v4/qoFz4NSMaYC2UmsMAG3lyTj3mvXnCeAk09uTtmkJGRc.ttf\";s:3:\"700\";s:112:\"http://themes.googleusercontent.com/static/fonts/gentiumbasic/v4/2qL6yulgGf0wwgOp-UqGyLNuTeOOLg3nUymsEEGmdO0.ttf\";s:9:\"700italic\";s:112:\"http://themes.googleusercontent.com/static/fonts/gentiumbasic/v4/8N9-c_aQDJ8LbI1NGVMrwtswO1vWwP9exiF8s0wqW10.ttf\";}}i:209;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:19:\"Petit Formal Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-09-14\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:117:\"http://themes.googleusercontent.com/static/fonts/petitformalscript/v1/OEZwr2-ovBsq2n3ACCKoEvVPl2Gjtxj0D6F7QLy1VQc.ttf\";}}i:210;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Michroma\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/michroma/v4/0c2XrW81_QsiKV8T9thumA.ttf\";}}i:211;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Orienta\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-09-14\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/orienta/v1/_NKSk93mMs0xsqtfjCsB3Q.ttf\";}}i:212;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Fontdiner Swanky\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:115:\"http://themes.googleusercontent.com/static/fonts/fontdinerswanky/v3/8_GxIO5ixMtn5P6COsF3TlBjMPLzPAFJwRBn-s1U7kA.ttf\";}}i:213;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Volkhov\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/volkhov/v5/MDIZAofe1T_J3un5Kgo8zg.ttf\";s:6:\"italic\";s:86:\"http://themes.googleusercontent.com/static/fonts/volkhov/v5/1rTjmztKEpbkKH06JwF8Yw.ttf\";s:3:\"700\";s:107:\"http://themes.googleusercontent.com/static/fonts/volkhov/v5/L8PbKS-kEoLHm7nP--NCzPesZW2xOQ-xsNqO47m55DA.ttf\";s:9:\"700italic\";s:107:\"http://themes.googleusercontent.com/static/fonts/volkhov/v5/W6oG0QDDjCgj0gmsHE520C3USBnSvpkopQaUR-2r7iU.ttf\";}}i:214;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Gochi Hand\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/gochihand/v4/KT1-WxgHsittJ34_20IfAPesZW2xOQ-xsNqO47m55DA.ttf\";}}i:215;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:21:\"Love Ya Like A Sister\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:117:\"http://themes.googleusercontent.com/static/fonts/loveyalikeasister/v4/LzkxWS-af0Br2Sk_YgSJY-ad1xEP8DQfgfY8MH9aBUg.ttf\";}}i:216;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Puritan\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/puritan/v4/wv_RtgVBSCn-or2MC0n4Kg.ttf\";s:6:\"italic\";s:86:\"http://themes.googleusercontent.com/static/fonts/puritan/v4/BqZX8Tp200LeMv1KlzXgLQ.ttf\";s:3:\"700\";s:107:\"http://themes.googleusercontent.com/static/fonts/puritan/v4/pJS2SdwI0SCiVnO0iQSFT_esZW2xOQ-xsNqO47m55DA.ttf\";s:9:\"700italic\";s:107:\"http://themes.googleusercontent.com/static/fonts/puritan/v4/rFG3XkMJL75nUNZwCEIJqC3USBnSvpkopQaUR-2r7iU.ttf\";}}i:217;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Six Caps\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/sixcaps/v4/_XeDnO0HOV8Er9u97If1tQ.ttf\";}}i:218;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Courgette\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/courgette/v1/2YO0EYtyE9HUPLZprahpZA.ttf\";}}i:219;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Inder\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2013-11-21\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/inder/v2/C38TwecLTfKxIHDc_Adcrw.ttf\";}}i:220;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Sintony\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2013-02-27\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/sintony/v1/IDhCijoIMev2L6Lg5QsduQ.ttf\";s:3:\"700\";s:107:\"http://themes.googleusercontent.com/static/fonts/sintony/v1/zVXQB1wqJn6PE4dWXoYpvPesZW2xOQ-xsNqO47m55DA.ttf\";}}i:221;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Shanti\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/shanti/v4/lc4nG_JG6Q-2FQSOMMhb_w.ttf\";}}i:222;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Sancreek\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/sancreek/v4/8ZacBMraWMvHly4IJI3esw.ttf\";}}i:223;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Kristi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/kristi/v4/aRsgBQrkQkMlu4UPSnJyOQ.ttf\";}}i:224;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Anonymous Pro\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:6:{i:0;s:12:\"cyrillic-ext\";i:1;s:9:\"latin-ext\";i:2;s:9:\"greek-ext\";i:3;s:8:\"cyrillic\";i:4;s:5:\"greek\";i:5;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:112:\"http://themes.googleusercontent.com/static/fonts/anonymouspro/v3/Zhfjj_gat3waL4JSju74E-V_5zh5b-_HiooIRUBwn1A.ttf\";s:6:\"italic\";s:112:\"http://themes.googleusercontent.com/static/fonts/anonymouspro/v3/q0u6LFHwttnT_69euiDbWKwIsuKDCXG0NQm7BvAgx-c.ttf\";s:3:\"700\";s:112:\"http://themes.googleusercontent.com/static/fonts/anonymouspro/v3/WDf5lZYgdmmKhO8E1AQud--Cz_5MeePnXDAcLNWyBME.ttf\";s:9:\"700italic\";s:112:\"http://themes.googleusercontent.com/static/fonts/anonymouspro/v3/_fVr_XGln-cetWSUc-JpfA1LL9bfs7wyIp6F8OC9RxA.ttf\";}}i:225;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Advent Pro\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:7:\"regular\";i:4;s:3:\"500\";i:5;s:3:\"600\";i:6;s:3:\"700\";}s:7:\"subsets\";a:3:{i:0;s:9:\"latin-ext\";i:1;s:5:\"greek\";i:2;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":7:{s:3:\"100\";s:109:\"http://themes.googleusercontent.com/static/fonts/adventpro/v1/87-JOpSUecTG50PBYK4ysi3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"200\";s:109:\"http://themes.googleusercontent.com/static/fonts/adventpro/v1/URTSSjIp0Wr-GrjxFdFWnGeudeTO44zf-ht3k-KNzwg.ttf\";s:3:\"300\";s:109:\"http://themes.googleusercontent.com/static/fonts/adventpro/v1/sJaBfJYSFgoB80OL1_66m0eOrDcLawS7-ssYqLr2Xp4.ttf\";s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/adventpro/v1/1NxMBeKVcNNH2H46AUR3wfesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"500\";s:109:\"http://themes.googleusercontent.com/static/fonts/adventpro/v1/7kBth2-rT8tP40RmMMXMLJp-63r6doWhTEbsfBIRJ7A.ttf\";s:3:\"600\";s:109:\"http://themes.googleusercontent.com/static/fonts/adventpro/v1/3Jo-2maCzv2QLzQBzaKHV_pTEJqju4Hz1txDWij77d4.ttf\";s:3:\"700\";s:109:\"http://themes.googleusercontent.com/static/fonts/adventpro/v1/M4I6QiICt-ey_wZTpR2gKwJKKGfqHaYFsRG-T3ceEVo.ttf\";}}i:226;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Limelight\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-08-23\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/limelight/v4/5dTfN6igsXjLjOy8QQShcg.ttf\";}}i:227;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Merienda One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-11-28\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/meriendaone/v4/bCA-uDdUx6nTO8SjzCLXvS3USBnSvpkopQaUR-2r7iU.ttf\";}}i:228;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Crushed\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/crushed/v3/aHwSejs3Kt0Lg95u7j32jA.ttf\";}}i:229;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Days One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/daysone/v3/kzwZjNhc1iabMsrc_hKBIA.ttf\";}}i:230;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Magra\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/magra/v1/hoZ13bwCXBxuGZqAudgc5A.ttf\";s:3:\"700\";s:84:\"http://themes.googleusercontent.com/static/fonts/magra/v1/6fOM5sq5cIn8D0RjX8Lztw.ttf\";}}i:231;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Carrois Gothic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-10-03\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:113:\"http://themes.googleusercontent.com/static/fonts/carroisgothic/v1/GCgb7bssGpwp7V5ynxmWy2x3d0cwUleGuRTmCYfCUaM.ttf\";}}i:232;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"IM Fell English\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:113:\"http://themes.googleusercontent.com/static/fonts/imfellenglish/v3/xwIisCqGFi8pff-oa9uSVHGNmx1fDm-u2eBJHQkdrmk.ttf\";s:6:\"italic\";s:113:\"http://themes.googleusercontent.com/static/fonts/imfellenglish/v3/Z3cnIAI_L3XTRfz4JuZKbuewladMPCWTthtMv9cPS-c.ttf\";}}i:233;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Racing Sans One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-08-16\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:113:\"http://themes.googleusercontent.com/static/fonts/racingsansone/v1/1r3DpWaCiT7y3PD4KgkNyDjVlsJB_M_Q_LtZxsoxvlw.ttf\";}}i:234;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Cabin Sketch\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/cabinsketch/v5/d9fijO34zQajqQvl3YHRCS3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"700\";s:111:\"http://themes.googleusercontent.com/static/fonts/cabinsketch/v5/ki3SSN5HMOO0-IOLOj069ED2ttfZwueP-QU272T9-k4.ttf\";}}i:235;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Arapey\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/arapey/v2/dqu823lrSYn8T2gApTdslA.ttf\";s:6:\"italic\";s:85:\"http://themes.googleusercontent.com/static/fonts/arapey/v2/pY-Xi5JNBpaWxy2tZhEm5A.ttf\";}}i:236;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Prata\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/prata/v3/3gmx8r842loRRm9iQkCDGg.ttf\";}}i:237;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Boogaloo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/boogaloo/v3/4Wu1tvFMoB80fSu8qLgQfQ.ttf\";}}i:238;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:3:\"Ovo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:82:\"http://themes.googleusercontent.com/static/fonts/ovo/v4/mFg27dimu3s9t09qjCwB1g.ttf\";}}i:239;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Pompiere\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/pompiere/v3/o_va2p9CD5JfmFohAkGZIA.ttf\";}}i:240;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Cookie\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/cookie/v4/HxeUC62y_YdDbiFlze357A.ttf\";}}i:241;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Cutive\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-11-28\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/cutive/v4/G2bW-ImyOCwKxBkLyz39YQ.ttf\";}}i:242;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Slackey\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/slackey/v3/evRIMNhGVCRJvCPv4kteeA.ttf\";}}i:243;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Mako\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:83:\"http://themes.googleusercontent.com/static/fonts/mako/v4/z5zSLmfPlv1uTVAdmJBLXg.ttf\";}}i:244;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Abril Fatface\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:112:\"http://themes.googleusercontent.com/static/fonts/abrilfatface/v5/X1g_KwGeBV3ajZIXQ9VnDojjx0o0jr6fNXxPgYh_a8Q.ttf\";}}i:245;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Alike\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/alike/v4/Ho8YpRKNk_202fwDiGNIyw.ttf\";}}i:246;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Lekton\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-11-28\";s:5:\"files\";O:8:\"stdClass\":3:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/lekton/v4/r483JYmxf5PjIm4jVAm8Yg.ttf\";s:6:\"italic\";s:85:\"http://themes.googleusercontent.com/static/fonts/lekton/v4/_UbDIPBA1wDqSbhp-OED7A.ttf\";s:3:\"700\";s:85:\"http://themes.googleusercontent.com/static/fonts/lekton/v4/WZw-uL8WTkx3SBVfTlevXQ.ttf\";}}i:247;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Average Sans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-11-28\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/averagesans/v1/dnU3R-5A_43y5bIyLztPsS3USBnSvpkopQaUR-2r7iU.ttf\";}}i:248;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:20:\"Fredericka the Great\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:118:\"http://themes.googleusercontent.com/static/fonts/frederickathegreat/v2/7Es8Lxoku-e5eOZWpxw18nrnet6gXN1McwdQxS1dVrI.ttf\";}}i:249;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Fenix\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-10-03\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/fenix/v1/Ak8wR3VSlAN7VN_eMeJj7Q.ttf\";}}i:250;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Gruppo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/gruppo/v4/pS_JM0cK_piBZve-lfUq9w.ttf\";}}i:251;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:21:\"Montserrat Alternates\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-10-03\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:120:\"http://themes.googleusercontent.com/static/fonts/montserratalternates/v1/z2n1Sjxk9souK3HCtdHuklPuEVRGaG9GCQnmM16YWq0.ttf\";s:3:\"700\";s:120:\"http://themes.googleusercontent.com/static/fonts/montserratalternates/v1/YENqOGAVzwIHjYNjmKuAZpeqBKvsAhm-s2I4RVSXFfc.ttf\";}}i:252;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Englebert\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-11-28\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/englebert/v1/sll38iOvOuarDTYBchlP3Q.ttf\";}}i:253;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Give You Glory\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:112:\"http://themes.googleusercontent.com/static/fonts/giveyouglory/v3/DFEWZFgGmfseyIdGRJAxuBwwkpSPZdvjnMtysdqprfI.ttf\";}}i:254;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Homenaje\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-10-03\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/homenaje/v2/v0YBU0iBRrGdVjDNQILxtA.ttf\";}}i:255;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Parisienne\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/parisienne/v1/TW74B5QISJNx9moxGlmJfvesZW2xOQ-xsNqO47m55DA.ttf\";}}i:256;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Alex Brush\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/alexbrush/v3/ooh3KJFbKJSUoIRWfiu8o_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:257;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Fugaz One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/fugazone/v3/5tteVDCwxsr8-5RuSiRWOw.ttf\";}}i:258;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Caudex\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:4:{i:0;s:9:\"latin-ext\";i:1;s:9:\"greek-ext\";i:2;s:5:\"greek\";i:3;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/caudex/v3/PWEexiHLDmQbn2b1OPZWfg.ttf\";s:6:\"italic\";s:85:\"http://themes.googleusercontent.com/static/fonts/caudex/v3/XjMZF6XCisvV3qapD4oJdw.ttf\";s:3:\"700\";s:85:\"http://themes.googleusercontent.com/static/fonts/caudex/v3/PetCI4GyQ5Q3LiOzUu_mMg.ttf\";s:9:\"700italic\";s:106:\"http://themes.googleusercontent.com/static/fonts/caudex/v3/yT8YeHLjaJvQXlUEYOA8gqCWcynf_cDxXwCLxiixG1c.ttf\";}}i:259;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Contrail One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/contrailone/v3/b41KxjgiyqX-hkggANDU6C3USBnSvpkopQaUR-2r7iU.ttf\";}}i:260;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Kranky\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/kranky/v3/C8dxxTS99-fZ84vWk8SDrg.ttf\";}}i:261;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Yellowtail\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/yellowtail/v3/HLrU6lhCTjXfLZ7X60LcB_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:262;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Brawler\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/brawler/v3/3gfSw6imxQnQxweVITqUrg.ttf\";}}i:263;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Headland One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-08-23\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/headlandone/v1/iGmBeOvQGfq9DSbjJ8jDVy3USBnSvpkopQaUR-2r7iU.ttf\";}}i:264;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:22:\"Mountains of Christmas\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:120:\"http://themes.googleusercontent.com/static/fonts/mountainsofchristmas/v5/dVGBFPwd6G44IWDbQtPew2Auds3jz1Fxb61CgfaGDr4.ttf\";s:3:\"700\";s:120:\"http://themes.googleusercontent.com/static/fonts/mountainsofchristmas/v5/PymufKtHszoLrY0uiAYKNM9cPTbSBTrQyTa5TWAe3vE.ttf\";}}i:265;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Ultra\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/ultra/v4/OW8uXkOstRADuhEmGOFQLA.ttf\";}}i:266;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Alegreya SC\";s:8:\"variants\";a:6:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:3:\"900\";i:5;s:9:\"900italic\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":6:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/alegreyasc/v3/3ozeFnTbygMK6PfHh8B-iqCWcynf_cDxXwCLxiixG1c.ttf\";s:6:\"italic\";s:110:\"http://themes.googleusercontent.com/static/fonts/alegreyasc/v3/GOqmv3FLsJ2r6ZALMZVBmkeOrDcLawS7-ssYqLr2Xp4.ttf\";s:3:\"700\";s:110:\"http://themes.googleusercontent.com/static/fonts/alegreyasc/v3/M9OIREoxDkvynwTpBAYUq3e1Pd76Vl7zRpE7NLJQ7XU.ttf\";s:9:\"700italic\";s:110:\"http://themes.googleusercontent.com/static/fonts/alegreyasc/v3/5PCoU7IUfCicpKBJtBmP6c_zJjSACmk0BRPxQqhnNLU.ttf\";s:3:\"900\";s:110:\"http://themes.googleusercontent.com/static/fonts/alegreyasc/v3/M9OIREoxDkvynwTpBAYUqyenaqEuufTBk9XMKnKmgDA.ttf\";s:9:\"900italic\";s:110:\"http://themes.googleusercontent.com/static/fonts/alegreyasc/v3/5PCoU7IUfCicpKBJtBmP6U_yTOUGsoC54csJe1b-IRw.ttf\";}}i:267;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:22:\"Oleo Script Swash Caps\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-11-28\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:119:\"http://themes.googleusercontent.com/static/fonts/oleoscriptswashcaps/v1/vdWhGqsBUAP-FF3NOYTe4iMF4kXAPemmyaDpMXQ31P0.ttf\";s:3:\"700\";s:119:\"http://themes.googleusercontent.com/static/fonts/oleoscriptswashcaps/v1/HMO3ftxA9AU5floml9c755reFYaXZ4zuJXJ8fr8OO1g.ttf\";}}i:268;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Sunshiney\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/sunshiney/v3/kaWOb4pGbwNijM7CkxK1sQ.ttf\";}}i:269;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Cantora One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-09-14\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/cantoraone/v2/oI-DS62RbHI8ZREjp73ehqCWcynf_cDxXwCLxiixG1c.ttf\";}}i:270;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Rationale\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/rationale/v4/7M2eN-di0NGLQse7HzJRfg.ttf\";}}i:271;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Quantico\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/quantico/v2/pwSnP8Xpaix2rIz99HrSlQ.ttf\";s:6:\"italic\";s:108:\"http://themes.googleusercontent.com/static/fonts/quantico/v2/KQhDd2OsZi6HiITUeFQ2U_esZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:108:\"http://themes.googleusercontent.com/static/fonts/quantico/v2/OVZZzjcZ3Hkq2ojVcUtDjaCWcynf_cDxXwCLxiixG1c.ttf\";s:9:\"700italic\";s:108:\"http://themes.googleusercontent.com/static/fonts/quantico/v2/HeCYRcZbdRso3ZUu01ELbQJKKGfqHaYFsRG-T3ceEVo.ttf\";}}i:272;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Port Lligat Slab\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:114:\"http://themes.googleusercontent.com/static/fonts/portlligatslab/v2/CUEdhRk7oC7up0p6t0g4PxLSPACXvawUYCBEnHsOe30.ttf\";}}i:273;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Tenor Sans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:12:\"cyrillic-ext\";i:1;s:9:\"latin-ext\";i:2;s:8:\"cyrillic\";i:3;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/tenorsans/v4/dUBulmjNJJInvK5vL7O9yfesZW2xOQ-xsNqO47m55DA.ttf\";}}i:274;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Carter One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/carterone/v5/5X_LFvdbcB7OBG7hBgZ7fPesZW2xOQ-xsNqO47m55DA.ttf\";}}i:275;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Coda Caption\";s:8:\"variants\";a:1:{i:0;s:3:\"800\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-08-01\";s:5:\"files\";O:8:\"stdClass\":1:{s:3:\"800\";s:111:\"http://themes.googleusercontent.com/static/fonts/codacaption/v5/YDl6urZh-DUFhiMBTgAnz_qsay_1ZmRGmC8pVRdIfAg.ttf\";}}i:276;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Bentham\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/bentham/v3/5-Mo8Fe7yg5tzV0GlQIuzQ.ttf\";}}i:277;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Cousine\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:7:{i:0;s:12:\"cyrillic-ext\";i:1;s:9:\"latin-ext\";i:2;s:9:\"greek-ext\";i:3;s:8:\"cyrillic\";i:4;s:5:\"greek\";i:5;s:10:\"vietnamese\";i:6;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2013-08-14\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/cousine/v6/GYX4bPXObJNJo63QJEUnLg.ttf\";s:6:\"italic\";s:86:\"http://themes.googleusercontent.com/static/fonts/cousine/v6/1WtIuajLoo8vjVwsrZ3eOg.ttf\";s:3:\"700\";s:107:\"http://themes.googleusercontent.com/static/fonts/cousine/v6/FXEOnNUcCzhdtoBxiq-lovesZW2xOQ-xsNqO47m55DA.ttf\";s:9:\"700italic\";s:107:\"http://themes.googleusercontent.com/static/fonts/cousine/v6/y_AZ5Sz-FwL1lux2xLSTZS3USBnSvpkopQaUR-2r7iU.ttf\";}}i:278;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Kavoon\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2013-01-23\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/kavoon/v1/382m-6baKXqJFQjEgobt6Q.ttf\";}}i:279;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Alice\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/alice/v4/wZTAfivekBqIg-rk63nFvQ.ttf\";}}i:280;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Ruda\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:3:\"700\";i:2;s:3:\"900\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":3:{s:7:\"regular\";s:83:\"http://themes.googleusercontent.com/static/fonts/ruda/v4/jPEIPB7DM2DNK_uBGv2HGw.ttf\";s:3:\"700\";s:83:\"http://themes.googleusercontent.com/static/fonts/ruda/v4/JABOu1SYOHcGXVejUq4w6g.ttf\";s:3:\"900\";s:83:\"http://themes.googleusercontent.com/static/fonts/ruda/v4/Uzusv-enCjoIrznlJJaBRw.ttf\";}}i:281;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Short Stack\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/shortstack/v3/v4dXPI0Rm8XN9gk4SDdqlqCWcynf_cDxXwCLxiixG1c.ttf\";}}i:282;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Wire One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/wireone/v3/sRLhaQOQpWnvXwIx0CycQw.ttf\";}}i:283;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Salsa\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/salsa/v3/BnpUCBmYdvggScEPs5JbpA.ttf\";}}i:284;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Sofia\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/sofia/v2/Imnvx0Ag9r6iDBFUY5_RaQ.ttf\";}}i:285;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Poly\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:83:\"http://themes.googleusercontent.com/static/fonts/poly/v4/bcMAuiacS2qkd54BcwW6_Q.ttf\";s:6:\"italic\";s:83:\"http://themes.googleusercontent.com/static/fonts/poly/v4/Zkx-eIlZSjKUrPGYhV5PeA.ttf\";}}i:286;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Wendy One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-12-14\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/wendyone/v1/R8CJT2oDXdMk_ZtuHTxoxw.ttf\";}}i:287;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Merienda\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-11-28\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/merienda/v1/MYY6Og1qZlOQtPW2G95Y3A.ttf\";s:3:\"700\";s:108:\"http://themes.googleusercontent.com/static/fonts/merienda/v1/GlwcvRLlgiVE2MBFQ4r0sKCWcynf_cDxXwCLxiixG1c.ttf\";}}i:288;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Adamina\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/adamina/v4/RUQfOodOMiVVYqFZcSlT9w.ttf\";}}i:289;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Spinnaker\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/spinnaker/v5/MQdIXivKITpjROUdiN6Jgg.ttf\";}}i:290;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Delius\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/delius/v3/TQA163qafki2-gV-B6F_ag.ttf\";}}i:291;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Metamorphous\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-08-23\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:112:\"http://themes.googleusercontent.com/static/fonts/metamorphous/v3/wGqUKXRinIYggz-BTRU9ei3USBnSvpkopQaUR-2r7iU.ttf\";}}i:292;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Lemon\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/lemon/v2/wed1nNu4LNSu-3RoRVUhUw.ttf\";}}i:293;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Fauna One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2013-06-12\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/faunaone/v1/8kL-wpAPofcAMELI_5NRnQ.ttf\";}}i:294;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Belleza\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/belleza/v1/wchA3BWJlVqvIcSeNZyXew.ttf\";}}i:295;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Buenard\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/buenard/v3/NSpMPGKAUgrLrlstYVvIXQ.ttf\";s:3:\"700\";s:107:\"http://themes.googleusercontent.com/static/fonts/buenard/v3/yUlGE115dGr7O9w9FlP3UvesZW2xOQ-xsNqO47m55DA.ttf\";}}i:296;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Tauri\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2013-02-27\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/tauri/v1/XIWeYJDXNqiVNej0zEqtGg.ttf\";}}i:297;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"La Belle Aurore\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:113:\"http://themes.googleusercontent.com/static/fonts/labelleaurore/v3/Irdbc4ASuUoWDjd_Wc3md123K2iuuhwZgaKapkyRTY8.ttf\";}}i:298;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"IM Fell DW Pica\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:112:\"http://themes.googleusercontent.com/static/fonts/imfelldwpica/v3/W81bfaWiUicLSPbJhW-ATsA5qm663gJGVdtpamafG5A.ttf\";s:6:\"italic\";s:112:\"http://themes.googleusercontent.com/static/fonts/imfelldwpica/v3/alQJ8SK5aSOZVaelYoyT4PL2asmh5DlYQYCosKo6yQs.ttf\";}}i:299;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Sacramento\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-11-28\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/sacramento/v1/_kv-qycSHMNdhjiv0Kj7BvesZW2xOQ-xsNqO47m55DA.ttf\";}}i:300;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Mouse Memoirs\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-11-28\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:112:\"http://themes.googleusercontent.com/static/fonts/mousememoirs/v1/NBFaaJFux_j0AQbAsW3QeH8f0n03UdmQgF_CLvNR2vg.ttf\";}}i:301;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Anaheim\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-11-28\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/anaheim/v1/t-z8aXHMpgI2gjN_rIflKA.ttf\";}}i:302;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:18:\"Cedarville Cursive\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:117:\"http://themes.googleusercontent.com/static/fonts/cedarvillecursive/v3/cuCe6HrkcqrWTWTUE7dw-41zwq9-z_Lf44CzRAA0d0Y.ttf\";}}i:303;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:19:\"Sue Ellen Francisco\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:117:\"http://themes.googleusercontent.com/static/fonts/sueellenfrancisco/v4/TwHX4vSxMUnJUdEz1JIgrhzazJzPVbGl8jnf1tisRz4.ttf\";}}i:304;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Podkova\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/podkova/v5/eylljyGVfB8ZUQjYY3WZRQ.ttf\";s:3:\"700\";s:107:\"http://themes.googleusercontent.com/static/fonts/podkova/v5/SqW4aa8m_KVrOgYSydQ33vesZW2xOQ-xsNqO47m55DA.ttf\";}}i:305;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:18:\"Chau Philomene One\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:116:\"http://themes.googleusercontent.com/static/fonts/chauphilomeneone/v1/KKc5egCL-a2fFVoOA2x6tBFi5dxgSTdxqnMJgWkBJcg.ttf\";s:6:\"italic\";s:116:\"http://themes.googleusercontent.com/static/fonts/chauphilomeneone/v1/eJj1PY_iN4KiIuyOvtMHJP6uyLkxyiC4WcYA74sfquE.ttf\";}}i:306;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:18:\"UnifrakturMaguntia\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:118:\"http://themes.googleusercontent.com/static/fonts/unifrakturmaguntia/v4/7KWy3ymCVR_xfAvvcIXm3-kdNg30GQauG_DE-tMYtWk.ttf\";}}i:307;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Audiowide\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/audiowide/v1/yGcwRZB6VmoYhPUYT-mEow.ttf\";}}i:308;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Nova Round\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/novaround/v5/7-cK3Ari_8XYYFgVMxVhDvesZW2xOQ-xsNqO47m55DA.ttf\";}}i:309;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Lilita One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/lilitaone/v1/vTxJQjbNV6BCBHx8sGDCVvesZW2xOQ-xsNqO47m55DA.ttf\";}}i:310;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Acme\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:83:\"http://themes.googleusercontent.com/static/fonts/acme/v2/-J6XNtAHPZBEbsifCdBt-g.ttf\";}}i:311;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:17:\"Delius Swash Caps\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:115:\"http://themes.googleusercontent.com/static/fonts/deliusswashcaps/v5/uXyrEUnoWApxIOICunRq7yIrxb5zDVgU2N3VzXm7zq4.ttf\";}}i:312;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Grand Hotel\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-12-06\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/grandhotel/v1/C_A8HiFZjXPpnMt38XnK7qCWcynf_cDxXwCLxiixG1c.ttf\";}}i:313;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Strait\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-10-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/strait/v1/m4W73ViNmProETY2ybc-Bg.ttf\";}}i:314;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:24:\"Annie Use Your Telescope\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:121:\"http://themes.googleusercontent.com/static/fonts/annieuseyourtelescope/v3/2cuiO5VmaR09C8SLGEQjGqbp7mtG8sPlcZvOaO8HBak.ttf\";}}i:315;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Snippet\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-08-08\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/snippet/v3/eUcYMLq2GtHZovLlQH_9kA.ttf\";}}i:316;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Corben\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/corben/v5/tTysMZkt-j8Y5yhkgsoajQ.ttf\";s:3:\"700\";s:85:\"http://themes.googleusercontent.com/static/fonts/corben/v5/lirJaFSQWdGQuV--fksg5g.ttf\";}}i:317;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Forum\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:12:\"cyrillic-ext\";i:1;s:9:\"latin-ext\";i:2;s:8:\"cyrillic\";i:3;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/forum/v4/MZUpsq1VfLrqv8eSDcbrrQ.ttf\";}}i:318;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Federo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/federo/v5/JPhe1S2tujeyaR79gXBLeQ.ttf\";}}i:319;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:3:\"Geo\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-10-26\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:82:\"http://themes.googleusercontent.com/static/fonts/geo/v5/mJuJYk5Pww84B4uHAQ1XaA.ttf\";s:6:\"italic\";s:82:\"http://themes.googleusercontent.com/static/fonts/geo/v5/8_r1wToF7nPdDuX1qxel6Q.ttf\";}}i:320;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Marcellus SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-10-03\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/marcellussc/v1/_jugwxhkkynrvsfrxVx8gS3USBnSvpkopQaUR-2r7iU.ttf\";}}i:321;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Basic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/basic/v2/hNII2mS5Dxw5C0u_m3mXgA.ttf\";}}i:322;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Montez\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/montez/v3/kx58rLOWQQLGFM4pDHv5Ng.ttf\";}}i:323;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Aclonica\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/aclonica/v3/M6pHZMPwK3DiBSlo3jwAKQ.ttf\";}}i:324;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Bowlby One SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/bowlbyonesc/v5/8ZkeXftTuzKBtmxOYXoRedDkZCMxWJecxjvKm2f8MJw.ttf\";}}i:325;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Maiden Orange\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:112:\"http://themes.googleusercontent.com/static/fonts/maidenorange/v3/ZhKIA2SPisEwdhW7g0RUWojjx0o0jr6fNXxPgYh_a8Q.ttf\";}}i:326;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Stardos Stencil\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:114:\"http://themes.googleusercontent.com/static/fonts/stardosstencil/v3/ygEOyTW9a6u4fi4OXEZeTFf2eT4jUldwg_9fgfY_tHc.ttf\";s:3:\"700\";s:114:\"http://themes.googleusercontent.com/static/fonts/stardosstencil/v3/h4ExtgvoXhPtv9Ieqd-XC81wDCbBgmIo8UyjIhmkeSM.ttf\";}}i:327;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Tulpen One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/tulpenone/v3/lwcTfVIEVxpZLZlWzR5baPesZW2xOQ-xsNqO47m55DA.ttf\";}}i:328;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Quando\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/quando/v1/03nDiEZuO2-h3xvtG6UmHg.ttf\";}}i:329;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Andada\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/andada/v4/rSFaDqNNQBRw3y19MB5Y4w.ttf\";}}i:330;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Tienne\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:3:\"700\";i:2;s:3:\"900\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":3:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/tienne/v5/-IIfDl701C0z7-fy2kmGvA.ttf\";s:3:\"700\";s:85:\"http://themes.googleusercontent.com/static/fonts/tienne/v5/JvoCDOlyOSEyYGRwCyfs3g.ttf\";s:3:\"900\";s:85:\"http://themes.googleusercontent.com/static/fonts/tienne/v5/FBano5T521OWexj2iRYLMw.ttf\";}}i:331;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Yesteryear\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/yesteryear/v2/dv09hP_ZrdjVOfZQXKXuZvesZW2xOQ-xsNqO47m55DA.ttf\";}}i:332;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Allura\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/allura/v1/4hcqgZanyuJ2gMYWffIR6A.ttf\";}}i:333;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Antic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/antic/v4/hEa8XCNM7tXGzD0Uk0AipA.ttf\";}}i:334;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:20:\"Dawning of a New Day\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:116:\"http://themes.googleusercontent.com/static/fonts/dawningofanewday/v4/JiDsRhiKZt8uz3NJ5xA06gXLnohmOYWQZqo_sW8GLTk.ttf\";}}i:335;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:19:\"Playfair Display SC\";s:8:\"variants\";a:6:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:3:\"900\";i:5;s:9:\"900italic\";}s:7:\"subsets\";a:3:{i:0;s:9:\"latin-ext\";i:1;s:8:\"cyrillic\";i:2;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-10-31\";s:5:\"files\";O:8:\"stdClass\":6:{s:7:\"regular\";s:117:\"http://themes.googleusercontent.com/static/fonts/playfairdisplaysc/v1/G0-tvBxd4eQRdwFKB8dRkcpjYTDWIvcAwAccqeW9uNM.ttf\";s:6:\"italic\";s:117:\"http://themes.googleusercontent.com/static/fonts/playfairdisplaysc/v1/myuYiFR-4NTrUT4w6TKls2klJsJYggW8rlNoTOTuau0.ttf\";s:3:\"700\";s:117:\"http://themes.googleusercontent.com/static/fonts/playfairdisplaysc/v1/5ggqGkvWJU_TtW2W8cEubA-Amcyomnuy4WsCiPxGHjw.ttf\";s:9:\"700italic\";s:117:\"http://themes.googleusercontent.com/static/fonts/playfairdisplaysc/v1/6X0OQrQhEEnPo56RalREX4krgPi80XvBcbTwmz-rgmU.ttf\";s:3:\"900\";s:117:\"http://themes.googleusercontent.com/static/fonts/playfairdisplaysc/v1/5ggqGkvWJU_TtW2W8cEubKXL3C32k275YmX_AcBPZ7w.ttf\";s:9:\"900italic\";s:117:\"http://themes.googleusercontent.com/static/fonts/playfairdisplaysc/v1/6X0OQrQhEEnPo56RalREX8Zag2q3ssKz8uH1RU4a9gs.ttf\";}}i:336;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Expletus Sans\";s:8:\"variants\";a:8:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":8:{s:7:\"regular\";s:112:\"http://themes.googleusercontent.com/static/fonts/expletussans/v4/gegTSDBDs5le3g6uxU1ZsX8f0n03UdmQgF_CLvNR2vg.ttf\";s:6:\"italic\";s:112:\"http://themes.googleusercontent.com/static/fonts/expletussans/v4/Y-erXmY0b6DU_i2Qu0hTJj4G9C9ttb0Oz5Cvf0qOitE.ttf\";s:3:\"500\";s:112:\"http://themes.googleusercontent.com/static/fonts/expletussans/v4/cl6rhMY77Ilk8lB_uYRRwAqQmZ7VjhwksfpNVG0pqGc.ttf\";s:9:\"500italic\";s:112:\"http://themes.googleusercontent.com/static/fonts/expletussans/v4/sRBNtc46w65uJE451UYmW87DCVO6wo6i5LKIyZDzK40.ttf\";s:3:\"600\";s:112:\"http://themes.googleusercontent.com/static/fonts/expletussans/v4/cl6rhMY77Ilk8lB_uYRRwCvj1tU7IJMS3CS9kCx2B3U.ttf\";s:9:\"600italic\";s:112:\"http://themes.googleusercontent.com/static/fonts/expletussans/v4/sRBNtc46w65uJE451UYmW8yKH23ZS6zCKOFHG0e_4JE.ttf\";s:3:\"700\";s:112:\"http://themes.googleusercontent.com/static/fonts/expletussans/v4/cl6rhMY77Ilk8lB_uYRRwFCbmAUID8LN-q3pJpOk3Ys.ttf\";s:9:\"700italic\";s:112:\"http://themes.googleusercontent.com/static/fonts/expletussans/v4/sRBNtc46w65uJE451UYmW5F66r9C4AnxxlBlGd7xY4g.ttf\";}}i:337;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Lustria\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/lustria/v1/gXAk0s4ai0X-TAOhYzZd1w.ttf\";}}i:338;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Numans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/numans/v3/g5snI2p6OEjjTNmTHyBdiQ.ttf\";}}i:339;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Redressed\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/redressed/v3/3aZ5sTBppH3oSm5SabegtA.ttf\";}}i:340;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Over the Rainbow\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:114:\"http://themes.googleusercontent.com/static/fonts/overtherainbow/v4/6gp-gkpI2kie2dHQQLM2jQBdxkZd83xOSx-PAQ2QmiI.ttf\";}}i:341;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Baumans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/baumans/v2/o0bFdPW1H5kd5saqqOcoVg.ttf\";}}i:342;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Kelly Slab\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:9:\"latin-ext\";i:1;s:8:\"cyrillic\";i:2;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/kellyslab/v3/F_2oS1e9XdYx1MAi8XEVefesZW2xOQ-xsNqO47m55DA.ttf\";}}i:343;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Norican\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/norican/v1/SHnSqhYAWG5sZTWcPzEHig.ttf\";}}i:344;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Iceland\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/iceland/v2/kq3uTMGgvzWGNi39B_WxGA.ttf\";}}i:345;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Skranji\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-08-23\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/skranji/v1/jnOLPS0iZmDL7dfWnW3nIw.ttf\";s:3:\"700\";s:107:\"http://themes.googleusercontent.com/static/fonts/skranji/v1/Lcrhg-fviVkxiEgoadsI1vesZW2xOQ-xsNqO47m55DA.ttf\";}}i:346;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Niconne\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/niconne/v3/ZA-mFw2QNXodx5y7kfELBg.ttf\";}}i:347;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:17:\"Cinzel Decorative\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:3:\"700\";i:2;s:3:\"900\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-10-26\";s:5:\"files\";O:8:\"stdClass\":3:{s:7:\"regular\";s:116:\"http://themes.googleusercontent.com/static/fonts/cinzeldecorative/v1/fmgK7oaJJIXAkhd9798yQgT5USbJx2F82lQbogPy2bY.ttf\";s:3:\"700\";s:116:\"http://themes.googleusercontent.com/static/fonts/cinzeldecorative/v1/pXhIVnhFtL_B9Vb1wq2F95-YYVDmZkJErg0zgx9XuZI.ttf\";s:3:\"900\";s:116:\"http://themes.googleusercontent.com/static/fonts/cinzeldecorative/v1/pXhIVnhFtL_B9Vb1wq2F97Khqbv0zQZa0g-9HOXAalU.ttf\";}}i:348;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Vibur\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/vibur/v4/xB9aKsUbJo68XP0bAg2iLw.ttf\";}}i:349;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Cherry Swash\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-10-26\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/cherryswash/v1/HqOk7C7J1TZ5i3L-ejF0vi3USBnSvpkopQaUR-2r7iU.ttf\";s:3:\"700\";s:111:\"http://themes.googleusercontent.com/static/fonts/cherryswash/v1/-CfyMyQqfucZPQNB0nvYyED2ttfZwueP-QU272T9-k4.ttf\";}}i:350;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Delius Unicase\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:113:\"http://themes.googleusercontent.com/static/fonts/deliusunicase/v6/b2sKujV3Q48RV2PQ0k1vqu6rPKfVZo7L2bERcf0BDns.ttf\";s:3:\"700\";s:113:\"http://themes.googleusercontent.com/static/fonts/deliusunicase/v6/7FTMTITcb4dxUp99FAdTqNy5weKXdcrx-wE0cgECMq8.ttf\";}}i:351;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Dorsa\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/dorsa/v4/wCc3cUe6XrmG2LQE6GlIrw.ttf\";}}i:352;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Clicker Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-11-28\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:113:\"http://themes.googleusercontent.com/static/fonts/clickerscript/v1/Zupmk8XwADjufGxWB9KThBnpV0hQCek3EmWnCPrvGRM.ttf\";}}i:353;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Nova Square\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/novasquare/v5/BcBzXoaDzYX78rquGXVuSqCWcynf_cDxXwCLxiixG1c.ttf\";}}i:354;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Oranienbaum\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:12:\"cyrillic-ext\";i:1;s:9:\"latin-ext\";i:2;s:8:\"cyrillic\";i:3;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-08-23\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/oranienbaum/v1/M98jYwCSn0PaFhXXgviCoaCWcynf_cDxXwCLxiixG1c.ttf\";}}i:355;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Quintessential\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-11-28\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:114:\"http://themes.googleusercontent.com/static/fonts/quintessential/v1/mmk6ioesnTrEky_Zb92E5s02lXbtMOtZWfuxKeMZO8Q.ttf\";}}i:356;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Simonetta\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"900\";i:3;s:9:\"900italic\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/simonetta/v2/fN8puNuahBo4EYMQgp12Yg.ttf\";s:6:\"italic\";s:109:\"http://themes.googleusercontent.com/static/fonts/simonetta/v2/ynxQ3FqfF_Nziwy3T9ZwL6CWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"900\";s:109:\"http://themes.googleusercontent.com/static/fonts/simonetta/v2/22EwvvJ2r1VwVCxit5LcVi3USBnSvpkopQaUR-2r7iU.ttf\";s:9:\"900italic\";s:109:\"http://themes.googleusercontent.com/static/fonts/simonetta/v2/WUXOpCgBZaRPrWtMCpeKoienaqEuufTBk9XMKnKmgDA.ttf\";}}i:357;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Krona One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/kronaone/v1/zcQj4ljqTo166AdourlF9w.ttf\";}}i:358;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Denk One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2013-11-21\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/denkone/v1/TdXOeA4eA_hEx4W8Sh9wPw.ttf\";}}i:359;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Megrim\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/megrim/v4/e-9jVUC9lv1zxaFQARuftw.ttf\";}}i:360;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Junge\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/junge/v1/j4IXCXtxrw9qIBheercp3A.ttf\";}}i:361;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:18:\"IM Fell English SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:115:\"http://themes.googleusercontent.com/static/fonts/imfellenglishsc/v3/h3Tn6yWfw4b5qaLD1RWvz5ATixNthKRRR1XVH3rJNiw.ttf\";}}i:362;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"PT Mono\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:12:\"cyrillic-ext\";i:1;s:9:\"latin-ext\";i:2;s:8:\"cyrillic\";i:3;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2013-04-10\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/ptmono/v1/QUbM8H9yJK5NhpQ0REO6Wg.ttf\";}}i:363;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Prosto One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:9:\"latin-ext\";i:1;s:8:\"cyrillic\";i:2;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/prostoone/v1/bsqnAElAqk9kX7eABTRFJPesZW2xOQ-xsNqO47m55DA.ttf\";}}i:364;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:18:\"IM Fell DW Pica SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:114:\"http://themes.googleusercontent.com/static/fonts/imfelldwpicasc/v3/xBKKJV4z2KsrtQnmjGO17JZ9RBdEL0H9o5qzT1Rtof4.ttf\";}}i:365;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Hanuman\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/hanuman/v5/hRhwOGGmElJSl6KSPvEnOQ.ttf\";s:3:\"700\";s:107:\"http://themes.googleusercontent.com/static/fonts/hanuman/v5/lzzXZ2l84x88giDrbfq76vesZW2xOQ-xsNqO47m55DA.ttf\";}}i:366;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Capriola\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/capriola/v1/JxXPlkdzWwF9Cwelbvi9jA.ttf\";}}i:367;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Mr Dafoe\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/mrdafoe/v2/s32Q1S6ZkT7EaX53mUirvQ.ttf\";}}i:368;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Sigmar One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-08-08\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/sigmarone/v3/oh_5NxD5JBZksdo2EntKefesZW2xOQ-xsNqO47m55DA.ttf\";}}i:369;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Imprima\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/imprima/v1/eRjquWLjwLGnTEhLH7u3kA.ttf\";}}i:370;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Nova Mono\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:5:\"greek\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/novamono/v4/6-SChr5ZIaaasJFBkgrLNw.ttf\";}}i:371;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Buda\";s:8:\"variants\";a:1:{i:0;s:3:\"300\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:3:\"300\";s:83:\"http://themes.googleusercontent.com/static/fonts/buda/v3/hLtAmNUmEMJH2yx7NGUjnA.ttf\";}}i:372;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Chelsea Market\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:113:\"http://themes.googleusercontent.com/static/fonts/chelseamarket/v1/qSdzwh2A4BbNemy78sJLfAAI1i8fIftCBXsBF2v9UMI.ttf\";}}i:373;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"GFS Didot\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"greek\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/gfsdidot/v3/jQKxZy2RU-h9tkPZcRVluA.ttf\";}}i:374;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Codystar\";s:8:\"variants\";a:2:{i:0;s:3:\"300\";i:1;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:3:\"300\";s:108:\"http://themes.googleusercontent.com/static/fonts/codystar/v1/EVaUzfJkcb8Zqx9kzQLXqqCWcynf_cDxXwCLxiixG1c.ttf\";s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/codystar/v1/EN-CPFKYowSI7SuR7-0cZA.ttf\";}}i:375;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Londrina Solid\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:113:\"http://themes.googleusercontent.com/static/fonts/londrinasolid/v1/yysorIEiYSBb0ylZjg791MR125CwGqh8XBqkBzea0LA.ttf\";}}i:376;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Italianno\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/italianno/v3/HsyHnLpKf8uP7aMpDQHZmg.ttf\";}}i:377;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Holtwood One SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:113:\"http://themes.googleusercontent.com/static/fonts/holtwoodonesc/v4/sToOq3cIxbfnhbEkgYNuBbAgSRh1LpJXlLfl8IbsmHg.ttf\";}}i:378;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:18:\"Swanky and Moo Moo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:115:\"http://themes.googleusercontent.com/static/fonts/swankyandmoomoo/v3/orVNZ9kDeE3lWp3U3YELu9DVLKqNC3_XMNHhr8S94FU.ttf\";}}i:379;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Medula One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/medulaone/v3/AasPgDQak81dsTGQHc5zUPesZW2xOQ-xsNqO47m55DA.ttf\";}}i:380;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Galdeano\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/galdeano/v3/ZKFMQI6HxEG1jOT0UGSZUg.ttf\";}}i:381;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Vast Shadow\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/vastshadow/v3/io4hqKX3ibiqQQjYfW0-h6CWcynf_cDxXwCLxiixG1c.ttf\";}}i:382;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Meddon\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/meddon/v4/f8zJO98uu2EtSj9p7ci9RA.ttf\";}}i:383;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"MedievalSharp\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:113:\"http://themes.googleusercontent.com/static/fonts/medievalsharp/v5/85X_PjV6tftJ0-rX7KYQkOe45sJkivqprK7VkUlzfg0.ttf\";}}i:384;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Unica One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-10-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/unicaone/v1/KbYKlhWMDpatWViqDkNQgA.ttf\";}}i:385;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:23:\"IM Fell Great Primer SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:119:\"http://themes.googleusercontent.com/static/fonts/imfellgreatprimersc/v3/A313vRj97hMMGFjt6rgSJtRg-ciw1Y27JeXb2Zv4lZQ.ttf\";}}i:386;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Belgrano\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/belgrano/v3/iq8DUa2s7g6WRCeMiFrmtQ.ttf\";}}i:387;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:20:\"IM Fell French Canon\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:117:\"http://themes.googleusercontent.com/static/fonts/imfellfrenchcanon/v3/iKB0WL1BagSpNPz3NLMdsJ3V2FNpBrlLSvqUnERhBP8.ttf\";s:6:\"italic\";s:117:\"http://themes.googleusercontent.com/static/fonts/imfellfrenchcanon/v3/owCuNQkLLFW7TBBPJbMnhRa-QL94KdW80H29tcyld2A.ttf\";}}i:388;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Voces\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/voces/v1/QoBH6g6yKgNIgvL8A2aE2Q.ttf\";}}i:389;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Finger Paint\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-10-03\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/fingerpaint/v1/m_ZRbiY-aPb13R3DWPBGXy3USBnSvpkopQaUR-2r7iU.ttf\";}}i:390;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Sonsie One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/sonsieone/v2/KSP7xT1OSy0q2ob6RQOTWPesZW2xOQ-xsNqO47m55DA.ttf\";}}i:391;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Unna\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:83:\"http://themes.googleusercontent.com/static/fonts/unna/v5/UAS0AM7AmbdCNY_80xyAZQ.ttf\";}}i:392;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:19:\"IM Fell Double Pica\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:116:\"http://themes.googleusercontent.com/static/fonts/imfelldoublepica/v3/yN1wY_01BkQnO0LYAhXdUol14jEdVOhEmvtCMCVwYak.ttf\";s:6:\"italic\";s:116:\"http://themes.googleusercontent.com/static/fonts/imfelldoublepica/v3/64odUh2hAw8D9dkFKTlWYq0AWwkgdQfsRHec8TYi4mI.ttf\";}}i:393;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Life Savers\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-12-17\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/lifesavers/v3/g49cUDk4Y1P0G5NMkMAm7qCWcynf_cDxXwCLxiixG1c.ttf\";s:3:\"700\";s:110:\"http://themes.googleusercontent.com/static/fonts/lifesavers/v3/THQKqChyYUm97rNPVFdGGXe1Pd76Vl7zRpE7NLJQ7XU.ttf\";}}i:394;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Mate SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/matesc/v2/-YkIT2TZoPZF6pawKzDpWw.ttf\";}}i:395;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Wellfleet\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/wellfleet/v1/J5tOx72iFRPgHYpbK9J4XQ.ttf\";}}i:396;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Share Tech\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-11-28\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/sharetech/v1/Dq3DuZ5_0SW3oEfAWFpen_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:397;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Knewave\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/knewave/v2/KGHM4XWr4iKnBMqzZLkPBg.ttf\";}}i:398;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Press Start 2P\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:9:\"latin-ext\";i:1;s:8:\"cyrillic\";i:2;s:5:\"greek\";i:3;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:112:\"http://themes.googleusercontent.com/static/fonts/pressstart2p/v1/8Lg6LX8-ntOHUQnvQ0E7o1jfl3W46Sz5gOkEVhcFWF4.ttf\";}}i:399;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Fjord One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/fjordone/v2/R_YHK8au2uFPw5tNu5N7zw.ttf\";}}i:400;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Donegal One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-12-14\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/donegalone/v1/6kN4-fDxz7T9s5U61HwfF6CWcynf_cDxXwCLxiixG1c.ttf\";}}i:401;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Euphoria Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:114:\"http://themes.googleusercontent.com/static/fonts/euphoriascript/v1/c4XB4Iijj_NvSsCF4I0O2MxLhO8OSNnfAp53LK1_iRs.ttf\";}}i:402;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Marcellus\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-10-03\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/marcellus/v1/UjiLZzumxWC9whJ86UtaYw.ttf\";}}i:403;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Candal\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/candal/v3/x44dDW28zK7GR1gGDBmj9g.ttf\";}}i:404;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"VT323\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/vt323/v4/ITU2YQfM073o1iYK3nSOmQ.ttf\";}}i:405;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Fanwood Text\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/fanwoodtext/v3/hDNDHUlsSb8bgnEmDp4T_i3USBnSvpkopQaUR-2r7iU.ttf\";s:6:\"italic\";s:111:\"http://themes.googleusercontent.com/static/fonts/fanwoodtext/v3/0J3SBbkMZqBV-3iGxs5E9_MZXuCXbOrAvx5R0IT5Oyo.ttf\";}}i:406;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Amethysta\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/amethysta/v1/1jEo9tOFIJDolAUpBnWbnA.ttf\";}}i:407;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Bowlby One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/bowlbyone/v4/eKpHjHfjoxM2bX36YNucefesZW2xOQ-xsNqO47m55DA.ttf\";}}i:408;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Monoton\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/monoton/v3/aCz8ja_bE4dg-7agSvExdw.ttf\";}}i:409;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Average\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-11-28\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/average/v1/aHUibBqdDbVYl5FM48pxyQ.ttf\";}}i:410;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Gilda Display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-11-28\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:112:\"http://themes.googleusercontent.com/static/fonts/gildadisplay/v1/8yAVUZLLZ3wb7dSsjix0CADHmap7fRWINAsw8-RaxNg.ttf\";}}i:411;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Oldenburg\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/oldenburg/v1/dqA_M_uoCVXZbCO-oKBTnQ.ttf\";}}i:412;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Graduate\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/graduate/v1/JpAmYLHqcIh9_Ff35HHwiA.ttf\";}}i:413;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Patrick Hand SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:9:\"latin-ext\";i:1;s:10:\"vietnamese\";i:2;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2013-02-27\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:113:\"http://themes.googleusercontent.com/static/fonts/patrickhandsc/v1/OYFWCgfCR-7uHIovjUZXsbAgSRh1LpJXlLfl8IbsmHg.ttf\";}}i:414;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"League Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:112:\"http://themes.googleusercontent.com/static/fonts/leaguescript/v4/wnRFLvfabWK_DauqppD6vSeUSrabuTpOsMEiRLtKwk0.ttf\";}}i:415;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Alef\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2013-05-22\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:83:\"http://themes.googleusercontent.com/static/fonts/alef/v1/ENvZ_P0HBDQxNZYCQO0lUA.ttf\";s:3:\"700\";s:83:\"http://themes.googleusercontent.com/static/fonts/alef/v1/VDgZJhEwudtOzOFQpZ8MEA.ttf\";}}i:416;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Miltonian Tattoo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:115:\"http://themes.googleusercontent.com/static/fonts/miltoniantattoo/v6/1oU_8OGYwW46eh02YHydn2uk0YtI6thZkz1Hmh-odwg.ttf\";}}i:417;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Geostar Fill\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/geostarfill/v3/Y5ovXPPOHYTfQzK2aM-hui3USBnSvpkopQaUR-2r7iU.ttf\";}}i:418;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Oxygen Mono\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-09-14\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/oxygenmono/v1/DigTu7k4b7OmM8ubt1Qza6CWcynf_cDxXwCLxiixG1c.ttf\";}}i:419;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Ruslan Display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:4:{i:0;s:12:\"cyrillic-ext\";i:1;s:9:\"latin-ext\";i:2;s:8:\"cyrillic\";i:3;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:113:\"http://themes.googleusercontent.com/static/fonts/ruslandisplay/v4/SREdhlyLNUfU1VssRBfs3rgH88D3l9N4auRNHrNS708.ttf\";}}i:420;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Rammetto One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/rammettoone/v2/mh0uQ1tV8QgSx9v_KyEYPC3USBnSvpkopQaUR-2r7iU.ttf\";}}i:421;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:23:\"IM Fell French Canon SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:119:\"http://themes.googleusercontent.com/static/fonts/imfellfrenchcanonsc/v3/kA3bS19-tQbeT_iG32EZmaiyyzHwYrAbmNulTz423iM.ttf\";}}i:422;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:20:\"IM Fell Great Primer\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:117:\"http://themes.googleusercontent.com/static/fonts/imfellgreatprimer/v3/AL8ALGNthei20f9Cu3e93rgeX3ROgtTz44CitKAxzKI.ttf\";s:6:\"italic\";s:117:\"http://themes.googleusercontent.com/static/fonts/imfellgreatprimer/v3/1a-artkXMVg682r7TTxVY1_YG2SFv8Ma7CxRl1S3o7g.ttf\";}}i:423;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Artifika\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/artifika/v3/Ekfp4H4QG7D-WsABDOyj8g.ttf\";}}i:424;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Qwigley\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/qwigley/v3/aDqxws-KubFID85TZHFouw.ttf\";}}i:425;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Zeyada\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/zeyada/v3/hmonmGYYFwqTZQfG2nRswQ.ttf\";}}i:426;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Wallpoet\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/wallpoet/v4/hmum4WuBN4A0Z_7367NDIg.ttf\";}}i:427;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Linden Hill\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/lindenhill/v3/UgsC0txqd-E1yjvjutwm_KCWcynf_cDxXwCLxiixG1c.ttf\";s:6:\"italic\";s:110:\"http://themes.googleusercontent.com/static/fonts/lindenhill/v3/OcS3bZcu8vJvIDH8Zic83keOrDcLawS7-ssYqLr2Xp4.ttf\";}}i:428;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Smokum\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/smokum/v3/8YP4BuAcy97X8WfdKfxVRw.ttf\";}}i:429;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Mate\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:83:\"http://themes.googleusercontent.com/static/fonts/mate/v2/ooFviPcJ6hZP5bAE71Cawg.ttf\";s:6:\"italic\";s:83:\"http://themes.googleusercontent.com/static/fonts/mate/v2/5XwW6_cbisGvCX5qmNiqfA.ttf\";}}i:430;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Petrona\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/petrona/v2/nnQwxlP6dhrGovYEFtemTg.ttf\";}}i:431;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Creepster\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/creepster/v2/0vdr5kWJ6aJlOg5JvxnXzQ.ttf\";}}i:432;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Della Respira\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:112:\"http://themes.googleusercontent.com/static/fonts/dellarespira/v1/F4E6Lo_IZ6L9AJCcbqtDVeDcg5akpSnIcsPhLOFv7l8.ttf\";}}i:433;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Trochut\";s:8:\"variants\";a:3:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":3:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/trochut/v1/6Y65B0x-2JsnYt16OH5omw.ttf\";s:6:\"italic\";s:86:\"http://themes.googleusercontent.com/static/fonts/trochut/v1/pczUwr4ZFvC79TgNO5cZng.ttf\";s:3:\"700\";s:107:\"http://themes.googleusercontent.com/static/fonts/trochut/v1/lWqNOv6ISR8ehNzGLFLnJ_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:434;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"UnifrakturCook\";s:8:\"variants\";a:1:{i:0;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:3:\"700\";s:114:\"http://themes.googleusercontent.com/static/fonts/unifrakturcook/v5/ASwh69ykD8iaoYijVEU6RrWZkcsCTHKV51zmcUsafQ0.ttf\";}}i:435;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Yeseva One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:9:\"latin-ext\";i:1;s:8:\"cyrillic\";i:2;s:5:\"latin\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2012-09-26\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/yesevaone/v6/eenQQxvpzSA80JmisGcgX_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:436;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Julee\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/julee/v3/CAib-jsUsSO8SvVRnE9fHA.ttf\";}}i:437;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Poller One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/pollerone/v3/dkctmDlTPcZ6boC8662RA_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:438;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Montaga\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/montaga/v1/PwTwUboiD-M4-mFjZfJs2A.ttf\";}}i:439;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Duru Sans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-08-23\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/durusans/v3/R1xHvAOARPh8_so9_UKw1w.ttf\";}}i:440;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"GFS Neohellenic\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"greek\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:114:\"http://themes.googleusercontent.com/static/fonts/gfsneohellenic/v4/B4xRqbn-tANVqVgamMsSDiayCZa0z7CpFzlkqoCHztc.ttf\";s:6:\"italic\";s:114:\"http://themes.googleusercontent.com/static/fonts/gfsneohellenic/v4/KnaWrO4awITAqigQIIYXKkCTdomiyJpIzPbEbIES3rU.ttf\";s:3:\"700\";s:114:\"http://themes.googleusercontent.com/static/fonts/gfsneohellenic/v4/7HwjPQa7qNiOsnUce2h4448_BwCLZY3eDSV6kppAwI8.ttf\";s:9:\"700italic\";s:114:\"http://themes.googleusercontent.com/static/fonts/gfsneohellenic/v4/FwWjoX6XqT-szJFyqsu_GYFF0fM4h-krcpQk7emtCpE.ttf\";}}i:441;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Bubblegum Sans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:113:\"http://themes.googleusercontent.com/static/fonts/bubblegumsans/v2/Y9iTUUNz6lbl6TrvV4iwsytnKWgpfO2iSkLzTz-AABg.ttf\";}}i:442;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Rufina\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-11-28\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/rufina/v1/s9IFr_fIemiohfZS-ZRDbQ.ttf\";s:3:\"700\";s:85:\"http://themes.googleusercontent.com/static/fonts/rufina/v1/D0RUjXFr55y4MVZY2Ww_RA.ttf\";}}i:443;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Sniglet\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"800\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2013-09-26\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/sniglet/v4/XWhyQLHH4SpCVsHRPRgu9w.ttf\";s:3:\"800\";s:107:\"http://themes.googleusercontent.com/static/fonts/sniglet/v4/NLF91nBmcEfkBgcEWbHFa_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:444;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Astloch\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/astloch/v3/fmbitVmHYLQP7MGPuFgpag.ttf\";s:3:\"700\";s:107:\"http://themes.googleusercontent.com/static/fonts/astloch/v3/aPkhM2tL-tz1jX6aX2rvo_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:445;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:20:\"Montserrat Subrayada\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-10-03\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:119:\"http://themes.googleusercontent.com/static/fonts/montserratsubrayada/v1/nzoCWCz0e9c7Mr2Gl8bbgrJymm6ilkk9f0nDA_sC_qk.ttf\";s:3:\"700\";s:119:\"http://themes.googleusercontent.com/static/fonts/montserratsubrayada/v1/wf-IKpsHcfm0C9uaz9IeGJvEcF1LWArDbGWgKZSH9go.ttf\";}}i:446;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Irish Grover\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/irishgrover/v3/kUp7uUPooL-KsLGzeVJbBC3USBnSvpkopQaUR-2r7iU.ttf\";}}i:447;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Mr De Haviland\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:112:\"http://themes.googleusercontent.com/static/fonts/mrdehaviland/v2/fD8y4L6PJ4vqDk7z8Y8e27v4lrhng1lzu7-weKO6cw8.ttf\";}}i:448;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Rouge Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/rougescript/v2/AgXDSqZJmy12qS0ixjs6Vy3USBnSvpkopQaUR-2r7iU.ttf\";}}i:449;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Dynalight\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/dynalight/v2/-CWsIe8OUDWTIHjSAh41kA.ttf\";}}i:450;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Pirata One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-11-28\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/pirataone/v1/WnbD86B4vB2ckYcL7oxuhvesZW2xOQ-xsNqO47m55DA.ttf\";}}i:451;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Shojumaru\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/shojumaru/v1/WP8cxonzQQVAoI3RJQ2wug.ttf\";}}i:452;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:22:\"IM Fell Double Pica SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:118:\"http://themes.googleusercontent.com/static/fonts/imfelldoublepicasc/v3/jkrUtrLFpMw4ZazhfkKsGwc4LoC4OJUqLw9omnT3VOU.ttf\";}}i:453;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:17:\"Carrois Gothic SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-10-03\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:115:\"http://themes.googleusercontent.com/static/fonts/carroisgothicsc/v1/bVp4nhwFIXU-r3LqUR8DSJTdPW1ioadGi2uRiKgJVCY.ttf\";}}i:454;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Gravitas One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/gravitasone/v3/nBHdBv6zVNU8MtP6w9FwTS3USBnSvpkopQaUR-2r7iU.ttf\";}}i:455;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Nova Slim\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/novaslim/v5/rPYXC81_VL2EW-4CzBX65g.ttf\";}}i:456;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Prociono\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/prociono/v3/43ZYDHWogdFeNBWTl6ksmw.ttf\";}}i:457;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Overlock SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/overlocksc/v2/8D7HYDsvS_g1GhBnlHzgzaCWcynf_cDxXwCLxiixG1c.ttf\";}}i:458;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Bigshot One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/bigshotone/v3/wSyZjBNTWDQHnvWE2jt6j6CWcynf_cDxXwCLxiixG1c.ttf\";}}i:459;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Nova Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/novascript/v5/dEvxQDLgx1M1TKY-NmBWYaCWcynf_cDxXwCLxiixG1c.ttf\";}}i:460;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Amarante\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/amarante/v1/2dQHjIBWSpydit5zkJZnOw.ttf\";}}i:461;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Kenia\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-08-01\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/kenia/v5/OLM9-XfITK9PsTLKbGBrwg.ttf\";}}i:462;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Lily Script One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2013-06-12\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:113:\"http://themes.googleusercontent.com/static/fonts/lilyscriptone/v1/uPWsLVW8uiXqIBnE8ZwGPDjVlsJB_M_Q_LtZxsoxvlw.ttf\";}}i:463;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Monofett\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/monofett/v3/C6K5L799Rgxzg2brgOaqAw.ttf\";}}i:464;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Cutive Mono\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-10-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/cutivemono/v1/ncWQtFVKcSs8OW798v30k6CWcynf_cDxXwCLxiixG1c.ttf\";}}i:465;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Sail\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:83:\"http://themes.googleusercontent.com/static/fonts/sail/v3/iuEoG6kt-bePGvtdpL0GUQ.ttf\";}}i:466;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Alike Angular\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:112:\"http://themes.googleusercontent.com/static/fonts/alikeangular/v3/OpeCu4xxI3qO1C7CZcJtPT3XH2uEnVI__ynTBvNyki8.ttf\";}}i:467;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Nova Flat\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/novaflat/v5/pK7a0CoGzI684qe_XSHBqQ.ttf\";}}i:468;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Bilbo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/bilbo/v3/-ty-lPs5H7OIucWbnpFrkA.ttf\";}}i:469;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Smythe\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/smythe/v4/yACD1gy_MpbB9Ft42fUvYw.ttf\";}}i:470;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Arizonia\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/arizonia/v3/yzJqkHZqryZBTM7RKYV9Wg.ttf\";}}i:471;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Trade Winds\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/tradewinds/v2/sDOCVgAxw6PEUi2xdMsoDaCWcynf_cDxXwCLxiixG1c.ttf\";}}i:472;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:21:\"Stint Ultra Condensed\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:119:\"http://themes.googleusercontent.com/static/fonts/stintultracondensed/v2/8DqLK6-YSClFZt3u3EgOUYelbRYnLTTQA1Z5cVLnsI4.ttf\";}}i:473;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Ranchers\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-09-14\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/ranchers/v1/9ya8CZYhqT66VERfjQ7eLA.ttf\";}}i:474;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Lovers Quarrel\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:113:\"http://themes.googleusercontent.com/static/fonts/loversquarrel/v1/gipdZ8b7pKb89MzQLAtJHLHLxci2ElvNEmOB303HLk0.ttf\";}}i:475;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:23:\"Jacques Francois Shadow\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-09-14\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:121:\"http://themes.googleusercontent.com/static/fonts/jacquesfrancoisshadow/v1/V14y0H3vq56fY9SV4OL_FASt0D_oLVawA8L8b9iKjbs.ttf\";}}i:476;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Balthazar\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/balthazar/v2/WgbaSIs6dJAGXJ0qbz2xlw.ttf\";}}i:477;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Modern Antiqua\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:113:\"http://themes.googleusercontent.com/static/fonts/modernantiqua/v3/8qX_tr6Xzy4t9fvZDXPkh6rFJ4O13IHVxZbM6yoslpo.ttf\";}}i:478;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Flamenco\";s:8:\"variants\";a:2:{i:0;s:3:\"300\";i:1;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:3:\"300\";s:108:\"http://themes.googleusercontent.com/static/fonts/flamenco/v3/x9iI5CogvuZVCGoRHwXuo6CWcynf_cDxXwCLxiixG1c.ttf\";s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/flamenco/v3/HC0ugfLLgt26I5_BWD1PZA.ttf\";}}i:479;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Molle\";s:8:\"variants\";a:1:{i:0;s:6:\"italic\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-09-26\";s:5:\"files\";O:8:\"stdClass\":1:{s:6:\"italic\";s:84:\"http://themes.googleusercontent.com/static/fonts/molle/v1/9XTdCsjPXifLqo5et-YoGA.ttf\";}}i:480;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Bilbo Swash Caps\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:114:\"http://themes.googleusercontent.com/static/fonts/bilboswashcaps/v4/UB_-crLvhx-PwGKW1oosDmYeFSdnSpRYv5h9gpdlD1g.ttf\";}}i:481;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Gabriela\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2013-03-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/gabriela/v1/B-2ZfbAO3HDrxqV6lR5tdA.ttf\";}}i:482;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Engagement\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/engagement/v2/4Uz0Jii7oVPcaFRYmbpU6vesZW2xOQ-xsNqO47m55DA.ttf\";}}i:483;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Text Me One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-11-28\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/textmeone/v1/9em_3ckd_P5PQkP4aDyDLqCWcynf_cDxXwCLxiixG1c.ttf\";}}i:484;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Port Lligat Sans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:114:\"http://themes.googleusercontent.com/static/fonts/portlligatsans/v2/CUEdhRk7oC7up0p6t0g4P6mASEpx5X0ZpsuJOuvfOGA.ttf\";}}i:485;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Milonga\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-12-06\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/milonga/v1/dzNdIUSTGFmy2ahovDRcWg.ttf\";}}i:486;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Nosifer\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/nosifer/v2/7eJGoIuHRrtcG00j6CptSA.ttf\";}}i:487;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Goblin One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/goblinone/v3/331XtzoXgpVEvNTVcBJ_C_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:488;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Nova Oval\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/novaoval/v5/VuukVpKP8BwUf8o9W5LYQQ.ttf\";}}i:489;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Condiment\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/condiment/v1/CstmdiPpgFSV0FUNL5LrJA.ttf\";}}i:490;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Snowburst One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-12-17\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:112:\"http://themes.googleusercontent.com/static/fonts/snowburstone/v1/zSQzKOPukXRux2oTqfYJjIjjx0o0jr6fNXxPgYh_a8Q.ttf\";}}i:491;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Asset\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/asset/v3/hfPmqY-JzuR1lULlQf9iTg.ttf\";}}i:492;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Cagliostro\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/cagliostro/v2/i85oXbtdSatNEzss99bpj_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:493;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Kite One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-10-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/kiteone/v1/8ojWmgUc97m0f_i6sTqLoQ.ttf\";}}i:494;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Raleway Dots\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-09-14\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/ralewaydots/v1/lhLgmWCRcyz-QXo8LCzTfC3USBnSvpkopQaUR-2r7iU.ttf\";}}i:495;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Rosarivo\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/rosarivo/v1/EmPiINK0qyqc7KSsNjJamA.ttf\";s:6:\"italic\";s:108:\"http://themes.googleusercontent.com/static/fonts/rosarivo/v1/u3VuWsWQlX1pDqsbz4paNPesZW2xOQ-xsNqO47m55DA.ttf\";}}i:496;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Oregano\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-08-16\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/oregano/v1/UiLhqNixVv2EpjRoBG6axA.ttf\";s:6:\"italic\";s:86:\"http://themes.googleusercontent.com/static/fonts/oregano/v1/_iwqGEht6XsAuEaCbYG64Q.ttf\";}}i:497;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Ledger\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:9:\"latin-ext\";i:1;s:8:\"cyrillic\";i:2;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/ledger/v1/G432jp-tahOfWHbCYkI0jw.ttf\";}}i:498;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Geostar\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/geostar/v3/A8WQbhQbpYx3GWWaShJ9GA.ttf\";}}i:499;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Lancelot\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/lancelot/v2/XMT7T_oo_MQUGAnU2v-sdA.ttf\";}}i:500;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Iceberg\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/iceberg/v1/p2XVm4M-N0AOEEOymFKC5w.ttf\";}}i:501;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Ruluko\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/ruluko/v1/lv4cMwJtrx_dzmlK5SDc1g.ttf\";}}i:502;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:3:\"Rye\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-08-23\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:82:\"http://themes.googleusercontent.com/static/fonts/rye/v1/VUrJlpPpSZxspl3w_yNOrQ.ttf\";}}i:503;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Gorditas\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-09-14\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/gorditas/v1/uMgZhXUyH6qNGF3QsjQT5Q.ttf\";s:3:\"700\";s:108:\"http://themes.googleusercontent.com/static/fonts/gorditas/v1/6-XCeknmxaon8AUqVkMnHaCWcynf_cDxXwCLxiixG1c.ttf\";}}i:504;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Fresca\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/fresca/v2/2q7Qm9sCo1tWvVgSDVWNIw.ttf\";}}i:505;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Passero One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/passeroone/v5/Yc-7nH5deCCv9Ed0MMnAQqCWcynf_cDxXwCLxiixG1c.ttf\";}}i:506;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Nova Cut\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/novacut/v5/6q12jWcBvj0KO2cMRP97tA.ttf\";}}i:507;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Esteban\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/esteban/v1/ESyhLgqDDyK5JcFPp2svDw.ttf\";}}i:508;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Elsie Swash Caps\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"900\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-12-14\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:114:\"http://themes.googleusercontent.com/static/fonts/elsieswashcaps/v1/9L3hIJMPCf6sxCltnxd6X2YeFSdnSpRYv5h9gpdlD1g.ttf\";s:3:\"900\";s:114:\"http://themes.googleusercontent.com/static/fonts/elsieswashcaps/v1/iZnus9qif0tR5pGaDv5zdKoKBWBozTtxi30NfZDOXXU.ttf\";}}i:509;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Atomic Age\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/atomicage/v3/WvBMe4FxANIKpo6Oi0mVJ_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:510;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Federant\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/federant/v4/tddZFSiGvxICNOGra0i5aA.ttf\";}}i:511;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Miltonian\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/miltonian/v5/Z4HrYZyqm0BnNNzcCUfzoQ.ttf\";}}i:512;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Aubrey\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/aubrey/v5/zo9w8klO8bmOQIMajQ2aTA.ttf\";}}i:513;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Chela One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-10-26\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/chelaone/v1/h5O0dEnpnIq6jQnWxZybrA.ttf\";}}i:514;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Aladin\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/aladin/v2/PyuJ5cVHkduO0j5fAMKvAA.ttf\";}}i:515;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Henny Penny\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/hennypenny/v1/XRgo3ogXyi3tpsFfjImRF6CWcynf_cDxXwCLxiixG1c.ttf\";}}i:516;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Miniver\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/miniver/v2/4yTQohOH_cWKRS5laRFhYg.ttf\";}}i:517;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Seaweed Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:113:\"http://themes.googleusercontent.com/static/fonts/seaweedscript/v1/eorWAPpOvvWrPw5IHwE60BnpV0hQCek3EmWnCPrvGRM.ttf\";}}i:518;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Cambo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/cambo/v2/PnwpRuTdkYCf8qk4ajmNRA.ttf\";}}i:519;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Averia Libre\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":6:{s:3:\"300\";s:111:\"http://themes.googleusercontent.com/static/fonts/averialibre/v1/r6hGL8sSLm4dTzOPXgx5XacQoVhARpoaILP7amxE_8g.ttf\";s:9:\"300italic\";s:111:\"http://themes.googleusercontent.com/static/fonts/averialibre/v1/I6wAYuAvOgT7el2ePj2nkina0FLWfcB-J_SAYmcAXaI.ttf\";s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/averialibre/v1/rYVgHZZQICWnhjguGsBspC3USBnSvpkopQaUR-2r7iU.ttf\";s:6:\"italic\";s:111:\"http://themes.googleusercontent.com/static/fonts/averialibre/v1/1etzuoNxVHR8F533EkD1WfMZXuCXbOrAvx5R0IT5Oyo.ttf\";s:3:\"700\";s:111:\"http://themes.googleusercontent.com/static/fonts/averialibre/v1/r6hGL8sSLm4dTzOPXgx5XUD2ttfZwueP-QU272T9-k4.ttf\";s:9:\"700italic\";s:111:\"http://themes.googleusercontent.com/static/fonts/averialibre/v1/I6wAYuAvOgT7el2ePj2nkvAs9-1nE9qOqhChW0m4nDE.ttf\";}}i:520;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Supermercado One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-08-23\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:115:\"http://themes.googleusercontent.com/static/fonts/supermercadoone/v3/kMGPVTNFiFEp1U274uBMb4mm5hmSKNFf3C5YoMa-lrM.ttf\";}}i:521;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Concert One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/concertone/v4/N5IWCIGhUNdPZn_efTxKN6CWcynf_cDxXwCLxiixG1c.ttf\";}}i:522;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:20:\"Monsieur La Doulaise\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:118:\"http://themes.googleusercontent.com/static/fonts/monsieurladoulaise/v2/IMAdMj6Eq9jZ46CPctFtMKP61oAqTJXlx5ZVOBmcPdM.ttf\";}}i:523;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Stoke\";s:8:\"variants\";a:2:{i:0;s:3:\"300\";i:1;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-08-08\";s:5:\"files\";O:8:\"stdClass\":2:{s:3:\"300\";s:84:\"http://themes.googleusercontent.com/static/fonts/stoke/v3/Sell9475FOS8jUqQsfFsUQ.ttf\";s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/stoke/v3/A7qJNoqOm2d6o1E6e0yUFg.ttf\";}}i:524;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Paprika\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-10-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/paprika/v1/b-VpyoRSieBdB5BPJVF8HQ.ttf\";}}i:525;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Ruthie\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/ruthie/v3/vJ2LorukHSbWYoEs5juivg.ttf\";}}i:526;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:17:\"Averia Sans Libre\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":6:{s:3:\"300\";s:115:\"http://themes.googleusercontent.com/static/fonts/averiasanslibre/v1/_9-jTfQjaBsWAF_yp5z-V4CP_KG_g80s1KXiBtJHoNc.ttf\";s:9:\"300italic\";s:115:\"http://themes.googleusercontent.com/static/fonts/averiasanslibre/v1/o7BEIK-fG3Ykc5Rzteh88YuyGu4JqttndUh4gRKxic0.ttf\";s:7:\"regular\";s:115:\"http://themes.googleusercontent.com/static/fonts/averiasanslibre/v1/yRJpjT39KxACO9F31mj_LqV8_KRn4epKAjTFK1s1fsg.ttf\";s:6:\"italic\";s:115:\"http://themes.googleusercontent.com/static/fonts/averiasanslibre/v1/COEzR_NPBSUOl3pFwPbPoCZU2HnUZT1xVKaIrHDioao.ttf\";s:3:\"700\";s:115:\"http://themes.googleusercontent.com/static/fonts/averiasanslibre/v1/_9-jTfQjaBsWAF_yp5z-V8QwVOrz1y5GihpZmtKLhlI.ttf\";s:9:\"700italic\";s:115:\"http://themes.googleusercontent.com/static/fonts/averiasanslibre/v1/o7BEIK-fG3Ykc5Rzteh88bXy1DXgmJcVtKjM5UWamMs.ttf\";}}i:527;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:18:\"Averia Serif Libre\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:7:\"regular\";i:3;s:6:\"italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":6:{s:3:\"300\";s:116:\"http://themes.googleusercontent.com/static/fonts/averiaseriflibre/v2/yvITAdr5D1nlsdFswJAb8SmC4gFJ2PHmfdVKEd_5S9M.ttf\";s:9:\"300italic\";s:116:\"http://themes.googleusercontent.com/static/fonts/averiaseriflibre/v2/YOLFXyye4sZt6AZk1QybCG2okl0bU63CauowU4iApig.ttf\";s:7:\"regular\";s:116:\"http://themes.googleusercontent.com/static/fonts/averiaseriflibre/v2/fdtF30xa_Erw0zAzOoG4BZqY66i8AUyI16fGqw0iAew.ttf\";s:6:\"italic\";s:116:\"http://themes.googleusercontent.com/static/fonts/averiaseriflibre/v2/o9qhvK9iT5iDWfyhQUe-6Ru_b0bTq5iipbJ9hhgHJ6U.ttf\";s:3:\"700\";s:116:\"http://themes.googleusercontent.com/static/fonts/averiaseriflibre/v2/yvITAdr5D1nlsdFswJAb8Q50KV5TaOVolur4zV2iZsg.ttf\";s:9:\"700italic\";s:116:\"http://themes.googleusercontent.com/static/fonts/averiaseriflibre/v2/YOLFXyye4sZt6AZk1QybCNxohRXP4tNDqG3X4Hqn21k.ttf\";}}i:528;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Inika\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/inika/v1/eZCrULQGaIxkrRoGz_DjhQ.ttf\";s:3:\"700\";s:84:\"http://themes.googleusercontent.com/static/fonts/inika/v1/bl3ZoTyrWsFun2zYbsgJrA.ttf\";}}i:529;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Griffy\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-09-14\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/griffy/v1/vWkyYGBSyE5xjnShNtJtzw.ttf\";}}i:530;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Croissant One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-11-28\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:112:\"http://themes.googleusercontent.com/static/fonts/croissantone/v1/mPjsOObnC77fp1cvZlOfIYjjx0o0jr6fNXxPgYh_a8Q.ttf\";}}i:531;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Titan One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/titanone/v1/FbvpRvzfV_oipS0De3iAZg.ttf\";}}i:532;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"McLaren\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-08-16\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/mclaren/v1/OprvTGxaiINBKW_1_U0eoQ.ttf\";}}i:533;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Italiana\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/italiana/v1/dt95fkCSTOF-c6QNjwSycA.ttf\";}}i:534;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Aguafina Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:114:\"http://themes.googleusercontent.com/static/fonts/aguafinascript/v2/65g7cgMtMGnNlNyq_Z6CvMxLhO8OSNnfAp53LK1_iRs.ttf\";}}i:535;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Mrs Sheppards\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:112:\"http://themes.googleusercontent.com/static/fonts/mrssheppards/v2/2WFsWMV3VUeCz6UVH7UjCn8f0n03UdmQgF_CLvNR2vg.ttf\";}}i:536;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Habibi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/habibi/v2/YYyqXF6pWpL7kmKgS_2iUA.ttf\";}}i:537;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Jacques Francois\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-09-14\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:115:\"http://themes.googleusercontent.com/static/fonts/jacquesfrancois/v1/_-0XWPQIW6tOzTHg4KaJ_M13D_4KM32Q4UmTSjpuNGQ.ttf\";}}i:538;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Spicy Rice\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/spicyrice/v2/WGCtz7cLoggXARPi9OGD6_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:539;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Bigelow Rules\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-11-28\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:112:\"http://themes.googleusercontent.com/static/fonts/bigelowrules/v1/FEJCPLwo07FS-6SK6Al50X8f0n03UdmQgF_CLvNR2vg.ttf\";}}i:540;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Share Tech Mono\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-11-28\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:113:\"http://themes.googleusercontent.com/static/fonts/sharetechmono/v1/RQxK-3RA0Lnf3gnnnNrAscwD6PD0c3_abh9zHKQtbGU.ttf\";}}i:541;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Khmer\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2013-06-12\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/khmer/v6/vWaBJIbaQuBNz02ALIKJ3A.ttf\";}}i:542;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Caesar Dressing\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:114:\"http://themes.googleusercontent.com/static/fonts/caesardressing/v2/2T_WzBgE2Xz3FsyJMq34T9gR43u4FvCuJwIfF5Zxl6Y.ttf\";}}i:543;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Mystery Quest\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:112:\"http://themes.googleusercontent.com/static/fonts/mysteryquest/v1/467jJvg0c7HgucvBB9PLDyeUSrabuTpOsMEiRLtKwk0.ttf\";}}i:544;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Gafata\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2013-03-07\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/gafata/v2/aTFqlki_3Dc3geo-FxHTvQ.ttf\";}}i:545;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Keania One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-11-28\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/keaniaone/v1/PACrDKZWngXzgo-ucl6buvesZW2xOQ-xsNqO47m55DA.ttf\";}}i:546;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Trykker\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/trykker/v2/YiVrVJpBFN7I1l_CWk6yYQ.ttf\";}}i:547;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Risque\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-11-28\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/risque/v1/92RnElGnl8yHP97-KV3Fyg.ttf\";}}i:548;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Chango\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/chango/v2/3W3AeMMtRTH08t5qLOjBmg.ttf\";}}i:549;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Rum Raisin\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-11-28\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/rumraisin/v1/kDiL-ntDOEq26B7kYM7cx_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:550;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Battambang\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2013-06-12\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/battambang/v6/MzrUfQLefYum5vVGM3EZVPesZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:110:\"http://themes.googleusercontent.com/static/fonts/battambang/v6/dezbRtMzfzAA99DmrCYRMgJKKGfqHaYFsRG-T3ceEVo.ttf\";}}i:551;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Devonshire\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/devonshire/v2/I3ct_2t12SYizP8ZC-KFi_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:552;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Fondamento\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/fondamento/v2/6LWXcjT1B7bnWluAOSNfMPesZW2xOQ-xsNqO47m55DA.ttf\";s:6:\"italic\";s:110:\"http://themes.googleusercontent.com/static/fonts/fondamento/v2/y6TmwhSbZ8rYq7OTFyo7OS3USBnSvpkopQaUR-2r7iU.ttf\";}}i:553;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Suwannaphum\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2013-06-12\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/suwannaphum/v6/1jIPOyXied3T79GCnSlCN6CWcynf_cDxXwCLxiixG1c.ttf\";}}i:554;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Joti One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-11-28\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/jotione/v1/P3r_Th0ESHJdzunsvWgUfQ.ttf\";}}i:555;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Sarina\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/sarina/v2/XYtRfaSknHIU3NHdfTdXoQ.ttf\";}}i:556;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Autour One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-09-26\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/autourone/v1/2xmQBcg7FN72jaQRFZPIDvesZW2xOQ-xsNqO47m55DA.ttf\";}}i:557;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Londrina Shadow\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:114:\"http://themes.googleusercontent.com/static/fonts/londrinashadow/v1/dNYuzPS_7eYgXFJBzMoKdbw6Z3rVA5KDSi7aQxS92Nk.ttf\";}}i:558;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Glass Antiqua\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:112:\"http://themes.googleusercontent.com/static/fonts/glassantiqua/v1/0yLrXKplgdUDIMz5TnCHNODcg5akpSnIcsPhLOFv7l8.ttf\";}}i:559;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Antic Didone\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/anticdidone/v1/r3nJcTDuOluOL6LGDV1vRy3USBnSvpkopQaUR-2r7iU.ttf\";}}i:560;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:20:\"Stint Ultra Expanded\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:118:\"http://themes.googleusercontent.com/static/fonts/stintultraexpanded/v1/FeigX-wDDgHMCKuhekhedQ7dxr0N5HY0cZKknTIL6n4.ttf\";}}i:561;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Princess Sofia\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:113:\"http://themes.googleusercontent.com/static/fonts/princesssofia/v1/8g5l8r9BM0t1QsXLTajDe-wjmA7ie-lFcByzHGRhCIg.ttf\";}}i:562;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Emilys Candy\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/emilyscandy/v1/PofLVm6v1SwZGOzC8s-I3S3USBnSvpkopQaUR-2r7iU.ttf\";}}i:563;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Asul\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:83:\"http://themes.googleusercontent.com/static/fonts/asul/v2/9qpsNR_OOwyOYyo2N0IbBw.ttf\";s:3:\"700\";s:83:\"http://themes.googleusercontent.com/static/fonts/asul/v2/uO8uNmxaq87-DdPmkEg5Gg.ttf\";}}i:564;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Eagle Lake\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/eaglelake/v1/ZKlYin7caemhx9eSg6RvPfesZW2xOQ-xsNqO47m55DA.ttf\";}}i:565;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Piedra\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/piedra/v2/owf-AvEEyAj9LJ2tVZ_3Mw.ttf\";}}i:566;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:19:\"Mrs Saint Delafield\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:117:\"http://themes.googleusercontent.com/static/fonts/mrssaintdelafield/v1/vuWagfFT7bj9lFtZOFBwmjHMBelqWf3tJeGyts2SmKU.ttf\";}}i:567;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Stalemate\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-11-28\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/stalemate/v1/wQLCnG0qB6mOu2Wit2dt_w.ttf\";}}i:568;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Original Surfer\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:114:\"http://themes.googleusercontent.com/static/fonts/originalsurfer/v2/gdHw6HpSIN4D6Xt7pi1-qIkEz33TDwAZczo_6fY7eg0.ttf\";}}i:569;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Germania One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/germaniaone/v1/3_6AyUql_-FbDi1e68jHdC3USBnSvpkopQaUR-2r7iU.ttf\";}}i:570;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Purple Purse\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-11-28\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/purplepurse/v1/Q5heFUrdmei9axbMITxxxS3USBnSvpkopQaUR-2r7iU.ttf\";}}i:571;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Chicle\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/chicle/v2/xg4q57Ut9ZmyFwLp51JLgg.ttf\";}}i:572;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Sevillana\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/sevillana/v1/6m1Nh35oP7YEt00U80Smiw.ttf\";}}i:573;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Offside\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-10-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/offside/v1/v0C913SB8wqQUvcu1faUqw.ttf\";}}i:574;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:15:\"Londrina Sketch\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:114:\"http://themes.googleusercontent.com/static/fonts/londrinasketch/v1/p7Ai06aT1Ycp_D2fyE3z69d6z_uhFGnpCOifUY1fJQo.ttf\";}}i:575;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Nokora\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2012-10-26\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/nokora/v6/dRyz1JfnyKPNaRcBNX9F9A.ttf\";s:3:\"700\";s:85:\"http://themes.googleusercontent.com/static/fonts/nokora/v6/QMqqa4QEOhQpiig3cAPmbQ.ttf\";}}i:576;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Meie Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-08-23\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/meiescript/v1/oTIWE5MmPye-rCyVp_6KEqCWcynf_cDxXwCLxiixG1c.ttf\";}}i:577;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Sofadi One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-10-03\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/sofadione/v1/nirf4G12IcJ6KI8Eoj119fesZW2xOQ-xsNqO47m55DA.ttf\";}}i:578;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Ribeye\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/ribeye/v2/e5w3VE8HnWBln4Ll6lUj3Q.ttf\";}}i:579;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Almendra\";s:8:\"variants\";a:4:{i:0;s:7:\"regular\";i:1;s:6:\"italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-11-28\";s:5:\"files\";O:8:\"stdClass\":4:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/almendra/v5/PDpbB-ZF7deXAAEYPkQOeg.ttf\";s:6:\"italic\";s:108:\"http://themes.googleusercontent.com/static/fonts/almendra/v5/CNWLyiDucqVKVgr4EMidi_esZW2xOQ-xsNqO47m55DA.ttf\";s:3:\"700\";s:108:\"http://themes.googleusercontent.com/static/fonts/almendra/v5/ZpLdQMj7Q2AFio4nNO6A76CWcynf_cDxXwCLxiixG1c.ttf\";s:9:\"700italic\";s:108:\"http://themes.googleusercontent.com/static/fonts/almendra/v5/-tXHKMcnn6FqrhJV3l1e3QJKKGfqHaYFsRG-T3ceEVo.ttf\";}}i:580;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Sirin Stencil\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:112:\"http://themes.googleusercontent.com/static/fonts/sirinstencil/v1/pRpLdo0SawzO7MoBpvowsImg74kgS1F7KeR8rWhYwkU.ttf\";}}i:581;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Butterfly Kids\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:113:\"http://themes.googleusercontent.com/static/fonts/butterflykids/v1/J4NTF5M25htqeTffYImtlUZaDk62iwTBnbnvwSjZciA.ttf\";}}i:582;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Arbutus\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/arbutus/v2/Go_hurxoUsn5MnqNVQgodQ.ttf\";}}i:583;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Bubbler One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-09-14\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/bubblerone/v1/e8S0qevkZAFaBybtt_SU4qCWcynf_cDxXwCLxiixG1c.ttf\";}}i:584;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Galindo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-08-16\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/galindo/v1/2lafAS_ZEfB33OJryhXDUg.ttf\";}}i:585;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Ribeye Marrow\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:112:\"http://themes.googleusercontent.com/static/fonts/ribeyemarrow/v3/q7cBSA-4ErAXBCDFPrhlY0cTNmV93fYG7UKgsLQNQWs.ttf\";}}i:586;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Fascinate\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/fascinate/v2/ZE0637WWkBPKt1AmFaqD3Q.ttf\";}}i:587;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Odor Mean Chey\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:112:\"http://themes.googleusercontent.com/static/fonts/odormeanchey/v5/GK3E7EjPoBkeZhYshGFo0eVKG8sq4NyGgdteJLvqLDs.ttf\";}}i:588;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Jolly Lodger\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/jollylodger/v1/RX8HnkBgaEKQSHQyP9itiS3USBnSvpkopQaUR-2r7iU.ttf\";}}i:589;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Emblema One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/emblemaone/v2/7IlBUjBWPIiw7cr_O2IfSaCWcynf_cDxXwCLxiixG1c.ttf\";}}i:590;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Content\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"700\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/content/v5/l8qaLjygvOkDEU2G6-cjfQ.ttf\";s:3:\"700\";s:107:\"http://themes.googleusercontent.com/static/fonts/content/v5/7PivP8Zvs2qn6F6aNbSQe_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:591;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Eater\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/eater/v2/gm6f3OmYEdbs3lPQtUfBkA.ttf\";}}i:592;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Bokor\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/bokor/v5/uAKdo0A85WW23Gs6mcbw7A.ttf\";}}i:593;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:19:\"Averia Gruesa Libre\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:117:\"http://themes.googleusercontent.com/static/fonts/averiagruesalibre/v1/10vbZTOoN6T8D-nvDzwRFyXcKHuZXlCN8VkWHpkUzKM.ttf\";}}i:594;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Felipa\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/felipa/v1/SeyfyFZY7abAQXGrOIYnYg.ttf\";}}i:595;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Frijole\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/frijole/v2/L2MfZse-2gCascuD-nLhWg.ttf\";}}i:596;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Revalia\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/revalia/v1/1TKw66fF5_poiL0Ktgo4_A.ttf\";}}i:597;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Ewert\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/ewert/v1/Em8hrzuzSbfHcTVqMjbAQg.ttf\";}}i:598;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Freehand\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/freehand/v5/uEBQxvA0lnn_BrD6krlxMw.ttf\";}}i:599;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Peralta\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-08-08\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/peralta/v1/cTJX5KEuc0GKRU9NXSm-8Q.ttf\";}}i:600;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Flavors\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/flavors/v2/SPJi5QclATvon8ExcKGRvQ.ttf\";}}i:601;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:18:\"Macondo Swash Caps\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:116:\"http://themes.googleusercontent.com/static/fonts/macondoswashcaps/v1/SsSR706z-MlvEH7_LS6JAPkkgYRHs6GSG949m-K6x2k.ttf\";}}i:602;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Dr Sugiyama\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/drsugiyama/v2/S5Yx3MIckgoyHhhS4C9Tv6CWcynf_cDxXwCLxiixG1c.ttf\";}}i:603;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Akronim\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-09-26\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/akronim/v1/qA0L2CSArk3tuOWE1AR1DA.ttf\";}}i:604;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Combo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-09-26\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/combo/v1/Nab98KjR3JZSSPGtzLyXNw.ttf\";}}i:605;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Elsie\";s:8:\"variants\";a:2:{i:0;s:7:\"regular\";i:1;s:3:\"900\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-12-14\";s:5:\"files\";O:8:\"stdClass\":2:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/elsie/v1/gwspePauE45BJu6Ok1QrfQ.ttf\";s:3:\"900\";s:84:\"http://themes.googleusercontent.com/static/fonts/elsie/v1/1t-9f0N2NFYwAgN7oaISqg.ttf\";}}i:606;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Angkor\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/angkor/v5/DLpLgIS-8F10ecwKqCm95Q.ttf\";}}i:607;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"New Rocker\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-12-06\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/newrocker/v1/EFUWzHJedEkpW399zYOHofesZW2xOQ-xsNqO47m55DA.ttf\";}}i:608;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Marko One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/markoone/v3/hpP7j861sOAco43iDc4n4w.ttf\";}}i:609;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Romanesco\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2013-12-02\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/romanesco/v2/2udIjUrpK_CPzYSxRVzD4Q.ttf\";}}i:610;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Preahvihear\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/preahvihear/v5/82tDI-xTc53CxxOzEG4hDaCWcynf_cDxXwCLxiixG1c.ttf\";}}i:611;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Margarine\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-11-28\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/margarine/v1/DJnJwIrcO_cGkjSzY3MERw.ttf\";}}i:612;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:20:\"Herr Von Muellerhoff\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2013-12-02\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:118:\"http://themes.googleusercontent.com/static/fonts/herrvonmuellerhoff/v3/mmy24EUmk4tjm4gAEjUd7NLGIYrUsBdh-JWHYgiDiMU.ttf\";}}i:613;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Mr Bedfort\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2013-12-02\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/mrbedfort/v2/81bGgHTRikLs_puEGshl7_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:614;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Miss Fajardose\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2013-12-02\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:113:\"http://themes.googleusercontent.com/static/fonts/missfajardose/v3/WcXjlQPKn6nBfr8LY3ktNu6rPKfVZo7L2bERcf0BDns.ttf\";}}i:615;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Ruge Boogie\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2013-12-02\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/rugeboogie/v4/U-TTmltL8aENLVIqYbI5QaCWcynf_cDxXwCLxiixG1c.ttf\";}}i:616;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Freckle Face\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-11-28\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/freckleface/v1/7-B8j9BPJgazdHIGqPNv8y3USBnSvpkopQaUR-2r7iU.ttf\";}}i:617;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Seymour One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:9:\"latin-ext\";i:1;s:8:\"cyrillic\";i:2;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-10-26\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/seymourone/v1/HrdG2AEG_870Xb7xBVv6C6CWcynf_cDxXwCLxiixG1c.ttf\";}}i:618;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Londrina Outline\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2013-12-02\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:115:\"http://themes.googleusercontent.com/static/fonts/londrinaoutline/v2/lls08GOa1eT74p072l1AWJmp8DTZ6iHear7UV05iykg.ttf\";}}i:619;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Dangrek\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/dangrek/v5/LOaFhBT-EHNxZjV8DAW_ew.ttf\";}}i:620;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Uncial Antiqua\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:113:\"http://themes.googleusercontent.com/static/fonts/uncialantiqua/v1/F-leefDiFwQXsyd6eaSllqrFJ4O13IHVxZbM6yoslpo.ttf\";}}i:621;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Koulen\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2013-12-02\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/koulen/v6/AAYOK8RSRO7FTskTzFuzNw.ttf\";}}i:622;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Diplomata\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-09-14\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:88:\"http://themes.googleusercontent.com/static/fonts/diplomata/v1/u-ByBiKgN6rTMA36H3kcKg.ttf\";}}i:623;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Taprom\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/taprom/v5/-KByU3BaUsyIvQs79qFObg.ttf\";}}i:624;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:4:\"Moul\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:83:\"http://themes.googleusercontent.com/static/fonts/moul/v5/Kb0ALQnfyXawP1a_P_gpTQ.ttf\";}}i:625;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Underdog\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:9:\"latin-ext\";i:1;s:8:\"cyrillic\";i:2;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-09-26\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/underdog/v1/gBv9yjez_-5PnTprHWq0ig.ttf\";}}i:626;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:14:\"Jim Nightshade\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:113:\"http://themes.googleusercontent.com/static/fonts/jimnightshade/v1/_n43lYHXVWNgXegdYRIK9CF1W_bo0EdycfH0kHciIic.ttf\";}}i:627;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Faster One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-10-31\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:109:\"http://themes.googleusercontent.com/static/fonts/fasterone/v1/YxTOW2sf56uxD1T7byP5K_esZW2xOQ-xsNqO47m55DA.ttf\";}}i:628;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Metal Mania\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2012-08-16\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/metalmania/v2/isriV_rAUgj6bPWPN6l9QKCWcynf_cDxXwCLxiixG1c.ttf\";}}i:629;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Macondo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2013-12-02\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/macondo/v2/G6yPNUscRPQ8ufBXs_8yRQ.ttf\";}}i:630;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:10:\"Butcherman\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2013-12-02\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/butcherman/v4/bxiJmD567sPBVpJsT0XR0vesZW2xOQ-xsNqO47m55DA.ttf\";}}i:631;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Almendra SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2013-12-02\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/almendrasc/v3/IuiLd8Fm9I6raSalxMoWeaCWcynf_cDxXwCLxiixG1c.ttf\";}}i:632;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Bayon\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v5\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/bayon/v5/yTubusjTnpNRZwA4_50iVw.ttf\";}}i:633;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:13:\"Stalinist One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:3:{i:0;s:9:\"latin-ext\";i:1;s:8:\"cyrillic\";i:2;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2013-12-02\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:112:\"http://themes.googleusercontent.com/static/fonts/stalinistone/v2/ltOD4Zj3WJDXYjAIR-9vZojjx0o0jr6fNXxPgYh_a8Q.ttf\";}}i:634;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Ceviche One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2012-07-25\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/cevicheone/v3/WOaXIMBD4VYMy39MsobJhKCWcynf_cDxXwCLxiixG1c.ttf\";}}i:635;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Bonbon\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2013-12-02\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/bonbon/v3/IW3u1yzG1knyW5oz0s9_6Q.ttf\";}}i:636;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Plaster\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2013-12-02\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/plaster/v4/O4QG9Z5116CXyfJdR9zxLw.ttf\";}}i:637;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:11:\"Vampiro One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2013-12-02\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:110:\"http://themes.googleusercontent.com/static/fonts/vampiroone/v2/OVDs4gY4WpS5u3Qd1gXRW6CWcynf_cDxXwCLxiixG1c.ttf\";}}i:638;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Fruktur\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2013-12-02\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/fruktur/v2/PnQvfEi1LssAvhJsCwH__w.ttf\";}}i:639;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Moulpali\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2013-12-02\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/moulpali/v6/diD74BprGhmVkJoerKmrKA.ttf\";}}i:640;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Almendra Display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2013-12-02\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:115:\"http://themes.googleusercontent.com/static/fonts/almendradisplay/v2/2Zuu97WJ_ez-87yz5Ai8fF6uyC_qD11hrFQ6EGgTJWI.ttf\";}}i:641;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:9:\"Erica One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2013-11-21\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/ericaone/v3/cIBnH2VAqQMIGYAcE4ufvQ.ttf\";}}i:642;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Diplomata SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2013-12-02\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/diplomatasc/v2/JdVwAwfE1a_pahXjk5qpNi3USBnSvpkopQaUR-2r7iU.ttf\";}}i:643;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:16:\"Fascinate Inline\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2013-11-19\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:115:\"http://themes.googleusercontent.com/static/fonts/fascinateinline/v3/lRguYfMfWArflkm5aOQ5QJmp8DTZ6iHear7UV05iykg.ttf\";}}i:644;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:5:\"Metal\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2013-12-02\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:84:\"http://themes.googleusercontent.com/static/fonts/metal/v6/zA3UOP13ooQcxjv04BZX5g.ttf\";}}i:645;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Unlock\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"latin\";}s:7:\"version\";s:2:\"v3\";s:12:\"lastModified\";s:10:\"2013-12-02\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/unlock/v3/rXEQzK7uIAlhoyoAEiMy1w.ttf\";}}i:646;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:12:\"Hanalei Fill\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v1\";s:12:\"lastModified\";s:10:\"2012-11-28\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:111:\"http://themes.googleusercontent.com/static/fonts/hanaleifill/v1/5uPeWLnaDdtm4UBG26Ds6C3USBnSvpkopQaUR-2r7iU.ttf\";}}i:647;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Siemreap\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2013-12-02\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/siemreap/v6/JSK-mOIsXwxo-zE9XDDl_g.ttf\";}}i:648;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Chenla\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v6\";s:12:\"lastModified\";s:10:\"2013-12-02\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/chenla/v6/aLNpdAUDq2MZbWz2U1a16g.ttf\";}}i:649;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:8:\"Fasthand\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:1:{i:0;s:5:\"khmer\";}s:7:\"version\";s:2:\"v4\";s:12:\"lastModified\";s:10:\"2013-12-02\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:87:\"http://themes.googleusercontent.com/static/fonts/fasthand/v4/6XAagHH_KmpZL67wTvsETQ.ttf\";}}i:650;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:6:\"Warnes\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2013-12-02\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:85:\"http://themes.googleusercontent.com/static/fonts/warnes/v2/MXG7_Phj4YpzAXxKGItuBw.ttf\";}}i:651;O:8:\"stdClass\":7:{s:4:\"kind\";s:16:\"webfonts#webfont\";s:6:\"family\";s:7:\"Hanalei\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"version\";s:2:\"v2\";s:12:\"lastModified\";s:10:\"2013-12-02\";s:5:\"files\";O:8:\"stdClass\":1:{s:7:\"regular\";s:86:\"http://themes.googleusercontent.com/static/fonts/hanalei/v2/Sx8vVMBnXSQyK6Cn0CBJ3A.ttf\";}}}}","no");
INSERT INTO wp_options VALUES("37982","_transient_timeout_021b61f9f3e68411","1458874884","no");
INSERT INTO wp_options VALUES("37983","_transient_021b61f9f3e68411","O:8:\"stdClass\":1:{s:14:\"wp-list-themes\";a:8:{i:0;O:8:\"stdClass\":6:{s:7:\"item_id\";s:7:\"2189918\";s:9:\"item_name\";s:49:\"MayaShop - A Flexible Responsive e-Commerce Theme\";s:10:\"theme_name\";s:9:\"Maya Shop\";s:11:\"author_name\";s:23:\"Your Inspiration Themes\";s:7:\"version\";s:5:\"2.9.3\";s:11:\"description\";s:52:\"The start base for easy theme wordpress development.\";}i:1;O:8:\"stdClass\":6:{s:7:\"item_id\";s:7:\"5415589\";s:9:\"item_name\";s:49:\"SpotFinder - Versatile Directory & Listings Theme\";s:10:\"theme_name\";s:10:\"SpotFinder\";s:11:\"author_name\";s:11:\"BTOA Themes\";s:7:\"version\";s:6:\"2.0.31\";s:11:\"description\";s:20:\"Premium Finder Theme\";}i:2;O:8:\"stdClass\":6:{s:7:\"item_id\";s:7:\"3519946\";s:9:\"item_name\";s:31:\"Replete e-Commerce and Business\";s:10:\"theme_name\";s:7:\"Replete\";s:11:\"author_name\";s:6:\"Kriesi\";s:7:\"version\";s:3:\"2.4\";s:11:\"description\";s:281:\"<strong>A responsive e-Commerce Theme by Kriesi</strong> - <br/> Update notifications available on twitter and facebook:<br/> <a href=\'http://twitter.com/kriesi\'>Follow me on twitter</a><br/> - <a href=\'http://www.facebook.com/pages/Kriesi/333648177216\'>Join the Facebook Group</a>\";}i:3;O:8:\"stdClass\":6:{s:7:\"item_id\";s:7:\"2833226\";s:9:\"item_name\";s:38:\"Avada | Responsive Multi-Purpose Theme\";s:10:\"theme_name\";s:5:\"Avada\";s:11:\"author_name\";s:11:\"ThemeFusion\";s:7:\"version\";s:5:\"3.9.3\";s:11:\"description\";s:85:\"The #1 selling theme of all time that allows you to build virtually any design style.\";}i:4;O:8:\"stdClass\":6:{s:7:\"item_id\";s:7:\"9602611\";s:9:\"item_name\";s:35:\"Listify - WordPress Directory Theme\";s:10:\"theme_name\";s:7:\"Listify\";s:11:\"author_name\";s:10:\"Astoundify\";s:7:\"version\";s:5:\"1.3.2\";s:11:\"description\";s:43:\"The last directory theme you will ever buy.\";}i:5;O:8:\"stdClass\":6:{s:7:\"item_id\";s:7:\"9806696\";s:9:\"item_name\";s:45:\"Travelo - Travel/Tour Booking WordPress Theme\";s:10:\"theme_name\";s:7:\"Travelo\";s:11:\"author_name\";s:9:\"SoapTheme\";s:7:\"version\";s:5:\"1.6.1\";s:11:\"description\";s:125:\"The Travelo theme for WordPress is a fully responsive theme that looks great on any device. This theme is for travel booking.\";}i:6;O:8:\"stdClass\":6:{s:7:\"item_id\";s:7:\"4994573\";s:9:\"item_name\";s:47:\"Sweet Date - More than a Wordpress Dating Theme\";s:10:\"theme_name\";s:9:\"Sweetdate\";s:11:\"author_name\";s:12:\"SeventhQueen\";s:7:\"version\";s:5:\"2.9.3\";s:11:\"description\";s:34:\"More than a WordPress dating theme\";}i:7;O:8:\"stdClass\":6:{s:7:\"item_id\";s:7:\"8103494\";s:9:\"item_name\";s:49:\"Multinews - Multi-purpose WordPress News,Magazine\";s:10:\"theme_name\";s:10:\"Multi News\";s:11:\"author_name\";s:12:\"Momizat Team\";s:7:\"version\";s:5:\"2.5.1\";s:11:\"description\";s:78:\"<strong>A responsive News/magazine theme</strong> - built on unlimited concept\";}}}","no");
INSERT INTO wp_options VALUES("37986","_transient_timeout_b0007f665ee34845","1458874884","no");
INSERT INTO wp_options VALUES("37987","_transient_b0007f665ee34845","O:8:\"stdClass\":1:{s:4:\"item\";O:8:\"stdClass\":14:{s:2:\"id\";s:7:\"2189918\";s:4:\"item\";s:49:\"MayaShop - A Flexible Responsive e-Commerce Theme\";s:3:\"url\";s:82:\"http://themeforest.net/item/mayashop-a-flexible-responsive-ecommerce-theme/2189918\";s:4:\"user\";s:6:\"Sara_p\";s:9:\"thumbnail\";s:54:\"https://0.s3.envato.com/files/171328739/thumb-maya.png\";s:5:\"sales\";s:5:\"10759\";s:6:\"rating\";s:3:\"4.5\";s:14:\"rating_decimal\";s:4:\"4.61\";s:4:\"cost\";s:5:\"64.00\";s:11:\"uploaded_on\";s:30:\"Wed Apr 18 02:11:24 +1000 2012\";s:11:\"last_update\";s:30:\"Sat Mar 05 07:11:31 +1100 2016\";s:4:\"tags\";s:105:\"e-commerce theme, responsive e-commerce, seo, shop, shop theme, store, woo commerce, wordpress e-commerce\";s:8:\"category\";s:31:\"wordpress/ecommerce/woocommerce\";s:16:\"live_preview_url\";s:75:\"https://0.s3.envato.com/files/25315705/ThemePreview/001.__large_preview.jpg\";}}","no");
INSERT INTO wp_options VALUES("37988","_transient_timeout_65a21317dd1612d6","1458874884","no");
INSERT INTO wp_options VALUES("37989","_transient_65a21317dd1612d6","O:8:\"stdClass\":1:{s:4:\"item\";s:0:\"\";}","no");
INSERT INTO wp_options VALUES("37990","_transient_timeout_4c0952e729eb618b","1458874885","no");
INSERT INTO wp_options VALUES("37991","_transient_4c0952e729eb618b","O:8:\"stdClass\":1:{s:4:\"item\";O:8:\"stdClass\":14:{s:2:\"id\";s:7:\"3519946\";s:4:\"item\";s:31:\"Replete e-Commerce and Business\";s:3:\"url\";s:66:\"http://themeforest.net/item/replete-ecommerce-and-business/3519946\";s:4:\"user\";s:6:\"Kriesi\";s:9:\"thumbnail\";s:59:\"https://0.s3.envato.com/files/42211719/tooltip_template.jpg\";s:5:\"sales\";s:4:\"2272\";s:6:\"rating\";s:3:\"4.5\";s:14:\"rating_decimal\";s:4:\"4.57\";s:4:\"cost\";s:5:\"59.00\";s:11:\"uploaded_on\";s:30:\"Thu Nov 29 01:09:27 +1100 2012\";s:11:\"last_update\";s:30:\"Sat Dec 19 01:55:00 +1100 2015\";s:4:\"tags\";s:147:\"clothes, commerce, e-commerce, furniture, mega menu, mobile, mobile optimized, paypal, responsive, seo, shop, slideshow, store, tablet, woocommerce\";s:8:\"category\";s:31:\"wordpress/ecommerce/woocommerce\";s:16:\"live_preview_url\";s:75:\"https://0.s3.envato.com/files/42211720/images/1_preview.__large_preview.jpg\";}}","no");
INSERT INTO wp_options VALUES("37992","_transient_timeout_1da59d9b57fa0927","1458874885","no");
INSERT INTO wp_options VALUES("37993","_transient_1da59d9b57fa0927","O:8:\"stdClass\":1:{s:4:\"item\";O:8:\"stdClass\":14:{s:2:\"id\";s:7:\"2833226\";s:4:\"item\";s:38:\"Avada | Responsive Multi-Purpose Theme\";s:3:\"url\";s:71:\"http://themeforest.net/item/avada-responsive-multipurpose-theme/2833226\";s:4:\"user\";s:11:\"ThemeFusion\";s:9:\"thumbnail\";s:53:\"https://0.s3.envato.com/files/169508862/Thumbnail.jpg\";s:5:\"sales\";s:6:\"204022\";s:6:\"rating\";s:3:\"5.0\";s:14:\"rating_decimal\";s:4:\"4.78\";s:4:\"cost\";s:5:\"59.00\";s:11:\"uploaded_on\";s:30:\"Thu Aug 16 01:28:46 +1000 2012\";s:11:\"last_update\";s:30:\"Thu Jan 28 12:13:49 +1100 2016\";s:4:\"tags\";s:153:\"blog, business, clean, corporate, creative, ecommerce, modern, multipurpose, one page, photography, portfolio, responsive, retina, woocommerce, wordpress\";s:8:\"category\";s:19:\"wordpress/corporate\";s:16:\"live_preview_url\";s:82:\"https://0.s3.envato.com/files/169508866/screenshots/00_preview.__large_preview.jpg\";}}","no");
INSERT INTO wp_options VALUES("37994","_transient_timeout_d26126ec386a2163","1458874885","no");
INSERT INTO wp_options VALUES("37995","_transient_d26126ec386a2163","O:8:\"stdClass\":1:{s:4:\"item\";O:8:\"stdClass\":14:{s:2:\"id\";s:7:\"9602611\";s:4:\"item\";s:35:\"Listify - WordPress Directory Theme\";s:3:\"url\";s:69:\"http://themeforest.net/item/listify-wordpress-directory-theme/9602611\";s:4:\"user\";s:10:\"Astoundify\";s:9:\"thumbnail\";s:57:\"https://0.s3.envato.com/files/112870792/80x80-Listify.jpg\";s:5:\"sales\";s:4:\"7757\";s:6:\"rating\";s:3:\"4.5\";s:14:\"rating_decimal\";s:4:\"4.43\";s:4:\"cost\";s:5:\"64.00\";s:11:\"uploaded_on\";s:30:\"Wed Nov 26 13:42:18 +1100 2014\";s:11:\"last_update\";s:30:\"Fri Feb 05 08:08:49 +1100 2016\";s:4:\"tags\";s:141:\"airbnb, booking, classified, directory, listing, local directory, maps, marketplace, product vendors, real estate, reservation, reviews, yelp\";s:8:\"category\";s:38:\"wordpress/corporate/directory-listings\";s:16:\"live_preview_url\";s:82:\"https://0.s3.envato.com/files/113694579/Listify-Product-Banner.__large_preview.jpg\";}}","no");
INSERT INTO wp_options VALUES("37996","_transient_timeout_cd845f0fc8c572da","1458874885","no");
INSERT INTO wp_options VALUES("37997","_transient_cd845f0fc8c572da","O:8:\"stdClass\":1:{s:4:\"item\";O:8:\"stdClass\":14:{s:2:\"id\";s:7:\"9806696\";s:4:\"item\";s:45:\"Travelo - Travel/Tour Booking WordPress Theme\";s:3:\"url\";s:78:\"http://themeforest.net/item/travelo-traveltour-booking-wordpress-theme/9806696\";s:4:\"user\";s:9:\"SoapTheme\";s:9:\"thumbnail\";s:53:\"https://0.s3.envato.com/files/117491935/Thumbnail.png\";s:5:\"sales\";s:4:\"1982\";s:6:\"rating\";s:3:\"4.5\";s:14:\"rating_decimal\";s:4:\"4.73\";s:4:\"cost\";s:5:\"54.00\";s:11:\"uploaded_on\";s:30:\"Fri Jan 02 14:06:40 +1100 2015\";s:11:\"last_update\";s:30:\"Thu Mar 24 13:28:45 +1100 2016\";s:4:\"tags\";s:178:\"accommodation, accommodation booking, booking theme, holiday, hotel, hotel booking, multi language, reservation, responsive, rtl, tour, tour booking, travel, travel booking, wpml\";s:8:\"category\";s:23:\"wordpress/retail/travel\";s:16:\"live_preview_url\";s:67:\"https://0.s3.envato.com/files/138368525/Preview.__large_preview.jpg\";}}","no");
INSERT INTO wp_options VALUES("37998","_transient_timeout_e7c0fbce0530264b","1458874885","no");
INSERT INTO wp_options VALUES("37999","_transient_e7c0fbce0530264b","O:8:\"stdClass\":1:{s:4:\"item\";O:8:\"stdClass\":14:{s:2:\"id\";s:7:\"4994573\";s:4:\"item\";s:47:\"Sweet Date - More than a Wordpress Dating Theme\";s:3:\"url\";s:81:\"http://themeforest.net/item/sweet-date-more-than-a-wordpress-dating-theme/4994573\";s:4:\"user\";s:12:\"SeventhQueen\";s:9:\"thumbnail\";s:49:\"https://0.s3.envato.com/files/178139199/thumb.png\";s:5:\"sales\";s:4:\"5514\";s:6:\"rating\";s:3:\"4.5\";s:14:\"rating_decimal\";s:4:\"4.63\";s:4:\"cost\";s:5:\"59.00\";s:11:\"uploaded_on\";s:30:\"Thu Jun 27 00:45:49 +1000 2013\";s:11:\"last_update\";s:30:\"Tue Mar 22 02:42:04 +1100 2016\";s:4:\"tags\";s:139:\"bbpress, buddypress, clean, community, creative, dating, facebook, foundation, mailchimp, retina, seo, social, woocommerce, wordpress, zurb\";s:8:\"category\";s:20:\"wordpress/buddypress\";s:16:\"live_preview_url\";s:85:\"https://0.s3.envato.com/files/178139204/Theme%20Preview/sweetdate.__large_preview.png\";}}","no");
INSERT INTO wp_options VALUES("38000","_transient_timeout_8acaccea8e44351c","1458874885","no");
INSERT INTO wp_options VALUES("38001","_transient_8acaccea8e44351c","O:8:\"stdClass\":1:{s:4:\"item\";O:8:\"stdClass\":14:{s:2:\"id\";s:7:\"8103494\";s:4:\"item\";s:49:\"Multinews - Multi-purpose WordPress News,Magazine\";s:3:\"url\";s:81:\"http://themeforest.net/item/multinews-multipurpose-wordpress-newsmagazine/8103494\";s:4:\"user\";s:7:\"Momizat\";s:9:\"thumbnail\";s:52:\"https://0.s3.envato.com/files/174422025/ml-thumb.png\";s:5:\"sales\";s:4:\"2640\";s:6:\"rating\";s:3:\"4.5\";s:14:\"rating_decimal\";s:4:\"4.69\";s:4:\"cost\";s:5:\"59.00\";s:11:\"uploaded_on\";s:30:\"Fri Jul 04 07:14:14 +1000 2014\";s:11:\"last_update\";s:30:\"Sun Feb 28 01:20:22 +1100 2016\";s:4:\"tags\";s:120:\"bbpress, buddypress, community, editorial, magazine, mega menus, news, newspaper, page builder, review, rtl, translation\";s:8:\"category\";s:38:\"wordpress/blog-magazine/news-editorial\";s:16:\"live_preview_url\";s:108:\"https://0.s3.envato.com/files/174422027/large_preview_ml.__large_preview.__large_preview.__large_preview.png\";}}","no");
INSERT INTO wp_options VALUES("38003","_transient_timeout_settings_errors","1458874721","no");
INSERT INTO wp_options VALUES("38004","_transient_settings_errors","a:1:{i:0;a:4:{s:7:\"setting\";s:7:\"general\";s:4:\"code\";s:16:\"settings_updated\";s:7:\"message\";s:15:\"Settings saved.\";s:4:\"type\";s:7:\"updated\";}}","no");
INSERT INTO wp_options VALUES("38887","_transient_timeout_wflginfl_00000000000000000000ffff9b855270","1459095200","no");
INSERT INTO wp_options VALUES("38888","_transient_wflginfl_00000000000000000000ffff9b855270","1","no");
INSERT INTO wp_options VALUES("39483","_transient_timeout_jetpack_https_test","1459483364","no");
INSERT INTO wp_options VALUES("39484","_transient_jetpack_https_test","1","no");
INSERT INTO wp_options VALUES("39644","_site_transient_timeout_security_report_performed_recently","1459464029","yes");
INSERT INTO wp_options VALUES("39645","_site_transient_security_report_performed_recently","1","yes");
INSERT INTO wp_options VALUES("39650","_site_transient_timeout_browser_32672d518ceb2ef9200cc67e6dfe5176","1460067947","yes");
INSERT INTO wp_options VALUES("39651","_site_transient_browser_32672d518ceb2ef9200cc67e6dfe5176","a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"49.0.2623.110\";s:10:\"update_url\";s:28:\"http://www.google.com/chrome\";s:7:\"img_src\";s:49:\"http://s.wordpress.org/images/browsers/chrome.png\";s:11:\"img_src_ssl\";s:48:\"https://wordpress.org/images/browsers/chrome.png\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO wp_options VALUES("39714","wpseo_sitemap_dslc_partners_cache_validator","uCzbY","yes");
INSERT INTO wp_options VALUES("39717","dslc_partners_cats_children","a:0:{}","yes");
INSERT INTO wp_options VALUES("39840","_transient_timeout_yst_sm_dslc_projects_1:9MdGrI_aFFNeU","1459596507","no");
INSERT INTO wp_options VALUES("39841","_transient_yst_sm_dslc_projects_1:9MdGrI_aFFNeU","<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:image=\"http://www.google.com/schemas/sitemap-image/1.1\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/muddaddy-flats-quesadillary/</loc>\n		<lastmod>2016-02-25T16:35:06+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-Muddaddy-Flats.png</image:loc>\n			<image:caption><![CDATA[Muddaddy Flats Quesadillary]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/ambrose-electric/</loc>\n		<lastmod>2016-02-25T16:34:01+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-Ambrose-Electric.png</image:loc>\n			<image:caption><![CDATA[Ambrose Electric]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/1495/</loc>\n		<lastmod>2016-02-25T16:33:27+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-JM-Jewelers.png</image:loc>\n			<image:caption><![CDATA[JM Jewelers]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/empire-state-plumbing/</loc>\n		<lastmod>2016-02-25T16:32:25+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-Empire-State-Plumbing.png</image:loc>\n			<image:caption><![CDATA[Empire State Plumbing]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/classic-crust-mobile-catering/</loc>\n		<lastmod>2016-02-25T16:31:22+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-Classic-Crust.png</image:loc>\n			<image:caption><![CDATA[Classic Crust Mobile Catering]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/ania-hair-studio-spa/</loc>\n		<lastmod>2016-02-25T16:30:40+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-Ania-Hair-Studio.png</image:loc>\n			<image:caption><![CDATA[Ania Hair Studio &amp; Spa]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/dream-street-modulars/</loc>\n		<lastmod>2016-02-25T16:30:05+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-Dream-St-Modulars.png</image:loc>\n			<image:caption><![CDATA[Dream Street Modulars]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/prestige-dmv/</loc>\n		<lastmod>2016-02-25T16:29:31+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-Prestige-DMV.png</image:loc>\n			<image:caption><![CDATA[Prestige DMV]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/kickassvacuumdealer-com/</loc>\n		<lastmod>2016-02-25T16:28:54+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-Kickass-Vacuum-Dealer.png</image:loc>\n			<image:caption><![CDATA[KickAssVacuumDealer.com]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/mde-scouting/</loc>\n		<lastmod>2016-02-25T16:26:39+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-MDE-Scouting.png</image:loc>\n			<image:caption><![CDATA[MDE Scouting]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/northwood-homes/</loc>\n		<lastmod>2016-02-25T16:28:14+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-Northwood-Homes.png</image:loc>\n			<image:caption><![CDATA[NorthWood Homes]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/capital-district-contractors/</loc>\n		<lastmod>2016-02-25T16:27:21+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-Capital-District-Contractors.png</image:loc>\n			<image:caption><![CDATA[Capital District Contractors]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/a-magic-kingdom/</loc>\n		<lastmod>2016-02-25T16:37:13+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-A-Magic-Kingdom.png</image:loc>\n			<image:caption><![CDATA[A Magic Kingdom]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/machnick-builders/</loc>\n		<lastmod>2016-02-25T16:42:59+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-Machnick-Builders.png</image:loc>\n			<image:caption><![CDATA[Machnick Builders, LTD.]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/teds-flooring-interior-design/</loc>\n		<lastmod>2016-02-25T16:47:28+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-Teds-Flooring.png</image:loc>\n			<image:caption><![CDATA[Ted]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/brits-r-us/</loc>\n		<lastmod>2016-02-25T16:53:50+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-Brits-R-Us.png</image:loc>\n			<image:caption><![CDATA[Brits R Us]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/albany-beverage-center/</loc>\n		<lastmod>2016-02-25T16:58:13+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-Albany-Beverage-Center.png</image:loc>\n			<image:caption><![CDATA[Albany Beverage Center]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/the-della-ratta-law-office/</loc>\n		<lastmod>2016-02-25T17:06:08+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-Della-Ratta-Law-Office.png</image:loc>\n			<image:caption><![CDATA[The Della Ratta Law Office]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/ac-towing-recovery/</loc>\n		<lastmod>2016-02-25T17:11:21+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-ACs-Towing-and-Recovery.png</image:loc>\n			<image:caption><![CDATA[Ac Towing &amp; Recovery]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/crescent-gardens/</loc>\n		<lastmod>2016-02-25T17:18:46+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2016/02/Capital-District-Digital_-Web-Design_-Crescent-Gardens.png</image:loc>\n			<image:caption><![CDATA[Crescent Gardens]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/project-view/the-ideal-u/</loc>\n		<lastmod>2016-02-25T17:23:05+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/07/Capital-District-Digital_-Web-Design_-The-Ideal-U.png</image:loc>\n			<image:caption><![CDATA[The Ideal U]]></image:caption>\n		</image:image>\n	</url>\n</urlset>","no");
INSERT INTO wp_options VALUES("39842","_transient_timeout_yst_sm_dslc_staff_1:9MdGrI_94j49n","1459596508","no");
INSERT INTO wp_options VALUES("39843","_transient_yst_sm_dslc_staff_1:9MdGrI_94j49n","<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:image=\"http://www.google.com/schemas/sitemap-image/1.1\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>https://capitaldistrictdigital.com/staff-view/anthony-troia/</loc>\n		<lastmod>2016-03-11T15:25:34+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/09/Anthony-Troia-Co-Founder-Capital-District-Digital-Albany-NY.jpg</image:loc>\n			<image:caption><![CDATA[Anthony Troia]]></image:caption>\n		</image:image>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/staff-view/kaila-wieszchowski/</loc>\n		<lastmod>2016-03-11T18:53:44+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n		<image:image>\n			<image:loc>https://capitaldistrictdigital.com/wp-content/uploads/2015/09/Kaila-Co-Founder-Capital-District-Digital-Albany-NY-2.jpg</image:loc>\n			<image:caption><![CDATA[Kaila Wieszchowski]]></image:caption>\n		</image:image>\n	</url>\n</urlset>","no");
INSERT INTO wp_options VALUES("39844","_transient_timeout_yst_sm_dslc_templates_1:9MdGrI_aFADdn","1459596509","no");
INSERT INTO wp_options VALUES("39845","_transient_yst_sm_dslc_templates_1:9MdGrI_aFADdn","<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:image=\"http://www.google.com/schemas/sitemap-image/1.1\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>https://capitaldistrictdigital.com/dslc_templates/project/</loc>\n		<lastmod>2015-05-20T18:22:17+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/dslc_templates/staff-2/</loc>\n		<lastmod>2015-09-08T00:42:24+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n</urlset>","no");
INSERT INTO wp_options VALUES("39858","_site_transient_timeout_browser_e9e7bc230acdf2bfc4f1ec10f23c3a92","1460130987","yes");
INSERT INTO wp_options VALUES("39859","_site_transient_browser_e9e7bc230acdf2bfc4f1ec10f23c3a92","a:9:{s:8:\"platform\";s:5:\"Linux\";s:4:\"name\";s:13:\"Mobile Safari\";s:7:\"version\";s:6:\"537.36\";s:10:\"update_url\";s:0:\"\";s:7:\"img_src\";s:0:\"\";s:11:\"img_src_ssl\";s:0:\"\";s:15:\"current_version\";s:0:\"\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}","yes");
INSERT INTO wp_options VALUES("39925","_transient_timeout_wflginfl_00000000000000000000ffff55192d40","1459623498","no");
INSERT INTO wp_options VALUES("39926","_transient_wflginfl_00000000000000000000ffff55192d40","1","no");
INSERT INTO wp_options VALUES("39927","_transient_timeout_wflginfl_00000000000000000000ffff5c356091","1459630601","no");
INSERT INTO wp_options VALUES("39928","_transient_wflginfl_00000000000000000000ffff5c356091","1","no");
INSERT INTO wp_options VALUES("39929","_transient_timeout_wflginfl_00000000000000000000ffffadfe562c","1459630764","no");
INSERT INTO wp_options VALUES("39930","_transient_wflginfl_00000000000000000000ffffadfe562c","1","no");
INSERT INTO wp_options VALUES("39931","_transient_timeout_wflginfl_00000000000000000000ffffd8acbd83","1459637117","no");
INSERT INTO wp_options VALUES("39932","_transient_wflginfl_00000000000000000000ffffd8acbd83","1","no");
INSERT INTO wp_options VALUES("39937","_transient_timeout_wflginfl_00000000000000000000ffff2ea10911","1459641305","no");
INSERT INTO wp_options VALUES("39938","_transient_wflginfl_00000000000000000000ffff2ea10911","1","no");
INSERT INTO wp_options VALUES("39939","_transient_timeout_wflginfl_00000000000000000000ffff6d7b550d","1459643526","no");
INSERT INTO wp_options VALUES("39940","_transient_wflginfl_00000000000000000000ffff6d7b550d","1","no");
INSERT INTO wp_options VALUES("39941","_transient_timeout_yst_sm_page_1:9MdGrI_28FiiR","1459731967","no");
INSERT INTO wp_options VALUES("39942","_transient_yst_sm_page_1:9MdGrI_28FiiR","<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:image=\"http://www.google.com/schemas/sitemap-image/1.1\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>https://capitaldistrictdigital.com/sample-page/</loc>\n		<lastmod>2015-02-17T11:56:24+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/pricing/</loc>\n		<lastmod>2014-03-25T16:55:58+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/services/</loc>\n		<lastmod>2014-04-21T16:44:30+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/about/</loc>\n		<lastmod>2016-02-08T22:53:30+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/case-studies/</loc>\n		<lastmod>2016-02-25T17:13:42+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/contact-us/</loc>\n		<lastmod>2015-02-24T17:47:21+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/clients/</loc>\n		<lastmod>2014-05-29T16:30:53+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/testimonials/</loc>\n		<lastmod>2014-05-30T05:30:43+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/</loc>\n		<lastmod>2016-02-08T22:43:07+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>1</priority>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/services-web-development/</loc>\n		<lastmod>2014-11-29T02:57:45+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/services-web-design/</loc>\n		<lastmod>2016-03-01T11:39:28+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/services-social-media-marketing/</loc>\n		<lastmod>2015-08-28T15:40:50+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/services-search-engine-optimization/</loc>\n		<lastmod>2016-03-26T00:20:09+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/services-email-marketing/</loc>\n		<lastmod>2014-12-05T21:10:51+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/services-pay-per-click-management-ppc/</loc>\n		<lastmod>2014-12-05T21:12:24+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/wordpress-virus-removal-service/</loc>\n		<lastmod>2016-03-24T02:17:48+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/services-local-seo/</loc>\n		<lastmod>2014-12-05T21:43:38+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/services-digital-consultancy/</loc>\n		<lastmod>2014-12-05T21:45:57+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/services-mobile-marketing/</loc>\n		<lastmod>2014-12-05T21:46:59+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/services-reputation-management/</loc>\n		<lastmod>2014-12-05T21:49:28+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/sitemap/</loc>\n		<lastmod>2016-03-02T15:08:31+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/install-https-ssl-certificate-wordpress/</loc>\n		<lastmod>2016-03-25T01:42:38+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n	<url>\n		<loc>https://capitaldistrictdigital.com/newspaper-digital-marketing-vendors/</loc>\n		<lastmod>2016-04-01T02:38:26+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.8</priority>\n	</url>\n</urlset>","no");
INSERT INTO wp_options VALUES("39943","_transient_timeout_yst_sm_1_1:9MdGrI_28FidT","1459732265","no");
INSERT INTO wp_options VALUES("39944","_transient_yst_sm_1_1:9MdGrI_28FidT","<sitemapindex xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n<sitemap>\n<loc>https://capitaldistrictdigital.com/page-sitemap.xml</loc>\n<lastmod>2016-04-01T02:38:26+00:00</lastmod>\n</sitemap>\n<sitemap>\n<loc>https://capitaldistrictdigital.com/dslc_templates-sitemap.xml</loc>\n<lastmod>2015-09-08T00:42:24+00:00</lastmod>\n</sitemap>\n<sitemap>\n<loc>https://capitaldistrictdigital.com/dslc_projects-sitemap.xml</loc>\n<lastmod>2016-02-25T17:23:05+00:00</lastmod>\n</sitemap>\n<sitemap>\n<loc>https://capitaldistrictdigital.com/dslc_staff-sitemap.xml</loc>\n<lastmod>2016-03-11T18:53:44+00:00</lastmod>\n</sitemap>\n<sitemap>\n<loc>https://capitaldistrictdigital.com/dslc_projects_cats-sitemap.xml</loc>\n<lastmod>2016-02-25T17:23:05+00:00</lastmod>\n</sitemap>\n</sitemapindex>","no");
INSERT INTO wp_options VALUES("39946","_transient_timeout_wflginfl_00000000000000000000ffff2e1c695c","1459650297","no");
INSERT INTO wp_options VALUES("39947","_transient_wflginfl_00000000000000000000ffff2e1c695c","1","no");
INSERT INTO wp_options VALUES("39953","_transient_timeout_wflginfl_00000000000000000000ffff45a3d083","1459656360","no");
INSERT INTO wp_options VALUES("39954","_transient_wflginfl_00000000000000000000ffff45a3d083","1","no");
INSERT INTO wp_options VALUES("39955","_transient_timeout_wflginfl_00000000000000000000ffff51b187c9","1459656658","no");
INSERT INTO wp_options VALUES("39956","_transient_wflginfl_00000000000000000000ffff51b187c9","1","no");
INSERT INTO wp_options VALUES("39962","_transient_timeout_wflginfl_00000000000000000000ffff32064d72","1459662990","no");
INSERT INTO wp_options VALUES("39963","_transient_wflginfl_00000000000000000000ffff32064d72","1","no");
INSERT INTO wp_options VALUES("39965","_transient_timeout_lbmn_customized_css","1459749222","no");
INSERT INTO wp_options VALUES("39966","_transient_lbmn_customized_css","<!-- Dynamically generated styles 2016-04-03 05:53  -->\n<style type=\'text/css\' id =\'seowp_customized_css\'>\nbody, .global-wrapper {background-color:rgb(255, 255, 255);}body.boxed-page-layout {background-color:rgb(102, 130, 144);}body.boxed-page-layout:before {opacity:;}.notification-panel {background-color:rgb(24, 101, 160);}.notification-panel, .notification-panel * {color:rgb(189, 227, 252); }.notification-panel:before {min-height:40px;}.notification-panel:hover {background-color:rgb(15, 119, 200);}.notification-panel:hover, .notification-panel:hover * {color:rgb(255, 255, 255); }a {color:rgb(42, 160, 239);}a:hover {color:rgb(93, 144, 226);}body {font-family:\'Roboto\', Helvetica,Arial,\'DejaVu Sans\',\'Liberation Sans\',Freesans,sans-serif;line-height:27px;font-weight:300;color:rgb(65, 72, 77);}.site {font-size:17px;}p {margin-bottom:20px;}h1 {font-family:\'Roboto\', Helvetica,Arial,\'DejaVu Sans\',\'Liberation Sans\',Freesans,sans-serif;font-size:42px;line-height:48px;font-weight:200;margin-bottom:25px;color:rgb(70, 72, 75);}h2 {font-family:\'Roboto\', Helvetica,Arial,\'DejaVu Sans\',\'Liberation Sans\',Freesans,sans-serif;font-size:31px;line-height:38px;font-weight:300;margin-bottom:20px;color:rgb(39, 40, 43);}h3 {font-family:\'Roboto\', Helvetica,Arial,\'DejaVu Sans\',\'Liberation Sans\',Freesans,sans-serif;font-size:24px;line-height:33px;font-weight:300;margin-bottom:20px;color:rgb(16, 16, 17);}h4 {font-family:\'Roboto\', Helvetica,Arial,\'DejaVu Sans\',\'Liberation Sans\',Freesans,sans-serif;font-size:21px;line-height:29px;font-weight:300;margin-bottom:18px;color:rgb(53, 54, 57);}h5 {font-family:\'Roboto\', Helvetica,Arial,\'DejaVu Sans\',\'Liberation Sans\',Freesans,sans-serif;font-size:17px;line-height:27px;font-weight:500;margin-bottom:25px;color:rgb(16, 16, 17);}h6 {font-family:\'Roboto\', Helvetica,Arial,\'DejaVu Sans\',\'Liberation Sans\',Freesans,sans-serif;font-size:17px;line-height:27px;font-weight:400;margin-bottom:25px;color:rgb(70, 72, 75);}.calltoaction-area {background-color:rgb(0, 0, 0);height:160px;line-height:160px;}.calltoaction-area, .calltoaction-area * {color:rgb(255, 255, 255); }.calltoaction-area:hover {background-color:rgb(86, 174, 227);}.calltoaction-area:hover, .calltoaction-area:hover * {color:rgb(255, 255, 255); }.calltoaction-area__content{font-family:\'Roboto\', Helvetica,Arial,\'DejaVu Sans\',\'Liberation Sans\',Freesans,sans-serif;font-weight:300;font-size:35px;}input[type=\"text\"], input[type=\"password\"], input[type=\"date\"], input[type=\"datetime\"], input[type=\"datetime-local\"], input[type=\"month\"], input[type=\"week\"], input[type=\"email\"], input[type=\"number\"], input[type=\"search\"], input[type=\"tel\"], input[type=\"time\"], input[type=\"url\"], textarea {background:rgb(255, 255, 255);}\n</style>","no");
INSERT INTO wp_options VALUES("39972","_transient_timeout_yst_sm_dslc_projects_cats_1:9MdGrI_7oZuIK","1459751743","no");
INSERT INTO wp_options VALUES("39973","_transient_yst_sm_dslc_projects_cats_1:9MdGrI_7oZuIK","<urlset xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd\" xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n	<url>\n		<loc>https://capitaldistrictdigital.com/dslc_projects_cats/responsive-web-design/</loc>\n		<lastmod>2016-02-25T17:23:05+00:00</lastmod>\n		<changefreq>weekly</changefreq>\n		<priority>0.6</priority>\n	</url>\n</urlset>","no");
INSERT INTO wp_options VALUES("39980","_transient_timeout_wflginfl_00000000000000000000ffff1fdc1130","1459669072","no");
INSERT INTO wp_options VALUES("39981","_transient_wflginfl_00000000000000000000ffff1fdc1130","1","no");
INSERT INTO wp_options VALUES("39989","_transient_timeout_wflginfl_00000000000000000000ffffbb2dc3b8","1459675160","no");
INSERT INTO wp_options VALUES("39990","_transient_wflginfl_00000000000000000000ffffbb2dc3b8","1","no");
INSERT INTO wp_options VALUES("40001","_transient_timeout_wflginfl_00000000000000000000ffff405a30d1","1459681551","no");
INSERT INTO wp_options VALUES("40002","_transient_wflginfl_00000000000000000000ffff405a30d1","1","no");
INSERT INTO wp_options VALUES("40004","_transient_timeout_wflginfl_00000000000000000000ffff4df5951b","1459682159","no");
INSERT INTO wp_options VALUES("40005","_transient_wflginfl_00000000000000000000ffff4df5951b","1","no");
INSERT INTO wp_options VALUES("40007","_transient_timeout_wflginfl_00000000000000000000ffff4707be10","1459682794","no");
INSERT INTO wp_options VALUES("40008","_transient_wflginfl_00000000000000000000ffff4707be10","1","no");
INSERT INTO wp_options VALUES("40021","_transient_timeout_wflginfl_00000000000000000000ffff46204411","1459687874","no");
INSERT INTO wp_options VALUES("40022","_transient_wflginfl_00000000000000000000ffff46204411","1","no");
INSERT INTO wp_options VALUES("40032","_transient_timeout_wflginfl_00000000000000000000ffff4b62a682","1459694171","no");
INSERT INTO wp_options VALUES("40033","_transient_wflginfl_00000000000000000000ffff4b62a682","1","no");
INSERT INTO wp_options VALUES("40034","_transient_timeout_wflginfl_00000000000000000000ffff592e68bd","1459700437","no");
INSERT INTO wp_options VALUES("40035","_transient_wflginfl_00000000000000000000ffff592e68bd","1","no");
INSERT INTO wp_options VALUES("40037","_site_transient_timeout_theme_roots","1459703973","yes");
INSERT INTO wp_options VALUES("40038","_site_transient_theme_roots","a:1:{s:5:\"seowp\";s:7:\"/themes\";}","yes");
INSERT INTO wp_options VALUES("40040","_site_transient_timeout_ewt_readme","1459706963","yes");
INSERT INTO wp_options VALUES("40041","_site_transient_ewt_readme","=== Envato WordPress Toolkit ===\nContributors: envato, valendesigns\nTags: install, update, api, envato, theme, upgrade\nRequires at least: 3.7\nTested up to: 4.3-beta1\nStable tag: 1.7.3\n\nWordPress toolkit for Envato Marketplace hosted items. Currently supports the following theme functionality: install, upgrade, & backups during upgrade.\n\n== Description ==\n\nThis toolkit plugin establishes an Envato Marketplace API connection to take advantage of the new `wp-list-themes` & `wp-download` methods created specifically for this plugin. These API methods grants access to information about your purchased themes and create temporary download URL\'s for installing and upgrading those themes. Basically, users that have purchased themes from ThemeForest.net can now install and upgrade any theme that takes advantage of these new methods. \n\nFor end users, all that\'s required to get started is an Envato Marketplace username & API key, and to have purchased one of the many WordPress themes found on ThemeForest.net. \n\nFor theme authors, navigate to your theme\'s admin page on ThemeForest.net and click edit; you\'ll need to upload the `Optional WordPress Theme` ZIP which contains your installable WordPress Theme. Once you\'ve got an installable ZIP uploaded and approved, users can install & update directly from within WordPress. Also, to take advantage of the update functionality you\'ll need to increment your themes version in the style.css every time a new version is available for download and repeat the process above of uploading an installable ZIP.\n\nBelow is a description of the new api-key protected Envato Marketplace API methods or sets. For full documentation on how to use the API go to http://marketplace.envato.com/api/documentation and have a look at the examples.\n\n`wp-list-themes`\n* Details of all WordPress themes you have purchased. Contains the item ID, item name, theme name, author name & version.\n\n`wp-download`\n* Temporary download URL to a WordPress item you have purchased. Requires the item ID, e.g. wp-download:1234.\n\n== Installation ==\n\n1. Upload the `envato-wordpress-toolkit` folder to the `/wp-content/plugins/` directory.\n2. Activate the plugin through the `Plugins` menu in WordPress.\n3. To establish an Envato Marketplace API connection navigate to the `Envato Toolkit` page and insert your Marketplace username and secret API key in the designated input fields. To obtain your API Key, visit your \"My Settings\" page on any of the Envato Marketplaces.\n4. Once the API connection has been established you will see a list of themes that can be auto installed. If you don\'t see any themes and are certain you\'ve done everything correct, there is a good chance the theme author has not updated their theme to be available for auto install and update. If that\'s the case, please contact the theme author and ask them to update their theme\'s information.\n\n== Changelog ==\n\n= 1.7.3 =\n* Added a custom user agent to all API requests so a connection is once again possible.\n* Added the option to turn sslverify on and off.\n* Envato API requests are now using HTTPS endpoints.\n* Replace `wp_remote_request` with `wp_safe_remote_request`, which will validated the API url.\n* Lowered the API request timeout to something more reasonable.\n\n= 1.7.2 =\n* Added checks to stop PHP from throwing redeclare class errors.\n* Fix an issue where the `ZipArchive` class was called before the `class_exists` check.\n* Fixed the Github Updater class so it now shows updates on `update-core.php`.\n* Changed the Github Updater class to pull in the contents of `readme.txt` to build the config array.\n* Changed the `raw_url` in `_admin_update_check` to use `raw.githubusercontent`, because `raw.github` causes a second `http` request.\n\n= 1.7.1 =\n* Fixed: Stop Mojo Marketplace from tracking your movements and causing long or hanging page loads.\n* Fixed: Fix an issue that caused the timeout to be set high globally.\n* Added: Ability to deactivate the Github Updater.\n* Fixed: Stopped `wp_list_themes` from making an API request before credentials have been entered into WordPress.\n* Fixed: Changed the menu position and load priority to stop Mojo Marketplace from hiding the Envato Toolkit menu item.\n* Fixed: Switched from `.png` to a font icon, which makes it Admin Color Scheme compatible.\n* Added: New i18n file and changed the domain from `envato` to `envato-wordpress-toolkit` to avoid potential conflicts.\n* Fixed: Changed the UI so it now has tabs for better content separation.\n* Fixed: Now uses the Customizer to preview installed themes.\n\n= 1.7.0 =\n* Fixed: Converted transient names into hashes to comply with character limits.\n* Fixed: Invalid argument supplied foreach warning.\n* Fixed: Call to undefined function wp_create_nonce.\n* Fixed: Changed the WP_GitHub_Updater class so it will properly name the directory.\n* Fixed: Decompression error caused by gzinflate().\n\n= 1.6.3 =\n* Fixed: Conflict with the WP-Compatibility Installer plugin.\n\n= 1.6.2 =\n* Fixed: Conflict with other plugins using the GitHub updater.\n\n= 1.6.1 =\n* set_time_limit errors are now hidden in favor of a more user-friendly message.\n* Make error notices dismissible.\n\n= 1.6 =\n* Fixed: Bug that prevented updating if backups were enabled.\n* Added auto-updating.\n* Various bug fixes.\n\n= 1.5 =\n* Changed use of cURL to the WordPress HTTP API\n* Removed ini_set usage\n\n= 1.4 =\n* Added support for theme backups during upgrade.\n* Allow backups to be turned off from within the UI.\n\n= 1.3 =\n* Added caching to the Envato Marketplace API requests.\n* Added support for Multisite.\n\n= 1.2 =\n* Updated register_setting group ID bug.\n\n= 1.1 =\n* Gutted the unnecessary files and classes.\n* Renamed the plugin and moved functions into a single class.\n* Updated strings for future Internationalization.\n\n= 1.0 =\n* Initial release with auto theme install and update.\n* Force an increase on \'max_execution_time\' to ensure large themes finish downloading.","yes");
INSERT INTO wp_options VALUES("40042","_site_transient_timeout_ewt_github_data","1459706963","yes");
INSERT INTO wp_options VALUES("40043","_site_transient_ewt_github_data","O:8:\"stdClass\":71:{s:2:\"id\";i:2558893;s:4:\"name\";s:24:\"envato-wordpress-toolkit\";s:9:\"full_name\";s:31:\"envato/envato-wordpress-toolkit\";s:5:\"owner\";O:8:\"stdClass\":17:{s:5:\"login\";s:6:\"envato\";s:2:\"id\";i:14786;s:10:\"avatar_url\";s:49:\"https://avatars.githubusercontent.com/u/14786?v=3\";s:11:\"gravatar_id\";s:0:\"\";s:3:\"url\";s:35:\"https://api.github.com/users/envato\";s:8:\"html_url\";s:25:\"https://github.com/envato\";s:13:\"followers_url\";s:45:\"https://api.github.com/users/envato/followers\";s:13:\"following_url\";s:58:\"https://api.github.com/users/envato/following{/other_user}\";s:9:\"gists_url\";s:51:\"https://api.github.com/users/envato/gists{/gist_id}\";s:11:\"starred_url\";s:58:\"https://api.github.com/users/envato/starred{/owner}{/repo}\";s:17:\"subscriptions_url\";s:49:\"https://api.github.com/users/envato/subscriptions\";s:17:\"organizations_url\";s:40:\"https://api.github.com/users/envato/orgs\";s:9:\"repos_url\";s:41:\"https://api.github.com/users/envato/repos\";s:10:\"events_url\";s:52:\"https://api.github.com/users/envato/events{/privacy}\";s:19:\"received_events_url\";s:51:\"https://api.github.com/users/envato/received_events\";s:4:\"type\";s:12:\"Organization\";s:10:\"site_admin\";b:0;}s:7:\"private\";b:0;s:8:\"html_url\";s:50:\"https://github.com/envato/envato-wordpress-toolkit\";s:11:\"description\";s:53:\"WordPress Toolkit for Envato Marketplace hosted items\";s:4:\"fork\";b:0;s:3:\"url\";s:60:\"https://api.github.com/repos/envato/envato-wordpress-toolkit\";s:9:\"forks_url\";s:66:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/forks\";s:8:\"keys_url\";s:74:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/keys{/key_id}\";s:17:\"collaborators_url\";s:89:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/collaborators{/collaborator}\";s:9:\"teams_url\";s:66:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/teams\";s:9:\"hooks_url\";s:66:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/hooks\";s:16:\"issue_events_url\";s:83:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/issues/events{/number}\";s:10:\"events_url\";s:67:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/events\";s:13:\"assignees_url\";s:77:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/assignees{/user}\";s:12:\"branches_url\";s:78:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/branches{/branch}\";s:8:\"tags_url\";s:65:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/tags\";s:9:\"blobs_url\";s:76:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/git/blobs{/sha}\";s:12:\"git_tags_url\";s:75:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/git/tags{/sha}\";s:12:\"git_refs_url\";s:75:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/git/refs{/sha}\";s:9:\"trees_url\";s:76:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/git/trees{/sha}\";s:12:\"statuses_url\";s:75:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/statuses/{sha}\";s:13:\"languages_url\";s:70:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/languages\";s:14:\"stargazers_url\";s:71:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/stargazers\";s:16:\"contributors_url\";s:73:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/contributors\";s:15:\"subscribers_url\";s:72:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/subscribers\";s:16:\"subscription_url\";s:73:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/subscription\";s:11:\"commits_url\";s:74:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/commits{/sha}\";s:15:\"git_commits_url\";s:78:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/git/commits{/sha}\";s:12:\"comments_url\";s:78:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/comments{/number}\";s:17:\"issue_comment_url\";s:85:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/issues/comments{/number}\";s:12:\"contents_url\";s:77:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/contents/{+path}\";s:11:\"compare_url\";s:84:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/compare/{base}...{head}\";s:10:\"merges_url\";s:67:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/merges\";s:11:\"archive_url\";s:83:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/{archive_format}{/ref}\";s:13:\"downloads_url\";s:70:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/downloads\";s:10:\"issues_url\";s:76:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/issues{/number}\";s:9:\"pulls_url\";s:75:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/pulls{/number}\";s:14:\"milestones_url\";s:80:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/milestones{/number}\";s:17:\"notifications_url\";s:100:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/notifications{?since,all,participating}\";s:10:\"labels_url\";s:74:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/labels{/name}\";s:12:\"releases_url\";s:74:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/releases{/id}\";s:15:\"deployments_url\";s:72:\"https://api.github.com/repos/envato/envato-wordpress-toolkit/deployments\";s:10:\"created_at\";s:20:\"2011-10-11T22:58:26Z\";s:10:\"updated_at\";s:20:\"2016-03-17T00:20:12Z\";s:9:\"pushed_at\";s:20:\"2015-11-16T04:47:53Z\";s:7:\"git_url\";s:52:\"git://github.com/envato/envato-wordpress-toolkit.git\";s:7:\"ssh_url\";s:50:\"git@github.com:envato/envato-wordpress-toolkit.git\";s:9:\"clone_url\";s:54:\"https://github.com/envato/envato-wordpress-toolkit.git\";s:7:\"svn_url\";s:50:\"https://github.com/envato/envato-wordpress-toolkit\";s:8:\"homepage\";s:0:\"\";s:4:\"size\";i:517;s:16:\"stargazers_count\";i:330;s:14:\"watchers_count\";i:330;s:8:\"language\";s:3:\"PHP\";s:10:\"has_issues\";b:1;s:13:\"has_downloads\";b:1;s:8:\"has_wiki\";b:1;s:9:\"has_pages\";b:0;s:11:\"forks_count\";i:133;s:10:\"mirror_url\";N;s:17:\"open_issues_count\";i:70;s:5:\"forks\";i:133;s:11:\"open_issues\";i:70;s:8:\"watchers\";i:330;s:14:\"default_branch\";s:6:\"master\";s:12:\"organization\";O:8:\"stdClass\":17:{s:5:\"login\";s:6:\"envato\";s:2:\"id\";i:14786;s:10:\"avatar_url\";s:49:\"https://avatars.githubusercontent.com/u/14786?v=3\";s:11:\"gravatar_id\";s:0:\"\";s:3:\"url\";s:35:\"https://api.github.com/users/envato\";s:8:\"html_url\";s:25:\"https://github.com/envato\";s:13:\"followers_url\";s:45:\"https://api.github.com/users/envato/followers\";s:13:\"following_url\";s:58:\"https://api.github.com/users/envato/following{/other_user}\";s:9:\"gists_url\";s:51:\"https://api.github.com/users/envato/gists{/gist_id}\";s:11:\"starred_url\";s:58:\"https://api.github.com/users/envato/starred{/owner}{/repo}\";s:17:\"subscriptions_url\";s:49:\"https://api.github.com/users/envato/subscriptions\";s:17:\"organizations_url\";s:40:\"https://api.github.com/users/envato/orgs\";s:9:\"repos_url\";s:41:\"https://api.github.com/users/envato/repos\";s:10:\"events_url\";s:52:\"https://api.github.com/users/envato/events{/privacy}\";s:19:\"received_events_url\";s:51:\"https://api.github.com/users/envato/received_events\";s:4:\"type\";s:12:\"Organization\";s:10:\"site_admin\";b:0;}s:13:\"network_count\";i:133;s:17:\"subscribers_count\";i:105;}","yes");
INSERT INTO wp_options VALUES("40044","_transient_timeout_wpseo-dashboard-totals","1459789968","no");
INSERT INTO wp_options VALUES("40045","_transient_wpseo-dashboard-totals","a:2:{i:0;a:0:{}i:1;a:0:{}}","no");
INSERT INTO wp_options VALUES("40046","_transient_timeout_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca","1459746568","no");
INSERT INTO wp_options VALUES("40047","_transient_feed_ac0b00fe65abe10e0c5b588f3ed8c7ca","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 01 Apr 2016 05:19:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:38:\"https://wordpress.org/?v=4.5-RC1-37156\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"WordPress 4.5 Release Candidate\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/news/2016/03/wordpress-4-5-release-candidate/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 24 Mar 2016 03:50:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4165\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:344:\"The release candidate for WordPress 4.5 is now available. We&#8217;ve made 49 changes since releasing Beta 4 a week ago. RC means we think we’re done, but with millions of users and thousands of plugins and themes, it’s possible we’ve missed something. We hope to ship WordPress 4.5 on Tuesday, April 12, but we need your help [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Mike Schroder\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2251:\"<p>The release candidate for WordPress 4.5 is now available.</p>\n<p>We&#8217;ve made <a href=\"https://core.trac.wordpress.org/log/trunk?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=37077&amp;stop_rev=37026&amp;limit=120&amp;verbose=on\">49 changes</a> since releasing Beta 4 a week ago. RC means we think we’re done, but with millions of users and thousands of plugins and themes, it’s possible we’ve missed something. We hope to ship WordPress 4.5 on <strong>Tuesday, April 12</strong>, but we need your help to get there.</p>\n<p>If you haven’t tested 4.5 yet, now is the time!</p>\n<p><strong>Think you&#8217;ve found a bug?</strong> Please post to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta support forum</a>. If any known issues come up, you&#8217;ll be able to <a href=\"https://core.trac.wordpress.org/report/5\">find them here</a>.</p>\n<p>To test WordPress 4.5, you can use the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin or you can <a href=\"https://wordpress.org/wordpress-4.5-RC1.zip\">download the release candidate here</a> (zip).</p>\n<p>For more information about what’s new in version 4.5, check out the <a href=\"https://wordpress.org/news/2016/02/wordpress-4-5-beta-1/\">Beta 1</a>, <a href=\"https://wordpress.org/news/2016/03/wordpress-4-5-beta-2/\">Beta 2</a>, <a href=\"https://wordpress.org/news/2016/03/wordpress-4-5-beta-3/\">Beta 3</a>, and <a href=\"https://wordpress.org/news/2016/03/wordpress-4-5-beta-4/\">Beta 4</a> blog posts.</p>\n<p><strong>Developers</strong>, please test your plugins and themes against WordPress 4.5 and update your plugin&#8217;s <em>Tested up to</em> version in the readme to 4.5 before next week. If you find compatibility problems, we never want to break things, so please be sure to post to the support forums so we can figure those out before the final release.</p>\n<p>Be sure to <a href=\"https://make.wordpress.org/core/\">follow along the core development blog</a>, where we&#8217;ll continue to post <a href=\"https://make.wordpress.org/core/tag/dev-notes+4-5/\">notes for developers</a> for 4.5.</p>\n<p><em>Free as in Freedom</em><br />\n<em>It is WordPress 4.5</em><br />\n<em>Also free as in beer</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n				\n		\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.5 Beta 4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2016/03/wordpress-4-5-beta-4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Mar 2016 04:30:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:4:\"beta\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4155\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.5 Beta 4 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.5, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Mike Schroder\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3392:\"<p>WordPress 4.5 Beta 4 is now available!</p>\n<p>This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.5, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.5-beta4.zip\" target=\"_blank\">download the beta here</a> (zip).</p>\n<p>For more information on what&#8217;s new in 4.5, check out the <a href=\"https://wordpress.org/news/2016/02/wordpress-4-5-beta-1/\">Beta 1</a>, <a href=\"https://wordpress.org/news/2016/03/wordpress-4-5-beta-2/\">Beta 2</a>, and <a href=\"https://wordpress.org/news/2016/03/wordpress-4-5-beta-3/\">Beta 3</a> blog posts, along with <a href=\"https://make.wordpress.org/core/tag/4-5+dev-notes/\">in-depth field guides on make/core</a>. This is the final <a href=\"https://make.wordpress.org/core/version-4-5-project-schedule/\">planned beta</a> of WordPress 4.5, with a release candidate scheduled for next week.</p>\n<p>Some of the changes in Beta 4 include:</p>\n<ul>\n<li>Add support for oEmbed <strong>moments and timelines from Twitter</strong> (<a href=\"https://core.trac.wordpress.org/ticket/36197\">#36197</a>).</li>\n<li>More changes to better support <strong>HHVM with Imagick</strong>.<strong> </strong>Please test with HHVM setups and resizing/rotating images (<a href=\"https://core.trac.wordpress.org/ticket/35973\">#35973</a>).</li>\n<li>Tightened up the <strong>Inline Link</strong> feature (<a href=\"https://core.trac.wordpress.org/ticket/33301\">#33301</a>, <a href=\"https://core.trac.wordpress.org/ticket/30468\">#30468</a>).</li>\n<li>Support <code>&lt;hr&gt;</code> <strong>editor shortcut</strong> with 3 or more dashes (<code>---</code>); no spaces. To give more time to study the best shortcuts for users, text patterns for bold and italic have been removed and won&#8217;t ship with for 4.5 (<a href=\"https://core.trac.wordpress.org/ticket/33300\">#33300</a>).</li>\n<li>Fixes for <strong>SSL with Responsive Images</strong>. Please test with SSL, especially on sites with mixed http/https setups (<a href=\"https://core.trac.wordpress.org/ticket/34945\">#34945</a>).</li>\n<li>Allow rewrite rules to work in nested <strong>WordPress installations on IIS</strong> (<a href=\"https://core.trac.wordpress.org/ticket/35558\">#35558</a>).</li>\n<li><strong>Various bug fixes</strong>. We&#8217;ve made <a href=\"https://core.trac.wordpress.org/log/?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=37025&amp;stop_rev=36932&amp;limit=200&amp;verbose=on\">almost 100 changes</a> during the last week.</li>\n</ul>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\" target=\"_blank\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\" target=\"_blank\">file one on the WordPress Trac</a>. There, you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\" target=\"_blank\">a list of known bugs.</a></p>\n<p>Happy testing!</p>\n<p class=\"p1\"><em>Llegamos al fin</em><br />\n<em>del tiempo pa&#8217; beta</em><br />\n<em>¡Pruébalo Ahora!</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n				\n		\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.5 Beta 3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2016/03/wordpress-4-5-beta-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Mar 2016 06:59:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:4:\"beta\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4128\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.5 Beta 3 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.5, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Mike Schroder\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3631:\"<p>WordPress 4.5 Beta 3 is now available!</p>\n<p>This software is still in development<strong>,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.5, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.5-beta3.zip\" target=\"_blank\">download the beta here</a> (zip).</p>\n<p>For more information on what&#8217;s new in 4.5, check out the <a href=\"https://wordpress.org/news/2016/02/wordpress-4-5-beta-1/\">Beta 1</a> and <a href=\"https://wordpress.org/news/2016/03/wordpress-4-5-beta-2/\">Beta 2</a> blog posts, along with <a href=\"https://make.wordpress.org/core/tag/4-5+dev-notes/\">in-depth field guides on make/core</a>. Some of the fixes in Beta 3 include:</p>\n<ul>\n<li>Many <strong>Theme Logo Support</strong> (<a href=\"https://core.trac.wordpress.org/ticket/33755\">#33755</a>) fixes, including support for bundled Twenty Fifteen (<a href=\"https://core.trac.wordpress.org/ticket/35944\">#35944</a>).</li>\n<li>Add <strong>Responsive Preview</strong> to theme install previewer (<a href=\"https://core.trac.wordpress.org/ticket/36017\">#36017</a>).</li>\n<li>Support <strong>Imagick in HHVM</strong> (<a href=\"https://core.trac.wordpress.org/ticket/35973\">#35973</a>).</li>\n<li><strong>Whitelist IPTC, XMP, and EXIF profiles</strong> from <code>strip_meta()</code> to maintain authorship, copyright, license, and image orientation (<a href=\"https://core.trac.wordpress.org/ticket/28634\">#28634</a>).</li>\n<li>Support <strong>Windows shares/DFS roots</strong> in <code>wp_normalize_path()</code> (<a href=\"https://core.trac.wordpress.org/ticket/35996\">#35996</a>).</li>\n<li><span class=\"s1\">New installs default to <strong>generating secret keys and salts locally</strong> instead of relying on the <span class=\"s2\">WordPress.org</span> API. Please test installing WP in situations where it can’t connect to the internet <span class=\"s1\">(like on a ?, ✈️, or ?) </span></span><span class=\"s1\">(<a href=\"https://core.trac.wordpress.org/ticket/35290\">#35290</a>).</span></li>\n<li>OPTIONS requests to REST API should <strong>return Allow header</strong> (<a href=\"https://core.trac.wordpress.org/ticket/35975\">#35975</a>).</li>\n<li>Upgrade twemoji.js to version 2 (<a href=\"https://core.trac.wordpress.org/ticket/36059\">#36059</a>) and add extra IE11 compatibility (<a href=\"https://core.trac.wordpress.org/ticket/35977\">#35977</a>) for <strong>Emoji</strong>.</li>\n<li><strong>Various bug fixes</strong>. We&#8217;ve made <a href=\"https://core.trac.wordpress.org/log/?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=36931&amp;stop_rev=36814&amp;limit=200&amp;verbose=on\">more than 100 changes</a> during the last week.</li>\n</ul>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\" target=\"_blank\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\" target=\"_blank\">file one on the WordPress Trac</a>. There, you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\" target=\"_blank\">a list of known bugs.</a></p>\n<p>Happy testing!</p>\n<p class=\"p1\"><em><span class=\"s1\">Beta one, two, three<br />\n</span><span class=\"s1\">so many bugs have been fixed<br />\n</span><span class=\"s2\">Closer now; four, five.</span></em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.5 Beta 2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2016/03/wordpress-4-5-beta-2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 03 Mar 2016 04:55:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4116\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.5 Beta 2 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.5, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Mike Schroder\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2370:\"<p>WordPress 4.5 Beta 2 is now available!</p>\n<p>This software is still in development<strong>,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.5, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.5-beta2.zip\" target=\"_blank\">download the beta here</a> (zip).</p>\n<p>For more information on what&#8217;s new in 4.5, check out the <a href=\"https://wordpress.org/news/2016/02/wordpress-4-5-beta-1/\">Beta 1 blog post</a>. Some of the fixes in Beta 2 include:</p>\n<ul>\n<li>Added <a href=\"https://core.trac.wordpress.org/ticket/33300\">Horizontal Rule (HR) editing shortcut</a> and <a href=\"https://core.trac.wordpress.org/ticket/28612\">dismissible &#8220;Paste as Text&#8221; notice</a> in <strong>TinyMCE</strong>.</li>\n<li><strong>Selective Refresh</strong> support is <a href=\"https://core.trac.wordpress.org/changeset/36797\">enabled for core themes titles and taglines</a>, which allows shift-click to focus on controls and PHP filters to apply in the preview.</li>\n<li>Resolved a fatal error on <strong>image upload</strong> when ImageMagick could not complete stripping meta during resize (<a href=\"https://core.trac.wordpress.org/ticket/33642\">#33642</a>).</li>\n<li><strong>Various bug fixes</strong>. We&#8217;ve made <a href=\"https://core.trac.wordpress.org/log/?action=stop_on_copy&amp;mode=stop_on_copy&amp;rev=36813&amp;stop_rev=36701&amp;limit=200&amp;verbose=on\">just over 100 changes</a> in the last week.</li>\n</ul>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\" target=\"_blank\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\" target=\"_blank\">file one on the WordPress Trac</a>. There, you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\" target=\"_blank\">a list of known bugs.</a></p>\n<p>Happy testing!</p>\n<p><em>It&#8217;s peer pressure time</em><br />\n<em>Testing: all cool kids do it</em><br />\n<em>Help find ALL the bugs!</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:33:\"\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"Contributor Weekend: One-Hour Video\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://wordpress.org/news/2016/02/contributor-weekend-one-hour-video/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 26 Feb 2016 19:36:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4112\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:349:\"It&#8217;s time for our second global contributor weekend, and this time we&#8217;re focusing on the video team. For this month&#8217;s challenge, in honor of it being our second month, you have two options for how you can participate! The challenge for this month overall is to work with at least one hour worth of WordCamp video, which [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"Jen\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2590:\"<p>It&#8217;s time for our second global contributor weekend, and this time we&#8217;re focusing on the <a href=\"https://make.wordpress.org/tv\">video team</a>. For this month&#8217;s challenge, in honor of it being our second month, you have two options for how you can participate! The challenge for this month overall is to work with at least one hour worth of WordCamp video, which you can do by either creating subtitles or editing the video file in preparation for upload to <a href=\"http://WordPress.tv\">WordPress.tv</a>.</p>\n<p>One of the great things about contributing to the video team is that you get to learn so much, since all the work basically involves watching WordCamp presentation videos. Subtitling is a doubly important need, as it is needed to make all those WordCamp videos accessible to people who are deaf or hard of hearing and can&#8217;t listen to the audio track, as well as making it possible for the videos to be consumed (in some cases after subtitle translation) by people who speak different languages.</p>\n<p>The challenge will last from Saturday, February 27, 2016 through Sunday, February 28, 2016, and the results will be reviewed afterward by members of the video team. If you enjoy the challenge, the video team would be very excited to welcome you into their ranks! Interested? <a href=\"https://wp.me/P6onIa-28D\">Here&#8217;s how to participate</a>.</p>\n<h3>What About Last Month?</h3>\n<p>In January, the inaugural contributor weekend was focused on the support forums. That challenge had 73 participants, including 10 people who provided 20 or more correct answers to open support threads, thereby winning the challenge. Congratulations to Harris Anastasiadis, Ahmad Awais, Takis Bouyouris, Phil Erb, Eric Gunawan, Jackie McBride, Diana Nichols, Kostas Nicolacopoulos, Juhi Saxena, and Sarah Semark! To them and to everyone else who participated, thank you <strong>so much</strong> for your efforts. Every answer helps, and over the course of this contributor weekend, these amazing volunteers responded to <strong>800 support threads</strong>. The support forums queue of requests with no replies went from 28 pages to 7 pages &#8212; that was an incredible success, of which every participant was a part!</p>\n<p>So head on over to see how to <a href=\"https://wp.me/P6onIa-28D\">get involved with the one-hour video challenge</a> this weekend, and help us make next month&#8217;s post just as impressive! <img src=\"https://s.w.org/images/core/emoji/72x72/1f642.png\" alt=\"?\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:41:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n	\n\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 4.5 Beta 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2016/02/wordpress-4-5-beta-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 25 Feb 2016 03:27:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4080\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:329:\"WordPress 4.5 Beta 1 is now available! This software is still in development, so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.5, try the WordPress Beta Tester plugin (you’ll want “bleeding edge nightlies”). Or you can [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:2:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:62:\"https://wordpress.org/news/files/2016/02/wp-inline-linking.mp4\";s:6:\"length\";s:6:\"409018\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:62:\"https://wordpress.org/news/files/2016/02/wp-editor-updates.mp4\";s:6:\"length\";s:6:\"231953\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Mike Schroder\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5453:\"<p>WordPress 4.5 Beta 1 is now available!</p>\n<p><strong>This software is still in development,</strong> so we don’t recommend you run it on a production site. Consider setting up a test site just to play with the new version. To test WordPress 4.5, try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\">WordPress Beta Tester</a> plugin (you’ll want “bleeding edge nightlies”). Or you can <a href=\"https://wordpress.org/wordpress-4.5-beta1.zip\" target=\"_blank\">download the beta here</a> (zip).</p>\n<p>WordPress 4.5 is slated for release on <a href=\"https://make.wordpress.org/core/version-4-5-project-schedule/\" target=\"_blank\">April 12</a>, but to get there, we need your help testing what we have been working on, including:</p>\n<ul>\n<li><strong>Responsive Preview of your site in the Customizer </strong>(<a href=\"https://core.trac.wordpress.org/ticket/31195\">#31195</a>) &#8211; See how your site looks in <a href=\"https://make.wordpress.org/core/2016/01/28/previewing-site-responsiveness-in-the-customizer/\">mobile, tablet, and desktop</a> contexts before making changes to its appearance.</li>\n<li><strong>Theme Logo Support </strong>(<a href=\"https://core.trac.wordpress.org/ticket/33755\">#33755</a>) &#8211; Native support for a <a href=\"https://make.wordpress.org/core/2016/02/24/theme-logo-support/\">theme logo within the Customizer</a>.</li>\n<li><strong>Inline Link Editing</strong> (<a href=\"https://core.trac.wordpress.org/ticket/33301\">#33301</a>) &#8211; Within the visual editor, <a href=\"https://wordpress.org/news/files/2016/02/wp-inline-linking.mp4\">edit links inline</a> for a smoother workflow.</li>\n<li><strong>Additional Editor Shortcuts</strong> (<a href=\"https://core.trac.wordpress.org/ticket/33300\">#33300</a>) &#8211; <a href=\"https://wordpress.org/news/files/2016/02/wp-editor-updates.mp4\">Includes a few new shortcuts</a>, like <code>`..`</code> for <code>code</code> and <code>**..**</code> for <strong>bold</strong>.</li>\n<li><strong>Comment Moderation Improvements </strong>(<a href=\"https://core.trac.wordpress.org/ticket/34133\">#34133</a>) &#8211; An enhanced experience when moderating comments, including preview with rendered formatting.</li>\n<li><strong>Optimization of Image Generation </strong>(<a href=\"https://core.trac.wordpress.org/ticket/33642\">#33642</a>) &#8211; Image sizes are generated more efficiently and remove unneeded meta, while still including color profiles in Imagick, for reduced sizes of up to 50% with near identical visual quality.</li>\n</ul>\n<p>&nbsp;</p>\n<p>There have been changes for developers to explore as well:</p>\n<ul>\n<li><strong>Selective Refresh </strong>(<a href=\"https://core.trac.wordpress.org/ticket/27355\">#27355</a>)<strong> </strong>&#8211; A <a href=\"https://make.wordpress.org/core/2016/02/16/selective-refresh-in-the-customizer/\">comprehensive framework</a> for rendering parts of the customizer preview in real time. Theme and plugin authors should test their widgets specifically for compatibility with selective refresh, and note that it <a href=\"https://core.trac.wordpress.org/ticket/35855\">may ultimately be opt-in for 4.5</a>.</li>\n<li><strong>Backbone and Underscore updated to latest versions</strong> (<a href=\"https://core.trac.wordpress.org/ticket/34350\">#34350</a>)<b> </b>&#8211; Backbone is upgraded from 1.1.2 to 1.2.3 and Underscore is upgraded from 1.6.0 to 1.8.3. See the <a href=\"https://make.wordpress.org/core/2016/02/17/backbone-and-underscore-updated-to-latest-versions/\">this post</a> for important changes.</li>\n<li><strong>Embed templates</strong> (<a href=\"https://core.trac.wordpress.org/ticket/34561\">#34561</a>) &#8211; Embed templates were split into parts and can now be directly overridden by themes via the template hierarchy.</li>\n<li><strong>New WP_Site class</strong> (<a href=\"https://core.trac.wordpress.org/ticket/32450\">#32450</a>) &#8211; More object-oriented approach for managing sites in Multisite</li>\n<li><strong>Script loader</strong> (<a href=\"https://core.trac.wordpress.org/ticket/14853\">#14853</a>, <a href=\"https://core.trac.wordpress.org/ticket/35873\">#35873</a>) &#8211; Introduces <code>wp_add_inline_script()</code> for including inline JavaScript just like <code>wp_add_inline_style()</code> works for CSS, and better support for script header/footer dependencies.</li>\n</ul>\n<p>If you want a more in-depth view of what major changes have made it into 4.5, <a href=\"https://make.wordpress.org/core/tag/4-5/\" target=\"_blank\">check out all 4.5-tagged posts</a> on the main development blog, or check out a <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;resolution=fixed&amp;milestone=4.5&amp;group=component&amp;order=priority\">list of everything</a> that&#8217;s changed.</p>\n<p><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\" target=\"_blank\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\" target=\"_blank\">file one on the WordPress Trac</a>. There, you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\" target=\"_blank\">a list of known bugs.</a></p>\n<p>Happy testing!</p>\n<p><em>A wonderful day</em><br />\n<em>is one that brings new WordPress</em><br />\n<em>Four Five Beta One</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"Experiment: WordCamp Incubator\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://wordpress.org/news/2016/02/experiment-wordcamp-incubator/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 18 Feb 2016 19:28:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4076\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:399:\"WordCamps are locally-organized WordPress conferences that happen all over the world (and are so fun). Sometimes people don&#8217;t realize that WordCamps are organized by local volunteers rather than a central organization, and they contact us asking, &#8220;Can you bring WordCamp to my city?&#8221; When this happens, we always suggest they start with a meetup group, and think about [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"Jen\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2989:\"<p><a href=\"http://wordcamp.org\">WordCamps</a> are locally-organized WordPress conferences that happen all over the world (and are so fun). Sometimes people don&#8217;t realize that WordCamps are organized by local volunteers rather than a central organization, and they contact us asking, &#8220;Can you bring WordCamp to my city?&#8221; When this happens, we always suggest they start with a meetup group, and think about organizing a WordCamp themselves after their group has been active for a few months. We emphasize that WordCamps are locally-organized events, not something that the central <a href=\"https://make.wordpress.org/community\">community team</a> plans from afar.</p>\n<p>This has been successful in many areas &#8212; there are currently 241 meetup groups on our meetup.com chapter program! In some regions, though, enthusiastic volunteers have had more of a challenge getting things started. Because of this, we&#8217;re going to try an experiment this year called the WordCamp Incubator.</p>\n<p>The intention of the incubator program is to help spread WordPress to underserved areas through providing more significant organizing support for a first event. In practical terms, this experiment means we&#8217;ll be choosing three cities in 2016 where there is not an active WordPress community &#8212; but where it seems like there is a lot of potential and where there are some people excited to become organizers &#8212; and will help to organize their first WordCamp. These WordCamps will be small, one-day, one-track events geared toward the goal of generating interest and getting people involved in creating an ongoing local community.*</p>\n<p>So, where should we do these three events?  If you have always wanted a WordCamp in your city but haven&#8217;t been able to get a meetup group going, this is a great opportunity. We will be taking applications for the next week, then will get in touch with everyone who applied to discuss the possibilities. We will announce the  cities chosen by the end of March.</p>\n<p>To apply, <a href=\"http://wordpressdotorg.polldaddy.com/s/wordcamp-incubator-application\">fill in the application</a> by February 26, 2016. You don&#8217;t need to have any specific information handy, it&#8217;s just a form to let us know you&#8217;re interested. You can apply to nominate your city even if you don&#8217;t want to be the main organizer, but for this experiment  we will need local liaisons and volunteers, so please only nominate cities where you live or work so that we have at least one local connection to begin.</p>\n<p>Thanks, and good luck!</p>\n<p><em><strong>* </strong>For the record, that describes the ideal first WordCamp even if you have an active meetup &#8212; there&#8217;s no need to wait until your group is big enough to support a large multi-day event, and small events are a lot of fun because everyone has a chance to be involved and get to know most of the other attendees.</em></p>\n<p>&nbsp;</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:36:\"\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 4.4.2 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wordpress.org/news/2016/02/wordpress-4-4-2-security-and-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Feb 2016 17:57:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4065\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:375:\"WordPress 4.4.2 is now available. This is a security release for all previous versions and we strongly encourage you to update your sites immediately. WordPress versions 4.4.1 and earlier are affected by two security issues: a possible SSRF for certain local URIs, reported by Ronni Skansing; and an open redirection attack, reported by Shailesh Suthar. Thank you [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Samuel Sidler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2072:\"<p>WordPress 4.4.2 is now available. This is a <strong>security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>WordPress versions 4.4.1 and earlier are affected by two security issues: a possible SSRF for certain local URIs, reported by <a href=\"https://www.linkedin.com/in/ronni-skansing-36143b65\">Ronni Skansing</a>; and an open redirection attack, reported by <a href=\"https://twitter.com/shailesh4594\">Shailesh Suthar</a>.</p>\n<p>Thank you to both reporters for practicing <a href=\"https://make.wordpress.org/core/handbook/testing/reporting-security-vulnerabilities/\">responsible disclosure</a>.</p>\n<p>In addition to the security issues above, WordPress 4.4.2 fixes 17 bugs from 4.4 and 4.4.1. For more information, see the <a href=\"https://codex.wordpress.org/Version_4.4.2\">release notes</a> or consult the <a href=\"https://core.trac.wordpress.org/query?milestone=4.4.2\">list of changes</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.4.2</a> or venture over to Dashboard → Updates and simply click “Update Now.” Sites that support automatic background updates are already beginning to update to WordPress 4.4.2.</p>\n<p>Thanks to everyone who contributed to 4.4.2:</p>\n<p><a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/berengerzyla\">berengerzyla</a>, <a href=\"https://profiles.wordpress.org/boonebgorges\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/chandrapatel\">Chandra Patel</a>, <a href=\"https://profiles.wordpress.org/chriscct7\">Chris Christoff</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/firebird75\">firebird75</a>, <a href=\"https://profiles.wordpress.org/ivankristianto\">Ivan Kristianto</a>, <a href=\"https://profiles.wordpress.org/jmdodd\">Jennifer M. Dodd</a>, <a href=\"https://profiles.wordpress.org/salvoaranzulla\">salvoaranzulla</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n				\n		\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"Contributor Weekend: Support Forums\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://wordpress.org/news/2016/01/contributor-weekend-support-forums/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 22 Jan 2016 18:31:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:12:\"contributors\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:14:\"Support Forums\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4055\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:351:\"Our first global contributor drive is coming up next weekend, January 30-31, 2016, and we want you to be involved! Many of our current contributors first got involved at a Contributor Day at a WordCamp or WordPress Meetup event near them, but not everyone has had that opportunity, so we&#8217;re trying to create an online experience that [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"Jen\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2112:\"<p>Our first global contributor drive is coming up next weekend, January 30-31, 2016, and we want you to be involved!</p>\n<p>Many of our current contributors first got involved at a Contributor Day at a <a href=\"http://wordcamp.org\">WordCamp</a> or <a href=\"http://www.meetup.com/pro/wordpress/\">WordPress Meetup</a> event near them, but not everyone has had that opportunity, so we&#8217;re trying to create an online experience that will give new contributors the same kind of live support and group dynamic. We&#8217;ll be doing these as weekend challenges rather than one-day events so that WordPress users all over the world can participate without worrying about pesky time zones, but each challenge will be designed to be completed within a few hours, comparable to an in-person Contributor Day.</p>\n<p>Our inaugural Contributor Weekend is focused on the <a href=\"https://make.wordpress.org/support\">Support Team</a> &#8212; the folks who volunteer their time to help people with WordPress questions in the <a href=\"https://wordpress.org/support\">support forums</a> and <a href=\"https://make.wordpress.org/support/irc-support-channel/\">IRC</a>. Over the two day span, forum moderators will be available online to help new contributors and answer questions as needed. The challenge this month is called <em>20 Questions;</em> your mission (should you choose to accept it) is to help WordPress users by answering 20 forum support requests over the course of the weekend.</p>\n<p>You can participate on your own, or you can get together with other people from your local meetup group and work on it together. Working together in person is really fun, so we highly recommend trying to get some folks together if you&#8217;re able, but if that&#8217;s not possible you can still connect to other participants online. Either way, this is a great way to give back to the WordPress project and have some fun helping people at the same time.</p>\n<p>Interested? <a href=\"https://make.wordpress.org/support/20-questions/\">Get the details on how to participate</a>.</p>\n<p>Hope to see you next weekend!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:39:\"\n		\n		\n		\n		\n				\n		\n		\n\n		\n		\n				\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WordPress 4.4.1 Security and Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://wordpress.org/news/2016/01/wordpress-4-4-1-security-and-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 06 Jan 2016 20:07:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=4041\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:376:\"WordPress 4.4.1 is now available. This is a security release for all previous versions and we strongly encourage you to update your sites immediately. WordPress versions 4.4 and earlier are affected by a cross-site scripting vulnerability that could allow a site to be compromised. This was reported by Crtc4L. There were also several non-security bug fixes: Emoji [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Aaron Jorbin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5153:\"<p>WordPress 4.4.1 is now available. This is a <strong>security release</strong> for all previous versions and we strongly encourage you to update your sites immediately.</p>\n<p>WordPress versions 4.4 and earlier are affected by a cross-site scripting vulnerability that could allow a site to be compromised. This was <a href=\"https://make.wordpress.org/core/handbook/reporting-security-vulnerabilities/\">reported</a> by <a href=\"https://hackerone.com/crtc4l\">Crtc4L</a>.</p>\n<p>There were also several non-security bug fixes:</p>\n<ul>\n<li>Emoji support has been updated to include all of the latest emoji characters, including the new diverse emoji! <img src=\"https://s.w.org/images/core/emoji/72x72/1f44d.png\" alt=\"?\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><img src=\"https://s.w.org/images/core/emoji/72x72/1f3ff.png\" alt=\"?\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><img src=\"https://s.w.org/images/core/emoji/72x72/1f44c.png\" alt=\"?\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><img src=\"https://s.w.org/images/core/emoji/72x72/1f3fd.png\" alt=\"?\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><img src=\"https://s.w.org/images/core/emoji/72x72/1f44f.png\" alt=\"?\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><img src=\"https://s.w.org/images/core/emoji/72x72/1f3fc.png\" alt=\"?\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></li>\n<li>Some sites with older versions of OpenSSL installed were unable to communicate with other services provided through some plugins.</li>\n<li>If a post URL was ever re-used, the site could redirect to the wrong post.</li>\n</ul>\n<p>WordPress 4.4.1 fixes 52 bugs from 4.4. For more information, see the <a href=\"https://codex.wordpress.org/Version_4.4.1\">release notes</a> or consult the <a href=\"https://core.trac.wordpress.org/query?milestone=4.4.1\">list of changes</a>.</p>\n<p><a href=\"https://wordpress.org/download/\">Download WordPress 4.4.1</a> or venture over to Dashboard → Updates and simply click “Update Now.” Sites that support automatic background updates are already beginning to update to WordPress 4.4.1.</p>\n<p>Thanks to everyone who contributed to 4.4.1:</p>\n<p><a href=\"https://profiles.wordpress.org/aaroncampbell\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/afercia\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/nacin\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/azaozz\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/boonebgorges\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/Compute\">Compute</a>, <a href=\"https://profiles.wordpress.org/redsweater\">Daniel Jalkut (Red Sweater)</a>, <a href=\"https://profiles.wordpress.org/DvanKooten\">Danny van Kooten</a>, <a href=\"https://profiles.wordpress.org/dd32\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90\">Dominik Schilling (ocean90)</a>, <a href=\"https://profiles.wordpress.org/dossy\">Dossy Shiobara</a>, <a href=\"https://profiles.wordpress.org/eherman24\">Evan Herman</a>, <a href=\"https://profiles.wordpress.org/pento\">Gary Pendergast</a>, <a href=\"https://profiles.wordpress.org/gblsm\">gblsm</a>, <a href=\"https://profiles.wordpress.org/hnle\">Hinaloe</a>, <a href=\"https://profiles.wordpress.org/igmoweb\">Ignacio Cruz Moreno</a>, <a href=\"https://profiles.wordpress.org/jadpm\">jadpm</a>, <a href=\"https://profiles.wordpress.org/jeffpyebrookcom/\">Jeff Pye Brook</a>, <a href=\"https://profiles.wordpress.org/joemcgill\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/johnbillion\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/JPr\">jpr</a>, <a href=\"https://profiles.wordpress.org/obenland\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/KrissieV\">KrissieV</a>, <a href=\"https://profiles.wordpress.org/tyxla\">Marin Atanasov</a>, <a href=\"https://profiles.wordpress.org/wp-architect\">Matthew Ell</a>, <a href=\"https://profiles.wordpress.org/meitar\">Meitar</a>, <a href=\"https://profiles.wordpress.org/swissspidy\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/rogerhub\">Roger Chen</a>, <a href=\"https://profiles.wordpress.org/rmccue\">Ryan McCue</a>, <a href=\"https://profiles.wordpress.org/salcode\">Sal Ferrarello</a>, <a href=\"https://profiles.wordpress.org/wonderboymusic\">Scott Taylor</a>, <a href=\"https://profiles.wordpress.org/scottbrownconsulting\">scottbrownconsulting</a>, <a href=\"https://profiles.wordpress.org/SergeyBiryukov\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/ShinichiN\">Shinichi Nishikawa</a>, <a href=\"https://profiles.wordpress.org/smerriman\">smerriman</a>, <a href=\"https://profiles.wordpress.org/netweb\">Stephen Edgar</a>, <a href=\"https://profiles.wordpress.org/stephenharris\">Stephen Harris</a>, <a href=\"https://profiles.wordpress.org/tharsheblows\">tharsheblows</a>, <a href=\"https://profiles.wordpress.org/voldemortensen\">voldemortensen</a>, and <a href=\"https://profiles.wordpress.org/webaware\">webaware</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:10:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Sun, 03 Apr 2016 17:09:27 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Fri, 01 Apr 2016 05:19:35 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 250\";}s:5:\"build\";s:14:\"20130911040210\";}","no");
INSERT INTO wp_options VALUES("40048","_transient_timeout_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca","1459746568","no");
INSERT INTO wp_options VALUES("40049","_transient_feed_mod_ac0b00fe65abe10e0c5b588f3ed8c7ca","1459703368","no");
INSERT INTO wp_options VALUES("40050","_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9","1459746568","no");
INSERT INTO wp_options VALUES("40051","_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9","a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"WPTavern: In Case You Missed It – Issue 6\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=53139&preview_id=53139\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"http://wptavern.com/in-case-you-missed-it-issue-6\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5496:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/01/ICYMIFeaturedImage.png\" rel=\"attachment wp-att-50955\"><img class=\"size-full wp-image-50955\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/01/ICYMIFeaturedImage.png?resize=676%2C292\" alt=\"In Case You Missed It Featured Image\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/112901923@N07/16153818039\">Night Moves</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-nc/2.0/\">(license)</a>\n<p>There’s a lot of great WordPress content published in the community but not all of it is featured on the Tavern. This post is an assortment of items related to WordPress that caught my eye but didn’t make it into a full post.</p>\n<h2>Jen Mylo Moves on From Automattic</h2>\n<p>Jen Mylo, formerly known as Jane Wells, <a href=\"http://jenmylo.com/2016/03/23/end-of-an-era/\">announced she has left</a> her position at Automattic after eight years to pursue other opportunities. Normally, people switching or leaving jobs isn&#8217;t news but Mylo is an exception to the rule because of the impact she&#8217;s had on the WordPress project and community over those eight years.</p>\n<p>From leading the effort to redesign the <a href=\"https://wordpress.org/news/2008/12/coltrane/\">WordPress 2.7 &#8220;Coltrane&#8221;</a> backend which was code-named <a href=\"https://wordpress.org/news/2008/10/the-new-27-dashboard/\">Crazyhorse</a>, to helping WordCamp organizers behind the scenes, to the <a href=\"https://make.wordpress.org/community/2015/01/15/remembering-kim-parsell/\">Kim Parsell travel scholarship</a>. She also facilitated and helped many WordPress lead developers.</p>\n<p>Thanks Jen for everything you&#8217;ve done and contributed to the WordPress project and its community. I wish and hope for the best for you in your future endeavors.</p>\n<h2>Generous in Spirit</h2>\n<p>Carrie Dils reminds us that the WordPress community is generous of spirit. If you haven&#8217;t experienced it yet, get in touch with her and she&#8217;ll introduce you.</p>\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">The <a href=\"https://twitter.com/hashtag/WordPress?src=hash\">#WordPress</a> community is so generous of spirit. If you feel disconnected from it and want to be a part, message me &amp; I\'ll introduce you.</p>\n<p>&mdash; carrie dils (@cdils) <a href=\"https://twitter.com/cdils/status/715339254000275456\">March 31, 2016</a></p></blockquote>\n<p></p>\n<h2>How to Protect a GPL Licensed Plugin from Being Copied</h2>\n<p>There&#8217;s <a href=\"https://www.facebook.com/groups/advancedwp/permalink/1126950354033844/\">a post on the Advanced WordPress Facebook group</a> that asks, what are the best ways to protect a GPL licensed plugin from being copied? The thread has more than a dozen responses with many explaining that copying is at the core of the license. The simple answer is that you don&#8217;t.</p>\n<h2>Comparison: Working from Home vs In an Office</h2>\n<p>The Onion <a href=\"http://www.theonion.com/graphic/working-home-vs-working-office-52630?utm_medium=RSS&utm_campaign=feeds\">compares what it&#8217;s like</a> to work from home as opposed to working in an office. I think the humorous comparisons ring true for many.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/04/TheOnionComparesWorkFromHome.jpg\"><img class=\"size-full wp-image-53144\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/04/TheOnionComparesWorkFromHome.jpg?resize=960%2C1121\" alt=\"Working From Home Compared to Working In an Office\" /></a>Working From Home Compared to Working In an Office\n<h2>WordPress 4.5 Field Guide</h2>\n<p>Everything you need to know to prepare for WordPress 4.5 is in <a href=\"https://make.wordpress.org/core/2016/03/30/wordpress-4-5-field-guide/\">the field guide</a>. Thanks to Aaron Jorbin for putting the guide together as it&#8217;s a great resource for those not able to keep up with development.</p>\n<h2>Jumboji</h2>\n<p>The only thing better than emoji in core is jumbo emoji. Thankfully, <a href=\"https://wordpress.org/plugins/big-emoji-comments/\">there&#8217;s a plugin</a> available that turns emoji into almost larger than life emoji.</p>\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">I am delighted to unveil Big Emoji Comments (Jumboji) for WordPress: <a href=\"https://t.co/AcEBzmvjCV\">https://t.co/AcEBzmvjCV</a> <a href=\"https://t.co/3g6Ii8AsUg\">pic.twitter.com/3g6Ii8AsUg</a></p>\n<p>&mdash; george ﬆephanis (@daljo628) <a href=\"https://twitter.com/daljo628/status/712822383208505344\">March 24, 2016</a></p></blockquote>\n<p></p>\n<h2>Gianuu or Italian Wapuu!</h2>\n<p>In what is a traditional part of this series, I end each issue by featuring a Wapuu design. For those who don&#8217;t know, Wapuu is the <a href=\"http://wapuu.jp/2015/12/12/wapuu-origins/\">unofficial mascot</a> of the WordPress project. Gianduu is the official mascot of <a href=\"https://2016.torino.wordcamp.org/\">WordCamp Torino 2016</a>. Gianduu is a mix between Gianuja, a famous carnival mask and Gianduiotto, a Turin confectionery tradition.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/04/Gianduu.png\"><img class=\"size-full wp-image-53145\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/04/Gianduu.png?resize=744%2C817\" alt=\"Gianduu\" /></a>Gianduu\n<p>That&#8217;s it for issue six. If you recently discovered a cool resource or post related to WordPress, please share it with us in the comments.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 01 Apr 2016 22:23:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"WPTavern: Features-as-Plugins First Transitions Into Features-as-Projects\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=53097\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"http://wptavern.com/features-as-plugins-first-transitions-into-features-as-projects\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7058:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/04/FeaturesAsPluginsFeaturedImage.png\"><img class=\"size-full wp-image-53129\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/04/FeaturesAsPluginsFeaturedImage.png?resize=689%2C346\" alt=\"Features as projects featured image\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/25132305@N05/3514532960\">Office Pranks</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-nc-sa/2.0/\">(license)</a>\n<p>Last year, I <a href=\"http://wptavern.com/the-features-as-plugins-first-model-is-a-mess\">identified key factors</a> that suggested the <strong>features-as-plugins</strong> first model was falling apart. A lack of communication, direction, buy-in from core developers, and synchronized development between plugins on Github and WordPress.org were some of the contributing factors highlighted.</p>\n<h2>Features-as-Projects</h2>\n<p>WordPress lead developer <a href=\"http://profiles.wordpress.org/helen\" target=\"_blank\">Helen Hou-Sandí</a> has <a href=\"https://make.wordpress.org/core/2016/03/31/iterating-on-feature-plugins/\">outlined a new strategy</a> for the model transitioning from a <strong>features-as-plugins</strong> approach to <strong>features-as-projects. </strong></p>\n<p>&#8220;Thinking of features as plugins has strapped us in a number of ways, in large part because the &#8216;plugin&#8217; part implies a functional project from the start,&#8221; Hou-Sandí said.</p>\n<p>&#8220;From observation, experienced and newer contributors alike set their initial goal to be some sort of functional plugin. As a result, by the time something is being proposed in whatever forum, there’s been a fair amount of effort spent – and personal attachment developed – for something that might be headed in the wrong direction. Changing direction at that point is very demoralizing and has led to burn out and less participation.&#8221;<strong><br />\n</strong></p>\n<h2>A New Page for Featured Projects</h2>\n<p>Feature projects are listed <a href=\"https://make.wordpress.org/core/features/\">on a new page</a> which includes a brief explanation of the problems being solved. Active projects include WordPress NUX which aims to remove barriers to entry and Font Natively which switches to system fonts to load faster and provide a more native experience.</p>\n<p>Anyone can suggest a feature project but its mission statement must clearly address what problem it&#8217;s trying to solve, its goals, and how it fits into <a href=\"https://wordpress.org/about/philosophy/\">WordPress&#8217; core philosophies</a> and objective. The new page also serves as a roadmap for future feature projects.</p>\n<p>By changing their approach, the core team hopes to achieve the following individual goals.</p>\n<ul>\n<li>To attract and retain a greater range of skill sets in contributors, for example through being able to more thoroughly engage designers in early stages.</li>\n<li>Implementing methods of collecting usage information and other data.</li>\n<li>Supporting feature projects with resources for user testing and more structured feedback.</li>\n<li>Advance both contributor and general community knowledge around product design and development.</li>\n</ul>\n<p>Beginning <a href=\"http://www.timeanddate.com/worldclock/fixedtime.html?iso=20160405T1700\">Tuesday, April 5th, 2016 at 1PM Eastern Daylight Time</a>, in the <a href=\"https://make.wordpress.org/chat/\">#core Slack channel</a>, bi-weekly meetings will be held where people can propose and discuss feature projects. These meetings are also where project leaders can ask for help, provide status updates, and maintain direction.</p>\n<h2>Design and Discovery First</h2>\n<p>Perhaps one of the most important changes in the process is the focus on discovery and design first. Instead of testing features after they&#8217;re developed, this plan focuses on gathering testing and usage data from users before technical implementation occurs.</p>\n<p>&#8220;Feature design and development should come from interviews with users, developed personas, surveys of those personas, documented flows, and other fairly standard methods,&#8221; Hou-Sandí said.</p>\n<p>&#8220;Proper discovery will allow for testing long before functional development begins using low-fidelity storyboards and walking through potential concepts with users, both verbally and visually. Projects should check in at a meeting when discovery results are available and continue to check in through the design process.&#8221;</p>\n<p>Even though the discovery and design phase may not lead to a full-fledged feature in core, the process should help discover pain points along the way which can translate into other improvements.</p>\n<h2>Iterating is Not Just For Software</h2>\n<p>The new model incorporates <a href=\"https://make.wordpress.org/core/2014/11/03/open-update-thread/#comment-20735\">many of the suggestions</a> by WordPress lead developer, Ryan Boren from 2014.</p>\n<ul>\n<li>Be present and up-to-date in the plugin directory.</li>\n<li>Be as ready to go on mobile as they are on desktop.</li>\n<li>Have visual records for major flows through all new interfaces on all devices.</li>\n<li>Have mature UI that isn’t going to derail the release train.</li>\n<li>Have a history of posting weekly updates to make/core.</li>\n<li>Have a history of regular plugin directory updates.</li>\n<li>Have a testing audience.</li>\n<li>Publish a merge consideration post on make/core complete with visual records and other diligence.</li>\n<li>Exist for at least one release cycle. Plugins created at the beginning of a release cycle should not be considered for merge until the next release.</li>\n</ul>\n<p>It also focuses on establishing a direction for a project early on instead of people aimlessly developing it to see where it goes. It&#8217;s worth noting that <a href=\"https://make.wordpress.org/core/2016/03/31/iterating-on-feature-plugins/#comment-29594\">Boren supports </a>the changes to the model.</p>\n<p>Early feedback suggests this is a great move. Michelle Schulp, Founder of <a href=\"http://marktimemedia.com/\">Marktime Media</a>, had this to say about the changes:</p>\n<blockquote><p>Love this, not only because it a) treats WordPress more like an actual product where decisions on features should be tested and vetted before they’re built, and b) validates the design and discovery process as &#8216;important to WordPress&#8217; and saves a ton of unnecessary dev time, but also c) will help encourage those with other important talents like design/ux/ui/user testing (but not core-level development skills) to contribute.</p></blockquote>\n<p>Although I suggested renaming feature plugins to feature experiments, feature projects is pretty good name. It&#8217;s nice to see the model evolve and address many of the problems I outlined in 2015. I encourage you to <a href=\"https://make.wordpress.org/core/2016/03/31/iterating-on-feature-plugins/\">read the full post</a> and let us know what you think of the changes.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 01 Apr 2016 20:47:19 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"WPTavern: bbPress 2.6 Expected Later This Year, Two Major Features Pushed Back to 2.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=53134\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"http://wptavern.com/bbpress-2-6-expected-later-this-year-two-major-features-pushed-back-to-2-7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1961:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/06/bbpress.png\"><img class=\"aligncenter size-full wp-image-24338\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2014/06/bbpress.png?resize=1025%2C378\" alt=\"bbpress\" /></a>There hasn&#8217;t been a lot of news about bbPress lately but earlier this week on the project&#8217;s development blog, John James Jacoby <a href=\"https://bbpress.org/blog/2016/03/an-update-on-bbpress-2-6/\">provided a status update</a> on the progress of 2.6 and what to expect for 2.7.</p>\n<p>According to the post, the team has worked hard on 2.6 since <a href=\"https://bbpress.org/blog/2013/11/bbpress-2-5-released/\">2.5&#8217;s release</a> in 2013. Unfortunately, two highly anticipated features that were expected to be in 2.6 have been pushed back to 2.7. Jacoby explains why:</p>\n<blockquote><p>Stephen and I have been steadily improving and readying the next major version (2.6) ever since releasing 2.5.0, and while many huge features and neat little improvements have already landed in the development version, there are 2 features that will likely get bumped to 2.7 so we can call 2.6 done:</p>\n<ul>\n<li>bbPress as Post Comments</li>\n<li>Forums as Taxonomies</li>\n</ul>\n<p>These two features are fully architected and planned, but do not have enough progress in code for them to hold up the release of 2.6.</p></blockquote>\n<p>Users can expect to see betas and release candidates of bbPress 2.6 in the coming weeks. Jacoby notes that development on 2.7 will exclusively focus on the two missing features.</p>\n<p>As someone who is waiting on the bbPress as Post Comments feature before diving into bbPress, I&#8217;m disappointed. I&#8217;m grateful for the time and effort Jacoby, Stephen Edgar, and others put into the project but considering its release history, it may be another 1-2 years before 2.7 is a reality. I don&#8217;t know if I can wait that long.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 01 Apr 2016 20:34:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: BuddyPress 2.6 Development Kicks Off, David Cavins to Lead Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=53003\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"http://wptavern.com/buddypress-2-6-development-kicks-off-david-cavins-to-lead-release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3909:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/02/buddypress-wallpapers1.png\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/02/buddypress-wallpapers1.png?resize=800%2C450\" alt=\"buddypress-wallpapers\" class=\"aligncenter size-full wp-image-16156\" /></a></p>\n<p>Development on BuddyPress 2.6 began this week with a meeting to set the schedule and scope for the release. The BuddyPress project recently moved to adopt <a href=\"https://make.wordpress.org/core/2015/04/01/release-leads-for-wordpress-4-3-and-4-4/\" target=\"_blank\">release leads</a> as part of the core development process.</p>\n<p>“The release lead gets a sense at the beginning of the dev cycle what he/she would like to accomplish, as well as what others want and are willing to contribute,&#8221; Boone Gorges said during last week&#8217;s development meeting. &#8220;Within those parameters, there is likely lots of room for the lead to make decisions about what the focus should be.”</p>\n<p><a href=\"https://twitter.com/daveycavey\" target=\"_blank\">David Cavins</a> was named release lead for the upcoming 2.6 release and <a href=\"https://profiles.wordpress.org/mercime\" target=\"_blank\">@mercime</a> will be on deck for 2.7. During <a href=\"https://wordpress.slack.com/archives/buddypress/p1459364425000688\" target=\"_blank\">this week&#8217;s meeting</a>, Cavins set a schedule for 2.6:</p>\n<ul>\n<li>Beta: May 25</li>\n<li>RC1: June 8</li>\n<li>Official Release: June 15</li>\n</ul>\n<p>Cavins said that 2.6 will focus on performance and UI polish, as many of the tickets filed for the milestone fall into those general categories. Contributors chimed in during the meeting to express interest in working on specific goals and tickets:</p>\n<ul>\n<li>A new API to manage single items navigation (<a href=\"https://buddypress.trac.wordpress.org/ticket/6534\" target=\"_blank\">#6534</a>)</li>\n<li>Incrementor-based caching for ID queries (<a href=\"https://buddypress.trac.wordpress.org/ticket/6643\" target=\"_blank\">#6643</a>)</li>\n<li>Explore implementing Behat to add a functional testing capability to the project</li>\n<li>Extend BuddyPress&#8217; use of caching to group memberships</li>\n<li>Framework for bulk data handling after updates (#<a href=\"https://buddypress.trac.wordpress.org/ticket/6841\" target=\"_blank\">6841</a>)</li>\n</ul>\n<p>Cavins is also organizing a few &#8220;<a href=\"https://bpdevel.wordpress.com/2016/03/30/bp-work-parties-april-2016/\" target=\"_blank\">BuddyPress Work Parties</a>&#8221; early in the release cycle where contributors can get together to collaborate on tickets, documentation, testing patches, and answering support questions.</p>\n<p>In addition to the new release leads concept, the BuddyPress core team is also considering implementing component maintainers, similar to the way WordPress core is organized.</p>\n<p>&#8220;It gives newcomers a sense of where to look if they have questions about a part of BP, or want to get involved in contributing,&#8221; Gorges said. &#8220;It also creates a sense of ownership for people who are already doing the practical work of triaging certain kinds of tickets, and encourages people to step up and take a role of responsibility.&#8221;</p>\n<p>BuddyPress project lead John James Jacoby said that component maintainers has been one of his personal leadership goals for BuddyPress for a long time, with individuals and eventually teams &#8220;owning&#8221; components to make them shine.</p>\n<p>&#8220;The main reasons to do it are empowering people to make decisions, and to elevate everyone&#8217;s contributions by promoting within and creating goals for contributors to graduate to, to celebrate their value,&#8221; Jacoby said.</p>\n<p>Specific maintainers and/or teams have not yet been identified but the core team is working towards making this more official to streamline contributions.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 01 Apr 2016 20:13:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"Post Status: WordPress Questions &amp; Answers — Draft podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=23159\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://poststatus.com/wordpress-questions-answers-draft-podcast/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:5738:\"<p>Welcome to the Post Status <a href=\"https://poststatus.com/category/draft\">Draft podcast</a>, which you can find <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\">on iTunes</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\">Stitcher</a>, and <a href=\"http://simplecast.fm/podcasts/1061/rss\">via RSS</a> for your favorite podcatcher. Post Status Draft is hosted by Joe Hoyle &#8212; the CTO of Human Made &#8212; and Brian Krogsgard.</p>\n<p><span>Today, we answer questions from Post Status community members, who asked us all sorts of stuff on the <a href=\"https://poststatus.com/ask/\">Post Status Ask</a> page. If you&#8217;d like to ask a question, be sure to go there and we&#8217;ll see if we can answer it on a future show.</span></p>\n<!--[if lt IE 9]><script>document.createElement(\'audio\');</script><![endif]-->\n<a href=\"https://audio.simplecast.com/34442.mp3\">https://audio.simplecast.com/34442.mp3</a>\n<p><a href=\"http://audio.simplecast.com/34442.mp3\">Direct Download</a></p>\n<h3>Questions &amp; Links</h3>\n<p><span>We answered the following questions:</span></p>\n<p><strong>Why WordPress?</strong></p>\n<p>In a survey I did before my PressNomics talk, the top answer for what&#8217;s important to people in regards to the WordPress world was the quality of the community. WordPress&#8217; ubiquity &#8212; powering 26% of the web &#8212; helps too.</p>\n<p><strong>What is the biggest mistake you made learning WordPress? (Or, what would you do differently?)</strong></p>\n<p>Joe and I each shared what we tend to do wrong when learning new things. We are fully on opposite ends of the spectrum. Recommended link: <a href=\"http://justbuildwebsites.com/\">Just Build Websites</a>. Also, my post on <a href=\"https://poststatus.com/learn-wordpress-development/\">learning WordPress</a>s holds up pretty well, considering I wrote it in 2014.</p>\n<p><strong>Why did a lot of web and WordPress people get upset about the Mandrill pricing changes, when we want people to value the work we&#8217;re doing ourselves?</strong></p>\n<p>We discuss what made Mandrill&#8217;s pricing changes controversial, and why we think some level of &#8220;outcry&#8221; is understandable here. Basically, Mandrill isn&#8217;t differentiated enough to warrant the new pricing, in our opinions. However, it&#8217;s obviously their right to change their pricing and structure, and the questioner has a valid point in how we value other services versus our own.</p>\n<p><strong>The WordPress REST API clearly has the attention of savvy WordPress developers, but will it really change WordPress as we know it?</strong></p>\n<p>It&#8217;s hard to know exactly how the REST API will change WordPress. It partly depends on how extensive the core inclusion of the API is. But at a minimum, the WordPress REST API plugin will be maintained and offer a new way of interacting with WordPress for anyone that wants to do so. And efforts into learning the API will definitely be transferable to using other REST APIs on the web.</p>\n<p><strong>Why isn&#8217;t the WordPress importer being worked on more intensively?</strong></p>\n<p>Good question! We talk about the state of the importer, some other options like <a href=\"https://deliciousbrains.com/wp-migrate-db-pro/\">WP Migrate DB Pro</a>, <a href=\"http://www.wpallimport.com/\">WP All Import</a>, and <a href=\"http://wp-cli.org/commands/import/\">WP CLI</a>. We also discuss how to get involved with open source development.</p>\n<p><strong>Should taxonomies have the same feature capabilities as posts in the future?</strong></p>\n<p>There&#8217;s been a lot of interesting work on taxonomies in the last several releases, and you can read more about some of that and find links going back from my <a href=\"https://poststatus.com/wordpress-4-4/\">release post for WordPress 4.4</a>. However, we think taxonomies and posts should be different. With the introduction of term meta, it is more important to consider architectural choices well in advance. Finally, the <a href=\"https://make.wordpress.org/core/tag/fields-api/\">Fields API</a> will be interesting in how it affects customizing term edit screens.</p>\n<p><strong>How should I use my own domains with Multisite?</strong></p>\n<p>This turned interesting! Fortunately, Multisite component maintainer Jeremy Felt came through while we were on the show to point us to tickets that were merged in WordPress 3.9 for <a href=\"https://core.trac.wordpress.org/ticket/27003\">enabling simpler domain mapping</a>, and in 4.3, when <a href=\"https://core.trac.wordpress.org/ticket/22383\">a better UI was introduced</a>. So, today, it&#8217;s much easier to use a custom domain in a network &#8212; within the existing WordPress Multisite options interface &#8212; versus using a tool like <a href=\"https://github.com/humanmade/Mercator\">Mercator</a>.</p>\n<hr />\n<p>In addition to these questions, we also banter on about some other things and answer a few less serious questions we got from funny listeners. And at the end, I make a pretty big announcement&#8230;</p>\n<hr />\n<p>Today’s podcast is sponsored by Design Palette Pro. Design Palette Pro makes it easy to customize pretty much any Genesis theme, without touching code. It’s perfect for when you’re helping a friend with a website, but they don’t have a full service budget and you don’t have time to custom code every element. Get a great website in no time, with Design Palette Pro. Go to <a href=\"https://genesisdesignpro.com/\">GenesisDesignPro.com</a> for more information. Thank you to the team at <a href=\"http://reaktivstudios.com/\">Reaktiv Studios</a>, who builds Design Palette Pro, for being a Post Status partner.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 01 Apr 2016 19:21:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"Akismet: Akismet WordPress Plugin 3.1.10\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://blog.akismet.com/?p=1909\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"http://blog.akismet.com/2016/04/01/akismet-wordpress-plugin-3-1-10/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1161:\"<p>Version 3.1.10 of <a href=\"http://wordpress.org/plugins/akismet/\">the Akismet plugin for WordPress</a> is now available.</p>\n<p>This update fixes a bug that could cause comments caught as spam to end up in the Pending queue. It also fixes the History entries for comments caught by WordPress&#8217;s built-in Comment Blacklist in WordPress 4.4 or later.</p>\n<p>Version 3.1.10 is confirmed compatible with WordPress 4.5, which is <a href=\"https://wordpress.org/news/2016/03/wordpress-4-5-release-candidate/\">coming soon</a>.</p>\n<p>To upgrade, visit the Updates page of your WordPress dashboard and follow the instructions. If you need to download the plugin zip file directly, links to all versions are available in <a href=\"http://wordpress.org/plugins/akismet/\">the WordPress plugins directory</a>.</p><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/akismet.wordpress.com/1909/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/akismet.wordpress.com/1909/\" /></a> <img alt=\"\" border=\"0\" src=\"http://pixel.wp.com/b.gif?host=blog.akismet.com&blog=116920&post=1909&subd=akismet&ref=&feed=1\" width=\"1\" height=\"1\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 01 Apr 2016 17:07:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Christopher Finke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"WPTavern: Jetpack 3.9.6 Fixes Bug that Inserts Random Vimeo Videos into Comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=53075\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"http://wptavern.com/jetpack-3-9-6-fixes-bug-that-inserts-random-vimeo-videos-into-comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2109:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/jetpack-lego.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/jetpack-lego.jpg?resize=1024%2C504\" alt=\"photo credit: Tek F - cc\" class=\"size-full wp-image-33617\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/tekf/3509155200/\">Tek F</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nc-sa/2.0/\">cc</a>\n<p><a href=\"http://jetpack.com/2016/03/31/jetpack-3-9-5-maintenance-release/\" target=\"_blank\">Jetpack 3.9.5</a> was released yesterday with compatibilities for the upcoming WordPress 4.5 release and a handful of enhancements/bug fixes. Shortly after issuing the routine maintenance update, the Jetpack team began <a href=\"https://wordpress.org/support/topic/update-to-395-major-issue-adding-un-wanted-video-to-comments\" target=\"_blank\">receiving</a> <a href=\"https://wordpress.org/support/topic/update-to-395-major-issue-adding-un-wanted-video-to-comments\" target=\"_blank\">reports</a> of random, unwanted videos being added to the comments of posts. Any number string in the comments was automatically converted into a Vimeo video.</p>\n<p>No, this bug was not an April Fool&#8217;s Day prank, although it seemed like it. As a temporary fix, support representatives recommended that users deactivate the Shortcode Embeds module.</p>\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">We’re aware of an issue with numbers in comments embedding random Vimeo videos and are working to get 3.9.6 out as a fix ASAP.</p>\n<p>&mdash; Jetpack (@jetpack) <a href=\"https://twitter.com/jetpack/status/715603405432074240\">March 31, 2016</a></p></blockquote>\n<p></p>\n<p>The Jetpack team scrambled to fix the rather humorous and annoying bug, which had been introduced while fixing <a href=\"https://github.com/Automattic/jetpack/issues/3534\" target=\"_blank\">another Vimeo bug</a>. A few hours later they shipped 3.9.6 on the heels of the maintenance release. Users who updated to 3.9.5 right away will need to update again in order to avoid running into this bug.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 01 Apr 2016 04:43:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"WPTavern: WordPress.org UX Research Begins as Part of Long-Term Plan for Redesign\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=53042\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"http://wptavern.com/wordpress-org-ux-research-begins-as-part-of-long-term-plan-for-redesign\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3995:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/06/survey.jpg\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/06/survey.jpg?resize=1025%2C507\" alt=\"photo credit: Lukasz Kowalewski\" class=\"size-full wp-image-44957\" /></a>photo credit: <a href=\"https://stocksnap.io/photo/FI3UYVGNFD\">Lukasz Kowalewski</a>\n<p>WordPress.org is second only to WordPress.com in Google search results for &#8220;WordPress,&#8221; followed by the project&#8217;s download, about, and featured themes pages. Unfortunately, visitors to WordPress.org land on an outdated website that doesn&#8217;t accurately represent the vibrance of the WordPress project and its strong community. As the face of the open source project, WordPress.org is in desperate need of a redesign.</p>\n<p>Designer Hugo Baeta is currently gathering feedback on the user experience of the site as part of a long-term plan for its improvement. WordPress.org is a slow-moving machine when it comes to updates and design changes, but Baeta&#8217;s research is a solid first step towards action.</p>\n<p>&#8220;As we take on efforts of documenting and creating more polished and art directed design foundations for the WordPress project as a whole, the .org sites need to get some love as well,&#8221; Baeta said.</p>\n<p>He posted <a href=\"https://make.wordpress.org/meta/2016/03/30/wordpress-org-ux-research/\" target=\"_blank\">results of a lengthy 55-question survey</a>, summarizing anonymous feedback from 32 of WordPress&#8217; most active contributors &#8211; project leads, team reps, and highly active community members. The survey asked open-ended questions to encourage honest feedback on the site&#8217;s biggest pain-points.</p>\n<p>&#8220;This survey will help us get a better idea of the direction we need to go on a long-term plan to make improvements to WordPress.org, building a more solid and thought-out foundation so the community can grow and thrive for years to come,&#8221; Baeta said.</p>\n<p>For 81% of respondents, the primary reason they visit WordPress.org is to contribute to WordPress. Nearly all agreed that the design feels tired, old, outdated, and inconsistent. It&#8217;s not surprising, given the sample&#8217;s demographic, that most respondents rarely (if ever) visit the WordPress download page, the themes directory, hosting, or showcase pages.</p>\n<p>Overall, the survey&#8217;s participants find the current design to be inconsistent and confusing to navigate unless you are an insider. Several responses communicated frustration that the site isn&#8217;t 100% WordPress and that its underlying code prevents it from being easily updated.</p>\n<p>Survey participants offered both sharp criticism and constructive feedback. If you have the time and inclination, the <a href=\"https://make.wordpress.org/meta/2016/03/30/wordpress-org-ux-research/\" target=\"_blank\">results</a> are worth a read.</p>\n<p>WordPress.org serves two different types of users: contributors and the millions of people who use and the software. Baeta did not indicate his next step in the UX research, but it would be worthwhile to sample some first time visitors and users who frequent the pages that contributors don&#8217;t often visit.</p>\n<p>While open source software websites aren&#8217;t usually known for their cutting edge designs, many inspirational examples can be found at <a href=\"http://beautifulopen.com/\" target=\"_blank\">BeautifulOpen.com</a>. Browsing that catalogue, it&#8217;s clear that WordPress.org could greatly benefit from a brighter, more user-friendly design.</p>\n<p>Companies like Wix and Weebly, some of WordPress&#8217; commercial competitors, could never get away with having websites that don&#8217;t demonstrate the quality of their products. If WordPress is going to continue to grow past its current 26% market share, the project&#8217;s website should reflect its reputation of being easy-to-use software for creating beautiful websites.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 31 Mar 2016 21:48:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"WPTavern: WPWeekly Episode 228 – Communication is Key\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=53084&preview_id=53084\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"http://wptavern.com/wpweekly-episode-228-communication-is-key\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3473:\"<p>We didn&#8217;t have a guest this week so <a href=\"http://marcuscouch.com/\">Marcus Couch</a> and I discuss the latest news and events happening in the WordPress community. We update listeners as to the status of the W3 Total Cache plugin. This segues into a conversation on whether caching plugins are necessary considering the improvements in technology in the last decade.</p>\n<p>We congratulate Rian Rietveld on winning the Heroes of Accessibility award and then dive deep into why communication is a key component of success for developers. We provide a status update on WordPress 4.5 and end the show with the plugin picks of the week.</p>\n<h2>Stories Discussed:</h2>\n<p><a href=\"http://wptavern.com/frederick-townes-confirms-w3-total-cache-is-not-abandoned\">Frederick Townes Confirms W3 Total Cache is Not Abandoned</a><br />\n<a href=\"http://wptavern.com/versions-of-wp-cli-prior-to-0-23-0-are-incompatible-with-wordpress-4-5\">Versions of WP-CLI Prior to 0.23.0 Are Incompatible with WordPress 4.5</a><br />\n<a href=\"http://wptavern.com/draft-and-save-customizer-changes-for-later-with-new-customize-snapshots-plugin\">Draft and Save Customizer Changes for Later with New Customize Snapshots Plugin</a><br />\n<a href=\"http://wptavern.com/modern-tribe-acquires-gigpress-exploring-saas-events-management-solution\">Modern Tribe Acquires GigPress, Exploring SaaS Events Management Solution</a><br />\n<a href=\"http://wptavern.com/wordpress-contributor-rian-rietveld-wins-heroes-of-accessibility-award\">WordPress Contributor Rian Rietveld Wins Heroes of Accessibility Award</a><br />\n<a href=\"http://wptavern.com/a-little-communication-goes-a-long-way\">A Little Communication Goes a Long Way</a><br />\n<a href=\"https://make.wordpress.org/core/2016/03/30/wordpress-4-5-field-guide/\">WordPress 4.5 Field Guide</a></p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/flatty-flat-admin-theme/\">Flatty &#8211; Flat Admin Theme</a> is a new Admin theme based off the flat design trend of 2015. Simply install the plugin and configure how you want the admin area to look.</p>\n<p><a href=\"https://wordpress.org/plugins/scratching-effect/\">Scratching Effect</a> allows you to easily simulate a gift card or instant lottery ticket by adding a scratchable area to your site.</p>\n<p><a href=\"https://wordpress.org/plugins/fb-instant-articles/\">Facebook Instant Articles for WP</a> adds support for Instant Articles for Facebook, which is a new way for publishers to distribute fast, interactive stories on Facebook. Instant Articles are preloaded in the Facebook mobile app so they load instantly.</p>\n<p><a href=\"https://wordpress.org/plugins/wapuufall/\">Wapuu Fall plugin</a> allows you to have falling Wapuus, similar to a falling snow plugin.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, April 6th 9:30 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"http://www.wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #228:</strong><br />\n</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 31 Mar 2016 21:30:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"WPTavern: A Week of REST: WordPress REST API Developer Bootcamp Coming to the UK Late 2016\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=53059\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"http://wptavern.com/a-week-of-rest-wordpress-rest-api-developer-bootcamp-coming-to-the-uk-late-2016\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2086:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/bootcamp.jpg\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/bootcamp.jpg?resize=1024%2C532\" alt=\"photo credit: November Company – Confidence Course – Nov. 18, 2015 - (license)\" class=\"size-full wp-image-53064\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/59356205@N02/23194697112\">November Company – Confidence Course – Nov. 18, 2015</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-nc/2.0/\">(license)</a>\n<p>A Day of REST, the first conference dedicated to the WordPress REST API, was held in London at the end of January 2016, hosted by the events team at <a href=\"https://hmn.md/\" target=\"_blank\">Human Made</a>. Attendees offered overwhelmingly positive feedback after the conference finished, with <a href=\"http://wptavern.com/a-day-of-rest-conference-successful-81-would-attend-again\" target=\"_blank\">81% of the 221 participants saying they would attend again</a>.</p>\n<p>The event&#8217;s organizers announced today that the next WP REST API conference will be held in the UK in late 2016. <a href=\"https://aweekofrest.hm/\" target=\"_blank\">A Week of REST</a> is being organized as a four-day residential developer bootcamp. As such, the £1,500 (~$2157 USD) ticket price is for an immersive experience that includes all meals, accommodation, and training.</p>\n<p>After the first conference, attendees indicated that they would be interested in a longer event that offered more advanced training. Although specific sessions have not yet been announced, organizers are focusing the bootcamp around three main learning objectives: how to leverage the WordPress REST API, creating your own API with custom endpoints, and displaying WordPress data in a frontend JavaScript application.</p>\n<p>Developers can sign up at <a href=\"https://aweekofrest.hm/\" target=\"_blank\">aweekofrest.hm</a> to indicate interest in the event and subscribe to updates from the organization team. Location and exact dates will be announced soon.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 31 Mar 2016 17:56:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"WPTavern: Latte: A Free One-Page WordPress Theme to Showcase Your Profile\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52997\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"http://wptavern.com/latte-a-free-one-page-wordpress-theme-to-showcase-your-profile\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4485:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/latte.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/latte.png?resize=1025%2C477\" alt=\"latte\" class=\"aligncenter size-full wp-image-53014\" /></a></p>\n<p><a href=\"https://wordpress.org/themes/latte/\" target=\"_blank\">Latte</a> is a new parallax style WordPress portfolio theme created by <a href=\"http://www.hardeepasrani.com/\" target=\"_blank\">Hardeep Asrani</a>. The 19-year old developer from India already has 17 plugins and four themes to his credit on WordPress.org. We recently featured his work on the <a href=\"http://wptavern.com/write-css-in-the-customizer-with-the-advanced-css-editor-plugin\" target=\"_blank\">Advanced CSS Editor</a> plugin, which allows users to write CSS in the customizer.</p>\n<p>Latte follows suit with extensive customizer options for every section of the one-page scrolling theme. It was created for developers, designers, and freelancers who want to feature their work in a visual resume format with a profile photo, short bio, services, newsletter subscription, and more. Each of these sections are optional and can be turned on/off with a simple checkbox in the customizer.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/latte-customizer.png\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/latte-customizer.png?resize=1025%2C578\" alt=\"latte-customizer\" class=\"aligncenter size-full wp-image-53019\" /></a></p>\n<p>Latte theme users can choose to highlight different skills, portfolio items, blog posts, and/or services they provide. It is geared towards individuals who want to lead with their profile and keep all their relevant information on the home page.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/skills-portfolio.png\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/skills-portfolio.png?resize=1025%2C664\" alt=\"skills-portfolio\" class=\"aligncenter size-full wp-image-53023\" /></a></p>\n<p>In many one-page scrolling themes, blog posts become somewhat of an afterthought that don&#8217;t receive the same design attention. Latte, on the other hand, includes a simple, tasteful single post design that is harmonious with the rest of the site. A blog header image can be set in the customizer to be unique or match the rest of the site.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/latte-single-post.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/latte-single-post.png?resize=1025%2C647\" alt=\"latte-single-post\" class=\"aligncenter size-full wp-image-53028\" /></a></p>\n<p>If you&#8217;re not a fan of the preloader or the scrolling parallax animations, you can disable them in the customizer. The theme supports a slide-out navigation menu, which can also be disabled if you plan to keep all the content on the homepage without posting any blogs.</p>\n<p>Asrani built 100+ color control options into the theme and prides himself on its customizability. Latte&#8217;s homepage states that if you find something in the theme which is not customizable, then he will work on adding it to the theme.</p>\n<p>The services, skills, and subscribe sections are widgetized areas where the content is generated by special widgets that are included in the theme. <a href=\"https://themes.svn.wordpress.org/latte/0.6/documentation/Latte%20Documentation.pdf\" target=\"_blank\">Documentation</a> for setting up the various sections is included in the theme&#8217;s zip file. If you want to add pricing tables, a contact form, portfolio section, or a map, you&#8217;ll need to purchase the pro version. To Asrani&#8217;s credit, the free version is not cluttered by pro version &#8220;teaser&#8221; controls in the customizer.</p>\n<p>Check out the <a href=\"http://www.hardeepasrani.com/demo/latte/\" target=\"_blank\">live demo</a> to see each of the available sections in action on the page.</p>\n<p>Latte offers a welcome alternative to clunky, confusing page builders or drag-and-drop editors. With everything in the customizer, the user doesn&#8217;t have to hunt around for how to edit its many sections. If you want a simple one-page theme to showcase your profile and services, you&#8217;d be hard pressed to find one more customizable than Latte. <a href=\"https://wordpress.org/themes/latte/\" target=\"_blank\">Download</a> it for free from WordPress.org or via your admin themes browser.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 30 Mar 2016 19:04:50 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"WPTavern: A Little Communication Goes a Long Way\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52977\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"http://wptavern.com/a-little-communication-goes-a-long-way\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4926:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/01/CommunicationFeaturedImage.jpg\"><img class=\"size-full wp-image-15569\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/01/CommunicationFeaturedImage.jpg?resize=637%2C200\" alt=\"Communication Featured Image\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/elycefeliz/3224486233/\">elycefeliz</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nc-nd/2.0/\">cc</a>\n<p>Whether you manage WordPress plugins, themes, or a service, a key component to keeping users happy is communication. Users and especially paying customers want to know what&#8217;s going on. Going an extended period of time without communicating leads to doubt, a feeling of abandonment, and speculation.</p>\n<p>Communicating is not hard and these days, developers have more ways than ever to keep users and customers informed. If you&#8217;re experiencing writer&#8217;s block or don&#8217;t know what to write about, here are a few ideas.</p>\n<ul>\n<li>New Features</li>\n<li>Major Bug Fixes</li>\n<li>White Papers</li>\n<li>User Testimonials/Reviews</li>\n<li>Major Changes or Announcements</li>\n</ul>\n<p>The key is to maintain a cycle where you communicate, users and customers provide feedback, and implement the feedback into continued improvements. While it doesn&#8217;t always work this way, it&#8217;s an ideal strategy that keeps developers and users on the same page.</p>\n<h2>Controlling The Flow of Information</h2>\n<p>Ideally, a news site is not the first place users should discover what&#8217;s going on with a particular project. Blogs attached to a project&#8217;s site are an excellent way to keep insiders and outsiders informed. By utilizing Facebook, Twitter, change logs, and a blog, you control the flow of information and what you want people to know.</p>\n<p>Speaking of change logs, last year, <a href=\"http://wptavern.com/wordpress-plugin-developers-need-to-communicate-better-in-change-logs\">I offered advice</a> on what information to include and how to differentiate between the changes. Users read change logs and should be an important part of any developer&#8217;s communication strategy.</p>\n<h2>How Much Communication?</h2>\n<p>There&#8217;s no set rule on how much you should communicate but with all the options available, there&#8217;s no excuse not to push out a few updates a week. However, this all depends on how many users you have, how much development activity is going on, etc. Sometimes, there&#8217;s nothing to report and that&#8217;s fine. When it becomes concerning is when there is a lack of communication after a month or more.</p>\n<h2>Communication Can Make or Break a Business</h2>\n<p>Most of what I&#8217;ve discussed so far deals with software development. However, there is one aspect of communication that can make or break a business and that&#8217;s during a security issue.</p>\n<p>If your plugin, theme, or service experiences a security issue, the best thing to do is own it, be as transparent as possible, and inform users immediately. A great example is when <a href=\"https://ithemes.com/2014/09/23/important-security-update-for-all-customers/\">iThemes experienced a security breach</a> in late 2014, that affected approximately 60,000 customers.</p>\n<p>iThemes CEO Cory Miller could have swept the breach under the rug and fix things behind the scenes but instead, chose to <a href=\"http://wptavern.com/ithemes-suffers-security-breach-customers-urged-to-reset-passwords\">immediately inform customers</a>. In his post, he explains what happened, takes full responsibility, and explains what they&#8217;re going to do to make things right.</p>\n<p>As the company learned more about the breach, they shared that information with customers and the public. Thanks to Miller’s honest approach of attacking the issue head on, a lot of upset customers pledged their support for the company.</p>\n<h2>Be Honest</h2>\n<p>If iThemes chose to keep the breach under wraps for as long as possible, chances are that at some point it would be exposed likely causing the company irreparable damage. Humans are not perfect and security vulnerabilities happen, but it&#8217;s how they&#8217;re handled that can make or break a business.</p>\n<p>Be honest with yourself and to those giving you money. Nothing good happens by ignoring customers or setting unrealistic expectations.</p>\n<p>As the user and customer base of plugins, themes, and services increases, so does the impact of communication. You don&#8217;t have to write a thesis every week but it&#8217;s nice to know that the developers behind a project have a pulse, especially if it&#8217;s for something people are paying for.</p>\n<p>If communication is something you&#8217;re struggling with, let us know in the comments. If you develop a popular theme or plugin, let us know what your strategy is for keeping people informed.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 29 Mar 2016 23:24:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"WPTavern: Keep Track of Your WordPress.org Themes and Plugins with WP Dev Dashboard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52662\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:93:\"http://wptavern.com/keep-track-of-your-wordpress-org-themes-and-plugins-with-wp-dev-dashboard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4595:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/controls.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/controls.jpg?resize=960%2C443\" alt=\"photo credit: 	Drew Patrick Miller\" class=\"size-full wp-image-52988\" /></a>photo credit: <a href=\"https://stocksnap.io/photo/2724C9A9DE\">	Drew Patrick Miller</a>\n<p>The official <a href=\"https://wordpress.org/plugins/\" target=\"_blank\">plugin directory</a> is arguably the best place to host a plugin if you&#8217;re looking for the widest distribution, but it&#8217;s also one of the most inhospitable for developers. A current meta team <a href=\"https://make.wordpress.org/meta/2016/02/25/plugin-directory-v3/\" target=\"_blank\">initiative</a> is focused on improving search, including prioritizing translated plugins for international users, and streamlining plugin submission, among other improvements. This <a href=\"http://wptavern.com/the-wordpress-plugin-directory-is-getting-a-makeover\" target=\"_blank\">major overhaul</a> is slated to be finished at the end of June 2016.</p>\n<p>In the meantime, WordPress.org plugin author <a href=\"http://mickeykaycreative.com/\" target=\"_blank\">Mickey Kay</a> has created a plugin that he intends to be the go-to resource for plugin and theme authors looking for a better management experience. The <a href=\"https://wordpress.org/plugins/wp-dev-dashboard/\" target=\"_blank\">WP Dev Dashboard</a> plugin offers statistics for all of your WordPress.org plugins and themes in one convenient dashboard, along with a list of unresolved support requests.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/wp-dev-dashboard.gif\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/wp-dev-dashboard.gif?resize=1025%2C814\" alt=\"wp-dev-dashboard\" class=\"aligncenter size-full wp-image-52980\" /></a></p>\n<p>In a post titled &#8220;<a href=\"http://mickeykay.me/2016/03/model-for-new-wordpress-plugin-directory/\" target=\"_blank\">A model for the new WordPress plugin directory</a>,&#8221; Kay identifies some of the common pain points that developers experience with the existing directory: &#8220;dependency on SVN instead of Git, inconsistent search results, inclusion of obsolete information, obfuscation of more important statistics, etc.&#8221;</p>\n<p>Kay built WP Dev Dashboard to assist those who are trying to manage numerous extensions on WordPress.org, a process that currently requires drilling down into each plugin/theme to view data and support requests.</p>\n<p>&#8220;If I had to sum up the main problem I&#8217;m trying to solve, it&#8217;d be something like this: As a developer, and now maintainer of 16 plugins, it&#8217;s become all too easy for me to lose track of support requests, outdated core WP compatibility, and last updated dates,&#8221; Kay said.</p>\n<p>&#8220;The current directory requires developers to manually click through to each plugin via their &#8220;<a href=\"https://profiles.wordpress.org/mcguive7/#content-plugins\" target=\"_blank\">dashboard</a>&#8221; to check these stats. Plus, there are no options for notifications and/or other helpful automated features that would make my life much simpler.&#8221;</p>\n<p>When he first released the plugin, he planned to launch a free, hosted service that could automatically send out regular notifications for things like unresolved tickets and daily/weekly/monthly download counts. The hosted service would provide a centralized command center for managing WordPress.org-hosted extensions.</p>\n<p>&#8220;I haven&#8217;t built anything yet as there&#8217;s so much talk about building out a better solution natively within WordPress.org,&#8221; Kay said. &#8220;My strong preference would be for the new plugin directory efforts to incorporate ideas like these to create a better, more seamless experience for both end users and developers.&#8221;</p>\n<p>One of the items on the roadmap for the second milestone is the creation of a &#8220;<a href=\"https://meta.trac.wordpress.org/ticket/1571\" target=\"_blank\">Plugin Author Admin</a>.&#8221; Kay hopes that his implementation could serve as an inspiration for what WordPress.org could provide for developers with the existing Plugin API.</p>\n<p>&#8220;The base functionality is already there as part of WordPress core, and all of the data is readily available via the existing Plugin API,&#8221; Kay said. &#8220;I think plugin authors stand to gain a ton from an updated admin/dashboard experience, and with 40,000+ plugins and counting, that’s a lot of happy points.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 29 Mar 2016 21:10:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"WPTavern: WordPress Contributor Rian Rietveld Wins Heroes of Accessibility Award\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52962\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"http://wptavern.com/wordpress-contributor-rian-rietveld-wins-heroes-of-accessibility-award\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2407:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/rian.jpg\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/rian.jpg?resize=760%2C382\" alt=\"rian\" class=\"aligncenter size-full wp-image-52968\" /></a></p>\n<p>The 31st Annual <a href=\"http://www.csun.edu/cod/conference/2016/sessions/\" target=\"_blank\">International Technology and Persons with Disabilities Conference</a> was held in San Diego, California, last week. Every year thousands of attendees gather to share knowledge and best practices for technology that removes barriers for people with disabilities.</p>\n<p>This year <a href=\"http://www.rianrietveld.com/\" target=\"_blank\">Rian Rietveld</a> was recognized by <a href=\"http://Knowbility.org\" target=\"_blank\">Knowbility.org</a> for her accessibility contributions to WordPress core. She took first place in the Individual Achievement category of the Heroes of Accessibility Awards. Rietveld&#8217;s nomination read as follows:</p>\n<blockquote><p>She leads the push to make WordPress core accessible and is a knowledgeable, dedicated, and effective advocate for accessibility in the global WordPress community. Her achievements in 2015 were significant and are having a major impact on the core accessibility of the application that is used to build more than 25% of all the websites in the world.</p></blockquote>\n<p>Other finalists included <a href=\"http://www.karlgroves.com/\" target=\"_blank\">Karl Groves</a>, developer of <a href=\"http://wptavern.com/access-monitor-plugin-tests-wordpress-sites-for-accessibility-compliance\" target=\"_blank\">Tenon.io</a>, and <a href=\"https://twitter.com/mostgood\" target=\"_blank\">Sally Shephard</a>, an iOS developer and accessibility educator. A <a href=\"http://events.tvworldwide.com/Events/CSUN2016/TabId/1294/VideoId/2223/Knowbilitys-Second-Annual-Community-Heroes-Of-Accessibility-Awards.aspx\" target=\"_blank\">video of the awards ceremony</a> is available on the event&#8217;s website and you can see Rietveld&#8217;s award announced starting from the 6:50 timestamp.</p>\n<p>In addition to her core contributions, Rietveld provides accessibility auditing and consultancy for WordPress plugin and theme developers. After learning that she had won, Rietveld said the award was &#8220;a huge encouragement to continue working on WordPress accessibility together with the team.&#8221;</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 29 Mar 2016 18:15:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"WPTavern: Modern Tribe Acquires GigPress, Exploring SaaS Events Management Solution\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52870\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"http://wptavern.com/modern-tribe-acquires-gigpress-exploring-saas-events-management-solution\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:4434:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/gigpress.jpg\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/gigpress.jpg?resize=960%2C505\" alt=\"photo credit: Antoine Beauvillain\" class=\"size-full wp-image-52906\" /></a>photo credit: <a href=\"https://stocksnap.io/photo/P6IFK1ELC6\">Antoine Beauvillain</a>\n<p><a href=\"http://tri.be/\" target=\"_blank\">Modern Tribe</a>, a top digital agency with a <a href=\"https://profiles.wordpress.org/moderntribe/#content-plugins\" target=\"_blank\">collection</a> of popular plugins on WordPress.org, announced that it has <a href=\"http://tri.be/blog/welcoming-gigpress-to-modern-tribe/\" target=\"_blank\">acquired GigPress</a>. With 20,000+ active installs and more than 260,000 downloads, <a href=\"https://wordpress.org/plugins/gigpress/\" target=\"_blank\">GigPress</a> is one of the most widely used plugins for musicians and performers who want to manage events with WordPress.</p>\n<p>Despite the plugin&#8217;s solid placement in the WordPress events niche, GigPress creator Derek Hogue is passing the keys over to Modern Tribe as an alternative to letting it &#8220;slowly die of neglect.&#8221; In his <a href=\"http://gigpress.com/blog/2016/03/gigpress-joins-modern-tribe/\" target=\"_blank\">acquisition announcement</a>, Hogue said:</p>\n<blockquote><p>Eventually I started using other CMS’ more often than not, so my passion and impetus for improving GigPress fell off a cliff.</p>\n<p>For several years I kept GigPress alive via mostly bug fixes and compatibility updates. Last year I finally decided that the best hope for bringing my baby from its extended adolescence into adulthood would be to find it a new home.</p></blockquote>\n<p>Hogue assured users that GigPress will continue to be a free, open-source plugin but with better support and a brighter future. He confessed that he was not able to sufficiently monetize the plugin to make it worth his time.</p>\n<p>&#8220;You can give away your plugin for free all day long, but as soon as you hit a certain scale, support becomes a burden,&#8221; Hogue said. &#8220;Creating revenue from plugins in WordPress takes an infrastructure which is prohibitive for many small developers.&#8221;</p>\n<p>Modern Tribe, however, has fresh plans for GigPress and has already added some compatibilities for its <a href=\"https://theeventscalendar.com/product/wordpress-events-calendar/\" target=\"_blank\">Events Calendar</a> and <a href=\"https://theeventscalendar.com/product/wordpress-event-tickets-plus/\" target=\"_blank\">Event Tickets Plus</a> plugins.</p>\n<p>&#8220;GigPress has a big foothold in a really important vertical and a strong user base,&#8221; said Modern Tribe CEO Shane Pearlman. &#8220;One of our former team members made the introduction a few months back and exploring it together, the team was excited.&#8221;</p>\n<p>Pearlman and his team see GigPress as a key addition to their suite of event management plugins but are still considering different paths for monetizing it.</p>\n<p>&#8220;We’re definitely going to start serving specific verticals, with live music and touring artists being one of those,&#8221; Pearlman said. &#8220;Whether that’s directly through the evolution of the GigPress product, or introduction of complementary products is still in planing. Our first step is to gracefully integrate our <a href=\"https://wordpress.org/plugins/event-tickets/\" target=\"_blank\">Event Tickets</a> plugin so that bands and venues can sell tickets through the WP commerce platform of choice.&#8221;</p>\n<p>Pearlman said that as one of the principal players in the events management space, Modern Tribe plans to go beyond calendars and tickets. The team is looking into a SaaS model for its growing suite of event management plugins.</p>\n<p>&#8220;We are actively exploring the nuances of a SaaS solution,&#8221; he said. &#8220;We have an internal business plan showdown in progress and another strategic acquisition conversation in play.&#8221; Pearlman would not elaborate on the company&#8217;s next acquisition.</p>\n<p>The good news for those using GigPress is that Modern Tribe plans to build a profitable business on it, which will help to fund the support and future development of the open source plugin. If you&#8217;ve been waiting for help and updates in the past, chances are the experience of using GigPress will soon be greatly improved.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 28 Mar 2016 23:29:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"WPTavern: HeroPress Publishes Essays From 18 Countries in its First Year\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52918\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"http://wptavern.com/heropress-publishes-essays-from-18-countries-in-its-first-year\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3247:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/heropress.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/heropress.jpg?resize=956%2C423\" alt=\"heropress\" class=\"aligncenter size-full wp-image-37733\" /></a><br />\n<a href=\"http://heropress.com/\">HeroPress.com, </a>where inspirational essays are published each week from people across the world is one year old. In a <a href=\"http://heropress.com/one-year/\">post celebrating the milestone</a>, Topher DeRosia highlights some of the site&#8217;s accomplishments throughout 2015.</p>\n<p>Authors from <a href=\"http://heropress.com/contributor-map/\">eighteen countries</a> have published essays including, Lebanon, Nepal, New Zealand, Nigeria, and more. There are twice as many men as women with published essays, something DeRosia says he is working on, &#8220;That tilts SLIGHTLY better in the coming weeks, but not enough, so I’m looking for the voices and wisdom of more women,&#8221; he said.</p>\n<p>DeRosia thanked his family for their support and <a href=\"https://x-team.com/profile/dave-rosen/\">Dave Rosen</a>, Founder of web development firm <a href=\"https://x-team.com/about/\">X-Team</a>, for facilitating the idea and allowing him to manage the site despite <a href=\"http://wptavern.com/heropress-fails-to-attract-backers-cancels-kickstarter-campaign-ahead-of-deadline\">failing to reach his crowdfunding goal</a> in early 2015.</p>\n<p>To learn about the site&#8217;s origin and its future, I invite you to listen to our one hour interview with DeRosia. In it, he describes what inspired him to create the site and shares a personal story of someone who couldn’t submit an essay because they’re spending all of their time trying to stay alive.</p>\n<div class=\"audio-shortcode-wrap\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/01/heropress.jpg?resize=175%2C131\" alt=\"HeroPress Publishes Essays From 18 Countries in its First Year\" class=\"landscape cw-greater thumbnail post-thumbnail audio-image\" /><!--[if lt IE 9]><script>document.createElement(\'audio\');</script><![endif]-->\n<a href=\"http://wptavern.com/wp-content/uploads/2016/03/EPISODE-227-The-HeroPress-Story-with-Topher-DeRosia.mp3\">http://wptavern.com/wp-content/uploads/2016/03/EPISODE-227-The-HeroPress-Story-with-Topher-DeRosia.mp3</a></div><div class=\"media-shortcode-extend\"><div class=\"media-info audio-info\"><ul class=\"media-meta\"><li><span class=\"prep\">Run Time</span><span class=\"data\">1:09:57</span></li><li><span class=\"prep\">Artist</span><span class=\"data\">Jeff Chandler and Marcus Couch</span></li><li><span class=\"prep\">Album</span><span class=\"data\">WordPress Weekly</span></li><li><span class=\"prep\">Track</span><span class=\"data\">227</span></li><li><span class=\"prep\">File Type</span><span class=\"data\">MP3</span></li><li><span class=\"prep\">File Name</span><span class=\"data\"><a href=\"http://wptavern.com/wp-content/uploads/2016/03/EPISODE-227-The-HeroPress-Story-with-Topher-DeRosia.mp3\">EPISODE-227-The-HeroPress-Story-with-Topher-DeRosia.mp3</a></span></li><li><span class=\"prep\">Mime Type</span><span class=\"data\">audio/mpeg</span></li></ul></div><button class=\"media-info-toggle\">Audio Info</button></div>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 28 Mar 2016 23:28:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"WPTavern: Add Child Theme Support to Any WordPress Theme\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52912\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"http://wptavern.com/add-child-theme-support-to-any-wordpress-theme\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2736:\"<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/child-theme.jpg\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/child-theme.jpg?resize=960%2C562\" alt=\"photo credit: Leeroy\" class=\"size-full wp-image-52929\" /></a>photo credit: <a href=\"https://stocksnap.io/photo/R0C7A5M4WB\">Leeroy</a>\n<p>If you&#8217;re a developer, you may take for granted how easy it is for you to create a child theme for storing customizations separate from the parent theme. This one seemingly simple task can pose a significant hurdle for your average WordPress user. Without understanding the best practice of creating a child theme, users resort to cramming all changes into the active theme. This puts them in a vulnerable position when security updates are available but they cannot update without overwriting their changes.</p>\n<p><a href=\"https://twitter.com/mgibbs189\" target=\"_blank\">Matt Gibbs</a>, lead developer of <a href=\"https://facetwp.com/\" target=\"_blank\">FacetWP</a>, has created a little project to help users with creating child themes. &#8220;<a href=\"https://github.com/FacetWP/use-child-theme\" target=\"_blank\">Use Child Theme</a>&#8221; is a simple drop-in PHP class that theme developers can use to alert their users to activate a child theme and automatically create one for them.</p>\n<div class=\"embed-wrap\"></div>\n<p>&#8220;Normally, themes have to point users to a child theme documentation page or link to a pre-built child theme zip,&#8221; Gibbs said. &#8220;Most users don&#8217;t even bother.&#8221;</p>\n<p>Gibbs said the Use Child Theme project was built to make it easy for theme authors to support it. The project was also an offshoot of his experiences supporting FacetWP.</p>\n<p>&#8220;I do a lot of plugin support, and this issue keeps coming up over and over,&#8221; Gibbs said. &#8220;Users are on super old theme versions and they&#8217;re afraid to upgrade because they&#8217;ve modified the parent theme at one point, and don&#8217;t want to lose changes.&#8221;</p>\n<p>The idea behind <a href=\"https://github.com/FacetWP/use-child-theme\" target=\"_blank\">Use Child Theme</a> is to automatically create a child theme for someone who otherwise might not know how to create one. It&#8217;s not a plugin but rather a tool that theme developers can opt to include with just one line in functions.php:</p>\n<pre class=\"brush: php; light: true; title: ; notranslate\">include( dirname( __FILE__ ) . \'/use-child-theme.php\' );</pre>\n<p>WordPress theme developers, is this a method you would consider using to prompt users to activate a child theme? Or would you rather rely on links to documentation and/or a download link to a pre-built child theme?</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 28 Mar 2016 21:27:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"WPTavern: Take the Mental Health in Tech 2016 Survey\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52889\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"http://wptavern.com/take-the-mental-health-in-tech-2016-survey\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2517:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/mental-health-in-tech-2016.png\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/mental-health-in-tech-2016.png?resize=1025%2C528\" alt=\"mental-health-in-tech-2016\" class=\"aligncenter size-full wp-image-52893\" /></a></p>\n<p>Ed Finkler is on a mission to raise mental health awareness in the tech community with his <a href=\"https://osmihelp.org/\" target=\"_blank\">Open Source Mental Illness</a> (OSMI) campaign. In 2013 Finkler started speaking at conferences and gathering information on mental health in the tech workplace. His goal is to provide resources and documentation that companies can use to create more supportive environments for those dealing with mental health disorders.</p>\n<p>As part of the organization&#8217;s ongoing research, Finkler and the team at OSMI have authored <a href=\"https://cojfunkatroncom.typeform.com/to/Ao6BTw\" target=\"_blank\">a survey open to anyone working in the IT/tech community</a>. Respondents are not required to have a mental health issue in order to participate. The responses are recorded as anonymous and the survey does not collect any personal information.</p>\n<p>The bulk of the questions in the 10-minute survey gather information about employee&#8217;s perceptions of their co-workers and employer&#8217;s stance on dealing with mental health issues in the workplace. It asks if employers provide education on mental health topics, if there would be negative consequences of discussing these disorders in the workplace, and what kinds of benefits employers offer for treating mental health issues.</p>\n<p>After the survey concludes, OSMI will release the stats and information collected under a <a href=\"https://creativecommons.org/licenses/by-sa/4.0/\" target=\"_blank\">Creative Commons Attribution-ShareAlike 4.0 International license</a>.</p>\n<p>Finkler, who has suffered from depression, anxiety, and ADHD, is working to combat the associated shame and stigma by speaking openly about mental illness at tech conferences, including Open Source Bridge, Connect-JS, and Laracon US. In May, he will be speaking at <a href=\"https://2016.minneapolis.wordcamp.org/\" target=\"_blank\">WordCamp Minneapolis</a>. Check out <a href=\"https://channel9.msdn.com/Shows/Code+To+Live/Open-Sourcing-Mental-Health\" target=\"_blank\">Josh Holmes&#8217; interview with Finkler</a> in a recent episode of Code to Live to find out more about how he started OSMI.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 28 Mar 2016 18:10:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"Akismet: Akismet WordPress Plugin 3.1.9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"http://blog.akismet.com/?p=1907\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"http://blog.akismet.com/2016/03/28/akismet-wordpress-plugin-3-1-9/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:937:\"<p>Version 3.1.9 of <a href=\"http://wordpress.org/plugins/akismet/\">the Akismet plugin for WordPress</a> is now available.</p>\n<p>This update adds compatibility that allows Akismet to be auto-configured, and it fixes a bug where some comment data wouldn&#8217;t get included in the Akismet API request.</p>\n<p>To upgrade, visit the Updates page of your WordPress dashboard and follow the instructions. If you need to download the plugin zip file directly, links to all versions are available in <a href=\"http://wordpress.org/plugins/akismet/\">the WordPress plugins directory</a>.</p><br />  <a rel=\"nofollow\" href=\"http://feeds.wordpress.com/1.0/gocomments/akismet.wordpress.com/1907/\"><img alt=\"\" border=\"0\" src=\"http://feeds.wordpress.com/1.0/comments/akismet.wordpress.com/1907/\" /></a> <img alt=\"\" border=\"0\" src=\"http://pixel.wp.com/b.gif?host=blog.akismet.com&blog=116920&post=1907&subd=akismet&ref=&feed=1\" width=\"1\" height=\"1\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 28 Mar 2016 18:05:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"Christopher Finke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"Post Status: WordPress and SaaS — Draft podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=23047\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://poststatus.com/wordpress-saas-draft-podcast/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2537:\"<p>Welcome to the Post Status <a href=\"https://poststatus.com/category/draft\">Draft podcast</a>, which you can find <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\">on iTunes</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\">Stitcher</a>, and <a href=\"http://simplecast.fm/podcasts/1061/rss\">via RSS</a> for your favorite podcatcher. Post Status Draft is hosted by Joe Hoyle &#8212; the CTO of Human Made &#8212; and Brian Krogsgard.</p>\n<p><span>Software as a service (SaaS) is often viewed as a holy grail for successful online business. The ability to generate recurring revenue that doesn’t require hours-for-dollars is attractive to most entrepreneurs.</span></p>\n<p><span>WordPress can be a helpful tool to get a lot of SaaS functionality out of the box. In today’s episode, we discuss WordPress and SaaS in two contexts: one, using WordPress as a technology basis for a SaaS in another industry, and two, creating a SaaS catered to the WordPress world.</span></p>\n<a href=\"https://poststatus.com/category/planet/feed/\"></a>\n<p><a href=\"http://audio.simplecast.com/33745.mp3\">Direct Download</a></p>\n<h3>Links</h3>\n<p><span>We mentioned the following SaaS products, and probably some others too.</span></p>\n<ul>\n<li><span><a href=\"http://www.happytables.com/\">Happy Tables</a> </span></li>\n<li><span><a href=\"http://restaurantengine.com/\">Restaurant Engine</a> </span></li>\n<li><span><a href=\"https://eventsmart.com/\">Event Smart</a> </span></li>\n<li><span><a href=\"http://faithmade.com/\">Faithmade</a> </span></li>\n<li><span><a href=\"http://varsitynewsnetwork.com/\">Varsity News Network</a> </span></li>\n<li><a href=\"https://www.imagely.com/\">Imagely</a></li>\n<li><span><a href=\"http://rainmakerplatform.com/\">Rainmaker</a> </span></li>\n<li><span><a href=\"https://wordpress.com/\">WordPress.com</a> </span></li>\n<li><span><a href=\"http://optinmonster.com/\">OptinMonster</a> </span></li>\n<li><span><a href=\"https://ithemes.com/sync/\">iThemes Sync</a> </span></li>\n<li><span><a href=\"https://wpremote.com/\">WP Remote</a> </span></li>\n<li><span><a href=\"https://akismet.com/\">Akismet</a> </span></li>\n<li><span><a href=\"https://vaultpress.com/\">VaultPress</a> </span></li>\n</ul>\n<p>Today’s podcast is sponsored by WP Migrate DB Pro by <a href=\"https://deliciousbrains.com/\">Delicious Brains</a>, the tool that makes syncing your databases effortless. Check out WP Migrate DB Pro and all their other great products on their website.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 26 Mar 2016 17:44:47 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Katie Richards\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"WPTavern: Draft and Save Customizer Changes for Later with New Customize Snapshots Plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52655\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"http://wptavern.com/draft-and-save-customizer-changes-for-later-with-new-customize-snapshots-plugin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6422:\"<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/snapshots.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/snapshots.jpg?resize=750%2C446\" alt=\"photo credit: Chantel Lucas\" class=\"size-full wp-image-52875\" /></a>photo credit: <a href=\"https://stocksnap.io/photo/410Y7ES74I\">Chantel Lucas</a>\n<p>As the WordPress customizer becomes more widely adopted by theme and plugin developers, users often have a host of live preview options to play with when personalizing their sites. Different combinations can produce wildly different designs. What if you could save a preview of customizations before going live with it? This is the idea behind the new <a href=\"https://wordpress.org/plugins/customize-snapshots/\" target=\"_blank\">Customize Snapshots</a> plugin from Weston Ruter, Derek Herman, and the team at <a href=\"https://xwp.co/\" target=\"_blank\">XWP</a>.</p>\n<p>Customize Snapshots lets you draft and preview customizer states that can be shared via a private URL that the plugin generates. Users who are not authenticated can preview snapshots on the frontend without loading the customizer. Authenticated users will be able to load the snapshot inside the customizer to make further edits or publish the draft.</p>\n<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/customize-snapshot.gif\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/customize-snapshot.gif?resize=1025%2C525\" alt=\"customize-snapshot\" class=\"aligncenter size-full wp-image-52864\" /></a></p>\n<p>You may not be able to see it in the demo above, but snapshots can be saved with a scope of full or dirty, according to the plugin details page:</p>\n<ul>\n<li><strong>Full:</strong> will playback all the settings during preview [changeset]</li>\n<li><strong>Dirty:</strong> will only playback the ones that were marked dirty when the snapshot was taken [snapshot]</li>\n</ul>\n<p>&#8220;Snapshots was written as a feature plugin to implement a key feature that the <a href=\"https://make.wordpress.org/core/2015/01/26/customizer-transactions-proposal/\" target=\"_blank\">Customizer Transactions proposal</a> will make possible,&#8221; Weston Ruter said. Ruter is the Technology Director at XWP and a co-maintainer of WordPress&#8217; core customizer component. He said the plugin was also developed specifically for a client&#8217;s project requirements.</p>\n<p>&#8220;Customize Snapshots stores the Customizer state in a custom post type,&#8221; he said. &#8220;You can access the frontend of the site with the UUID for the snapshot added as a URL parameter to load the site with that Customizer state applied. So this makes it possible to preview Customizer changes on other devices entirely.&#8221;</p>\n<h3>Coming Soon: Schedule Customizier Changes to Go Live at a Future Date</h3>\n<p>WordPress core lacks the ability to schedule out changes to content that has already been published. The only option for editing published posts is to push changes live. This is also the same for the customizer, but the XWP team is aiming to add scheduling to Customize Snapshots.</p>\n<p>&#8220;The idea here, though not implemented yet in the feature plugin, is that you could also schedule a snapshot (aka transaction) to go live at a certain time,&#8221; Ruter said. &#8220;So you could bundle up a bunch of changes in the Customizer and &#8216;Save &amp; Publish&#8217; at a scheduled time, like Sunday at midnight.&#8221;</p>\n<p>With transactions added to the customizer, users could build up a large &#8216;changeset&#8217; as a draft, including things like building new pages, adding a collection of widgets, and updating menu items. The entire set of changes can then be scheduled to go live at the same time.</p>\n<p>&#8220;On the other side of that coin, it allows for there to be revision history for changes made in the Customizer,&#8221; Ruter said. &#8220;And this will work seamlessly with the <a href=\"https://github.com/xwp/wp-customize-posts\" target=\"_blank\">Customize Posts</a> feature plugin &#8211; the goal being to let the author do as much as possible during a Customizer session, for all changes to be previewed together, submitted for review and iteration, and staged for publishing at some point in time.&#8221;</p>\n<p>Ruter said he sees Customize Snapshots as another take on the common desire to build out content on a staging environment, preview changes, and then promote those changes to production.</p>\n<p>&#8220;This is a hard problem to solve, and lots of plugins are available with solutions, like WP-CFM, Ramp, and others,&#8221; he said. &#8220;But in the Customizer it&#8217;s something you can get for free because of its model, and you don&#8217;t need multiple environments. You just need to indicate which snapshot/transaction state you want to preview.&#8221;</p>\n<p>If you previously had a difficult time grasping the technical details of Ruter&#8217;s <a href=\"https://make.wordpress.org/core/2015/01/26/customizer-transactions-proposal/\" target=\"_blank\">customizer transactions proposal</a>, the Customize Snapshots plugin is a perfect example of the kind of functionality that transactions would enable. The feature plugin is an adaptation of his proposed changes that implement the more fundamental “transactions” construct.</p>\n<p>Customize Snapshots adds to <a href=\"https://profiles.wordpress.org/xwp/#content-plugins\" target=\"_blank\">XWP&#8217;s collection of plugins</a> that extend the customizer in innovative ways and intersect with <a href=\"https://make.wordpress.org/core/2015/09/23/outlining-a-possible-roadmap-for-the-customizer/\" target=\"_blank\">the framework&#8217;s long-term roadmap</a>. Occasionally, this will also tie into client work, as with the case of Customize Snapshots.</p>\n<p>&#8220;We try to propose Customizer solutions for client projects as a way to fund Customizer advances, but we also believe in the Customizer and would be working on it regardless,&#8221; Ruter said.</p>\n<p><a href=\"https://wordpress.org/plugins/customize-snapshots/\" target=\"_blank\">Customize Snapshots</a> makes the customizer a more collaborative environment within WordPress. If you need to make a large number of changes and share a preview with others, this plugin will help you do that. The ability to see snapshots in the admin and schedule changes will make it even more useful in the future.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 25 Mar 2016 20:52:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"WPTavern: Get Your Widgets Ready for WordPress 4.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52812\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"http://wptavern.com/get-your-widgets-ready-for-wordpress-4-5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2255:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/testing.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/07/testing.jpg?resize=960%2C474\" alt=\"testing\" class=\"aligncenter size-full wp-image-46092\" /></a></p>\n<p>WordPress 4.5 is right around the corner with the <a href=\"https://wordpress.org/news/2016/03/wordpress-4-5-release-candidate/\" target=\"_blank\">first release candidate</a> now available for download. It includes <a href=\"https://core.trac.wordpress.org/log/trunk?action=stop_on_copy&mode=stop_on_copy&rev=37077&stop_rev=37026&limit=120&verbose=on\" target=\"_blank\">49 changes</a> from the last beta &#8211; improvements to the new custom logo feature, a minor update to jQuery, updates to inline documentation, and fixes for various small bugs.</p>\n<p>The upcoming release is packed full of <a href=\"https://make.wordpress.org/core/2016/03/10/customizer-improvements-in-4-5/\" target=\"_blank\">improvements to the customizer</a>: selective refresh, support for setting-less controls, and device preview. Plugin and theme authors who want to be on the cutting edge of the customizer&#8217;s new capabilities will want to review Weston Ruter&#8217;s post on <a href=\"https://make.wordpress.org/core/2016/03/22/implementing-selective-refresh-support-for-widgets/\" target=\"_blank\">Implementing Selective Refresh Support for Widgets</a>. All of the default WordPress themes and core widgets will ship with selective refresh in 4.5, but the feature is opt-in for plugins and themes.</p>\n<p>For most themes with standard sidebars, adding selective refresh is as simple as including one line to declare theme support:</p>\n<pre class=\"brush: php; light: true; title: ; notranslate\">add_theme_support( \'customize-selective-refresh-widgets\' );</pre>\n<p>Adding support for widgets is a bit more involved, depending on whether the widget uses JavaScript for initialization. Ruter&#8217;s post includes a tutorial for how to add selective refresh in either scenario. The <a href=\"https://make.wordpress.org/core/version-4-5-project-schedule/\" target=\"_blank\">target release date for 4.5</a> is April 12, 2016, so plugin and theme developers still have three weeks to add support.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 25 Mar 2016 16:18:43 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"WPTavern: Versions of WP-CLI Prior to 0.23.0 Are Incompatible with WordPress 4.5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52830\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"http://wptavern.com/versions-of-wp-cli-prior-to-0-23-0-are-incompatible-with-wordpress-4-5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1873:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/12/restful-wp-cli.png\"><img class=\"aligncenter size-full wp-image-49286\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2015/12/restful-wp-cli.png?resize=1025%2C459\" alt=\"restful-wp-cli\" /></a>Daniel Bachhuber, maintainer of <a href=\"http://wp-cli.org/\">WP-CLI</a>, a popular command line interface utility for managing WordPress sites, <a href=\"http://wp-cli.org/blog/version-0.23.0.html\">has released</a> version 0.23.0. This release includes a number of bug fixes, improvements, and features, but the most important thing to note is that earlier versions of WP-CLI will not work with WordPress 4.5.</p>\n<p>According to Bachhuber, WordPress 4.5 loads a file in wp-settings.php and since WP-CLI uses a custom wp-settings-cli.php file, 0.23.0 and above are the only versions compatible with WordPress 4.5. Bachhuber created a <a href=\"https://core.trac.wordpress.org/ticket/34936\">new ticket on Trac</a> to start a discussion on using wp-settings.php instead of the custom file.</p>\n<p>&#8220;WP-CLI uses a custom wp-settings-cli.php to load WordPress, instead of wp-settings.php,&#8221; Bachhuber said. &#8220;While I appreciate the <a class=\"ext-link\" href=\"http://wp-cli.org/blog/how-wp-cli-loads-wordpress.html\">historical justifications</a> for the bootstrap process, it would be much better if WP-CLI could use wp-settings.php because, occasionally, there are <a class=\"ext-link\" href=\"http://wp-cli.org/blog/versions-0.21.1-and-0.20.4.html\">substantial problems</a> arising from needing to maintain a fork.&#8221;</p>\n<p>To see a full list of changes with detailed explanations on how to use new features such as installing community commands from the package index, check out the <a href=\"http://wp-cli.org/blog/version-0.23.0.html\">release post</a>.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 24 Mar 2016 21:59:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"WPTavern: WPWeekly Episode 227 – The HeroPress Story with Topher DeRosia\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=52825&preview_id=52825\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"http://wptavern.com/wpweekly-episode-227-the-heropress-story-with-topher-derosia\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2102:\"<p>In this episode of WordPress Weekly, <a href=\"http://marcuscouch.com/\">Marcus Couch</a> and I are joined by <a href=\"https://topher1kenobe.com/\">Topher DeRosia</a> to learn about the origins of <a href=\"http://heropress.com/\">HeroPress</a>. DeRosia explains his motivation for creating the site and why despite not reaching his crowdfunding goal, decided to press on.</p>\n<p>We also discuss the impact the essays are having on people across the world and whether or not HeroPress is accomplishing <a href=\"http://heropress.com/about/\">its mission</a>. Last but not least, DeRosia shares a personal story of someone who couldn&#8217;t write an essay for the site because they&#8217;re spending all of their time trying to stay alive.</p>\n<h2>Plugins Picked By Marcus:</h2>\n<p><a href=\"https://wordpress.org/plugins/media-from-ftp/\">Media from FTP</a> allows you to import items into the WordPress media library that are uploaded via FTP.</p>\n<p class=\"shortdesc\"><a href=\"https://wordpress.org/plugins/wp-open-last-modified/\">WP Open Last Modified </a>adds the last modified date and the current revision of your post/page using the [last_modified_date] shortcode.</p>\n<p><a href=\"https://wordpress.org/plugins/advanced-wp-reset/\">Advanced WordPress Reset</a> is a convenient way to restore WordPress back to a fresh install without having to go through the traditional installation process.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, March 30th 9:30 P.M. Eastern</p>\n<p><strong>Subscribe To WPWeekly Via Itunes: </strong><a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via RSS: </strong><a href=\"http://www.wptavern.com/feed/podcast\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Subscribe To WPWeekly Via Stitcher Radio: </strong><a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\" target=\"_blank\">Click here to subscribe</a></p>\n<p><strong>Listen To Episode #227:</strong><br />\n</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 24 Mar 2016 20:56:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"WP Mobile Apps: WordPress for iOS: Version 6.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"http://apps.wordpress.org/?p=3229\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://apps.wordpress.com/2016/03/24/wordpress-for-ios-version-6-0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2905:\"<p>Hello, WordPress users! <a href=\"https://itunes.apple.com/us/app/wordpress/id335703880?mt=8&uo=6&at=&ct=\">Version 6.0 of the WordPress for iOS app</a> is now available in the App Store.</p>\n<h1>What&#8217;s New:</h1>\n<p><strong>Delete sites from the app!</strong>  We know, we know, creating WordPress.com sites can get addictive. But if you feel like decluttering your dashboard, you can now delete a site (or two) directly from the app.</p>\n\n<a href=\"https://apps.wordpress.com/img_2103/\"><img width=\"169\" height=\"300\" src=\"https://apps.files.wordpress.com/2016/03/img_2103.png?w=169&h=300\" class=\"attachment-medium size-medium\" alt=\"It\'s now possible to delete sites from within the app.\" /></a>\n<a href=\"https://apps.wordpress.com/img_2104/\"><img width=\"169\" height=\"300\" src=\"https://apps.files.wordpress.com/2016/03/img_2104.png?w=169&h=300\" class=\"attachment-medium size-medium\" alt=\"You can choose to keep all your content when deleting a site.\" /></a>\n\n<p><strong>More improvements.</strong> Several magical <a href=\"https://github.com/wordpress-mobile/WordPress-iOS/issues?utf8=✓&q=is%3Aclosed+is%3Aissue+milestone%3A6.0+label%3A%22%5BType%5D+Enhancement%22+\">behind-the-scenes improvements</a> to make sure our codebase is stronger than ever.</p>\n<p><strong>Bug fixes.</strong> As usual, we squashed some bugs, but there weren&#8217;t many this time around. Keep an eye on <a href=\"https://github.com/wordpress-mobile/WordPress-iOS/issues?utf8=✓&q=is%3Aclosed+is%3Aissue+milestone%3A6.0+label%3A%22%5BType%5D+Bug%22+\">the complete list of bugs here</a>.</p>\n<h1>Thank You!</h1>\n<p>Thanks to all of the contributors who worked on this release:<br />\n<a href=\"https://github.com/aerych\">@aerych</a>, <a href=\"https://github.com/alexcurylo\">@alexcurylo</a>, <a href=\"https://github.com/astralbodies\">@astralbodies</a>, <a href=\"https://github.com/diegoreymendez\">@diegoreymendez</a>, <a href=\"https://github.com/frosty\">@frosty</a>, <a href=\"https://github.com/hugobaeta\">@hugobaeta</a>, <a href=\"https://github.com/jleandroperez\">@jleandroperez</a>, <a href=\"https://github.com/koke\">@koke</a>, <a href=\"https://github.com/kurzee\">@kurzee</a>, <a href=\"https://github.com/kwonye\">@kwonye</a>, <a href=\"https://github.com/mattmiklic\">@mattmiklic</a>, <a href=\"https://github.com/maxme\">@maxme</a>, <a href=\"https://github.com/oguzkocer\">@oguzkocer</a>, <a href=\"https://github.com/sendhil\">@sendhil</a> and <a href=\"https://github.com/SergioEstevao\">@SergioEstevao</a>..</p>\n<p>You can track the development progress for the next update by visiting <a href=\"https://github.com/wordpress-mobile/WordPress-iOS/issues?q=is%3Aopen+is%3Aissue+milestone%3A6.1\" target=\"_blank\">our 6.1 milestone on GitHub</a>. Until next time!</p><img alt=\"\" border=\"0\" src=\"https://pixel.wp.com/b.gif?host=apps.wordpress.com&blog=108068616&post=3229&subd=apps&ref=&feed=1\" width=\"1\" height=\"1\" />\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 24 Mar 2016 12:48:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"diegoreymendez\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"WPTavern: Cast of Silicon Valley Nails The Meaning of Automattic on The First Try\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52809\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"http://wptavern.com/cast-of-silicon-valley-nails-the-meaning-of-automattic-on-the-first-try\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1475:\"<p><a href=\"http://www.hbo.com/silicon-valley\">Silicon Valley</a> is a comedic television series on HBO about a group of six engineers who create a startup company in Silicon Valley. <a href=\"http://www.wired.com/\">Wired.com</a> sat down with the cast and gave them the names to real startup companies to see if they could guess what they do.</p>\n<p>Among the names mentioned is <a href=\"https://automattic.com/\">Automattic</a>. Fast forward to <a href=\"https://youtu.be/5Y64UeNeiOM?t=1m14s\">1:14</a> to watch Kumail Nanjiani, who plays <a href=\"http://www.hbo.com/silicon-valley/cast-and-crew/kumail-nanjiani/index.html\">Dinesh</a> on the show, correctly guess the meaning of the name on his first try, &#8220;Automattic with two T&#8217;s is a company ran by a dude named Matt,&#8221; he says. His response to being told he&#8217;s correct is pretty funny.</p>\n<p>Warning, the video contains strong language and is not safe for work.</p>\n<div class=\"embed-wrap\"></div>\n<p>Automattic, founded in 2005, is the driving force behind WordPress.com and a handful of other services like Akismet, Gravatar, VaultPress, IntenseDebate, Polldaddy, and more.</p>\n<p>While many people are confused between WordPress the software project and WordPress.com, the reason for two T&#8217;s in Automattic was guessed correctly on the first try by someone who is not deeply involved in the community. There&#8217;s something mildly humorous about that.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 23 Mar 2016 23:45:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"WPTavern: Restrict BuddyPress Signups by Email Domain\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52202\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"http://wptavern.com/restrict-buddypress-signups-by-email-domain\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2637:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/02/mailboxes.jpg\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2015/02/mailboxes.jpg?resize=1024%2C496\" alt=\"mailboxes\" class=\"aligncenter size-full wp-image-39214\" /></a></p>\n<p>Spam is one of the most discouraging things about managing a BuddyPress-powered social network. Since WordPress itself is already a magnet for spam signups and comments, BuddyPress is subject to the same and then some. With an ordinary WordPress site you can block most of it fairly well, but with BuddyPress you often have to wade through signups to verify that real humans aren&#8217;t getting blocked.</p>\n<p>One of the best ways to cut down on the avalanche of unwanted signups is to restrict them by email domain. <a href=\"https://wordpress.org/plugins/bp-rsed/\" target=\"_blank\">BP Restrict Signup by Email Domain</a> is a plugin that allows you to whitelist an email domain or set of domains that will be required for registration on the site. You can also set an error message and create a custom message to appear on the registration page.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/email-address-restrictions.png\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/email-address-restrictions.png?resize=566%2C862\" alt=\"email-address-restrictions\" class=\"aligncenter size-full wp-image-52791\" /></a></p>\n<p>The plugin was created by BuddyPress contributing developer Ray Hoh for the <a href=\"http://commons.gc.cuny.edu/\" target=\"_blank\">CUNY Academic Commons</a>. It&#8217;s part of a suite of plugins recommended by the <a href=\"http://commonsinabox.org/\" target=\"_blank\">Commons In A Box (CBOX)</a> free software project. The university uses the plugin to ensure that anyone signing up to the Academic Commons will have a CUNY email address. You can see it in action on the <a href=\"http://commons.gc.cuny.edu/register/\" target=\"_blank\">registration page</a>.</p>\n<p>BP Restrict Signup by Email Domain works on both single site and multisite installations of WordPress. It has been tested with the latest version of BuddyPress (2.5) but should also be compatible back to version 1.6.</p>\n<p>Not every social site can afford to limit email domains, but this plugin works well for academic sites, nonprofit or other types of organizations, or any community that excludes all but a few set email domains. <a href=\"https://wordpress.org/plugins/bp-rsed/\" target=\"_blank\">BP Restrict Signup by Email Domain</a> is open source on WordPress.org and is actively maintained for use on CUNY.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 23 Mar 2016 23:09:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"WPTavern: Frederick Townes Confirms W3 Total Cache is Not Abandoned\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52766\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"http://wptavern.com/frederick-townes-confirms-w3-total-cache-is-not-abandoned\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7219:\"<p><a href=\"https://wordpress.org/plugins/w3-total-cache/\">W3 Total Cache</a> is a free, caching WordPress plugin created by <a href=\"https://profiles.wordpress.org/fredericktownes/\">Frederick Townes</a> that&#8217;s active on more than one million sites. While the plugin&#8217;s core functionality is free to use, there&#8217;s a handful of services users can buy from within the plugin such as enhanced support to server and site configurations.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/W3TCUpsells.png\"><img class=\"size-full wp-image-52768\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/W3TCUpsells.png?resize=1025%2C700\" alt=\"W3 Total Cache Upsells\" /></a>W3 Total Cache Upsells\n<p>A recent post by Scott Tuchman on the <a href=\"https://www.facebook.com/groups/advancedwp/permalink/1116520665076813/\">Advanced WordPress Facebook group</a> cites that the plugin hasn&#8217;t been updated in more than seven months and is not compatible with WordPress 4.4.2. Out of 44 reports, 34 people say W3 Total Cache 0.9.4.1 doesn&#8217;t work with WordPress 4.4.2.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/W3TCBroken.png\"><img class=\"size-full wp-image-52769\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/W3TCBroken.png?resize=884%2C626\" alt=\"W3 Total Cache Not Compatible With WordPress 4.4.2\" /></a>W3 Total Cache Not Compatible With WordPress 4.4.2\n<p>The plugin was recently updated with the <a href=\"https://plugins.trac.wordpress.org/changeset/1375883/w3-total-cache\">only change</a> being the readme.txt file which states it has been tested up to WordPress 4.5. A cursory glance at the support forums indicates <a href=\"https://wordpress.org/support/topic/how-come-the-version-0941-now-says-updated-on-mar-21\">some users</a> are <a href=\"https://wordpress.org/support/topic/compatible-up-to-45-but-no-update-since-9-months-ago\">not pleased</a> with the simple update.</p>\n<h2>A Rocky Year</h2>\n<p>In 2015, a disgruntled customer who purchased services from <a href=\"http://www.w3-edge.com/\">W3 Edge</a>, <a href=\"https://www.reddit.com/r/Wordpress/comments/2r7un1/my_experience_with_what_its_like_with_w3_total/\">described their negative experience</a> in a post on the WordPress subreddit. The complaints include, a lack of communication, not receiving purchased services, and project delays. Mike McAlister, of <a href=\"https://arraythemes.com/\">Array Themes</a>, told the Tavern about his experience with W3 Edge.</p>\n<blockquote><p>In 2014, I signed up for the premium version of W3 Total Cache to unlock some of the advanced caching features. The email confirmation said that the license would auto-renew unless cancelled, so I contacted them right away with my request to cancel the auto-renewal. I didn&#8217;t hear anything back and wrongly assumed this was taken care of.</p>\n<p>Fast forward one year and I get an email out of nowhere that my W3 license had been renewed. I immediately contacted W3 with details of my order and politely requested a solution, but never heard a response.</p>\n<p>I wrote a total of four emails and several tweets directed at W3 Edge and its founder, Frederick Townes, with not a single response throughout the ordeal. Like many others, I had to resort to calling the bank and filing a dispute to get my money back, which dragged the issue out for several months.</p></blockquote>\n<p>At the end of the Reddit thread, W3 Edge <a href=\"https://www.reddit.com/r/Wordpress/comments/2r7un1/my_experience_with_what_its_like_with_w3_total/cqag9sw\">responded to the criticism</a> and admitted that the company let users down with its lack of engagement. It also admitted to having a small team and the challenges involved with its support model.</p>\n<p>&#8220;One of the largest lessons learned is that there&#8217;s a lot to get right especially with a small team,&#8221; W3 Edge said. &#8220;We&#8217;ve made some changes to the team recently and we&#8217;re working to rectify experiences like the ones noted here. Since it’s the customer experience that matters and not intentions, I apologize for the negative experiences. Our mission remains to enable independent publishers with great software and solutions.&#8221;</p>\n<h2>W3 Total Cache Status Update</h2>\n<p>The company&#8217;s <a href=\"https://twitter.com/w3edge/with_replies?lang=en\">official Twitter account</a> has been inactive since April of 2015 and the <a href=\"https://www.w3-edge.com/weblog/\">last post published</a> on its blog was 10 months ago. Combined with the lack of plugin updates, it&#8217;s understandable why customers and users are concerned with the plugin&#8217;s status.</p>\n<p>Frederick Townes, founder of W3 Edge, issued the following statement to the Tavern.</p>\n<blockquote><p>Since the last update, development and other operations have been ongoing. There have been several hundred bug fixes based on user feedback, more than 100 improvements and numerous major improvements. We’ve added tens of thousands of unit tests for the various bugs and improvements in an attempt to allow us to release more updates faster in the future.</p>\n<p>We’re also working on a new services and support model, which is more exclusive in an attempt to reduce the volume of service requests and misaligned customer / subscriber expectations.</p>\n<p>Our goal is unchanged, to create easy ways for publishers and developers to increase WordPress performance and tune user-experience in self-hosted environments. As we work towards leaving beta and moving towards a 1.0 release (and making our GitHub repository public rather than private) our goal is to offer hosted services that use automation to simplify the performance optimization process in the future.</p></blockquote>\n<p>I spoke to Townes for an hour on Skype and he comes across as a sincere, concerned business owner who is struggling to find a system that works for the amount of support volume he and his team are dealing with. I asked what keeps him motivated to continue working on W3 Total Cache, &#8220;I love solving complex problems which is what W3 Total Cache does,&#8221; Townes replied.</p>\n<p>I can only imagine how heavy the burdens are maintaining a free plugin that&#8217;s active on more than a million sites. Joost de Valk, founder of <a href=\"https://yoast.com/\">Yoast.com</a>, and lead developer of <a href=\"https://wordpress.org/plugins/wordpress-seo/\">WordPress SEO</a>, a plugin active on more than one million sites shared some of the <a href=\"https://yoast.com/yoast-seo-3-0-release-a-recap/\">lessons he learned</a> after users experienced issues upgrading to 3.0.</p>\n<h2>Have The Changes Worked?</h2>\n<p>While researching for this article, I requested feedback from thousands of people to learn what recent customers are experiencing with the company but no one responded. This can mean any number of things but it&#8217;s difficult to determine whether the changes mentioned in the Reddit thread have improved the situation without getting feedback from recent customers.</p>\n<p>If you&#8217;ve recently purchased services from W3 Edge, please share your experience with us in the comments.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 23 Mar 2016 20:42:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"WPTavern: GitHub Issue and Pull Request Templates: Choose Your Own Adventure\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52746\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"http://wptavern.com/github-issue-and-pull-request-templates-choose-your-own-adventure\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2633:\"<p>Last month GitHub <a href=\"http://wptavern.com/github-introduces-issue-and-pull-request-templates\" target=\"_blank\">introduced issue and pull request templates</a> in response to the <a href=\"http://wptavern.com/open-source-project-maintainers-confront-github-with-open-letter-on-issue-management\" target=\"_blank\">&#8220;Dear GitHub&#8221; letter of complaints</a> from open source project maintainers. The new templates let maintainers streamline contributions to be more structured and meaningful for the project.</p>\n<p>Creating issue and pull request templates could be a boring addition to your project&#8217;s task list, or you can have a little fun with <a href=\"https://twitter.com/TalAter\" target=\"_blank\">Tal Ater</a>&#8216;s new <a href=\"https://www.talater.com/open-source-templates/\" target=\"_blank\">open source template generator</a>. It leads you on a whimsical journey inspired by Lewis Carroll and H.P. Lovecraft while creating templates for your project.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/issue-pull-request-generator.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/issue-pull-request-generator.png?resize=1025%2C485\" alt=\"issue-pull-request-generator\" class=\"aligncenter size-full wp-image-52757\" /></a></p>\n<p>The generator lets you build your templates in the style of a Choose Your Own Adventure book. At every step you make selections that will help structure the final templates. For example, you can choose whether or not to focus on bug reports, or prioritize new features/improvements, or make room for both in your issues template.</p>\n<p>In a post titled &#8220;<a href=\"http://www.theopensourcer.com/2016/learning-to-ship-through-ridiculousness/\" target=\"_blank\">Learn to Ship Faster by Embracing Ridiculousness</a>,&#8221; Ater explains how he built the project over three days as an exercise to help him learn to let go and ship imperfect products:</p>\n<blockquote><p>The project’s own imperfections are by definition its greatest strengths. Is it user friendly? About as friendly as a mad hatter. Does the writing make sense? Absolutely not. Did I get it from idea to shipping in 3 days? Abso-freaking-lutely.</p></blockquote>\n<p>The result is a fun little time machine that transports you back to childhood while outputting some useful templates for your open source projects. They may require a bit of additional tweaking for your particular use, but Ater&#8217;s <a href=\"https://www.talater.com/open-source-templates/#/\" target=\"_blank\">generator</a> gives you an easy way to get started.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 23 Mar 2016 16:32:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"WPTavern: WordPress Theme Review Team Moves Towards Automating Review Process\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52730\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"http://wptavern.com/wordpress-theme-review-team-moves-towards-automating-review-process\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2402:\"<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/red-pen.jpg\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2015/01/red-pen.jpg?resize=1024%2C500\" alt=\"photo credit: pollas - cc\" class=\"size-full wp-image-37241\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/pollas/526544001/\">pollas</a> &#8211; <a href=\"http://creativecommons.org/licenses/by-nc-sa/2.0/\">cc</a>\n<p>Getting a theme approved for the WordPress directory can sometimes take months, depending on the number of corrections required and reviewers available to handle the queue. As part of a larger plan to make things more efficient, the WordPress Theme Review Team is making progress towards automating many of the time-consuming checks involved in reviewing submissions and updates.</p>\n<p><a href=\"https://twitter.com/grapplerulrich\" target=\"_blank\">Ulrich Pogson</a>, who is leading the effort, published a <a href=\"https://make.wordpress.org/themes/2016/03/21/work-on-requirements-automation-update-1/\" target=\"_blank\">list of requirements</a> that might be good candidates for automated checks. Each item is now an issue on GitHub where contributors can discuss implementation and help build the checks. A few examples include &#8220;<a href=\"https://github.com/Otto42/theme-check/issues/133\" target=\"_blank\">Use the Customizer for implementing theme options</a>,&#8221; &#8220;<a href=\"https://github.com/Otto42/theme-check/issues/134\" target=\"_blank\">Don’t include any plugins</a>,&#8221; and &#8220;<a href=\"https://github.com/Otto42/theme-check/issues/126\" target=\"_blank\">Don’t include admin/feature pointers</a>.&#8221;</p>\n<p>During the most recent meeting, the team approved a <a href=\"https://make.wordpress.org/themes/2016/03/22/22-march-team-meeting/\" target=\"_blank\">list of 13 requirements</a> they are aiming to automate. They will need to write checks for each one and are inviting collaboration on GitHub.</p>\n<p>&#8220;It could be making a pull request, helping write the regex, or contributing ideas how to implement the check,&#8221; Pogson said. &#8220;Once the checks have been written we need help testing them for false positives.&#8221;</p>\n<p>Check out the <a href=\"https://github.com/Otto42/theme-check/issues\" target=\"_blank\">issues queue</a> for the Theme Check plugin if you want to help the team automate more checks.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 22 Mar 2016 22:30:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:30;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"WPTavern: Submit Pull Requests to WordPress Core with the GitHub-to-Patch Utility\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52711\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"http://wptavern.com/submit-pull-requests-to-wordpress-core-with-the-github-to-patch-utility\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3623:\"<p><a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/github-to-patch.png\"><img src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/github-to-patch.png?resize=1025%2C499\" alt=\"github-to-patch\" class=\"aligncenter size-full wp-image-52720\" /></a></p>\n<p>When Matt Mullenweg asked the audience who has used Git and/or GitHub during his <a href=\"http://wptavern.com/matt-mullenwegs-state-of-the-word-highlights-internationalization-mobile-and-new-tools-for-wordpress-contributors\" target=\"_blank\">2014 State of the Word</a> address, the response was almost unanimous. “Whoah, that’s all the hands!” he exclaimed before announcing that core contributors will soon be able to submit pull requests on GitHub.</p>\n<p>Two years later, an official patch workflow has not yet been established. In addition to ironing out the logistics, contributors must also take into account what might be lost or gained in the GitHub approach to problem solving. The GitHub pull request collaboration style is markedly different than the lengthy discussions that happen on WordPress Trac.</p>\n<p>Nevertheless, WordPress contributors who use GitHub as part of daily life are eager to see progress on an official pipeline for pull requests. In the meantime, Ryan McCue has just launched a utility that allows contributors to submit pull requests to core. <a href=\"https://rmccue.io/patch/\" target=\"_blank\">GitHub-to-Patch</a> is a proof-of-concept that provides an easy way to submit a pull request as a patch.</p>\n<p>The process that McCue outlines in his <a href=\"http://journal.rmccue.io/367/patch-wordpress-via-github/\" target=\"_blank\">post</a> involves submitting a pull request to the <a href=\"https://github.com/WordPress/WordPress\" target=\"_blank\">WordPress/WordPress repo</a>, selecting the request via the utility, and associating the request with the corresponding ticket number. He also advises heading back to the ticket to leave a comment about the patch you added.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/github-to-patch-step-1.png\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/github-to-patch-step-1.png?resize=1025%2C703\" alt=\"github-to-patch-step-1\" class=\"aligncenter size-full wp-image-52726\" /></a></p>\n<p>&#8220;Internally, the utility uses GitHub’s API to get a patch format of the pull request, then uses Trac’s XML-RPC API to upload,&#8221; McCue said. &#8220;This requires your WordPress.org credentials, and because of cross-origin policy, also requires an intermediary server. I hope to fix this in the future, either by integrating the tool into Trac itself, or by using OAuth with WordPress.org.&#8221;</p>\n<p>McCue clarified on Twitter that his utility is not meant to be a final solution to WordPress/GitHub interactions but rather a stop-gap measure until a better solution is available. He <a href=\"https://twitter.com/rmccue/status/712143679780200448\" target=\"_blank\">referenced</a> Weston Ruter&#8217;s approach that <a href=\"https://make.xwp.co/2015/12/05/streamlining-contributions-to-wordpress-core-via-github/\" target=\"_blank\">uses Travis CI to handle uploading patches from trusted pull requests to Trac</a> as one of the more elegant examples in the works.</p>\n<p>For those with no SVN experience, GitHub-to-Patch significantly lowers the barrier to entry for contributing to core. If you don&#8217;t want to use the <a href=\"https://rmccue.io/patch/\" target=\"_blank\">utility</a> on McCue&#8217;s server, the code is available on GitHub and can be installed on your own server.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 22 Mar 2016 18:34:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:31;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"WPTavern: WordPress Adopts Accessibility Coding Standards for All New and Updated Code\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52690\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:96:\"http://wptavern.com/wordpress-adopts-accessibility-coding-standards-for-all-new-and-updated-code\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:3221:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/paper-1.jpg\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/paper-1.jpg?resize=960%2C501\" alt=\"photo credit: Startup Stock Photos\" class=\"size-full wp-image-52706\" /></a>photo credit: <a href=\"https://stocksnap.io/photo/L2KBJB91D6\">Startup Stock Photos</a>\n<p>The Accessibility Team announced today that the <a href=\"https://make.wordpress.org/core/handbook/best-practices/coding-standards/accessibility-coding-standards/\" target=\"_blank\">WordPress Accessibility Coding Standards</a> have been approved for the core handbook. The team <a href=\"http://wptavern.com/your-chance-to-give-feedback-on-wordpress-accessibility-coding-standards\" target=\"_blank\">sought feedback on the draft of the guidelines</a> earlier this year and, after a few revisions, the coding standards are out of draft status.</p>\n<p>Contributors will now be required to meet these guidelines in order to have their code merged into core:</p>\n<blockquote><p>All new or updated code released in WordPress must conform with the <a href=\"https://www.w3.org/WAI/intro/wcag\" target=\"_blank\">WCAG 2.0 guidelines</a> at level AA.</p></blockquote>\n<p>Level AA, according to accessibility team member Rian Rietveld, includes guidelines used as a reference for a legal standard in many countries. WordPress&#8217; new accessibility coding standards cover five key areas:</p>\n<ul>\n<li>HTML Semantics</li>\n<li>Color Contrast</li>\n<li>Keyboard Accessibility</li>\n<li>Images and Icons</li>\n<li>Labeling</li>\n</ul>\n<p>The default Twenty Sixteen theme is already compliant with WCAG 2 AA and more <a href=\"https://wordpress.org/themes/tags/accessibility-ready/\" target=\"_blank\">accessibility-ready themes</a> are tagged in the official directory. At this time, themes and plugins hosted on WordPress.org are not required to meet these guidelines.</p>\n<p>&#8220;Having a dedicated principle that WordPress needs to meet a certain level of accessibility standards is incredibly powerful,&#8221; contributor Joe Dolson said in a reaction on his <a href=\"https://www.joedolson.com/2016/03/wordpress-goes-wcag-mean/\" target=\"_blank\">blog</a>.</p>\n<p>&#8220;Since it doesn’t change the fact that the WordPress Accessibility team consists of a relatively small group of part-time volunteers, we have to realistically acknowledge that we won’t catch everything.</p>\n<p>&#8220;But that still leaves us with an overall arc that leads to a future with a more accessible WordPress, and that’s an unmistakable win for accessibility,&#8221; he said.</p>\n<p>Vocal accessibility advocates have been <a href=\"http://wptavern.com/your-chance-to-give-feedback-on-wordpress-accessibility-coding-standards\" target=\"_blank\">calling for WordPress to adopt a set of standards</a> and these new guidelines demonstrate the project&#8217;s commitment to serving those with a disability. With WCAG 2 AA established as the standard, the accessibility team is now in a better position to provide a list of requirements for an <a href=\"https://make.wordpress.org/accessibility/2014/05/02/automated-accessibility-testing/\" target=\"_blank\">automated testing tool</a>.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 22 Mar 2016 05:17:25 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:32;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:78:\"WPTavern: WP Engine Adds 2FA to User Portal, Opt-In PHP 7 Support In the Works\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52657\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"http://wptavern.com/wp-engine-adds-2fa-to-user-portals-opt-in-php-7-support-in-the-works\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6799:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/wp-engine.jpg\"><img class=\"aligncenter size-full wp-image-34106\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2014/11/wp-engine.jpg?resize=1025%2C427\" alt=\"wp-engine\" /></a></p>\n<p>WP Engine <a href=\"https://wpengine.com/blog/two-factor-authentication/\" target=\"_blank\">announced</a> today that two-factor authentication (2FA) is now available to its 42,000 customers. The security measure will help combat increasing attempts on the host&#8217;s user portal.</p>\n<p>&#8220;As we grow, almost everything about the company changes, and security is one of them,&#8221; said WP Engine founder Jason Cohen. &#8220;For example, we see things like fraudulent accounts and account impersonation/phishing, and other things which didn’t appear often when we were smaller and less of a target.&#8221;</p>\n<p>Adding 2FA is part of a larger plan for improved security that the company began last year when it hired Eric Murphy as its new security director.</p>\n<p>&#8220;We’ve had a cross-departmental internal security group of about a dozen people for a few years now, but in 2015 we decided we needed even more leadership in that area,&#8221; Cohen said.</p>\n<p>&#8220;We hired Eric last year, in fact before the December security incident, so in hindsight that was excellent timing.&#8221;</p>\n<p>Murphy is now overseeing the technical aspects of security, like firewalls and VPNs, as well as the social engineering and training aimed at protecting customer account access.</p>\n<p>After the December breach where <a href=\"http://wptavern.com/wp-engine-security-breach-customer-credentials-exposed\" target=\"_blank\">customer credentials were exposed</a>, WP Engine began moving its customers off of Linode&#8217;s cloud infrastructure. Cohen confirmed that thousands of customers have been moved and that no new customers have been added to Linode.</p>\n<h3>The Challenges of Implementing 2FA</h3>\n<p>Although providing 2FA for accounts is a security best practice, Cohen said that it would not have prevented the December breach, as the entry point was with Linode. Regardless, WP Engine customers have been requesting 2FA support for the user portal for years. When asked why it took the company so long to implement it, Cohen identified a few of the technical challenges.</p>\n<p>&#8220;One of the challenges was in identity recovery,&#8221; he said. &#8220;We can’t use email as a way to recover from a lost phone, because then the email address becomes a &#8216;single factor,&#8217; i.e. you can use it to recover your password as well as your phone aspect.</p>\n<p>&#8220;However, nowadays with the advent of Google Authenticator and other apps, plus people’s general awareness of how to use things like scratch codes, we felt it was now not going to be hard for people to use,&#8221; Cohen said.</p>\n<p>When it comes to protecting WordPress, WP Engine customers have always been able to use a plugin to add 2FA. Cohen said that the company is investigating a solution to make it more convenient for customers who manage multiple accounts.</p>\n<p>&#8220;Suppose you manage 50 WP sites and you want 2FA,&#8221; he said. &#8220;So do you configure 2FA on every site and have 50 entries in your Google Authenticator App? That stinks!</p>\n<p>&#8220;So, something better would be a SSO system somewhere, have 2FA on <em>that</em>, and then use that to get into WordPress,&#8221; Cohen said.</p>\n<p>&#8220;Another way would be to use OAuth, e.g. use Google OAuth on WP, and indeed for customers who already use Google Apps, we do recommend that method. Another method might be that our own User Portal be an OAuth provider.&#8221;</p>\n<p>With a host of solutions already available, Cohen said they are also considering simply pointing customers to a list of recommendations.</p>\n<p>&#8220;Even if we do our own, we’d always support the other methods,&#8221; he said. &#8220;The idea isn’t to box anyone into a single method.&#8221;</p>\n<h3>WP Engine Plans to Add Opt-In PHP 7 Support in 2016</h3>\n<p>WP Engine is currently <a href=\"https://wpengine.com/blog/php-7-the-way-of-the-future/\" target=\"_blank\">working on a PHP 7 implementation</a> for all customers. In December, the company tested 25 concurrent users over 5 minutes across 10 randomly selected URLs — run against a basic WordPress (4.3.1) install on its Mercury Vagrant configuration. The results showed that PHP 7 handles the raw hits 2.6x faster than PHP 5.5.</p>\n<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/wp-engine-testing.png\"><img class=\"aligncenter size-full wp-image-52674\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/wp-engine-testing.png?resize=1025%2C709\" alt=\"wp-engine-testing\" /></a></p>\n<p>Unfortunately, customers who are eager to see WP Engine upgrade to PHP 7 across the board will be waiting for the rest of the WordPress ecosystem to catch up. As an alternative, the company is looking at the possibility of making PHP 7 an opt-in.</p>\n<p>&#8220;We have PHP7 running on some machines,&#8221; Cohen said. &#8220;But it’s actually amazing how few WP sites in the field are compatible. We’re finding that it&#8217;s less than 20%. There will need to be an opt-in for that reason.&#8221;</p>\n<p>Although WordPress core is compatible with PHP 7, the vast majority of WordPress plugins and themes are not.</p>\n<p>&#8220;Even WooCommerce doesn’t completely work with it,&#8221; Cohen said. &#8220;Many big, popular plugins are not yet compatible. With PHP v5.5 there was some of that, but this is much more. Of course PHP7 is the future so it’s inevitable, but it’s going to take more time than some other PHP releases did.&#8221;</p>\n<p>Cohen said the best case scenario would be for customers to choose PHP 7 on an install-by-install basis and change at any time. He does not yet have an ETA, as the company is working on an undisclosed big project that Cohen says is part and parcel of it.</p>\n<p>&#8220;We have to make some decisions about how much to put into it before release, versus releasing it earlier and then layering in more things afterwards,&#8221; he said.</p>\n<p>There are several large hurdles to allowing PHP version selection on an install-by-install basis, which need to be worked out before rolling it out to thousands of customers.</p>\n<p>&#8220;One challenge is running multiple versions at the same time on the same machine,&#8221; Cohen said. &#8220;Another is tech support — if something doesn’t work in it, we need our 150+ support techs to understand how to figure that out and help.&#8221;</p>\n<p>Cohen said he could see opt-in PHP 7 support happening for customers as early as this year but could not specify when.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 21 Mar 2016 20:17:13 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:33;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"Matt: Chamath on Growing Facebook\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=46387\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://ma.tt/2016/03/chamath-on-growing-facebook/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1405:\"<p><span class=\"embed-youtube\"></span></p>\n<p>This is a cool talk from <a href=\"https://twitter.com/chamath\">Chamath Palihapitiya</a> from a few years ago in 2013 which makes it extra interesting. It seems like a smaller audience so it&#8217;s fun and unguarded. (Though a great thing about Chamath is he&#8217;s incredibly candid in every context.) You can&#8217;t see the slides in the video, and there&#8217;s not much to them, but here they are:</p>\n<p> \n<div> <strong> <a href=\"https://www.slideshare.net/growthhackersconference/how-we-put-facebook-on-the-path-to-1-billion-users\" title=\"Facebook&#x27;s Growth Hacker on how they put Facebook on the Path to 1 Billion Users\" target=\"_blank\">Facebook&#x27;s Growth Hacker on how they put Facebook on the Path to 1 Billion Users</a> </strong> from <strong><a target=\"_blank\" href=\"http://www.slideshare.net/growthhackersconference\">growthhackersconference</a></strong> </div>\n<p>Here are the values he talks about at the end:</p>\n<ol>\n<li>Very high IQ.</li>\n<li>Strong sense of purpose.</li>\n<li>Relentless focus on success.</li>\n<li>Aggressive and competitive.</li>\n<li>High quality bar bordering on perfectionism.</li>\n<li>Likes changing and disrupting things.</li>\n<li>New ideas on how to do things better.</li>\n<li>High integrity.</li>\n<li>Surrounds themselves with good people.</li>\n<li>Cares about building real value over perception.</li>\n</ol>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 21 Mar 2016 02:00:08 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:34;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"WPTavern: In Case You Missed It – Issue 5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:44:\"http://wptavern.com?p=52645&preview_id=52645\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"http://wptavern.com/in-case-you-missed-it-issue-5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7253:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/01/ICYMIFeaturedImage.png\" rel=\"attachment wp-att-50955\"><img class=\"size-full wp-image-50955\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/01/ICYMIFeaturedImage.png?resize=676%2C292\" alt=\"In Case You Missed It Featured Image\" /></a>photo credit: <a href=\"http://www.flickr.com/photos/112901923@N07/16153818039\">Night Moves</a> &#8211; <a href=\"https://creativecommons.org/licenses/by-nc/2.0/\">(license)</a>\n<p>There&#8217;s a lot of great WordPress content published in the community but not all of it is featured on the Tavern. This post is an assortment of items related to WordPress that caught my eye but didn&#8217;t make it into a full post.</p>\n<h2>Human Made Hires Siobhan McKeown</h2>\n<p>Development firm, Human Made Ltd., <a href=\"https://hmn.md/2016/03/17/siobhan-mckeown-joins-human-made/\">announced</a> that it has hired Siobhan McKeown as their events director. Human Made worked closely with McKeown who helped organize and run <a href=\"https://feelingrestful.com\">A Day of REST</a>, a conference devoted to the WordPress REST API. According to the post, McKeown&#8217;s role is to expand the company&#8217;s events, including the Day of Rest conference.</p>\n<h2>WordPress is the Light in a Sea of Darkness</h2>\n<p>Raghavendra Satish Peri from India, who discovered at the age of 14 that he was 80% blind, <a href=\"http://heropress.com/essays/finding-hope-darkness/\">describes how WordPress</a> became a shining light in a sea of darkness.</p>\n<blockquote><p>WordPress has changed the way I see my life, today I am a full time <a href=\"http://www.digitala11y.com\">Digital Accessibility Consultant</a> &amp; I build most of my code examples on WP. This is helping me grow professionally &amp; personally each day. I am financially independent, travel around the world, attend &amp; speak at conferences/meet-ups, fought depression with my writing, wrote a bucket list &amp; am actively pursuing it. All this would have not been possible with the power of publishing &amp; WP has simplified it for me.</p></blockquote>\n<p>In the post, Satish Peri says he has two wishes. The first is to attend WordCamp US and meet Matt Mullenweg. The second is to see every part of WordPress core be accessible. While the <a href=\"https://make.wordpress.org/accessibility/\">WordPress accessibility team</a> is working on his second wish, how can we as a community grant the first?</p>\n<h2>WordPress&#8217; Greatest Threat Isn&#8217;t a CMS</h2>\n<p>Chris Wallace explains why the <a href=\"http://chriswallace.org/the-biggest-threat-to-wordpress-isnt-another-cms/\">greatest threat to WordPress</a> isn&#8217;t a competing CMS, but the people who criticize it in a rude and disrespectful way.</p>\n<blockquote><p>But the biggest threat to WordPress right now is not a CMS. Heck, it’s not even a technology challenge or an issue with legacy code. The biggest threat to WordPress is people in the community who voice opinions in a rude and disrespectful way, echoing a deep lack of appreciation for the contributors and project leaders simply trying to make WordPress better within the framework of being used on 25% of the web <em>with a desire to continue increasing that number</em>.</p></blockquote>\n<p>I tried to explain <a href=\"http://wptavern.com/how-not-to-communicate-grievances-with-wordpress\">how to be helpful</a> when criticizing WordPress last year, but I&#8217;m not sure I made an impact. I know from experience that encountering a constant barrage of criticism is unhealthy and can lead to burnout. The same holds true for those who are committed to improving WordPress on a daily basis.</p>\n<p>It&#8217;s not that things need to be sugarcoated, it&#8217;s that criticism should be given in an actionable way to make things better for all involved. It&#8217;s also about civil discourse and treating others with respect.</p>\n<p>The final part of Wallace&#8217;s post is great advice:</p>\n<blockquote><p>Let’s all take a few minutes to be grateful for the opportunity to make a living off the hard work of thousands of other people who donated their time and code to build something that has made a huge impact on the Internet and in people’s actual lives.</p></blockquote>\n<h2>Matt Mullenweg on The Changelog Podcast</h2>\n<p>Matt Mullenweg appeared on <a href=\"https://changelog.com/197/\">The Changelog podcast</a> to discuss the future of WordPress and how Calypso fits in. It&#8217;s a great show as the duo dive deep into the role JavaScript plays in the future of WordPress.</p>\n<h2>Developing a WordPress Plugin That Uses Service APIs</h2>\n<p>Smashing Magazine <a href=\"https://www.smashingmagazine.com/2016/03/making-a-wordpress-plugin-that-uses-service-apis/\">published a great guide</a> that explains how to create a plugin that taps into third-party service APIs.</p>\n<h2>Adopting Plugins is Life Changing for Some</h2>\n<p><a href=\"http://www.zdnet.com/meet-the-team/us/david-gewirtz/\">David Gewirtz</a>, who writes for ZDNet, describes how <a href=\"http://www.zdnet.com/article/a-year-later-what-happens-when-you-adopt-an-open-source-project/\">adopting 10 WordPress plugins changed his life</a>. It&#8217;s one of the coolest stories I&#8217;ve read on the use of the <a href=\"http://wptavern.com/adopt-me-plugin-tag-is-now-in-use-on-wordpress-org\">&#8220;Adopt-Me&#8221; tag</a> in the WordPress plugin directory. One of the best parts of the story is when Gewirtz explains what happened when he adopted a plugin with more than 10K active installs.</p>\n<blockquote><p>Seamless Donations had more than 10,000 active users on the day I adopted it. I expected my workload would be roughly the same as for the widget. I&#8217;d make a few security fixes as they came along and tweaks for compatibility.</p>\n<p>I was wrong.</p>\n<p>I also expected the users to be seasoned webmasters. After all, if you&#8217;re installing an open source project on your server, you&#8217;re obviously going to be experienced with Linux and PHP and all the rest, right? Right?</p>\n<p>Oh, how wrong I was.</p></blockquote>\n<p>Definitely give this a read if you&#8217;re thinking about adopting a popular plugin.</p>\n<h2>Warm Weather Wapuu</h2>\n<p>As a traditional part of this series, I end each issue by featuring a Wapuu design. For those who don&#8217;t know, Wapuu is the <a href=\"http://wapuu.jp/2015/12/12/wapuu-origins/\">unofficial mascot</a> of the WordPress project. Since the first day of Spring in the US is Sunday, March 20th, I decided to feature the Wapuu family from WordCamp Miami. Each member of the family except for the basketball one, is a reminder that warmer weather is on the way!</p>\n<blockquote class=\"twitter-tweet\"><p lang=\"en\" dir=\"ltr\">The official <a href=\"https://twitter.com/hashtag/wcmia?src=hash\">#wcmia</a> Wapuu family. <a href=\"http://t.co/U2Ao9Yh0qN\">pic.twitter.com/U2Ao9Yh0qN</a></p>\n<p>&mdash; WordCamp Miami (@wordcampmiami) <a href=\"https://twitter.com/wordcampmiami/status/606179756472692736\">June 3, 2015</a></p></blockquote>\n<p></p>\n<p>That&#8217;s it for issue five. If you recently discovered a cool resource or post related to WordPress, please share it with us in the comments.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 19 Mar 2016 01:40:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:35;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"WPTavern: WordPress 4.5 to Add oEmbed Support for Twitter Moments and Timelines\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52535\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"http://wptavern.com/wordpress-4-5-to-add-oembed-support-for-twitter-moments-and-timelines\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1549:\"<p>WordPress introduced oEmbed support for tweets in its <a href=\"https://codex.wordpress.org/Version_3.4\" target=\"_blank\">3.4 release</a>, but recent changes to Twitter&#8217;s API requires updates to core. On May 1, Twitter will be <a href=\"https://twittercommunity.com/t/deprecation-of-xml-response-type-for-single-tweet-oembed/62013\" target=\"_blank\">removing the XML response format</a> from the single Tweet oEmbed endpoint. Twitter engineer Niall Kennedy opened a <a href=\"https://core.trac.wordpress.org/ticket/36197\" target=\"_blank\">ticket</a> to change the oEmbed URL for single tweets from api.twitter.com to publish.twitter.com.</p>\n<p>In addition to the patch Kennedy submitted with the ticket, core committer Dominik Schilling added a patch to extend the provider list to support <a href=\"https://about.twitter.com/moments\" target=\"_blank\">moments</a> and <a href=\"https://support.twitter.com/articles/164083\" target=\"_blank\">timelines</a> from Twitter.</p>\n<p>The update was included in this week&#8217;s <a href=\"https://wordpress.org/news/2016/03/wordpress-4-5-beta-4/\" target=\"_blank\">WordPress 4.5 Beta 4 release</a>. To see it in action you can take the latest beta for a test drive or check out the embedded moment and timeline links below.</p>\n<p><a class=\"twitter-moment\" href=\"https://twitter.com/i/moments/650667182356082688\">The Obamas\' wedding anniversary</a></p>\n<p><a class=\"twitter-grid\" href=\"https://twitter.com/TwitterDev/timelines/539487832448843776\">National Park Tweets</a></p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 18 Mar 2016 21:29:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:36;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"Post Status: WordPress Hosting — Draft podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://poststatus.com/?p=22401\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://poststatus.com/wordpress-hosting-draft-podcast/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2464:\"<p>Welcome to the Post Status <a href=\"https://poststatus.com/category/draft\">Draft podcast</a>, which you can find <a href=\"https://itunes.apple.com/us/podcast/post-status-draft-wordpress/id976403008\">on iTunes</a>, <a href=\"http://www.stitcher.com/podcast/krogsgard/post-status-draft-wordpress-podcast\">Stitcher</a>, and <a href=\"http://simplecast.fm/podcasts/1061/rss\">via RSS</a> for your favorite podcatcher. Post Status Draft is hosted by Joe Hoyle &#8212; the CTO of Human Made &#8212; and Brian Krogsgard.</p>\n<p>WordPress hosting is always a hot topic of conversation, due to the difficult task of differentiating one host from another. There is also a lot of money and marketing involved in the industry &#8212; an industry that includes some of the largest companies in the WordPress ecosystem.</p>\n<p>In this episode, Joe and I attempt to break down what different types of hosting are available, how they are applicable to WordPress, and even dig in to some of the drama and politics that surround the hosting world.</p>\n<p>The techical part of the conversation is the first 50 minutes or so, and around that mark, we get into the politics and non-technical issues around WordPress hosting, as well as tell some stories of how companies have successfully marketed themselves by getting embedded in the WordPress community.</p>\n<p><a href=\"https://audio.simplecast.com/32589.mp3\">https://audio.simplecast.com/32589.mp3</a><br />\n<a href=\"https://audio.simplecast.com/32589.mp3\">Direct Download</a></p>\n<h3>Links</h3>\n<ul>\n<li><a href=\"http://reviewsignal.com\">Review Signal</a> is a great resource for comparing hosting.</li>\n<li>The 2015 <a href=\"http://reviewsignal.com/blog/2015/07/28/wordpress-hosting-performance-benchmarks-2015/\">Review Signal WordPress hosting review</a> is a nice guide.</li>\n<li>WordPress <a href=\"https://wordpress.org/hosting/\">recommended hosting page</a> is a source of a number of questions.</li>\n<li>We talk about a lot of different hosting companies during this episode. Just Google them.</li>\n</ul>\n<p>This episode is sponsored by one of our great partners, Prospress. Check out <a href=\"https://poststatus.com/organizations/prospress-inc/\">Prospress&#8217;s Post Status profile</a>, as well as <a href=\"https://prospress.com/?utm_source=post_status&utm_medium=banner&utm_campaign=ps_ads\">their website</a>. They are the makers of the excellent WooCommerce Subscriptions plugin, amongst other helpful products.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 18 Mar 2016 20:02:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Brian Krogsgard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:37;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"WPTavern: Is W3C Replicating the WordPress Pingback System?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52624\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"http://wptavern.com/is-w3c-replicating-the-wordpress-pingback-system\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:6137:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/JamesRichmanProfile.png\" rel=\"attachment wp-att-52632\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/JamesRichmanProfile.png?resize=150%2C150\" alt=\"JamesRichmanProfile\" class=\"alignright size-thumbnail wp-image-52632\" /></a>This post was contributed by guest author <a href=\"http://1stwebdesigner.com/\" target=\"_blank\">James Richman</a>. James writes about marketing, digital design, entrepreneurship, and technology. He has gained most of his experience from running a variety of his own businesses for more than a decade.<br />\n&nbsp;</p>\n<hr />\n<p>On January 12, 2016, the W3C (the World Wide Web Consortium) released its first public working draft of <a href=\"https://www.w3.org/TR/2016/WD-webmention-20160112/\" target=\"_blank\">Webmentions</a>, but the announcement didn’t feel new. In fact, Webmentions have been around since IndieWebCamp created them in 2013, and <a href=\"https://www.toptal.com/wordpress\" target=\"_blank\">top WordPress developers</a> are already using a Webmentions plugin to utilize the tool.</p>\n<p>Yet, for those who use WordPress, Webmentions seemed like a retread of WordPress’ Pingback system from the early 2000s, which featured a similar concept.</p>\n<p>The Pingback system was invented in 2002 by Stuart Langridge, and in essence, it allowed pieces that were published on different WordPress sites to talk to each other. This is perhaps best explained by walking through an example scenario:</p>\n<ol>\n<li>Website A posts a new entry on its blog.</li>\n<li>Website B responds to that blog post with its own post and links to the post on Website A.</li>\n<li>The Pingback system then notifies Website A that Website B wrote about and linked to its blog post.</li>\n<li>Website A then verifies the content and link on Website B. If it is not spam, Website A will post a comment on the original blog post linking to Website B’s post.</li>\n</ol>\n<p>It’s important to note a few things about the Pingback system. First, it is exclusively for WordPress sites, and both sites have to enable Pingback for it to work. Second, the whole Pingback system is automated, streamlining the process of trackbacks, which is the manual equivalent of the automated Pingback.</p>\n<p>Yet despite its perks, <a href=\"http://wptavern.com/its-time-for-xml-rpc-in-wordpress-to-hit-the-road\" target=\"_blank\">Pingback system usage</a> declined after the automatic system was taken advantage of by spammers.</p>\n<p>The issue of spamming and abuse of such a communication channel has long been the problem with this type of communication channel. Prior to Pingbacks, WordPress used a Trackback system that provided the same type of communication.</p>\n<p>The only difference between the Trackback system and Pingbacks is that Trackbacks had to be inputted manually. Spamming problems were just as prevalent with trackbacks. In fact the WPTavern site <a href=\"http://wptavern.com/wptavern-was-trackbacked-to-death\" target=\"_blank\">shut down in 2010</a> because of trackback spam.</p>\n<p>So what makes Webmentions different than the Pingbacks and Trackbacks that came before? Well, not all that much. Turns out, Webmentions do the exact same thing as the Pingback system; they just do it better.</p>\n<p>The biggest difference between the two is the code they’re composed of. Pingback uses XMLRPC, an outdated approach that encodes data with XML and then transports that data with HTTP. The Pingback system is bulky and slow. Webmentions, on the other hand, uses HTTP and x-www-form-urlencoded content, a much more widely accepted format in today’s world. The result is that Webmentions is much faster and much easier to integrate.</p>\n<p>As Pingback’s creator Langridge <a href=\"http://www.kryogenix.org/days/2014/11/29/enabling-webmentions/\" target=\"_blank\">points out on his blog</a>, “XMLRPC is considerably less popular than it was, and is really heavyweight for this sort of thing. We’ve learned since then that HTTP can actually do all this stuff for us way more simply.” If you haven’t guessed, the Pingback founder has converted to Webmentions too.</p>\n<p>Webmention’s growing popularity is due to the tool’s ease of use and the fact that it blocks spam effectively with the <a href=\"http://indiewebcamp.com/Vouch\" target=\"_blank\">Vouch protocol</a>. But Webmentions also look better aesthetically in the comments section. Pingback comments look robotic and aren’t exactly readable; a Pingback comment contains the title of the post that sent the Pingback and an ellipsed summary that doesn’t make much sense.</p>\n<p>Webmentions look and feel like human comments with the help of the <a href=\"https://github.com/pfefferle/wordpress-semantic-linkbacks\" target=\"_blank\">Semantic Linkbacks plugin</a>. This plugin parses the Webmention linkback and translates it into a full sentence (e.g. ‘Sarah mentioned this post in her article x on site y’) and can even include the author’s profile picture.</p>\n<p>Webmentions are quickly replacing the Pingback system because of the tool’s convenience and better implementation to reach a similar goal, and this has been happening prior to W3C’s public endorsement. So what does W3C’s support of <a href=\"http://indiewebcamp.com/webmention\" target=\"_blank\">IndieWebCamp’s creation</a> mean?</p>\n<p>Ultimately, W3C’s announcement will likely help cement Webmention’s place on the internet. And so W3C’s recent push can be and should be considered as an effort to standardize the wild web.</p>\n<p>The internet was created to communicate and share information, yet individual pieces of content are unable to communicate with each other as easily as users can. The Pingback system was a worthy, but flawed, attempt to change that, and now Pingback’s legacy survives through the broader support and growing distribution of Webmention’s network. If Webmentions become more popular, maybe one day in the future, they will connect the strands of the web together, so that the web will have earned its namesake in truth.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 18 Mar 2016 17:40:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:38;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:107:\"WPTavern: Cory Miller and Pippin Williamson Discuss the Importance of Mental Health on Office Hours Podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52599\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:117:\"http://wptavern.com/cory-miller-and-pippin-williamson-discuss-the-importance-of-mental-health-on-office-hours-podcast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:2006:\"<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/heart.jpg\" rel=\"attachment wp-att-52604\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/heart.jpg?resize=1024%2C587\" alt=\"photo credit: rubryan\" class=\"size-full wp-image-52604\" /></a>photo credit: <a href=\"https://www.flickr.com/photos/rubyran2626/2263837091/in/faves-57854010@N05/\">rubryan</a>\n<p>In the latest episode of <a href=\"http://officehours.fm/\" target=\"_blank\">Office Hours</a>, a WordPress business podcast, host Carrie Dils interviewed <a href=\"https://ithemes.com/\" target=\"_blank\">Cory Miller</a> and <a href=\"https://pippinsplugins.com/\" target=\"_blank\">Pippin Williamson</a> to discuss the importance of personal wellness. The episode is titled &#8220;<a href=\"http://officehours.fm/podcast/95-2/\" target=\"_blank\">Taking Care of Your Business Means Taking Care of Yourself</a>&#8221; and the video is now available on OfficeHours.fm.</p>\n<p>Both Miller and Williamson are successful WordPress entrepreneurs who have recently shared their experiences on maintaining mental health. In this interview Dils chats with the guests about stress and depression and how they can impact your business. They each share tips for how to recharge or &#8220;Go find your soul food,&#8221; as Williamson put it. The episode covers a broad range of topics that aren&#8217;t often discussed in the world of business:</p>\n<ul>\n<li>Extracting yourself from toxic relationships</li>\n<li>Fear of failure/ fear of not working</li>\n<li>Setting healthy boundaries</li>\n<li>Taking breaks</li>\n<li>Establishing a support team</li>\n<li>Transparency with peers</li>\n<li>Combatting negative thoughts</li>\n<li>Finding a mentor</li>\n</ul>\n<p>If you are experiencing the unique pressures of entrepreneurship or struggling with maintaining your mental health, check out the <a href=\"http://officehours.fm/podcast/95-2/\" target=\"_blank\">latest episode of Office Hours</a> for some practical tips.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 18 Mar 2016 05:25:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Sarah Gooding\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:39;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"WPTavern: WPForms Aims to be the Most Beginner Friendly Forms Plugin for WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52516\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:92:\"http://wptavern.com/wpforms-aims-to-be-the-most-beginner-friendly-forms-plugin-for-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:9192:\"<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormsFeaturedImage.png\" rel=\"attachment wp-att-52594\"><img class=\"aligncenter size-full wp-image-52594\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormsFeaturedImage.png?resize=817%2C261\" alt=\"WPForms Featured Image\" /></a></p>\n<p><a href=\"https://wordpress.org/plugins/wpforms-lite/\">WPForms Lite</a> is a new plugin developed by <a href=\"https://profiles.wordpress.org/smub/\">Syed Balkhi</a> and <a href=\"https://profiles.wordpress.org/jaredatch/\">Jared Atchison</a> that aims to be the most beginner friendly form creation plugin in the market, &#8220;We made simple tasks EASY rather than letting the complex tasks define how hard simple will be,&#8221; Balkhi told the Tavern. I took the plugin for a test drive to see how easy it is to use.</p>\n<h2>A Great Introduction</h2>\n<p>Upon activation, a WPForms introduction screen is displayed. This screen provides information on how to create your first form and includes an embedded video explaining how. I had to watch the video a few times to follow along but overall it serves its purpose.</p>\n<p>If video is not your thing, consider walking through the <a href=\"https://wpforms.com/docs/creating-first-form/\">step by step guide</a> on the WPForms website. Those who want to jump right in can do so by clicking the <strong>WPForms &gt; Add New</strong> link.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormsIntroductionScreen.png\" rel=\"attachment wp-att-52581\"><img class=\"size-full wp-image-52581\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormsIntroductionScreen.png?resize=1025%2C675\" alt=\"WP Forms Introduction Screen\" /></a>WPForms Introduction Screen\n<h2>WPForm User Interface Forces You to Focus</h2>\n<p>One of the first things I noticed is the user interface and how it appears over WordPress. It was shocking at first to see WordPress disappear but the team chose to use this interface to avoid being constrained with WordPress&#8217; user interface. After working with WPForms for more than an hour, I found myself enjoying the fact that the interface forced me to focus on creating my form.</p>\n<p>WPForms ships with six different templates to handle the most common use cases. All templates except the Blank Form and the Simple Contact form require you to upgrade to the commercial version. I chose the simple contact form template.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormTemplates.png\" rel=\"attachment wp-att-52582\"><img class=\"size-full wp-image-52582\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormTemplates.png?resize=1025%2C559\" alt=\"WPForm Templates\" /></a>WPForm Templates\n<p>The simple contact form template automatically adds a name, email, paragraph, and submit fields to the form. An important time saver that sets WPForms apart from other plugins is that, the fields are automatically flagged as required.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormSimpleContactFormTemplate.png\" rel=\"attachment wp-att-52583\"><img class=\"size-full wp-image-52583\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormSimpleContactFormTemplate.png?resize=1025%2C605\" alt=\"WPForm Simple Contact Form Template\" /></a>WPForm Simple Contact Form Template\n<p>You can rearrange the fields by clicking and dragging them up or down. Rearranging fields is a breeze, doesn&#8217;t require a page refresh, and doesn&#8217;t bog down the browser. When clicking on a field, its properties are displayed on the left where you can configure its label, format, description, and whether or not its required.</p>\n<p>Advanced options enable you to determine a field&#8217;s size, placeholder text, default values, and whether to hide the label or sub-labels. Switching between screens and configuring fields is a fast, straightforward process.</p>\n<a href=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormFieldOptions.png\" rel=\"attachment wp-att-52584\"><img class=\"size-full wp-image-52584\" src=\"http://i0.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormFieldOptions.png?resize=1025%2C671\" alt=\"WPForm Field Options\" /></a>WPForm Field Options\n<p>Once the fields are configured, you&#8217;ll want to click the Settings screen. This is where you can configure what happens when a visitor clicks the submit button. You can enable or disable email notifications and use smart tags to configure the form&#8217;s output. This version of WPForms Lite doesn&#8217;t have email templates but Balkhi says it&#8217;s something the team is working on.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormSmartTags.png\" rel=\"attachment wp-att-52585\"><img class=\"size-full wp-image-52585\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormSmartTags.png?resize=1025%2C489\" alt=\"WPForm Smart Tags\" /></a>WPForm Smart Tags\n<p>Here is what the form&#8217;s output looks like in Thunderbird. Personally, I like Jetpack&#8217;s formatting style more but this could change once WPForms supports email templates.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormOutput.png\" rel=\"attachment wp-att-52586\"><img class=\"size-full wp-image-52586\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormOutput.png?resize=836%2C367\" alt=\"WPForm Output\" /></a>WPForms Output\n<p>As a comparison, this is what Jetpack&#8217;s Contact Form module output looks like in Thunderbird. The text looks better and I appreciate the bold field names.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/JetpacksFormOutput.png\" rel=\"attachment wp-att-52588\"><img class=\"size-full wp-image-52588\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/JetpacksFormOutput.png?resize=809%2C310\" alt=\"Jetpack Contact Form Output\" /></a>Jetpack Contact Form Module Output\n<p>WPForms battles spam using two different methods, honeypot and <a href=\"https://wpforms.com/docs/setup-captcha-wpforms/\">reCAPTCHA.</a> reCAPTCHA is a free,  <a href=\"https://www.google.com/recaptcha/intro/index.html\">anti-spam service</a> provided by Google. In order to use it with WPForms, you&#8217;ll need to sign up for an account and add your site key and secret key to WPForm&#8217;s settings page.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormsSettingsPage.png\" rel=\"attachment wp-att-52590\"><img class=\"size-full wp-image-52590\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormsSettingsPage.png?resize=1025%2C420\" alt=\"WPForms Settings Page\" /></a>WPForms Settings Page\n<p>Once a form is configured and saved, adding it to a page is easy. Simply create a new page in WordPress and in the editor, click the Add Form button. A modal will pop up giving you the option to choose which form to add to the page. You can also choose whether to show the form&#8217;s title and description from this box. When a form is added to the page, WPForms puts a shortcode like [ wpforms id=&#8221;50582&#8243; ] into the content area.</p>\n<a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormInsertUI.png\" rel=\"attachment wp-att-52592\"><img class=\"size-full wp-image-52592\" src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormInsertUI.png?resize=498%2C219\" alt=\"UI For Inserting a WPForm into a Page\" /></a>UI For Inserting a WPForm into a Page\n<p>I configured WPForms to not apply styling to my form. However, you can choose whether WPForms applies base and form theme styling or base styling only. You&#8217;ll want to experiment with these options to see if your form looks any better with styles applied.</p>\n<a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormsTavernContactForm.png\" rel=\"attachment wp-att-52593\"><img class=\"size-full wp-image-52593\" src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/WPFormsTavernContactForm.png?resize=696%2C881\" alt=\"WPForms Contact Form on The Tavern Frontend\" /></a>WPForms Contact Form on The Tavern Frontend\n<h2>My Verdict?</h2>\n<p>You should know that outside of creating simple contact forms and what&#8217;s available via the standard fields, almost everything else requires you to upgrade to the commercial version, including the ability to store and view form entries in WordPress. However, the plugin doesn&#8217;t nag or annoy you with popups that a commercial version is available. Upgrade prompts are only triggered when trying to access a commercial feature.</p>\n<p>After putting WPForms Lite through its paces, it&#8217;s definitely one of the easiest and fastest ways to set up a contact form. It&#8217;s clear by using the supplied templates that Balkhi and his team have considered common pitfalls and have done a great job eliminating them.</p>\n<p>I haven&#8217;t looked into the contact form space in WordPress for a few years but after testing WPForms, I&#8217;m motivated to compare some of the most popular plugins in the space to see how each one tackles the user experience. Expect a detailed roundup in the next few weeks.</p>\n<div id=\"epoch-width-sniffer\"></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 18 Mar 2016 02:05:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:40;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:123:\"WPTavern: Stack Overflow Survey Results Show WordPress is Trending Up, Despite Being Ranked Among Most Dreaded Technologies\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://wptavern.com/?p=52540\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:132:\"http://wptavern.com/stack-overflow-survey-results-show-wordpress-is-trending-up-despite-being-ranked-among-most-dreaded-technologies\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:7217:\"<p><a href=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/stack-overflow-developer-survey-2016.png\" rel=\"attachment wp-att-52554\"><img src=\"http://i1.wp.com/wptavern.com/wp-content/uploads/2016/03/stack-overflow-developer-survey-2016.png?resize=1025%2C462\" alt=\"stack-overflow-developer-survey-2016\" class=\"aligncenter size-full wp-image-52554\" /></a></p>\n<p>Stack Overflow published the results of its <a href=\"https://stackoverflow.com/research/developer-survey-2016\" target=\"_blank\">2016 Developer Survey</a>, summarizing responses from 56,033 developers in 173 countries. The 45-question survey collected answers from more than twice as many developers as the previous year.</p>\n<p>The results were published along with a disclaimer recognizing that the survey is &#8220;biased against devs who don&#8217;t speak English, or who don&#8217;t like taking English-language surveys.&#8221; Nevertheless, since the survey captured responses from such a large number of developers on a site that receives 40 million visitors per month, the results are definitely worth a read.</p>\n<p>The average age of developers surveyed was 29.6 years old and 92.8% of the respondents were male. Most of them are at least partially self-taught (69%) with 45% of them having acquired degrees in computer science or a related field.</p>\n<p>A quick developer profile of those surveyed shows that the largest section (28%) is made up of those who identify as a full-stack web developer.</p>\n<p><a href=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/developer-profile.png\" rel=\"attachment wp-att-52557\"><img src=\"http://i2.wp.com/wptavern.com/wp-content/uploads/2016/03/developer-profile.png?resize=1025%2C490\" alt=\"developer-profile\" class=\"aligncenter size-full wp-image-52557\" /></a></p>\n<h3>Developers Value Diversity</h3>\n<p>Despite the fact that the vast majority of the respondents were male, the results indicate that developers value diversity. In summarizing 42,156 responses,