jQuery(document).ready(function($) {
    $('#simple-generate-links').on('click', function(e) {
        e.preventDefault();

        var postData = {
            'action': 'generate_links', // The AJAX action hook in your PHP code
            'post_id': $('#post_ID').val(), // ID of the current post being edited
            'nonce': simple_openai_params.nonce // The nonce for security
        };

        $.ajax({
            url: simple_openai_params.ajax_url, // The AJAX URL passed from PHP
            type: 'POST',
            data: postData,
            success: function(response) {
                if (response.success) {
                    alert('Links generated successfully.');

                    // Insert content into the standard textarea
                    $('#content').val($('#content').val() + response.data.links);
                } else {
                    // Server responded with some error
                    alert('Error: ' + response.data);
                }
            },
            error: function(jqXHR, textStatus, errorThrown) {
                // Handle AJAX errors
                console.error('AJAX error: ', textStatus, ', ', errorThrown);
            }
        });
    });
});
